
****************************************************************
*         Runtime startoff for 'standalone' C programs         *
*                                                              *
* Hardware initialization for Perkin-Elmer 7/32, 8/32 or 3220  *
****************************************************************

	extrn   main,trap,edata,end
	entry	ss,oc,rd,rh,rdh,wd,wh,wdh
	entry	_rtt

* Registers

r0      equ     0
r1      equ     1
r2      equ     2
r3      equ     3
r5      equ     5
r6      equ     6
sp      equ     7
re      equ     14
rf      equ     15

* PSW definitions

PS_START equ    x'30f0'         MM & AF traps enabled, reg set 15
PS_TRAP  equ    x'2000'         MM enabled

* Note:
*       This code must be loaded at physical location 0.  Since UNIX 'ld'
*       does not permit an ABS segment, it must be faked as PURE.

	pure
low     equ     *       Physical location 0

* Reserved memory locations

	das     8               00  floating-point regs (X/32)
mm.opsw das     2               20  machine malfunction old psw
	das     1               28        -
	das     1               2c  machine malfunction LM start address (3200)
	dc      PS_TRAP         30  illegal instruction new psw
	dc	trap.ii
	dc      PS_TRAP         38  machine malfunction new psw
	dc	trap.mm
	das     1               40  machine malfunction status word (3200)
	das     1               44  machine malfunction program address (3200)
	dc      PS_TRAP         48  arith fault new psw
	dc	trap.af

	org	low+x'60'
	b       start           60  start address from 'boot' program

	org	low+x'80'
	das     1               80  &(system queue)
	dc      x'80'           84  &(power-fail save area)
	dc      PS_TRAP         88  system queue service new psw
	dc	trap.sq
	dc      PS_TRAP         90  MAC fault new psw
	dc	trap.mf

	dc      PS_TRAP         98  SVC new psw status
	do      16              9c  SVC new psw locations
	dc      z(trap.sv)

	das     3               bc         -
	dc      PS_TRAP         c8  data format fault new psw
	dc      trap.df

* interrupt service pointer table

	org     low+x'd0'           d0 interrupt pointers
  nlist
	do	256
	dc      z(int.nul)
  list
*	do	256
*       dc      z(int.nul)              listing suppressed

	org     low+x'300'
mac.r0  das     16              300  MAC segmentation registers
mac.st  das     1               340  MAC status register

	org     low+x'400'          400  end of reserved locations
reboot  das     1               400  return address to bootstrap program

*  Initial entry from bootstrap (via bal rf,x'60')

start   equ     *
	li      r1,PS_START     disable everything
	epsr    r0,r1
	st      rf,reboot       save return address to bootstrap

*  Clear bss segment

	la      r1,edata        start at end of initialized data
	li      r2,adc          increment by wordlength
	la      r3,end          finish at end of program
	li      r0,0
clear   st      r0,0(r1)        clear a word
	bxle    r1,clear        increment r1 and repeat

*  Set up stack

	la      sp,8*1024(r1)   allow 8k beyond end of data

*  Call main program

	bal     rf,main
_rtt	equ	*
	l       rf,reboot       get return address to bootstrap program
	br      rf              reboot

*  Trap & interrupt vectors

trap.ii bal     r6,trapx
	db      c'Illegal instruction',0
	align   2
trap.mm lm      re,mm.opsw      get old PSW
	bal     r6,trapx
	db      c'Memory malfunction',0
	align   2
trap.af bal     r6,trapx
	db      c'Arithmetic fault',0
	align   2
trap.sq bal     r6,trapx
	db      c'System queue',0
	align   2
trap.mf li      r6,0
	st      r6,mac.st       clear MAC status register
	bal     r6,trapx
	db      c'MAC fault',0
	align   2
trap.sv bal     r6,trapx
	db      c'System call',0
	align   2
trap.df bal     r6,trapx
	db      c'Data format fault',0
	align   2
int.nul lr      re,r0           get old PSW
	lr      rf,r1
	bal     r6,trapx
	db      c'I/O Interrupt',0
	align   2
trapx   equ     *
	stm     r0,9*1024+end           save trap regs
	li      r1,PS_START             switch reg sets
	stm     r0,9*1024+64+end        save user regs
	la      sp,9*1024+end           set up trap stack
	bal     rf,trap                 call trap handler
	b       *                       loop forever

*  I/O instruction routines

ss	equ	*	sense status
	l	r1,0(sp)
	ssr	r1,r0
	br	rf

oc	equ	*	output command
	l	r1,0(sp)
	lb	r0,7(sp)	*** do ocr instead of oc
	ocr	r1,r0		*** because of timing bug on 7/32
	br	rf

wd	equ	*	write data
	l	r1,0(sp)
	wd	r1,7(sp)
	br	rf

wh	equ	*	write halfword
	l	r1,0(sp)
	wh	r1,6(sp)
	br	rf

wdh	equ	*	write 3 bytes
	l	r1,0(sp)
	wd	r1,5(sp)
	wh	r1,6(sp)
	br	rf

rd	equ	*	read data
	l	r1,0(sp)
	rdr	r1,r0
	br	rf

rh	equ	*	read halfword
	l	r1,0(sp)
	rhr	r1,r0
	br	rf

rdh	equ	*	read 3 bytes
	l	r1,0(sp)
	rdr	r1,r2
	rhr	r1,r0
	exhr	r2,r2
	or	r0,r2
	br	rf

	end
