/*
 * Perform backspace-delete function as in tty.c
 *	- useful after an edit session when you forgot stty
 */
#include <stdio.h>

main()
{
	register i, c, col;
	static line[256];

	col = 0;

	while ((c = getchar()) != EOF) {
		switch (c) {

		case '\n':
			for (i=0; i<col; i++)
				putchar(line[i]);
			putchar('\n');
			col = 0;
			break;

		case '\b':
			if (col)
				col--;
			break;

		default:
			line[col++] = c;
			break;

		}
	}
	exit(0);
}
