/* printf.c -- #include file
        Implements a more C/80-like printf function, distinguished from
        Lattice C implementation as follows:
        Call:
          format(str);  printf(v1);  printf(v2);  ...
        Differences:
          buffered output is used, except that it is
            flushed after every 'format()' call.
          '\n' translation is performed and I/O redirection OK
          only %u, %c, and %s conversions are implemented
        Requirements:
          #include <stdio.h> before it
*/
char *Pf;  /* current location in user's format */

format(form)
char *form;
{   Pf = form;  Ps();   }

printf(arg)     /* print one arg using current format */
char *arg;
{       if (!*Pf || *Pf++ != '%') {fflush(stdout);  return;}
        switch(*Pf++)
        {   case 'd': POn(arg); break; /* decimal */
            case 'c': Pc(arg); break; /* single char */
            case 's': while (*arg) Pc(*arg++);  break;
        }
        Ps();
}

Ps()    /* output format up to next % */
{   while (*Pf && *Pf != '%') Pc(*Pf++);  if (!*Pf) fflush(stdout);  }

Pc(c)   /* need a function not a macro to output a char */
char c;  {putch(c);  return(c);}

POn(num)
unsigned num;
{   if (num < 10)  Pc(num+'0');
      else {POn(num/10);  Pc(num%10+'0');}
}
