************************************************
*                                              *
*          BDOS & BIOS Access Routines         *
*                                              *
*  The following routines access the CP/M's    *
*  BDOS and BIOS routines through trap #2      *
*  and trap #3 respectively. The command       *
*  sequences are the same for both commands.   *
*  The parameters and definitions are as       *
*  follows:
*                                              *
*    return = BDOS(command, arg 1);            *
*    return = BIOS(command, arg 1);            *
*                                              *
*    int     command  - Command for low level  *
*                       routine (D0.W)         *
*    long    arg 1    - Input parameter for    *
*                       level routine (D1.L)   *
*    long    return   - Data returned from low *
*                       level routine          *
*                                              *
************************************************

*
*       Global equates
*

        .globl  _bdos            ;BDOS direct request entry
        .globl  _bios            ;BIOS direct request entry

*
*       Input argument parameter definitions
*

arg1:   .equ    8                ;Command
arg2:   .equ    arg1+2           ;Input parameter

*
*       BDOS direct entry routine
*

_bdos:
        link    a6,#0            ;Allocate space for request pkt
        movem.l d3-d7/a3-a6,-(a7) ;Save registers
        move.w  arg1(a6),d0      ;Set command
        move.l  arg2(a6),d1      ;Set up parameter
        trap    #2               ;Request I/O
        movem.l (a7)+,d3-d7/a3-a6 ;Restore registers
        unlk    a6
        rts

*
*       BIOS direct entry routine
*

_bios:
        link    a6,#0            ;Allocate space for request pkt
        movem.l d3-d7/a3-a6,-(a7) ;Save registers
        move.w  arg1(a6),d0      ;Set command
        move.l  arg2(a6),d1      ;Set up parameter
        trap    #3              ;Request I/O
        movem.l (a7)+,d3-d7/a3-a6 ;Restore registers
        unlk    a6
        rts
