************************************************
*                                              *
*       Pascal unit read / write I/O routines  *
*                                              *
*  The following routines allow access to the  *
*  low level bios I/O routines equivalent to   *
*  UCSD's unitread and unitwrite commands. The *
*  calling sequence for the command is as      *
*  follows:                                    *
*                                              *
*    error = uread(channel, buffer, length,    *
*                  block, flags)               *
*    error = uwrite(channel, buffer, length,   *
*                   block, flags)              *
*                                              *
*    int     channel  - same as pascal channel *
*                       (see sage manual)      *
*    XXXX    *buffer  - pointer to memory      *
*                       buffer for transfer    *
*    int     length   - number of bytes to     *
*                       transfer (1-(65k-1))   *
*    int     block    - block address for      *
*                       transfer if needed     *
*    int     flags    - I/O control flags      *
*                       (see Sage manual)      *
*    int     error    - error return from I/O  *
*                       (see Sage manual for   *
*                       definition, 0 = ok)    *
*                                              *
************************************************

*
*       Global equates
*

        .globl  _uread           ;Unit read routine
        .globl  _uwrite          ;Unit write routine entry

*
*       Input argument parameter definitions
*

arg1:   .equ    8                ;Channel
arg2:   .equ    arg1+2           ;Buffer address
arg3:   .equ    arg2+4           ;Transfer length
arg4:   .equ    arg3+2           ;Block address
arg5:   .equ    arg4+2           ;I/O flags

*
*       Unit read routine
*

_uread:
        moveq   #11,d0           ;Set read command
        bra     process          ;Set up & execute read

*
*       Unit write routine
*

_uwrite:
        moveq   #12,d0           ;Set write command

*
*       Request I/O
*

process:
        link    a6,#-16          ;Allocate space for request pkt
        move.l  a7,a0            ;Set address of request pkt
        movem.l d3-d7/a3-a5,-(a7) ;Save registers
        move.l  a6,-(a7)         ;Save frame pointer
        move.w  arg1(a6),(a0)    ;Set channel
        clr.w   2(a0)            ;Clear error
        clr.l   d1               ;Set transfer length
        move.w  arg3(a6),d1
        move.l  d1,4(a0)
        move.l  arg2(a6),8(a0)   ;Set buffer address
        move.w  arg4(a6),12(a0)  ;Set block address
        move.w  arg5(a6),14(a0)  ;Set I/O flags
        move.l  a0,-(a7)         ;Save packet pointer
        trap    #14              ;Request I/O
        move.l  (a7)+,a0         ;Restore packet pointer
        move.l  (a7)+,a6         ;Restor frame pointer
        move.w  2(a0),d0         ;Set error condition
        unlk    a6
        rts
