	IDT	'PFPY'
	TITL	'Put to floppy from serial port'
*
* PFPY - Read floppy disk image from serial port
*
R0	EQU	0
R1	EQU	1
R2	EQU	2
R3	EQU	3
R4	EQU	4
R5	EQU	5
R6	EQU	6
R7	EQU	7
R8	EQU	8
R9	EQU	9
R10	EQU	10
R11	EQU	11
R12	EQU	12
R13	EQU	13
R14	EQU	14
R15	EQU	15
*
* Terminal CRU bits
*
TRMCRU	EQU	>0
XMIT	EQU	8
DTR	EQU	9
RTS	EQU	10
WRQ	EQU	11
RRQ	EQU	12
NSF	EQU	13
KILL	EQU	>03		CTRL-C
XON	EQU	>11
XOFF	EQU	>13
*
* Disk CRU bits
*
DSKCRU	EQU	>80
SEEKCM	EQU	>1000
READCM	EQU	>4000
WRITCM	EQU	>7000
STOPCM	EQU	>B000
CMDBAS	EQU	>20
DATBAS	EQU	>FFC0
ERRMSK	EQU	>1BFC
* Command base relative
OPCOMP	EQU	>0
CBUSY	EQU	>0A
* Data base relative
GOTWRD	EQU	>0F
XFER	EQU	>11
CTLBSY	EQU	>1A
SECSIZ	EQU	128
	PAGE
*
* Task Entry
*
	DATA	WS,ENTRY,0
*
* Standalone Entry
*
SAENT	EQU	$
	LWPI	WS
ENTRY	EQU	$
	LIMI	0		Take over the system
	SBO	DTR
	SBO	RTS
	BLWP	@PRINT		Issue ready message
	DATA	READY,RDYLEN
	TB	RRQ
	JNE	$-2
	STCR	R1,8		Get reply
	SBZ	RRQ
*
	CLR	R2		Start at track zero
NXTTRK	EQU	$
	MOV	R2,@DSKPRM+2
	LI	R1,1		Start at sector one
NXTSEC	EQU	$
	LI	R9,DSKBUF
	LI	R10,SECSIZ
NXTCHAR	EQU	$
	TB	RRQ		Wait for input
	JNE	$-2
	STCR	R8,8		Get it.
	MOVB	R8,*R9+		Put in buffer.
	DEC	R10		Last char in sector?
	JGT	NXTCHAR		No, Get next char.
	MOV	R1,@DSKPRM+4	Yes, Write it out.
	BLWP	@DISKH		Put a sector
	DATA	DSKPRM,DSKBUF,OOPS
	BLWP	@PRINT		Tell sender to send next sector
	DATA	GO,GOLEN
	INC	R1
	CI	R1,27
	JLT	NXTSEC
	INC	R2
	CI	R2,77
	JLT	NXTTRK
IDLINS	IDLE
*
OOPS	EQU	$
	LI	R0,>DEAD
	LI	R1,>BAD0
	MOV	@IDLINS,*R1
	B	*R1
*
WS	DATA	0,0,0,0,0,0,0,0
	DATA	0,0,0,0,TRMCRU,0,0,0
*
READY	TEXT	'Enter any key when ready:'
	BYTE	>0D,>0A
RDYLEN	EQU	$-READY
*
GO	BYTE	>0D
GOLEN	EQU	$-GO
	EVEN
*
DSKPRM	DATA	1		Write
	DATA	$-$		Track
	DATA	$-$		Sector
	DATA	1		Unit
DSKBUF	BSS	SECSIZ
	PAGE
*
* Print a message
*
PRINT	DATA	PRWS,PRENT
PRENT	EQU	$
	MOV	*R14+,R2	Get buffer address
	MOV	*R14+,R1	Get message length
	SBO	DTR
	SBO	RTS
PRI010	LDCR	*R2+,8
	TB	WRQ
	JNE	$-2
	SBZ	WRQ
	TB	RRQ		Any thing coming back?
	JEQ	PRI030
PRI020	EQU	$
	DEC	R1
	JGT	PRI010
	CLR	@0(R13)		Done, exit 0.
	RTWP
*
PRI030	EQU	$
	STCR	R5,8		Get it.
	SBZ	RRQ
	SRL	R5,8
	CI	R5,XOFF		If XOFF then
	JEQ	PRI040		   go wait for XON
	CI	R5,KILL		If not KILL (CTRL-C) then
	JNE	PRI020		   Ignore.
	SETO	@0(R13)		else exit -1.
	RTWP
PRI040	EQU	$
	TB	RRQ		Wait for XON.
	JNE	PRI040
	STCR	R5,8
	SBZ	RRQ
	SRL	R5,8
	CI	R5,XON
	JEQ	PRI020
	JMP	PRI040
*
PRWS	DATA	0,0,0,0,0,0,0,0
	DATA	0,0,0,0,TRMCRU,0,0,0
	PAGE
*
* Disk Handler
*
DISKH	DATA	DISKWS,DISKEP
DISKWS	DATA	0,0,0,0,0,0,0,0
	DATA	0,0,0,0,DSKCRU,0,0,0
DISKEP	EQU	$
	MOV	*R14+,R10	Get parm addr
	MOV	*R14+,R9	Get buffer addr
	MOV	*R14+,R8	Get error vector
	LI	R6,READTR	Set read op
	MOV	*R10+,R0	If not input then
	JEQ	DSK020
	LI	R6,WRITTR	   set write op
DSK020	EQU	$
	MOV	*R10+,R2	Get Track
	MOV	*R10+,R3	Get Sector
	MOV	*R10+,R10	Get Unit
	SLA	R10,10
	B	*R6		Process
*
* Read from Track
*
READTR	EQU	$
	MOV	R2,R0
	BL	@SEEK		Seek to track
	MOV	R3,R0
	ORI	R0,READCM	Make a read command
	BL	@ISSUE1		Issue Read
	LI	R2,SECSIZ	Read entire sector
READ10	EQU	$
	BL	@XFRRDY		Wait for ready
	STCR	R1,0		Get a word
	SBZ	GOTWRD		Say we got it
	MOVB	R1,*R9+		Store in buffer
	SWPB	R1
	MOVB	R1,*R9+
	DECT	R2
	JGT	READ10
*
STOPIT	EQU	$
	LI	R0,STOPCM	Store Controller
	BL	@ISSUE2
	RTWP
*
* Write to Track
*
WRITTR	EQU	$
	MOV	R2,R0
	BL	@SEEK		Seek to track
	MOV	R3,R0
	ORI	R0,WRITCM	Make a write command
	BL	@ISSUE1		Issue Write
	LI	R2,SECSIZ	Read entire sector
WRIT10	EQU	$
	BL	@XFRRDY		Wait for ready
	MOVB	*R9+,R1		Get from buffer
	SWPB	R1
	MOVB	*R9+,R1
	SWPB	R1
	LDCR	R1,0		Write it
	DECT	R2
	JGT	WRIT10
	BL	@XFRRDY		Wait for ready
	JMP	STOPIT
*
* Seek to track
*
SEEK	EQU	$
	ORI	R0,SEEKCM	Make a seek command
*
* Issue commands to disk
*
ISSUE	EQU	$
	LI	R6,DECODE
	JMP	ISU010
ISSUE1	EQU	$
	LI	R6,DECOD1
ISU010	EQU	$
	ORI	R12,CMDBAS	Set to command base
	LI	R5,20000	Controller busy timer
ISU020	EQU	$
	TB	CBUSY		Wait till controller free
	JNE	ISU030
	DEC	R5
	JGT	ISU020
ISSUE2	EQU	$
	LI	R6,DECODE
ISU030	EQU	$
	ORI	R12,CMDBAS
	SOC	R10,R0		Set unit
	LDCR	R0,0
ISU040	EQU	$
	TB	OPCOMP		Wait till op complete
	JNE	ISU040
	STCR	R5,0		Get status
	B	*R6		Go decode
*
* Status Decoder
*
DECODE	EQU	$
	SETO	R7
	LDCR	R7,0		Clear status port
DECOD1	EQU	$
	CLR	R7
	ANDI	R5,ERRMSK
	JEQ	DEC020
	MOV	R8,R14		Set error vector
	RTWP
DEC020	EQU	$
	RT
*
* Wait for transfer ready
*
XFRRDY	EQU	$
	ANDI	R12,DATBAS	Set to data base
XFR010	EQU	$
	TB	XFER		If transfer ready
	JNE	XFR020
	RT			   return
XFR020	EQU	$
	TB	CTLBSY		else If controller busy then
	JEQ	XFR010		   wait
	ORI	R12,CMDBAS	else controller stopped
	STCR	R5,0		   why ?
	BL	@DECODE
	RTWP
	END	SAENT
