/***********************************************************************
*
* putfpy - Puts an FD800 floppy image onto the TI computer. Use in
*          conjunction with the 990 program pfpy.asm
*
* Changes:
*      07/20/04   DGP   Original
*
***********************************************************************/

#include <stdio.h>
#include <string.h>
#include <memory.h>
#include <ctype.h>
#include <sys/ioctl.h>
#include <termios.h>

#define SECTLEN 128
#define SECTTRK 26
#define TRKDISK 77
#define DISKSIZE  SECTLEN*SECTTRK*TRKDISK

struct termios cmdtty, runtty;
int fd;

/*
** Terminal routines borrowed from Bub Supnik's simh
*/

int
ttinit (FILE *ifd)
{
   fd = fileno(ifd);
   if (tcgetattr (fd, &cmdtty) < 0) return -1;		/* get old flags */
   runtty = cmdtty;
   runtty.c_lflag = runtty.c_lflag & ~(ECHO | ICANON);	/* no echo or edit */
   runtty.c_oflag = runtty.c_oflag & ~OPOST;		/* no output edit */
   runtty.c_iflag = runtty.c_iflag & ~ICRNL;		/* no cr conversion */
   runtty.c_cc[VINTR] = 0;				/* interrupt */
   runtty.c_cc[VQUIT] = 0;				/* no quit */
   runtty.c_cc[VERASE] = 0;
   runtty.c_cc[VKILL] = 0;
   runtty.c_cc[VEOF] = 0;
   runtty.c_cc[VEOL] = 0;
   runtty.c_cc[VSTART] = 0;				/* no host sync */
   runtty.c_cc[VSUSP] = 0;
   runtty.c_cc[VSTOP] = 0;
#if defined (VREPRINT)
   runtty.c_cc[VREPRINT] = 0;				/* no specials */
#endif
#if defined (VDISCARD)
   runtty.c_cc[VDISCARD] = 0;
#endif
#if defined (VWERASE)
   runtty.c_cc[VWERASE] = 0;
#endif
#if defined (VLNEXT)
   runtty.c_cc[VLNEXT] = 0;
#endif
   runtty.c_cc[VMIN] = 0;				/* no waiting */
   runtty.c_cc[VTIME] = 0;
#if defined (VDSUSP)
   runtty.c_cc[VDSUSP] = 0;
#endif
#if defined (VSTATUS)
   runtty.c_cc[VSTATUS] = 0;
#endif
   return 0;
}

int
ttrunstate (void)
{
   runtty.c_cc[VINTR] = 0;
   if (tcsetattr (fd, TCSAFLUSH, &runtty) < 0) return -1;
   return 0;
}

int
ttcmdstate (void)
{
   if (tcsetattr (fd, TCSAFLUSH, &cmdtty) < 0) return -1;
   return 0;
}

int
ttclose (void)
{
   return ttcmdstate ();
}

int
sim_os_putchar (int out)
{
   unsigned char c;

   c = out;
   write (1, &c, 1);
   return 0;
}

int
poll_kbd (void)
{
   int status;
   unsigned char buf[1];

   status = read (fd, buf, 1);
   if (status != 1) return -1;
   else return (buf[0]);
}

/***************************************************************************
* smallsleep - sleep in U seconds
* NOTE: Depending on the system the sleep time can vary widely.
***************************************************************************/

void
smallsleep (long Usec)
{
#if defined(UNIX)
#if defined(LINUX) || defined(SOLARIS)
#include <unistd.h>
   struct timespec req, rem;
#ifdef DEBUGCLOCK
#include <time.h>
   static clock_t starttime;
   static clock_t curtime;
   static int ticks;
   static int first = TRUE;

   if (first)
   {
      first = FALSE;
      ticks = 0;
      starttime = time (NULL) + 1;
   }
#endif

   req.tv_sec = 0;
   req.tv_nsec = Usec * 1000;

   nanosleep (&req, &rem);
#ifdef DEBUGCLOCK
   ticks++;
   curtime = time(NULL);
   if (curtime == starttime)
   {
      fprintf (stderr, "CLOCK: ticks = %d\n\r", ticks);
      starttime = curtime + 1;
      ticks = 0;
   }
#endif

#else
   struct timeval tv;

   tv.tv_sec = 0;
   tv.tv_usec = Usec;
   if (select (1,
	       NULL,
	       NULL,
	       NULL,
	       &tv) < 0)
   {
      if (ERRNO != EINTR && ERRNO != EAGAIN)
	 PERROR ("smallsleep: select failed");
   }
#endif
#endif /* UNIX */

#if defined(_WIN32)
   Sleep ((unsigned long) (Usec) / 100L);
#endif /* _WIN32 */

#if defined(OS2)
   DosSleep ((unsigned long) (Usec) / 100L);
#endif /* OS2 */

}

/***********************************************************************
* Main program.
***********************************************************************/

int
main(int argc, char **argv)
{
   FILE *iterm;
   FILE *oterm;
   FILE *ofd;
   int track = 0;
   int i;
   int c;
   int j, k;
   int size;
   int memory[DISKSIZE];

   /*
   ** Check args
   */

   if (argc != 2)
   {
      fprintf (stderr, "usage: putfpy file\n");
      exit (1);
   }

   /*
   ** Open the disk image file
   */

   if ((ofd = fopen (argv[1], "rb")) == NULL)
   {
      perror ("Can't open file");
      exit (1);
   }

   /*
   ** Set up the port
   */

   if ((iterm = fopen ("/dev/ttyS0", "rb")) == NULL)
   {
      perror ("Can't open terminal");
      exit (1);
   }
   if ((oterm = fopen ("/dev/ttyS0", "w")) == NULL)
   {
      perror ("Can't open terminal");
      exit (1);
   }

   ttinit (iterm);

   /*
   ** Tell the pfpy program to go
   */

   fputc ('\n', oterm);

   ttrunstate();

   /*
   ** Read the disk and send to the pfpy program. 
   */

   k = SECTLEN;
   j = SECTTRK;
   for (i = 0; i < DISKSIZE; i++)
   {
      if ((c = fgetc (ofd)) < 0)
      {
         perror ("file read error");
	 break;
      }
      sim_os_putchar (c);
      smallsleep (100);
      k--;
      if (k == 0)
      {
	 j--;
	 if (j == 0)
	 {
	    printf ("track %d\n", track++);
	    j = SECTTRK;
	 }
	 k = SECTLEN;
	 /*
	 ** Wait for go ahead
	 */
	 while ((c = poll_kbd()) != 0x0D) ;
      }
   }
   ttcmdstate();
   ttclose();

   /*
   ** Clean up and quit
   */

DIE:
   fclose (iterm);
   fclose (oterm);
   fclose (ofd);

   return (0);
}
