;---------------------------------------------------------------------------
;
; %FILE     int.asm
; %VSS-REV  $Revision: 1 $
; %VERSION  1.5
; %CREATED  1995.08.01
; %REVISED  $Date: 10/30/96 5:25p $
; %AUTHOR   Michael C. Draeger 
; %PROJECT  NS486SXF evaluation board software
; %PART     NS486SXF 
; %SUMMARY  interrupt example using boiler plate
;     
; %VSS      $Author: Miked $ $Date: 10/30/96 5:25p $ $Revision: 1 $
;
; DESCRIPTION
;
;   Sample test using the boiler plate module.  This test is linked with
;   the "BOILER.ASM" code.  The procedure user_start is called by the
;   code in "BOILER.ASM".  This should be linked after boiler so that
;   the entry point for the boiler code is at the start of the image.
;
;   This code sets up an ISR for INT 20h and tests it out.  UART messages 
;   are printed along the way so that if a terminal is connected to the
;   UART, the operator can see how far the test gets and what sequence.
;
;   Use this test as an example of how to set up an Interrupt Service
;   Routine using the macro from boiler.inc.
;
;   Proper UART output for this program is a 'r' followed
;   by repeating "123*".  The '2' is printed by the interrupt service
;   routine.
;
; RELEASE HISTORY
;
;   1.0   1995.08.01  mcd  genesis
;   1.1   1996.01.10  mcd  evb version
;   1.5   1996.10.30  mcd  updated for version 1.5 of "BOILER.ASM"
;
; COPYRIGHT
;
;      (c) 1995, 1996 National Semiconductor Corporation
;
;---------------------------------------------------------------------------

.486p  ; allow all instructions in assembler

;---------------------------------------------------------------------------
; include files
;---------------------------------------------------------------------------

include io.inc       ; port IO
include boiler.inc   ; boiler plate stuff

;---------------------------------------------------------------------------
; use UART.INC macros to print simple output
;---------------------------------------------------------------------------

        ; COM2, 9600 bps

uPORT   equ     uCOM2                           
uDLLv   equ     ulsb96       
uDLMv   equ     umsb96      

        ; include file

include uart.inc

;---------------------------------------------------------------------------
; symbols
;---------------------------------------------------------------------------

PUBLIC user_start

;---------------------------------------------------------------------------
; ************ Code ********************************************************
;---------------------------------------------------------------------------

CODESG     SEGMENT PARA USE32 PUBLIC 'code'
user_start PROC near
           ASSUME  CS:CODESG

;---------------------------------------------------------------------------
; Test program
;---------------------------------------------------------------------------

        ; initialize UART

        uart_init
        
        ; display debug message

        uart_outc 'r'

        ; set up IDT - use IDT entry 0x20.  ISR is at end of this program.

        setidt 020h, boiler_base + offset isr

        ; endless loop jumps here
endless:

        ; print a '1'
        uart_outc '1'

        ; cause interrupt

        int     20h

        ; print a '3'

        uart_outc '3'
        
        
        uart_outc '*'
        mov     ecx, 0200000h
endloop:
        dec ecx
        jnz endloop
        jmp endless

        ; game over man
        
        HLT

;---------------------------------------------------------------------------
; Interrupt Service Routine
;---------------------------------------------------------------------------
        
isr:

        ; display debug message

        uart_outc '2'
        
        ; return from interrupt

        iretd

        ; if we get here, something went wrong

        HLT

;---------------------------------------------------------------------------
; end of segment
;---------------------------------------------------------------------------

user_start ENDP
CODESG     ENDS
        
; end of program 

        END

;---------------------------------------------------------------------------
; END       int.asm 
;---------------------------------------------------------------------------

