//---------------------------------------------------------------------------
//
// %FILE     dmatest.c
// %VSS-REV  $Revision: 20 $
// %CREATED  1995.12.15
// %REVISED  $Date: 4/18/97 4:03p $
// %AUTHOR   Noreen Bell
// %PROJECT  NS486SXF evaluation board software
// %PART     NS486SXF (B2+)
// %SUMMARY  Direct Memory Access test module
//     
// %VSS      $Author: Miked $ $Date: 4/18/97 4:03p $ $Revision: 20 $
//
// DESCRIPTION
//
//   This module contains code to test Memory to Memory transfers
//   using the NS486 DMA controller.
//
// HISTORY
//
/*
 *
 * $History: dmatest.c $
 * 
 * *****************  Version 20  *****************
 * User: Miked        Date: 4/18/97    Time: 4:03p
 * Updated in $/nsdemo
 * Made one variable private.   New header (comment) changes.
 * 
 * *****************  Version 19  *****************
 * User: Miked        Date: 12/04/96   Time: 1:51p
 * Updated in $/nsdemo
 * Updated version to 1.6.
 * 
 * *****************  Version 18  *****************
 * User: Miked        Date: 12/04/96   Time: 11:24a
 * Updated in $/nsdemo
 * For some completely voodoo reason I was getting a Link&Locate Fatal
 * Error 3 (Disk Access Error, file "CodeView Types v4.0") when compiling
 * with Borland.  Using the -nodebug flag fixes the problem, but then
 * there is no debugging.  The problem seems to be in this module, but
 * eliminating any one function call seems to fix it, so I merged MemToMem
 * and DMA_Test.  This problem still needs to be resolved, but it seems to
 * be a Link&Locate error.   Note: you can avoid this error by turning off
 * source level debugging in either the compiler (-v switch) or the linker
 * (-nodebug), but then you loose source level debugging for the file or 
 * whole program respectively.
 * 
 * *****************  Version 17  *****************
 * User: Miked        Date: 8/06/96    Time: 11:59a
 * Updated in $/nsdemo
 * Version 1.4.  Maintainance release.  See README.TXT for info.
 * 
 * *****************  Version 16  *****************
 * User: Miked        Date: 7/23/96    Time: 2:25p
 * Updated in $/nsdemo
 * Maintainance release.  README.TXT describes changes.
 * 
 * *****************  Version 15  *****************
 * User: Miked        Date: 7/16/96    Time: 11:54a
 * Updated in $/nsdemo
 * Updated for rev C0 release.
 * 
 * *****************  Version 14  *****************
 * User: Miked        Date: 7/10/96    Time: 10:35a
 * Updated in $/nsdemo
 * Updated to include "dmatest.h".
 * 
 * *****************  Version 13  *****************
 * User: Miked        Date: 6/27/96    Time: 3:54p
 * Updated in $/nsdemo
 * Added return value from DMA_Test() - was missing.
 * 
 * *****************  Version 12  *****************
 * User: Miked        Date: 6/26/96    Time: 3:07p
 * Updated in $/nsdemo
 * Added DMA_ prefix to a bunch of #defines used in DMA structures.  The
 * one called "Set" in particular was interfering with other modules when
 * DMA.H was included before PIT.H.  The names were too generic to expect
 * them not to be steped on.
 * 
 * *****************  Version 11  *****************
 * User: Miked        Date: 6/26/96    Time: 2:39p
 * Updated in $/nsdemo
 * Updated for DMA Clocks Per Transfer change in DMA module.
 * 
 * *****************  Version 10  *****************
 * User: Miked        Date: 5/03/96    Time: 2:50p
 * Updated in $/nsdemo
 * Maintainence release.
 * 
 * *****************  Version 9  *****************
 * User: Miked        Date: 4/23/96    Time: 1:02p
 * Updated in $/nsdemo
 * Removed CS8 disabling (Flash shadow).  This was not necessary in this
 * module.  Just leave CS8 enabled for whole test.
 * 
 * *****************  Version 8  *****************
 * User: Noreen       Date: 4/18/96    Time: 10:48a
 * Updated in $/nsdemo
 * Updated comments for release version
 * 
 * *****************  Version 7  *****************
 * User: Miked        Date: 4/17/96    Time: 3:05p
 * Updated in $/nsdemo
 * Modified output messages and added check to make sure transfer worked.
 * 
 * *****************  Version 6  *****************
 * User: Miked        Date: 4/17/96    Time: 1:28p
 * Updated in $/nsdemo
 * Removed DMA chaining and modified so that MemToMem writes to a buffer
 * in DRAM.
 * 
 * *****************  Version 5  *****************
 * User: Noreen       Date: 4/17/96    Time: 10:22a
 * Updated in $/nsdemo
 * Redesigned print messages to dprintf
 * 
 * *****************  Version 4  *****************
 * User: Noreen       Date: 4/16/96    Time: 2:49p
 * Updated in $/nsdemo
 * Converted all print messages for SSI and Phar Lap.
 * Implemented DMA_Info function to display bank sizes.  
 * 
 * *****************  Version 3  *****************
 * User: Miked        Date: 4/12/96    Time: 3:07p
 * Branched in $/nsdemo
 * NS Demo
 * 
 * *****************  Version 2  *****************
 * User: Noreen       Date: 4/12/96    Time: 3:00p
 * Updated in $/nstest
 * Updated headers for VSS
 *
 */
//
// COPYRIGHT
//
//      (c) 1995, 1996, 1997 National Semiconductor Corporation
//
//---------------------------------------------------------------------------

#include "dmatest.h"

//Initial values for FLASH to DRAM transfer
#define FLASHBegin   0x01FC0000
#define Block 0x500

//Buffer to DMA into
PRIVATE BYTE DMABuffer[Block];

//---------------------------------------------------------------------------
//
// FUNCTION    DMA_Test
//
// INPUT       none
// OUTPUT      none
// RETURN      USHORT
//               SUCCESS - if call successful
//               FAIL - if any of the DMA functions return an error
// DESCRIPTION
//   This routine performs a DMA Memory to Memory Transfer from FLASH
//   to DRAM.
//
// NOTES
//   Logical Chip Select 8 is programmed to map to Chip Select 0 in order
//   to shadow the FLASH memory to the lower 64MBytes. This is because the
//   FLASH is the requestor and the requestor address can only be 26bits.
//
//---------------------------------------------------------------------------

USHORT DMA_Test(void)
{

    USHORT DMAChannel, testloop=0, terminate=20;
    DMA_TRANSFER Transfer;
    DMA_STATUS  Status;
    DWORD StartingAddress;
    USHORT retval = SUCCESS;
    USHORT compare;
    BYTE * Addr1;
    BYTE * Addr2;
    int i;

    //Pointer to Status structure
    DMA_STATUS * pStatus = &Status;
	
    //Perform Memory to Memory transfer from FLASH to DRAM
    dprintf("DMA Controller Test:\r\n");

    //Initialize DMA controller
    if(DMA_Initialize() != SUCCESS)
    {
      dprintf("   Mem to Mem Initialization - FAILED\r\n\n"); 
      return FAIL;
    }

    //Setup parameters to perform Memory to Memory transfer from
    //requestor(FLASH) to target(DRAM).
    Transfer.Mode = TransferMode_Single;     //Perform a single transfer
    Transfer.TC_EOP = DMA_TC;                    //TC vs /EOP pin will operate as
					     //Terminal Count
    Transfer.IO_MEM = DMA_MEM;                   //Memory->Memory
    Transfer.Direction = DMA_Read;               //Transfer type
    Transfer.AutoInit = DMA_Disable;             //Disable Autoinitialization
    Transfer.Channel = 2;                    //DMA Channel to use
    Transfer.RequestorDirection = DMA_Increment; //Increment Address
    Transfer.TargetDirection = DMA_Increment;    //Increment Address
    Transfer.Clocks = Clocks16;              //16 clocks per transfer
    Transfer.BusSize = DMA_bit16;                //16-bit data transfer
    Transfer.CPUDMARequest = DMA_Set;            //Issue a DMA request since there
					     //is no hardware to drive the DMA
    //Starting Address of target
    StartingAddress = (DWORD) (& DMABuffer);
    Transfer.TargetAddress = StartingAddress;

    //Starting Address of requestor
    StartingAddress = FLASHBegin;
    Transfer.RequestorAddress = StartingAddress;

    //Bytes to transfer
    Transfer.TransferByteCount = Block;

    //Perform Memory to Memory DMA transfer
    DMA_Transfer(Transfer);

    DMAChannel = 2;

    if (DMA_Status(DMAChannel, pStatus) != SUCCESS)
    {
      dprintf("   DMA Status - FAILED\r\n\n"); 
      return FAIL;
    }

    if(pStatus->TCStatus==DMA_TC_NotReached)
    {
	  while(testloop != terminate)
	  {
	       DMA_Status(DMAChannel, pStatus);
	       testloop++;
	  }
    }

    if(pStatus->TCStatus==DMA_TC_Reached)
       dprintf("  Terminal Count test - PASSED\r\n");
    else
    {
      dprintf("  Terminal Count test - FAILED\r\n");
      retval = FAIL;
    }

  // Compare DMA Buffer to see if transfer worked
  
  Addr1 = (BYTE *) (& DMABuffer);
  Addr2 = (BYTE *) FLASHBegin;
  compare = TRUE;

  for ( i=0; i < Block; i++ )
  {  
    if ( *Addr1 != *Addr2 ) 
      compare = FALSE;
    Addr1++;
    Addr2++;
  }

  if ( compare == FALSE )
    dprintf("  Memory to Memory Transfer - FAILED\r\n");
  else
    dprintf("  Memory to Memory Transfer - PASSED\r\n");

  // Thats it
	
  //Blank Line
  dprintf("\r\n");

  return retval;

}

//---------------------------------------------------------------------------
// END       dmatest.c
//---------------------------------------------------------------------------
