//---------------------------------------------------------------------------
//
// %FILE     main.c
// %VSS-REV  $Revision: 36 $
// %CREATED  1995.12.13
// %REVISED  $Date: 4/18/97 4:10p $
// %AUTHOR   Noreen Bell 
// %PROJECT  NS486SXF evaluation board software
// %PART     NS486SXF, NS486SXL
// %SUMMARY  main NSTEST module 
//     
// %VSS      $Author: Miked $ $Date: 4/18/97 4:10p $ $Revision: 36 $
//
// DESCRIPTION
//
//   This module contains the main() function for the NSDEMO test and
//   several small support functions that were not useful enough to put
//   in their own modules.
//
// HISTORY
//
/*
 *
 * $History: main.c $ 
 * 
 * *****************  Version 36  *****************
 * User: Miked        Date: 4/18/97    Time: 4:10p
 * Updated in $/nsdemo
 * Added SXL support.  Increased buffer size for output messages.
 * Improved dprintf function to print to buffer, stdout (if available),
 * and internal UART.
 * 
 * *****************  Version 35  *****************
 * User: Miked        Date: 4/07/97    Time: 2:37p
 * Updated in $/nsdemo
 * Updated for SXL part.  Added semicolon to CPU_ macros to accomodate for
 * nsglobal.h change.
 * 
 * *****************  Version 34  *****************
 * User: Rhinda       Date: 3/21/97    Time: 4:01p
 * Updated in $/nsdemo
 * Added call to LM75() to test I2C.
 * 
 * *****************  Version 33  *****************
 * User: Miked        Date: 8/06/96    Time: 11:59a
 * Updated in $/nsdemo
 * Version 1.4.  Maintainance release.  See README.TXT for info.
 * 
 * *****************  Version 32  *****************
 * User: Miked        Date: 8/05/96    Time: 6:02p
 * Updated in $/nsdemo
 * Modified buf_printf to print to buffer and UART.  Also added format
 * specifier to PIC_Mapping output.
 * 
 * *****************  Version 31  *****************
 * User: Miked        Date: 7/23/96    Time: 2:25p
 * Updated in $/nsdemo
 * Maintainance release.  README.TXT describes changes.
 * 
 * *****************  Version 30  *****************
 * User: Miked        Date: 7/16/96    Time: 11:54a
 * Updated in $/nsdemo
 * Updated for rev C0 release.
 * 
 * *****************  Version 29  *****************
 * User: Miked        Date: 7/12/96    Time: 3:46p
 * Updated in $/nsdemo
 * Added version and date of NSDEMO after welcome banner.
 * Added display of IRQs 0, 8 (PIT 0 and RTC) to IRQ display routine.
 * 
 * *****************  Version 28  *****************
 * User: Miked        Date: 6/28/96    Time: 1:41p
 * Updated in $/nsdemo
 * Got rid of inline assembly.  Added more verbose REV/ID printout.
 * 
 * *****************  Version 27  *****************
 * User: Miked        Date: 6/26/96    Time: 3:21p
 * Updated in $/nsdemo
 * Added call to LCD_Test().
 * Fixed bug: moved CACHE_DISABLE to after REV and ID are read.
 * 
 * *****************  Version 26  *****************
 * User: Noreen       Date: 6/19/96    Time: 2:17p
 * Updated in $/nsdemo
 * Added code to execute cache bug fix only if RevB.
 * 
 * *****************  Version 25  *****************
 * User: Miked        Date: 6/07/96    Time: 10:03a
 * Updated in $/nsdemo
 * Commented out CACHE enable and disable macros.  Rev C does not need
 * this.  Might do this based on chip ID.
 * 
 * *****************  Version 24  *****************
 * User: Noreen       Date: 5/07/96    Time: 3:53p
 * Updated in $/nsdemo
 * Replaced code for PCMCIA with call to PCM_Test function.  
 * 
 * *****************  Version 23  *****************
 * User: Miked        Date: 5/03/96    Time: 2:50p
 * Updated in $/nsdemo
 * Maintainence release.
 * 
 * *****************  Version 22  *****************
 * User: Miked        Date: 4/18/96    Time: 12:58p
 * Updated in $/nsdemo
 * Made Buffer global to make it easier to examine in debuggers.
 * 
 * *****************  Version 21  *****************
 * User: Miked        Date: 4/18/96    Time: 11:30a
 * Updated in $/nsdemo
 * Clean up for release.
 * 
 * *****************  Version 20  *****************
 * User: Miked        Date: 4/17/96    Time: 3:55p
 * Updated in $/nsdemo
 * Added CACHE_ENABLE and CACHE_DISABLE.
 * 
 * *****************  Version 19  *****************
 * User: Miked        Date: 4/17/96    Time: 3:05p
 * Updated in $/nsdemo
 * Put DMA test before PCMCIA and modified PCMCIA messages.
 * 
 * *****************  Version 18  *****************
 * User: Noreen       Date: 4/17/96    Time: 2:47p
 * Updated in $/nsdemo
 * Updated PIC_Mapping function
 * 
 * *****************  Version 17  *****************
 * User: Miked        Date: 4/17/96    Time: 2:41p
 * Updated in $/nsdemo
 * Added UART test code.
 * 
 * *****************  Version 16  *****************
 * User: Noreen       Date: 4/17/96    Time: 1:45p
 * Updated in $/nsdemo
 * Moved PCMCIA function
 * 
 * *****************  Version 15  *****************
 * User: Noreen       Date: 4/17/96    Time: 12:50p
 * Updated in $/nsdemo
 * Added PCMCIA_Enable function
 * 
 * *****************  Version 14  *****************
 * User: Miked        Date: 4/17/96    Time: 12:04p
 * Updated in $/nsdemo
 * Added code to restore PIT to what Pharlap uses on exit.  We change the
 * PIT clock to support longer times.  If we don't change this back, the
 * clock will be counting at half the speed that Pharlap's ETS expects.
 * 
 * *****************  Version 13  *****************
 * User: Miked        Date: 4/17/96    Time: 11:25a
 * Updated in $/nsdemo
 * Changed output messages for better readability.
 * 
 * *****************  Version 12  *****************
 * User: Noreen       Date: 4/17/96    Time: 10:43a
 * Updated in $/nsdemo
 * Removed RIO_Test function.
 * 
 * *****************  Version 11  *****************
 * User: Noreen       Date: 4/17/96    Time: 10:23a
 * Updated in $/nsdemo
 * Redesigned print messages to dprintf
 * 
 * *****************  Version 10  *****************
 * User: Miked        Date: 4/17/96    Time: 10:02a
 * Updated in $/nsdemo
 * More minor changes for printf support.
 * 
 * *****************  Version 9  *****************
 * User: Miked        Date: 4/17/96    Time: 9:42a
 * Updated in $/nsdemo
 * Added buf_printf function.
 * 
 * *****************  Version 8  *****************
 * User: Noreen       Date: 4/17/96    Time: 9:35a
 * Updated in $/nsdemo
 * Added PIC_Mapping function
 * 
 * *****************  Version 7  *****************
 * User: Noreen       Date: 4/16/96    Time: 2:45p
 * Updated in $/nsdemo
 * Converted print messages for SSI and Phar Lap. 
 * Removed NMI test.
 * 
 * *****************  Version 6  *****************
 * User: Miked        Date: 4/12/96    Time: 3:07p
 * Branched in $/nsdemo
 * NS Demo
 * 
 * *****************  Version 5  *****************
 * User: Miked        Date: 4/12/96    Time: 2:00p
 * Updated in $/nstest
 * Renamed from maintest to main.
 * 
 * *****************  Version 4  *****************
 * User: Miked        Date: 4/12/96    Time: 11:54a
 * Updated in $/nstest
 * More changes to the globals.  Includes "nsglobal.h"
 * 
 * *****************  Version 3  *****************
 * User: Miked        Date: 4/12/96    Time: 10:44a
 * Updated in $/nstest
 * Sets up global Target Info structure prior to calling UART_Initialize.
 * Displays Target Info after initialize the UART.
 * Also cleaned up the output messages associated with Target Info.
 * 
 * *****************  Version 2  *****************
 * User: Miked        Date: 4/11/96    Time: 3:24p
 * Updated in $/board test
 * added ICA Target Info call.
 * Updated headers for VSS.
 *
 */
//
// COPYRIGHT
//
//      (c) 1995, 1996, 1997 National Semiconductor Corporation
//
//---------------------------------------------------------------------------

#include "main.h"

//---------------------------------------------------------------------------
// Globals
	
gDEVICE_INFO gDeviceInfo;  // global to store device ID and Revision
gTARGET_INFO gTargetInfo;  // global to store target info
char Buffer[3000];         // buffer for dprintf statements

//---------------------------------------------------------------------------

PRIVATE int BufLoc;        // used by dprintf to keep place in output buffer

//---------------------------------------------------------------------------
// Function Prototypes

PRIVATE USHORT Target_Info();
PRIVATE USHORT Display_Target_Info();
PRIVATE USHORT Device_Info();
PRIVATE USHORT Display_Device_Info();
PRIVATE USHORT PIC_Mapping(void);

//---------------------------------------------------------------------------
// Main NSDEMO routine.

void main(void)
{
	
	// Disable CPU Interrupts
	// This is done in PIC_Initialize also, but it done here just
	// as a precaution to avoid spurious interrupts before the
	// PIC_Initialize code is called
	CPU_CLI;
	
	// Set up globals
	gTargetInfo.valid = FALSE;
	BufLoc = 0;
	
	// Read Device ID & Revision.
	Device_Info();
	
	// Disable cache for NS486SXF revision B.
	if ((gDeviceInfo.id == ID_NS486SXF) && (gDeviceInfo.rev == SXF_REV_B))
	   CPU_DISABLE_CACHE;
	else
	   CPU_ENABLE_CACHE;

	// Initialize BIU 
	BIU_Initialize();
	
	// Read ICA Target Info
	Target_Info();

	// Initialize UART for displaying messages to user.
	UART_Initialize();

	// Display Intro Banner
	dprintf(NSDEMO_INTRO);
	dprintf("  Version: %s\r\n", NSDEMO_VERSION);
	dprintf("  Date:    %s\r\n\n", NSDEMO_DATE);

	//Display Device ID & Revision.
	Display_Device_Info();
	
	// Display Target Info
	Display_Target_Info();

	//Test DRAM Controller
	DRAM_Info();

	//Initialize PIC Controller
	PIC_Initialize();

	// Show PIC mappings of interrupts
	PIC_Mapping();

	//Test PIT
	PIT_Test();
	
	//Test DMA Controller
	if (gDeviceInfo.id == ID_NS486SXF) 
	  DMA_Test();

	//Test PCMCIA Controller
	if (gDeviceInfo.id == ID_NS486SXF) 
	  PCM_Test();

	//Test Real Time Clock
	RTC_Test();

	//Test Watchdog
	WD_Test();
  
	// UART Test
	dprintf("Internal UART:\r\n");
	dprintf("  Configured to 9600bps\r\n");  
	uart_printf("NS486SXF DEMO - Message to UART port.\r\n");
	dprintf("  Message sent to UART port\r\n\n");

	// Test I2C Interface 
	LM75();

	// LCD Test
	if (gDeviceInfo.id == ID_NS486SXF) 
	  LCD_Test();

  // This is just to restore the PIC Clock divisor and gate status
  // that Pharlap's ETS Lite has set up before we mucked with it.

  #ifdef PHARLAP
    IOW_BYTE( PIT_CLOCK, 0x02);   // Clock is OSC_CLK/2 / 16
    IOW_BYTE( PIT_TICR,  0x3A);   // Both gates high, pins are T0 & T1
  #endif

	// Display Exit Banner
	dprintf(NSDEMO_EXIT);
	
}

//---------------------------------------------------------------------------
// Debug printf function
//
// The macro "dprintf" should be used in NSDEMO for all output messages.
// Currently, this function handles the dprintf macro.  It works
// just like printf with the following changes:
//
//   o is limited to 200 characters (of formatted output) per call
//   o prints to a global buffer (defined in this file) - note: no overflow
//     checking is performed, so you must make the Buffer big enough to
//     handle all output
//   o echo's the output to the NS486SXF internal UART
//   o with Pharlap or OnTime (RTTarget) echo's the output to stdout, which
//     is displayed to the user through the run/debug interface

void debug_printf( const char *fmt, ... )
{
	
  va_list arg;
  char buf[200];

  va_start (arg, fmt);
  vsprintf( buf, (char *)fmt, arg);
  BufLoc += sprintf( Buffer+BufLoc, "%s", buf);   // print to Buffer
  uart_outs( buf );                               // print to UART
  #ifdef PHARLAP
  printf("%s", buf);                              // Pharlap: send to stdout
  #endif
  #ifdef ONTIME
  printf("%s", buf);                              // OnTime: send to stdout
  #endif
  va_end (arg);

}

//---------------------------------------------------------------------------
// read ICA target info

PRIVATE USHORT Target_Info()
{

	// locals

	ICA_TARGET_INFO target_info;
  
	// read ICA target Info

	if ( ICA_Target_Info_Read( & target_info ) == SUCCESS )
	{
    
	     // Set up global information

	     gTargetInfo.raw_cpu_speed = target_info.cpu_speed;
	     gTargetInfo.raw_dram_size = target_info.ram_size;
	     gTargetInfo.cpu_speed = ( target_info.cpu_speed / 1000000L );
	     gTargetInfo.dram_size = ( target_info.ram_size / 0x100000L );
	     gTargetInfo.valid = TRUE;
  
	}
	else
	{
    
	    // Set up global information
    
	    gTargetInfo.valid = FALSE;

	}

	// thats it

	return SUCCESS;

}

//---------------------------------------------------------------------------
// Display ICA target info to user

PRIVATE USHORT Display_Target_Info()
{

	// display message
	dprintf("Target Information provided by Target Loader:\r\n");

	// read ICA target Info

	if ( gTargetInfo.valid == TRUE )
	{
	     // display results
	     dprintf("  CPU Speed:  %d MHz\r\n", gTargetInfo.cpu_speed );
	     dprintf("  DRAM Size:  %d MB\r\n\n", gTargetInfo.dram_size );
	}
	else
	{
    
	  // display results
	  dprintf("  Target Info not valid.  DRAM setup may have\r\n");
	  dprintf("  changed or the ICA area overwritten!\r\n\n");
	}

	// thats it

	return SUCCESS;

}

//---------------------------------------------------------------------------
// Display the PIC internal interrupt mappings

// pic_mappings
// This function is used by PIC_Mappings below to print out PIC internal
// interrupt mappings
PRIVATE void pic_mappings( BYTE iisr, char irq[], char upper[], char lower[] )
{

  if ( iisr != 0 )
  {
    dprintf("%s",irq);
    if ( iisr & 0x80 ) dprintf("%s ",upper);
    if ( iisr & 0x40 ) dprintf("%s ",lower);
    if ( iisr & 0x20 ) dprintf("IRQ[5] ");
    if ( iisr & 0x10 ) dprintf("IRQ[4] ");
    if ( iisr & 0x08 ) dprintf("IRQ[3] ");
    if ( iisr & 0x04 ) dprintf("IRQ[2] ");
    if ( iisr & 0x02 ) dprintf("IRQ[1] ");
    if ( iisr & 0x01 ) dprintf("IRQ[0] ");
    dprintf("\r\n");
  }

} 

// PIC_Mapping
// Displays the PIC internal interrupt mappings.  Only displays SXF
// mappings right now, although this will be accurate for the SXL
// except that the new IRQ pins (IRQ[6] and IRQ[7]) will be ignored.
// The SXL will read "0" in bits that are not supported (DMA, LCD).
// Also note the PCMCIA and ECP mappings are not currently shown.
PRIVATE USHORT PIC_Mapping(void)
{
  
  BYTE iisr;

  dprintf("Programmable Interrupt Controller:\r\n");

  dprintf("  IRQ0:  Timer0 \r\n");
  iisr = IOR_BYTE(PIC_II1SR);  pic_mappings( iisr,"  IRQ1:  ", "Watchdog", "3Wire" );
  iisr = IOR_BYTE(PIC_II3SR);  pic_mappings( iisr,"  IRQ3:  ", "UART", "Timer1" );
  iisr = IOR_BYTE(PIC_II4SR);  pic_mappings( iisr,"  IRQ4:  ", "UART", "LCD" );
  iisr = IOR_BYTE(PIC_II5SR);  pic_mappings( iisr,"  IRQ5:  ", "Watchdog", "3Wire" );
  iisr = IOR_BYTE(PIC_II6SR);  pic_mappings( iisr,"  IRQ6:  ", "Watchdog", "Timer1" );
  iisr = IOR_BYTE(PIC_II7SR);  pic_mappings( iisr,"  IRQ7:  ", "DMA", "LCD" );
  dprintf("  IRQ8:  RealTimeClock \r\n");
  iisr = IOR_BYTE(PIC_II9SR);  pic_mappings( iisr,"  IRQ9:  ", "3Wire", "LCD" );
  iisr = IOR_BYTE(PIC_II10SR); pic_mappings( iisr,"  IRQ10: ", "UART", "DMA" );
  iisr = IOR_BYTE(PIC_II11SR); pic_mappings( iisr,"  IRQ11: ", "Watchdog", "3Wire" );
  iisr = IOR_BYTE(PIC_II12SR); pic_mappings( iisr,"  IRQ12: ", "Timer1", "LCD" );
  iisr = IOR_BYTE(PIC_II13SR); pic_mappings( iisr,"  IRQ13: ", "Watchdog", "LCD" );
  iisr = IOR_BYTE(PIC_II14SR); pic_mappings( iisr,"  IRQ14: ", "Timer1", "3Wire" );
  iisr = IOR_BYTE(PIC_II15SR); pic_mappings( iisr,"  IRQ15: ", "DMA", "UART" );
  dprintf("\r\n");

  return SUCCESS;

}

//---------------------------------------------------------------------------
// Read device ID and revision

PRIVATE USHORT Device_Info(void)
{

	gDeviceInfo.id = IOR_BYTE(NS486_ID);
	gDeviceInfo.rev = IOR_BYTE(NS486_REV);

	return SUCCESS;
}

//---------------------------------------------------------------------------
// Display device ID and Revision

PRIVATE USHORT Display_Device_Info()
{
    
    // display message
    
    dprintf("NS486 Identification:\r\n");

    // display ID and revision

    dprintf("  Device ID: %d  ", gDeviceInfo.id);
    
    switch ( gDeviceInfo.id )
    {
    case 1:
      dprintf("(NS486SXF)\r\n");
      dprintf("  Revision:  %d  ", gDeviceInfo.rev);
      switch ( gDeviceInfo.rev )
      {
      case 1:
	    dprintf("(Rev A)\r\n\n");
	    break;
      case 2:
	    dprintf("(Rev B)\r\n\n");
	    break;
      case 3:
	    dprintf("(Rev C)\r\n\n");
	    break;
      default:
	    dprintf("\r\n\n");
      }
      break;
    case 2:
      dprintf("(NS486SXL)\r\n");
      dprintf("  Revision:  %d  ", gDeviceInfo.rev);
      switch ( gDeviceInfo.rev )
      {
      case 1:
	    dprintf("(Rev A)\r\n\n");
	    break;
      default:
	    dprintf("\r\n\n");
      }
      break;
    default:
      dprintf("\r\n\n");
    }

    return SUCCESS;
}

//---------------------------------------------------------------------------
// END       main.c
//---------------------------------------------------------------------------
