TITLE  DRIVEIO
;
; --- CORVUS/IBM DRIVE INTERFACE UNIT FOR MICROSOFT ----
;		   PASCAL AND BASIC
;
;		VERSION 1.2  BY  BRK
;	   (MICROSOFT ASSEMBLER VERSION )
;
;	THIS UNIT IMPLEMENTS  5  PROCEDURES:
;
;	INITIO
;	CDRECV = DRVRECV
;	CDSEND = DRVSEND
;
;
;   NOTE: THIS INTERFACE UNIT NOW SUPPORTS BOTH PASCAL AND BASIC
;	  BUT IT MUST BE RE-ASSEMBLED WITH THE APPROPRIATE SETTING
;	  OF THE  "LTYPE"  EQUATE TO DO THIS FOR EACH LANGUAGE.
;
;
;
;	THE CALLING PROCEDURE IN PASCAL IS :
;
;		CDSEND (VAR st : longstring )
;
;	THE FIRST TWO BYTES OF THE STRING ARE THE LENGTH
;	OF THE STRING TO BE SENT OR THE LENGTH OF THE
;	STRING RECEIVED.
;
;		function INITIO : INTEGER
;
;	THE FUNCTION RETURNS A VALUE TO INDICATE THE STATUS OF
;	THE INITIALIZATION OPERATION.  A VALUE OF ZERO INDICATES
;	THAT THE INITIALIZATION WAS SUCCESSFUL.  A NON-ZERO VALUE
;	INDICATES THE I/O WAS NOT SETUP AND THE CALLING PROGRAM
;	SHOULD NOT ATTEMPT TO USE THE CORVUS DRIVERS.
;
;
;
;
;	THE CALLING PROCEDURE BASIC IS :
;
;		CALL CDSEND (B$ )
;
;	THE FIRST TWO BYTES OF THE STRING ARE THE LENGTH
;	OF THE STRING TO BE SENT OR THE LENGTH OF THE
;	STRING RECEIVED ( I.E. LEFT$(B$,2) ).
;
;		CALL INITIO (A%)
;
;	THE FUNCTION RETURNS A VALUE TO INDICATE THE STATUS OF
;	THE INITIALIZATION OPERATION.  A VALUE OF ZERO INDICATES
;	THAT THE INITIALIZATION WAS SUCCESSFUL.  A NON-ZERO VALUE
;	INDICATES THE I/O WAS NOT SETUP AND THE CALLING PROGRAM
;	SHOULD NOT ATTEMPT TO USE THE CORVUS DRIVERS.
;
;=============================================================
;			REVISION HISTORY
;
; FIRST VERSION : 10-05-82  BY BRK
;		: 11-01-82  improved turn around delay for mirror
;		: 05-16-83  merged Pascal and Basic versions
;
;=============================================================
;
TRUE	EQU	0FFFFH
FALSE	EQU	0
;
PASCAL	EQU	1	; LANGUAGE TYPE DESCRIPTOR
BASIC	EQU	2	; LANGUAGE TYPE DESCRIPTOR
;
;
LTYPE	EQU	PASCAL	; SET TO LANGUAGE TYPE TO BE USED WITH
;
REVB	EQU	0	; 0 IF REVA OR REVB DRIVE, 1 IF REVB DRIVE ONLY
;
;
; ----- CORVUS EQUATES -----
;
DATA	EQU	2EEH	; DISC I/O PORT #
STAT	EQU	2EFH	; DISC STATUS PORT
DRDY	EQU	1	; MASK FOR DRIVE READY BIT
DIFAC	EQU	2	; MASK FOR BUS DIRECTION BIT
;
;
PGSEG	SEGMENT 'CODE'
	ASSUME	CS:PGSEG
;
;
	IF	LTYPE EQ PASCAL
	DB	'CORVUS/IBM PC FLAT CABLE PASCAL DRIVER AS OF 05-16-83'
	ENDIF
;
	IF	LTYPE EQ BASIC
	DB	'CORVUS/IBM PC FLAT CABLE BASIC  DRIVER AS OF 05-16-83'
	ENDIF
;
;
; --- INITIALIZE CORVUS I/O DRIVERS ---
;
;	THIS ROUTINE MUST BE CALLED
;	ONCE TO SETUP THE DRIVERS BEFORE
;	THEY ARE USED. IF THE ROUTINE DOES
;	ANYTHING THAT CAN ONLY BE DONE ONCE,
;	IT MUST DISABLE THIS SECTION SO THAT
;	AND ACCIDENTAL SECOND CALL WILL NOT
;	LOCK UP THE HARDWARE.
;
	PUBLIC INITIO
;
INITIO	PROC	FAR
;
	IF	LTYPE EQ PASCAL
	MOV	AX,0		; RETURN A ZERO
	RET
	ENDIF
;
	IF	LTYPE EQ BASIC
	PUSH	BP
	MOV	BP,SP
	MOV	BX,6 [BP]	; GET POINTER TO DATA "INTEGER"
	MOV	word ptr [BX],0 ; RETURN A ZERO
	POP	BP
	RET	2
	ENDIF
;
INITIO	ENDP
;
;
; --- RECEIVE A STRING OF BYTES FROM THE DRIVE ---
;
	PUBLIC	CDRECV, DRVRECV
;
CDRECV	PROC	FAR
DRVRECV:
	PUSH	BP		; SAVE FRAME POINTER
	MOV	BP,SP		; SET NEW ONE
;
;	IF	LTYPE EQ PASCAL
;	MOV	DI,6 [BP]	; GET ADDRESS OF STRING TO SAVE DATA IN
;	ENDIF
;
;	IF	LTYPE EQ BASIC
;	MOV	BX,6 [BP]	; GET ADDRESS OF STRING DESCRIPTOR
;	INC	BX
;	INC	BX		; POINT TO STRING POINTER
;	MOV	DI,[BX] 	; GET ADDRESS OF STRING TO SAVE DATA IN
;	ENDIF
;
	PUSH	ES
	PUSH	DI		; SAVE POINTER TO 'LENGTH'
	INC	DI		; POINT TO START OF DATA AREA
	INC	DI
;
	MOV	AX,DS
	MOV	ES,AX		; SET SEGMENT # FOR SAVING DATA
	CLD			; SET TO AUTO-INCREMENT
;
	MOV	DX,STAT 	; POINT TO STATUS PORT
;
;  --- FANCY "MIRROR" COMPATIBLE TURN ROUTINE ---
;
TURN:	IN	AL,DX		; GET STATUS BYTE
	TEST	AL,DIFAC	; LOOK AT BUSS DIRECTION
	JNE	TURN		; WAIT FOR "DRIVE TO HOST"
	TEST	AL,DRDY 	; LOOK AT "READY STATUS"
	JNE	TURN		; IF NOT READY, KEEP LOOPING
;
	CALL	SDELAY		; WAIT A MOMENT
;
	IN	AL,DX		; GET STATUS AGAIN
	TEST	AL,DIFAC
	JNE	TURN		; WAIT FOR "DRIVE TO HOST"
	TEST	AL,DRDY 	; LOOK AT "READY STATUS"
	JNE	TURN		; WAIT FOR "READY
;
	CALL	SDELAY
;
	MOV	CX,0		; INIT LENGTH COUNT
;
RLP:	IN	AL,DX		; GET STATUS BYTE
	TEST	AL,DRDY
	JNE	RLP		; LOOP UNTIL READY
;
	IN	AL,DX		; GET STATUS BYTE
	TEST	AL,DIFAC	; TEST BUS DIRECTION
	JNE	RLPE		; IF "HOST TO DRIVE", EXIT
;
	TEST	AL,DRDY 	; TEST FOR 'READY'
	JNZ	RLP		; DOUBLE CHECK THAT IT IS READY
;
	DEC	DX		; POINT TO DATA PORT
	IN	AL,DX		; GET DATA BYTE
	INC	DX		; POINT BACK TO STATUS PORT
	STOSB			; STORE DATA BYTE IN DATA STRING
	INC	CX		; INCREMENT LENGTH COUNTER
	JMP	RLP		; LOOP UNTIL DONE
;
RLPE:	POP	DI		; GET POINTER BACK TO LENGTH
	POP	ES
	MOV	ES:[DI],CX	; SET LENGTH OF RETURNED STRING
	POP	BP		; GET FRAME POINTER BACK
;	RET	2		; CLEAR RETURN STACK
	RET
CDRECV	ENDP
;
; --- SEND STRING OF BYTES TO DRIVE ---
;
	PUBLIC	CDSEND, DRVSEND
;
CDSEND	PROC	FAR
DRVSEND:
	PUSH	BP		; SAVE FRAME POINTER
	MOV	BP,SP		; SET NEW ONE
;
;	IF	LTYPE EQ PASCAL
;	MOV	SI,6 [BP]	; GET ADDRESS OF STRING TO SEND
;	ENDIF
;
;	IF	LTYPE EQ BASIC
;	MOV	BX,6 [BP]	; GET ADDRESS OF STRING DESCRIPTOR
;	INC	BX
;	INC	BX		; POINT TO STRING POINTER
;	MOV	SI,[BX] 	; GET ADDRESS OF STRING TO SAVE DATA IN
;	ENDIF
;
	MOV	CX,[SI] 	; GET STRING LENGTH
	JCXZ	ENDSND		; IF NULL STRING, JUST RETURN
;
	INC	SI		; POINT TO START OF DATA TO SEND
	INC	SI
	CLD			; SET TO AUTO-INCREMENT
;
	LODSB			; GET FIRST BYTE OF DATA
	CALL	WAITO		; SEND FIRST BYTE USING INTERRUPT TEST
;
	INC	DX		; POINT TO STATUS PORT
	JMP	WLP1		; ENTER COUNTING LOOP
;
WLP:	IN	AL,DX		; READ STATUS BYTE
	TEST	AL,DRDY 	; IS DRIVE READY FOR NEXT ACTION?
	JNZ	WLP		; NO, SO KEEP LOOPING
	DEC	DX		; POINT TO DATA PORT
WLPB:	LODSB			; YES, GET DATA BYTE FROM 'DMA' LOCATION
;
	IF	REVB-1		; FOR REV A OR REV B DRIVES
	OUT	DX,AL		; SEND DATA BYTE TO DISC
	INC	DX		; POINT BACK TO STATUS PORT
WLP1:	LOOP	WLP		; LOOP UNTIL TRANSFER IS COMPLETE
	ENDIF
;
	IF	REVB		; FOR REV B DRIVES ONLY
	OUT	DX,AL		; SEND DATA BACK TO STATUS PORT
WLP1:	LOOP	WLPB		; LOOP WITHOUT STATUS TEST
	ENDIF
;
ENDSND: POP	BP		; GET FRAME POINTER BACK
;	RET	2		; CLEAR RETURN STACK
	RET
CDSEND	ENDP
;
;
; --- SHORT DELAY ROUTINE ---
;
SDELAY	PROC	NEAR
	MOV	CL,30		; SETUP FOR SHORT DELAY
DELAY:	DEC	CL		; LOOP UNTIL DONE
	JNZ	DELAY		; DELAY TO AVOID BUS TURN AROUND GLITCHES
	RET
SDELAY	ENDP
;
; --- WAIT AND OUTPUT BYTE TO CONTROLLER ---
;	INTERRUPTS ARE SWITCHED HERE
;	   TO AVOID PROBLEMS WITH
;	       CONSTELLATION
;
WAITO	PROC	NEAR
	PUSH	AX		; SAVE DATA BYTE
WAITO1: STI			; ALLOW INTERRUPTS
	MOV	DX,STAT 	; POINT TO STATUS PORT
	NOP			; ADDITIONAL DELAY FOR INTERRUPT
	CLI			; DISABLE INTERRUPTS
	IN	AL,DX		; GET STATUS BYTE
	TEST	AL,DRDY 	; IS DRIVE READY?
	JNZ	WAITO1		; NO, SO LOOP
	POP	AX		; GET DATA BACK
	DEC	DX		; POINT TO DATA PORT
	OUT	DX,AL		; OUTPUT BYTE
	STI			; ALLOW INTERRUPTS
	RET
WAITO	ENDP
;
PGSEG	ENDS
;
	END
