
;**************************************************************************
;
; LOGON -	mount user's MSDOS volumes
;
;	4.01	WILLIAM E. KLINE - 17-Oct-84
;		1. Original release
;	4.02	WILLIAM E. KLINE - 24-Oct-84
;		1. Fix command line parsing
;	4.03	WILLIAM E. KLINE - 30-Oct-84
;		1. Fix command line parsing again
;	4.04	WILLIAM E. KLINE - 15-Nov-84
;		1. Change echo to use new stlye echo in CORDRV
;		   that is compatible with the Companion
;		2. Jump into PBOOT at offset 6 instead of 2 for
;		   PBOOT 2.8
;	4.05	BRUCE R. KENDALL - 27-Nov-84
;		put in some condition assembly changes to support
;		other MSDOS systems ( other than IBM ) by reference to
;		values in SYSTEM.EQU file ( this is mainly done by
;		not permitting P-system booting ).
;	4.10	WILLIAM E. KLINE - 05-feb-85
;		1. Put user name in 'HELLO' mesage
;		2. Change for Omnishare
;		   - don't do ECHOs or WAYs if emulator station
;		3. Read server name from block 8 if Omnishare emulator
;		   or old (not multiple server) disk server
;		4. Changes for Bank
;		   - always use large FAT defined at"DEFFAT" for any
;		     extra units
;		   - mount from Bank if /B switch in CONFIG.SYS or if
;		     only Banks are online
;		5. Handle a zero server count better
;		6. Speed up table searches
;		7. Read DI table directly into buffer "%DIREC"
;		8. Look for internal user name and only allocate FATs
;		   to units if that name is entered
;	4.20	NORMAN O. DOYLE - 26-Mar-85
;		1. Modified for use with SHADOW drive.	Sets up the
;		   SHADOW_TBL that is located in CORDRV.  Only mounts
;		   volumes for drives that are not SHADOW drives or
;		   that are master drives in a SHADOW pair.
;
; NOTE: when changes are made, update this revision history and increment
;	the appropriate version number equates (LVER, LREV, & LSUBREV).
;**************************************************************************

IF1
  IF (SHADOW)
	%OUT	< Including SHADOW Drive version of LOGON.INC >
  ELSE
	%OUT	< Including LOGON.INC >
  ENDIF
ENDIF

;**************************************************************************
;
;	the PSYSOK equate is TRUE for systems that will support P-system
;	boot with a loadable PBOOT.DAT file.
;
PSYSOK	=	(SYSTYP EQ IBMT) OR (SYSTYP EQ IBMX) OR ( SYSTYP EQ IBMF )
PSYSOK	=	PSYSOK OR (SYSTYP EQ IBM )
PSYSOK	=	PSYSOK OR (SYSTYP EQ Z100F) OR (SYSTYP EQ Z100T)
PSYSOK	=	PSYSOK OR (SYSTYP EQ TIT) OR (SYSTYP EQ TIF)
PSYSOK	=	PSYSOK OR (SYSTYP EQ TI) OR (SYSTYP EQ TIX)
;
;
;
;**************************************************************************

	JMP	LOGON			;jump to program start

;**************************************************************************
;
; CONSTANTS, STORAGE, AND LITERALS
;
;**************************************************************************

LVER	EQU	4			;
LREV	EQU	2			;
LSUBREV EQU	0			;

;ASCII Equates
BACKSPC EQU	08H			;ASCII back space
BELL	EQU	07H			;ASCII bell
BLANK	EQU	20H			;ASCII blank
COLON	EQU	3AH			;ASCII colon
DOT	EQU	2EH			;ASCII dot
ESCAPE	EQU	1BH			;ASCII escape
SLASH	EQU	2FH			;ASCII slash
STAR	EQU	2AH			;ASCII star

;X-Y Equates
XYLOGO	EQU	061AH			;

XYSTAR1 EQU	0003H+XYLOGO		;
XYSTAR2 EQU	0101H+XYLOGO		;

XYLINE1 EQU	0200H+XYLOGO		;
XYLINE2 EQU	0406H+XYLOGO		;

XYNAMEL EQU	0F00H			;name prompt position
XYPSWL	EQU	0200H+XYNAMEL		;password prompt position
XYNAME	EQU	0F18H			;name response
XYPSW	EQU	111CH			;password response

XYERR	EQU	0300H+XYPSWL		;error messages appear here
XYHOMERR EQU	0			;home position for certain messages
XYCONT	EQU	0200H+XYERR		;continue message

XYSTAT	EQU	1805H			;version
XYBTSRV EQU	001CH+XYSTAT		;boot server
XYSTN	EQU	003AH+XYSTAT		;station number

;**************************************************************************

;CONST II table Equates (ALL VALUES ARE DECIMAL)

;Number of entries/block
NURPB	EQU	16			;number of NU entries/block
DVRPB	EQU	16			;number of DV entries/block
DURPB	EQU	16			;number of DU entries/block
DARPB	EQU	64			;number of DA entries/block

;Size of entries
DIRECSZ EQU	512			;size of one DI record
NURECSZ EQU	32			;size of one NU record
DVRECSZ EQU	32			;size of one DV record
DURECSZ EQU	32			;size of one DU record
DARECSZ EQU	8			;size of one DA record

;DI table Equates
SPECIAL EQU	68			;set to 1982 if drive is initialized
DRVINIT EQU	52			;
DRVNO	EQU	54			;
ONLINE	EQU	56			;

NUBLKS	EQU	58			;size of NU table
DVBLKS	EQU	60			;size of DV table
DUBLKS	EQU	62			;size of DU table
DABLKS	EQU	64			;size of DA table

NUADDR	EQU	70			;NU table address
DVADDR	EQU	74			;DV table address
DUADDR	EQU	78			;DU table address
DAADDR	EQU	82			;DA table address

;NU table Equates
NUUSER	EQU	0			;user's name (encrypted)
NUPSW	EQU	10			;user's password (encrypted)
NUHSRV	EQU	18			;user's home server (encrypted)
NUOPSYS EQU	28			;user's operating system type

;DV table Equates
DVVOLNM EQU	0			;volume name
DVSTBLK EQU	10			;starting block
DVENDBLK EQU	14			;ending block
DVVTYPE EQU	18			;volume type
DVWRITE EQU	19			;writeable
DVGLB	EQU	20			;global access
DVVOFF	EQU	21			;volume offset from start

;DU table Equates
DUUSER	EQU	0			;user's name (encrypted)
DUPSW	EQU	10			;user's password (encrypted)
DUID	EQU	18			;user's id
DUMNT	EQU	20			;number of volumes mounted
DUACC	EQU	22			;number of volumes accessible
DUBT	EQU	24			;1=user's boot volumes is on this drive

;DA table Equates
DAID	EQU	0			;user's id
DAVADDR EQU	2			;starting block of volume
DAMNTINFO EQU	6			;OS dependent mount information
DARO	EQU	7			;read only
DABOOT	EQU	7			;boot volume

;**************************************************************************

;Server table Equates
DEVTYP	EQU	0			;device type offset
NODENUM EQU	1			;node number offset
SRVRNAM EQU	2			;server name offset
ENTRYSZ EQU	12			;size of one entry
TBLSZ	EQU	64			;number of entries


;Miscellaneous Equates
XMIT	EQU    ((WAIT*100H)+RETRIES)	;wait time and retries
BPBSZ	EQU	13			;size of a BPB entry
CMDLINE EQU	12H			;offset into RH of pointer to cmd line
MSDOS	EQU	4			;MSDOS type in NU table
MSDOSVL EQU	3			;MSDOS volume type in DV table
UCSD	EQU	17			;MSDOS type in NU table

DSKSERV EQU	1			;generic disk server device type
BANK	EQU	5			;Bank device type
ODRIVE	EQU	6			;Omnidrive device type

;**************************************************************************
;
; Storage
;
;**************************************************************************

EVEN
%VIDEO: DD	0			;offset and segment
MOUNTED:DW	0			;number of mounted volumes
%USERID:DW	0			;user ID from DU table
%NUMSRV:DW	0			;# of servers on the net (default=1)
%SRVPTR:DW	%SRVTBL 		;pointer into server table
%STKPTR:DW	0			;save stack pointer here

XTRAPTR:DW	XTRAVOL 		;pointer to extra vol. DV records
NUMXTRA:DW	0			;number of extra volumes

%CRYPTNM:DB	10 DUP (0)		;encrypted name
%CRYPPSW:DB	10 DUP (0)		;encrypted password
USERNAM:DB	"NULLUSER  "            ;user name
%HOMSRV:DB	10 DUP (0)		;home server name (decrypted)
%VOLNM: DB	10 DUP (0)		;current volume name (decrypted)

%ECHO:	DB	0			;FF = don't echo character
%MAXCHR:DB	0			;maximum number of characters wanted
%CHRTYP:DB	0			;number of characters typed
%INBUFF:DB	20 DUP (0)		;input buffer from console

%SERVER:DB	0			;server
%DRIVE: DB	0			;drive
%DIADDR:DB	0,0,0,8 		;address of DI table
BLKADDR:DB	0,0,0,0 		;block address
%RDCMD: DB	032H,0,0,0		;drive read command
%RETLEN:DB	0			;return length from drive command
%ERRCOD:DB	0			;error code from drive

;**************************************************************************

;Flags and Counters
%ESCFLG:DB	0			;FF = ESCAPE was pressed
FATONLY:DB	0			;FF = don't mount, only assign FATs
PSYSTEM:DB	0			;FF = booting the p-system
%WAYCNT:DB	0			;attempts to do a WHO ARE YOU
%USRFLG:DB	0			;FF = command line user name
DEV1OR6:DB	0			;non zero means device 1 or 6 found
BANKOK: DB	0			;FF = mount from Banks

;**************************************************************************

;Default BPBTBL entry
DEFFAT: DW	512			;sector size
	DB	16			;sectors/block
	DW	1			;reserved sectors
	DB	2			;# of FATs
	DW	256			;# of directory entries
	DW	65535			;# of sectors/disk
	DB	-1			;media descriptor
	DW	64			;# of sectors/FAT

;**************************************************************************

;CONSTELLATION II server commands
WHOAREYOU LABEL NEAR
	DB	01,0FEH 		;protocol ID
	DB	02,0			;message type
	DB	0			;
WAYSRC: DB	0			;source
WAYDEV: DB	0,0FFH			;responding device type wanted

ID	LABEL	NEAR
	DW	0			;protocol ID
	DW	0			;message type
	DB	0			;
IDSRC:	DB	0			;sending station's address
	DB	0			;
IDDEV:	DB	0			;sending station's device type
IDNM:	DB	10 DUP (0)		;sending station's name

HELLO	LABEL	NEAR
	DB	01,0FEH 		;protocol ID
	DB	0,0			;message type
	DB	0			;
HSRC:	DB	0			;source
	DB	0			;
	DB	HELLOTYP		;our device type (IBM, TI, etc.)
HNAME:	DB	10 DUP (0)		;our name

ADDACTIVE LABEL NEAR
	DB	34H,3			;disk command
ADDNAME:DB	10 DUP (0)		;our name
	DB	6 DUP (0)		;filler

;**************************************************************************

;Echo Table
%ECHOTBL:DB	(TBLSZ) DUP (0FFH)	;fill with FF's

;Server table
%SRVTBL:DB	(ENTRYSZ*TBLSZ) DUP (0FFH) ;

;Storage for a Read Shadow Status command
;
SHADOW_STAT2	LABEL	NEAR
DRVMOD2 DB	0			; Drive mode flag
	DB	0
	DB	0
	DB	0

;Buffers for block reads
EVEN
%BUFF1: DB	200H DUP (0)		;
%BUFF2: DB	200H DUP (0)		;

;Buffers for storage
%DAREC: DB	DARECSZ DUP (0) 	;store current DA entry here
%DVREC: DB	DVRECSZ DUP (0) 	;store current DV entry here
%DIREC	LABEL	NEAR
DIDRVNM:DB	10 DUP (0)		;drive name
DIDRVPW:DB	8  DUP (0)		;drive password
DISRVNM:DB	10 DUP (0)		;server name
DISRVPW:DB	8  DUP (0)		;server password
	DB	(DIRECSZ - ($ - %DIREC)) DUP (0)  ;rest of buffer

XTRAVOL:DB	((2+DARECSZ+DVRECSZ)*CV_MAX) DUP (0) ;storage for extra vol.

;**************************************************************************

;Literals
SEARCH	DB	"Searching for Network Servers..."
CRLF	DB	CR,LF,"$"

ASKFORSRV DB	"Cannot find home server; please enter server address: ","$"

TWOSTAR DB	"* *","$"
LINE1	DB	"C O R V U S   S Y S T E M S","$"
LINE2	DB	"CONSTELLATION II",CR,LF,LF
  IF (SHADOW)
	DB	33 DUP (" "),"SHADOW VERSION"
  ENDIF
	DB	"$"

NAMEL	DB	"Please enter your name:","$"
PSWL	DB	"Please enter your password:","$"

MNTL1	DB	"Mounting Volume ","$"
MNTL2	DB	" from Server ","$"
MNTL3	DB	" on UNIT ","$"

VERLINE DB	"Version: ",LVER+30H,".",LREV+30H,LSUBREV+30H,"$"
BTLINE	DB	"Boot Server: ","$"
STNLINE DB	"Station: ","$"

;**************************************************************************

;Error messages
MSGBADDI DB	"Cannot read Drive Information table","$"

MSGINVDI DB	"Drive is not initialized","$"

MSGUSER  DB	"User not found","$"

MSGPSW	 DB	"Incorrect password","$"

MSGINVOS DB	"User's operating system is not supported","$"

UNKPRMMSG DB	"Unknown parameter in CONFIG.SYS command line",CR,LF,"$"

BLKERR	 DB	"Block Read Error","$"

CONTINUE DB	" - Press Any Key To Continue","$"

MNTABORT DB	CR,LF,"Volume mounting aborted",CR,LF,"$"

PAGE
;**************************************************************************
;
; I/O and VIDEO ROUTINES
;
;**************************************************************************

;**************************************************************************
;
; PRNTSTR, PRNTCHR, PRNTNM and PRNTDEC
;
;**************************************************************************

PRNTSTR PROC	NEAR
	MOV	AH,09H			;MSDOS print string function
	INT	21H			;
	RET				;
PRNTSTR ENDP

;**************************************************************************

PRNTCHR PROC	NEAR
	MOV	AH,02H			;MSDOS print character function
	INT	21H			;
	RET				;
PRNTCHR ENDP

;**************************************************************************

PRNTNM	PROC	NEAR
	MOV	CX,10			;print 10 characters pointed to
PRTNM1: MOV	DL,BYTE PTR [BX]	;.by BX
	INC	BX			;
	CALL	PRNTCHR 		;
	LOOP	SHORT PRTNM1		;
	RET				;
PRNTNM	ENDP

;**************************************************************************

PRTDECB PROC	NEAR
	XOR	AH,AH			;print value of AL in decimal
PRTDECW:PUSH	CX			;print value of AX in decimal
	PUSH	DX			;
	CALL	PRNTDEC 		;
	POP	DX			;
	POP	CX			;
	RET				;

PRNTDEC:MOV	CX,10			;
PRNTD1: CWD				;divide by 10
	IDIV	CX			;
	PUSH	DX			;save remainder
	CMP	AX,0			;recurse if more digits
	JE	SHORT PRNTD2		;
	CALL	PRNTD1			;
PRNTD2: POP	DX			;get a digit, convert to ASCII
	ADD	DX,"0"                  ;.and print
	CALL	PRNTCHR 		;
	RET				;
PRTDECB ENDP

;**************************************************************************
;
; PUTLOGO -	displays the Corvus logo
;
;**************************************************************************

PUTLOGO PROC NEAR
	CALL	HOME			;clear screen home cursor
	CALL	STARS			;
	MOV	DX,XYLINE1		;
	CALL	POSCUR			;
	MOV	DX,OFFSET LINE1 	;
	CALL	PRNTSTR 		;
	MOV	DX,XYLINE2		;
	CALL	POSCUR			;
	MOV	DX,OFFSET LINE2 	;
	CALL	PRNTSTR 		;
	CMP	BYTE PTR XPORTER,0FFH	;check if flat cable and if so just
	JE	SHORT PUTL1		;.print version number
	MOV	DX,XYSTAT		;position to start of status line
	CALL	POSCUR			;
	MOV	DX,OFFSET VERLINE	;print version
	CALL	PRNTSTR 		;
	MOV	DX,XYBTSRV		;
	CALL	POSCUR			;
	MOV	DX,OFFSET BTLINE	;print boot server
	CALL	PRNTSTR 		;
	MOV	AL,BYTE PTR BSERVER	;
	CALL	PRTDECB 		;
	MOV	DX,XYSTN		;
	CALL	POSCUR			;
	MOV	DX,OFFSET STNLINE	;print station number
	CALL	PRNTSTR 		;
	MOV	AL,BYTE PTR XPORTER	;
	CALL	PRTDECB 		;
	RET				;

PUTL1:	MOV	DX,XYBTSRV		;center version
	CALL	POSCUR			;
	MOV	DX,OFFSET VERLINE	;
	CALL	PRNTSTR 		;
	RET				;

;**************************************************************************

STARS:	MOV	DX,XYSTAR1		;print out the Corvus stars
	CALL	POSCUR			;
	MOV	DL,STAR 		;
	CALL	PRNTCHR 		;
	MOV	DX,XYSTAR2		;
	CALL	POSCUR			;
	MOV	DX,OFFSET TWOSTAR	;
	CALL	PRNTSTR 		;
	RET				;
PUTLOGO ENDP

;**************************************************************************
;
; MNTMSG -	volume mounted message
;
;		DESTROYS - DX
;
;**************************************************************************

MNTMSG	PROC	NEAR
	PUSH	AX				;
	PUSH	BX				;
	PUSH	DI				;
	PUSH	SI				;
	MOV	SI,BX				;decrypt volume name, volume
	MOV	DI,OFFSET %VOLNM		;.name is first field
	CALL	NAMDECRYPT			;
	MOV	DX,OFFSET MNTL1 		;start literal
	CALL	PRNTSTR 			;
	MOV	BX,OFFSET %VOLNM		;print volume name
	CALL	PRNTNM				;
	MOV	DX,OFFSET MNTL2 		;say from which server
	CALL	PRNTSTR 			;
	MOV	AL,BYTE PTR %SERVER		;search for matching server
	MOV	BX,OFFSET %SRVTBL		;.table entry and get the
	MOV	CX,64				;.server name

MNTM0:	MOV	AH,BYTE PTR [BX+NODENUM]	;
	AND	AH,07FH 			;isolate just server address
	CMP	AH,AL				;
	JE	SHORT MNTM1			;
	ADD	BX,ENTRYSZ			;
	LOOP	MNTM0				;

MNTM1:	ADD	BX,SRVRNAM			;
	CALL	PRNTNM				;
	MOV	DX,OFFSET MNTL3 		;say on which unit
	CALL	PRNTSTR 			;
	POP	SI				;restore pointer to DA record
	MOV	DL,BYTE PTR [SI+DAMNTINFO]	;
	ADD	DL,BYTE PTR FLOPPIES		;account for devices already
	ADD	DL,40H				;.mounted, add ASCII and
	CALL	PRNTCHR 			;.upper case bias, print
	MOV	DX,OFFSET CRLF			;finish with CR, LF
	CALL	PRNTSTR 			;
	POP	DI				;
	POP	BX				;
	POP	AX				;
	RET					;
MNTMSG	ENDP

;**************************************************************************
;
; ERRCON and ERRMSG
;
;**************************************************************************

ERRCON	PROC	NEAR
	PUSH	DX				;save error message
	MOV	DL,BELL 			;...beep...
	CALL	PRNTCHR 			;
	MOV	DX,XYERR			;
	CALL	POSCUR				;
	POP	DX				;print error message
	CALL	PRNTSTR 			;
	MOV	DX,OFFSET CONTINUE		;wait for a key press
	CALL	PRNTSTR 			;
	CALL	GETKYB				;
	MOV	DX,XYERR			;
	CALL	POSCUR				;
	CALL	CLREOL				;clear line and continue
	RET					;
ERRCON	ENDP

ERRMSG	PROC	NEAR
	PUSH	DX				;
	MOV	DL,BELL 			;...beep...
	CALL	PRNTCHR 			;
	POP	DX				;
	CALL	PRNTSTR 			;
	RET					;
ERRMSG	ENDP

;**************************************************************************
;
; HOME, POSCUR, and CLREOL
;
;**************************************************************************

HOME	PROC	NEAR

	MOV	AH,1			;home
	CALL	DWORD PTR [%VIDEO]	;
	RET				;

CLREOL: MOV	AH,2			;clear to end of line
	CALL	DWORD PTR [%VIDEO]	;
	RET				;

POSCUR: MOV	AH,3			;position cursor; cursor position
	CALL	DWORD PTR [%VIDEO]	;.in DX (DH=ROW, DL=COLUMN)
	RET				;

HOME	ENDP

PAGE
;**************************************************************************
;
; KEYBOARD ROUTINES
;
;**************************************************************************

;**************************************************************************
;
; BUFIN -	buffered input
;
;		requires a data space of the following form
;		BYTE1:	   # of chars wanted
;		BYTE2:	   # of chars typed
;		BYTE3 - N: buffer for chars, as least as big as BYTE 1
;
;		also requires a one byte flag %ECHO, 0 = echo character
;
;		ON ENTRY - DX contains address of data space
;		ON EXIT  - carry set if ESCAPE	was typed or carriage
;			   return was first character typed; BYTE2 set
;			   to number of characters typed
;
;		ALL REGISTERS PRESERVED
;		CALLS ROUTINES: "GETKYB" and "PRNT"
;
;**************************************************************************

BUFIN	PROC   NEAR
	PUSH	BX			;save regs used
	PUSH	DI			;
	PUSH	CX			;
	PUSH	AX			;
	PUSH	DX			;
	MOV	BX,DX			;address of data space
	MOV	DI,DX			;
	ADD	DI,2			;DI now points at buffer
	XOR	CX,CX			;clear count

BUFIN1: CALL	GETKYB			;get char from keyboard
	JC	SHORT ESCEXT		;carry set means ESCAPE
	CMP	AL,CR			;check for a carriage return,
	JE	SHORT GOTCR		;.backspace, control chars., etc.
	CMP	AL,BACKSPC		;
	JE	SHORT GOTBS		;
	CMP	AL,BLANK		;
	JL	SHORT BUFIN1		;
	CMP	CL,BYTE PTR [BX]	;see if we got all the characters
	JE	SHORT GOTALL		;.we want

	MOV	BYTE PTR [DI],AL	;save character
	INC	DI			;
	INC	CX			;
	CMP	BYTE PTR %ECHO,0	;check if we should echo character,
	JE	SHORT BUFIN2		;.if not print a dot
	MOV	AL,DOT			;
BUFIN2: CALL	PRNT			;display it
	JMP	SHORT BUFIN1		;get the next

GOTALL: MOV	AL,BELL 		;got all charcters we wanted so
	CALL	PRNT			;.bitch about any more
	JMP	SHORT BUFIN1		;

GOTBS:	JCXZ	SHORT BUFIN1		;if no chars yet ignore BS
	CALL	PRNT			;else back up cursor
	MOV	AL,BLANK		;blank out char
	CALL	PRNT			;
	MOV	AL,BACKSPC		;back up cursor again
	CALL	PRNT			;
	DEC	DI			;dec char count and buffer pointer
	DEC	CX			;
	MOV	AL,BLANK		;blank out char in buffer
	MOV	BYTE PTR [DI],AL	;
	JMP	SHORT BUFIN1		;go for more

ESCEXT: STC				;show ESCAPE
	MOV	BYTE PTR [BX+1],0	;no chars. returned
	JMP	SHORT BUFEXT		;
GOTCR:	JCXZ	SHORT ESCEXT		;if carriage return is first char
	CLC				;.return with carry set
	MOV	BYTE PTR [BX+1],CL	;
BUFEXT: POP	DX			;restore regs and return
	POP	AX			;
	POP	CX			;
	POP	DI			;
	POP	BX			;
	RET				;
BUFIN	ENDP

;**************************************************************************

GETKYB	PROC	NEAR
	MOV	AH,08H			;get character from keyboard
	INT	21H			;
	CMP	AL,ESCAPE		;set carry and return if ESCAPE
	JE	SHORT GETK2		;
	CMP	AL,'a'                  ;
	JL	SHORT GETK1		;
	CMP	AL,'z'                  ;
	JG	SHORT GETK1		;
	SUB	AL,20H			;convert to upper case
GETK1:	CLC				;show that ESCAPE was pressed
	RET				;
GETK2:	STC				;
	RET				;
GETKYB	ENDP

;**************************************************************************

GETDEC	PROC	NEAR
	PUSH	SI			;
	PUSH	BX			;
	PUSH	CX			;
	PUSH	DX			;
	MOV	BYTE PTR %ECHO,0	;echo characters
	MOV	BYTE PTR %MAXCHR,02	;two digits maximum
	MOV	DX,OFFSET %MAXCHR	;
	XOR	AX,AX			;return zero if no characters typed
	CALL	BUFIN			;
	JC	SHORT GETDEC3		;
	XOR	CH,CH			;
	MOV	CL,BYTE PTR %CHRTYP	;loop for number of characters typed
	MOV	SI,OFFSET %INBUFF	;
GETDEC1:MOV	BL,BYTE PTR [SI]	;
	INC	SI			;
	SUB	BL,"0"                  ;
	JL	SHORT GETDEC4		;
	CMP	BL,9			;
	JG	SHORT GETDEC4		;
	CBW				;
	MOV	DX,10			;
	MUL	DX			;
	ADD	AX,BX			;
	LOOP	GETDEC1 		;

GETDEC3:POP	DX			;
	POP	CX			;
	POP	BX			;
	POP	SI			;
	RET				;

GETDEC4:STC				;show error
	JMP	SHORT GETDEC3		;
GETDEC	ENDP

;**************************************************************************

PRNT	PROC	NEAR
	MOV	DL,AL			;print character in AL
	MOV	AH,02			;
	INT	21H			;
	RET				;
PRNT	ENDP

PAGE
;**************************************************************************
;
; INSTALLATION LINE PARSING -
;
;**************************************************************************

;**************************************************************************
;
; SWITCH TABLE -
;
;**************************************************************************

SWTAB:	DB	'U'                             ;user name
	DW	CMDUSER 			;
	DB	'B'                             ;mount from Banks
	DW	BANKMNT 			;
	DB	'S'                             ;server name
	DW	CMDSRVR 			;
LSWTAB	EQU	(($-SWTAB)/3)			;length of switch table

SWTCHBUF:DB	21 DUP (0)			;command string buffer
						;.20 characters MAX

;**************************************************************************
;
; PARSE -
;
;**************************************************************************

PARSE	PROC	NEAR
	PUSH	DS				;get segment and offset
	PUSH	ES				;.of CONFIG.SYS command line
	LES	BX,DWORD PTR DD_OFF		;
	LDS	SI,ES:DWORD PTR CMDLINE[BX]	;
	POP	ES				;

PARSE3: CMP	BYTE PTR [SI],SLASH		;look for a slash meaning a
	JE	SHORT PARSE4			;.switch, a carraige return
	CMP	BYTE PTR [SI],CR		;.or line feed means the end
	JE	SHORT PARSE6			;
	CMP	BYTE PTR [SI],LF		;
	JE	SHORT PARSE6			;
	INC	SI				;
	JMP	SHORT PARSE3			;

PARSE4: INC	SI				;save command byte, if a colon
	MOV	AH,BYTE PTR [SI]		;.does not follow command byte
	CMP	BYTE PTR [SI+1],COLON		;.then there is no parameter
	JNE	SHORT PARSE7			;.else save parameter
	ADD	SI,2				;
	CALL	SAVEPRM 			;
PARSE7: MOV	BX,OFFSET SWTAB 		;get switch command table
	MOV	CX,LSWTAB			;.address and length
	PUSH	SI				;
	PUSH	DS				;
	PUSH	CS				;
	POP	DS				;
	CALL	DOSWTCH 			;find command and do it
	JC	SHORT PARSE5			;
PARSE2: POP	DS				;
	POP	SI				;
	JMP	SHORT PARSE3			;

PARSE5: CALL	HOME				;
	MOV	DX,OFFSET UNKPRMMSG		;
	CALL	ERRCON				;
	JMP	SHORT PARSE2			;

PARSE6: POP	DS				;
	RET					;
PARSE	ENDP

;**************************************************************************
;
; SAVEPRM -	save parameter
;
;**************************************************************************

SAVEPRM PROC	NEAR
	MOV	DI,OFFSET SWTCHBUF		;
SAVPRM1:MOV	AL,BYTE PTR [SI]		;
	CMP	AL,SLASH			;
	JE	SHORT SAVPRM2			;
	CMP	AL,CR				;
	JE	SHORT SAVPRM2			;
	CMP	AL,LF				;
	JE	SHORT SAVPRM2			;
	MOV	CS:BYTE PTR [DI],AL		;
	INC	SI				;
	INC	DI				;
	JMP	SHORT SAVPRM1			;
SAVPRM2:MOV	CS:BYTE PTR [DI],0		;
	RET					;
SAVEPRM ENDP

;**************************************************************************
;
; DOSWTCH -
;
;**************************************************************************

DOSWTCH PROC	NEAR
	CMP	BYTE PTR [BX],AH		;find command in table
	JE	SHORT DOSWT2			;.and do the corresponding
	ADD	BX,3				;.routine
	LOOP	SHORT DOSWTCH			;
	STC					;carry means command not found
	RET					;

DOSWT2: INC	BX				;
	CALL	WORD PTR [BX]			;
	CLC					;
	RET					;
DOSWTCH ENDP

;**************************************************************************
;
; CMDUSER -
;
;**************************************************************************

CMDUSER PROC	NEAR
	CALL	SAVEUSR 			;

	CALL	READDI				;read DI table
	JNC	SHORT CMDU0			;

	MOV	DX,OFFSET MSGBADDI		;bad DI table
	JMP	FATAL				;

CMDU0:	CALL	CHKDI				;check for a valid DI table
	JNC	SHORT CMDU2			;

	MOV	DX,OFFSET MSGINVDI		;invalid DI table
	JMP	SHORT CMDU9			;

CMDU2:	CALL	CHKUSER 			;check for a valid user, carry
	JNC	SHORT CMDU5			;.means invalid user

	MOV	DX,OFFSET MSGUSER		;invalid user
	JMP	SHORT CMDU9			;

CMDU5:	CALL	CHKBLKPSW			;check for a blank psw, no
	JNC	SHORT CMDU6			;.carry = no password

	MOV	DX,OFFSET MSGPSW		;don't boot from the command
	JMP	SHORT CMDU9			;.line if user has password

CMDU6:	MOV	AX,WORD PTR [BX+NUOPSYS]	;see if valid OS for this user
	XCHG	AH,AL				;flip due to byte sex
	CMP	AX,MSDOS			;MSDOS?
	JE	SHORT CMDU8			;
	CMP	AX,UCSD 			;p-system?
	JE	SHORT CMDU7			;

	MOV	DX,OFFSET MSGINVOS		;unsupported OS
	JMP	SHORT CMDU9			;

CMDU7:	MOV	BYTE PTR PSYSTEM,0FFH		;set p-system flag
CMDU8:	MOV	SI,BX				;decrypt and save home server
	ADD	SI,NUHSRV			;.name from user's NU entry
	MOV	DI,OFFSET %HOMSRV		;
	CALL	NAMDECRYPT			;

	MOV	BYTE PTR %USRFLG,0FFH		;flag user found on cmd line
	RET					;

CMDU9:	CALL	ERRCON				;
	RET					;
CMDUSER ENDP

;**************************************************************************

SAVEUSR PROC	NEAR				;
	CALL	BLANKBUF			;move user name from the
	MOV	DI,OFFSET %INBUFF		;.installation line into
	MOV	SI,OFFSET SWTCHBUF		;.the input buffer
	MOV	CX,10				;

SAVEU0: MOV	AL,BYTE PTR [SI]		;
	MOV	BYTE PTR [DI],AL		;
	INC	SI				;
	INC	DI				;
	CMP	BYTE PTR [SI],0 		;
	JE	SHORT SAVEU2			;
	LOOP	SHORT SAVEU0			;

SAVEU2: RET					;
SAVEUSR ENDP

;**************************************************************************
;
; BANKMNT -	sets flag if mounting from Banks is OK
;
;**************************************************************************

BANKMNT PROC	NEAR
	MOV	BYTE PTR BANKOK,0FFH		;FF = mount from banks
	RET					;
BANKMNT ENDP

;**************************************************************************
;
; CMDSRVR -
;
;**************************************************************************

CMDSRVR PROC	NEAR
	RET					;
CMDSRVR ENDP

PAGE
;**************************************************************************
;
; FLIP ROUTINES
;
;**************************************************************************

%FLIP	PROC	NEAR
	MOV	AX,WORD PTR [BX]		;get a word, flip it, and
	XCHG	AH,AL				;.put it back
	MOV	WORD PTR [BX],AX		;
	RET					;
%FLIP	ENDP

;**************************************************************************
;
; FLIPDI -	flip DI table entries
;
;**************************************************************************

FLIPDI	PROC	NEAR
	LEA	BX,[SI+DRVNO]			;flip drive number
	CALL	%FLIP				;
	LEA	BX,[SI+NUBLKS]			;point at # blocks in NU
	MOV	CX,6				;.table and then flip next

FLIP1:	CALL	%FLIP				;.six entries
	ADD	BX,2				;
	LOOP	SHORT FLIP1			;

	RET					;
FLIPDI	ENDP

;**************************************************************************
;
; CHKDI -	checks for a valid DI table on drive
;
;**************************************************************************

CHKDI	PROC	NEAR
	MOV	SI,OFFSET %DIREC		;
	CALL	FLIPDI				;flip DI table
	CMP	WORD PTR [SI+SPECIAL],1982	;check DI table
	JNE	SHORT CHKDI1			;
	CMP	BYTE PTR [SI+DRVINIT],1 	;initialized?
	JNE	SHORT CHKDI1			;
	CMP	BYTE PTR [SI+ONLINE],1		;online?
	JNE	SHORT CHKDI1			;
	CLC					;
	RET					;

CHKDI1: STC					;show invalid DI table
	RET					;
CHKDI	ENDP

;**************************************************************************
;
; CHKUSER -	checks for a valid user
;
;**************************************************************************

CHKUSER PROC	NEAR
	MOV	SI,OFFSET %INBUFF		;encrypt user name for search
	MOV	DI,OFFSET %CRYPTNM		;
	CALL	NAMENCRYPT			;

	MOV	CX,WORD PTR [%DIREC+NUBLKS]	;set to search NU table
	CALL	READNU				;read 1st block of NU table
	ADD	BX,32				;skip initial FFs and adjust
	DEC	DX				;.DX accordingly

CHKU1:	CMP	WORD PTR [BX],0 		;see if end of block and
	JE	SHORT CHKU2			;.read next block if so
	CMP	WORD PTR [BX],0FFFFH		;see if end of table
	JE	SHORT CHKU3			;.and exit if so

	MOV	SI,BX				;compare entered user name
	ADD	SI,NUUSER			;.with user name from NU entry
	MOV	DI,OFFSET %CRYPTNM		;
	PUSH	CX				;
	MOV	CX,10				;
   REPZ CMPSB					;
	POP	CX				;
	JZ	SHORT CHKU4			;if zero we found a match

	ADD	BX,NURECSZ			;point at next entry
	DEC	DX				;decrement count of NU entries
	JNZ	SHORT CHKU1			;.per block; check next entry
CHKU2:	CALL	NXTNUBLK			;.if any, else read in next blk
	LOOP	SHORT CHKU1			;

CHKU3:	STC					;carry means we didn't find
	RET					;.user

CHKU4:	MOV	SI,OFFSET %INBUFF		;save user name
	MOV	DI,OFFSET USERNAM		;
	MOV	CX,10				;
   REPZ MOVSB					;
	CLC					;
	RET					;
CHKUSER ENDP

;**************************************************************************
;
; CHKBLKPSW -	checks for a blank password (NO password)
;
;**************************************************************************

CHKBLKPSW PROC	NEAR
	CALL	BLANKBUF			;check for blank password (i.e.
	MOV	SI,OFFSET %INBUFF		;.no password); first encrypt
	MOV	DI,OFFSET %CRYPPSW		;.the blanks
	CALL	PSWENCRYPT			;

	MOV	SI,BX				;compare the encrypted blanks
	ADD	SI,NUPSW			;.with the password in the NU
	MOV	DI,OFFSET %CRYPPSW		;.entry
	MOV	CX,8				;
   REPZ CMPSB					;
	JZ	SHORT CHKB1			;if zero then no password

	STC					;carry = password
	RET					;
CHKB1:	CLC					;no carry = no password
	RET					;
CHKBLKPSW ENDP

PAGE
;**************************************************************************
;
; ENCRYPTION ROUTINES
;
;**************************************************************************
;**************************************************************************
;
; NAMENCRYPT, NAMDECRYPT, and PSWENCRYPT
;
;**************************************************************************

%MASK	DB	0				;
MASKMOD DB	9				;

NAMBASE DB	31,146,135,26,99,0,7,78,125,98	;
NAMEINC DB	 2,  1,  1, 1, 1,1,2, 1,  1, 1	;

PSWBASE DB	25,36,122,150,43,18,96,112	;
PSWINC	DB	 2, 1, -1,  1, 2, 1,-1,  1	;

;**************************************************************************

NAMENCRYPT PROC NEAR

	PUSH	CX			;
	PUSH	BX			;
	PUSH	AX			;

	XOR	BX,BX			;
	MOV	CX,10			;
	MOV	BYTE PTR %MASK,0	;
					;
NAMENC1:MOV	AL,BYTE PTR [SI+BX]	;get first character and convert
	SUB	AL,20H			;.from ASCII
					;
	IMUL	BYTE PTR NAMEINC[BX]	;multiply by increment
					;
	ADD	AL,BYTE PTR NAMBASE[BX] ;add in base and the mask
	ADD	AL,BYTE PTR %MASK	;
					;
	MOV	BYTE PTR [DI+BX],AL	;store it away
					;
	CMP	BX,0			;if first time through, make
	JNE	SHORT NAMENC2		;.a new mask value
					;
	MOV	AL,BYTE PTR [SI+BX]	;
	SUB	AL,20H			;
	CBW				;
	IDIV	BYTE PTR MASKMOD	;
	MOV	BYTE PTR %MASK,AH	;
					;
NAMENC2:INC	BX			;
	LOOP	SHORT NAMENC1		;do all characters

	POP	AX			;
	POP	BX			;
	POP	CX			;
	RET				;

NAMENCRYPT ENDP

;**************************************************************************

NAMDECRYPT PROC NEAR

	PUSH	AX			;
	PUSH	BX			;
	PUSH	CX			;
	PUSH	DX			;

	XOR	BX,BX			;
	MOV	CX,10			;
	MOV	BYTE PTR %MASK,0	;

NAMDEC1:MOV	AL,BYTE PTR [SI+BX]	;get characater to decrypt,
	SUB	AL,BYTE PTR %MASK	;.subtract off mask and base
	SUB	AL,BYTE PTR NAMBASE[BX] ;

	CBW				;
	IDIV	BYTE PTR NAMEINC[BX]	;divide by increment
	MOV	DL,AL			;

	ADD	DL,20H			;add in ASCII offset and store
	MOV	BYTE PTR [DI+BX],DL	;

	CMP	BX,0			;
	JNE	SHORT NAMDEC2		;

	CBW				;
	IDIV	BYTE PTR MASKMOD	;make a new mask value if first
	MOV	BYTE PTR %MASK,AH	;.time through

NAMDEC2:INC	BX			;
	LOOP	SHORT NAMDEC1		;do all characters

	POP	DX			;
	POP	CX			;
	POP	BX			;
	POP	AX			;
	RET				;

NAMDECRYPT ENDP

;**************************************************************************

PSWENCRYPT PROC NEAR

	PUSH	CX			;
	PUSH	BX			;
	PUSH	AX			;

	XOR	BX,BX			;
	MOV	CX,8			;
	MOV	BYTE PTR %MASK,0	;
					;
PSWENC1:MOV	AL,BYTE PTR [SI+BX]	;get character and subtract ASCII
	SUB	AL,20H			;.offset
					;
	IMUL	BYTE PTR PSWINC[BX]	;multiply by increment
					;
	ADD	AL,BYTE PTR PSWBASE[BX] ;add in base and mask value
	ADD	AL,BYTE PTR %MASK	;
					;
	MOV	BYTE PTR [DI+BX],AL	;store
					;
	CMP	BX,0			;
	JNE	SHORT PSWENC2		;
					;
	MOV	AL,BYTE PTR [SI+BX]	;calculate new mask value if first
	SUB	AL,20H			;.time through
	CBW				;
	IDIV	BYTE PTR MASKMOD	;
	MOV	BYTE PTR %MASK,AH	;
					;
PSWENC2:INC	BX			;
	LOOP	SHORT PSWENC1		;do all characters

	POP	AX			;
	POP	BX			;
	POP	CX			;
	RET				;

PSWENCRYPT ENDP

PAGE
;**************************************************************************
;
; BLANKBUF -	fills %INBUFF with blanks
;
;**************************************************************************

BLANKBUF PROC	NEAR
	MOV	DI,OFFSET %INBUFF	;fill buffer with blanks
	MOV	AL,BLANK		;
	MOV	CX,10			;
    REP STOSB				;
	RET				;
BLANKBUF ENDP

;**************************************************************************
;
; GETNAME, GETPSW
;
;**************************************************************************

GETNAME PROC	NEAR
	MOV	DX,XYNAMEL		;display prompt and get response
	CALL	POSCUR			;
	MOV	DX,OFFSET NAMEL 	;
	CALL	PRNTSTR 		;
	MOV	DX,XYNAME		;
	CALL	POSCUR			;
	CALL	CLREOL			;
	CALL	BLANKBUF		;fill buffer with blanks
	MOV	BYTE PTR %ECHO,0	;say we wish to echo characters
	MOV	BYTE PTR %MAXCHR,10	;name is 10 characters max
	MOV	DX,OFFSET %MAXCHR	;
	CALL	BUFIN			;
	RET				;
GETNAME ENDP

GETPSW	PROC	NEAR
	MOV	DX,XYPSWL		;display prompt and get response
	CALL	POSCUR			;
	MOV	DX,OFFSET PSWL		;
	CALL	PRNTSTR 		;
	MOV	DX,XYPSW		;
	CALL	POSCUR			;
	CALL	CLREOL			;
	CALL	BLANKBUF		;fill buffer with blanks
	MOV	BYTE PTR %ECHO,0FFH	;don't echo characters
	MOV	BYTE PTR %MAXCHR,08	;password is 8 characters max
	MOV	DX,OFFSET %MAXCHR	;
	CALL	BUFIN			;
	RET				;
GETPSW	ENDP

;**************************************************************************
;
; GETUSER -
;
;**************************************************************************

GETUSER PROC	NEAR
	CALL	READDI				;read DI table
	JNC	SHORT GETU0			;
	JMP	BADDI				;bad DI table

GETU0:	CALL	CHKDI				;check for a valid DI table
	JNC	SHORT GETU1			;
	JMP	INVDI				;

GETU1:	CALL	GETNAME 			;get user name; if an ESCAPE
	JNC	SHORT GETU1A			;.was typed then set flag and
	MOV	BYTE PTR %ESCFLG,0FFH		;.return with carry set; else
	JMP	CRYRET				;.user name in %INBUFF

GETU1A: MOV	SI,OFFSET %INBUFF		;compare name entered to the
	MOV	DI,OFFSET USERNAM		;.default name and if they
	MOV	CX,10				;.match allocate FATs and
   REPZ CMPSB					;.return
	JNZ	SHORT GETU2			;
	MOV	BYTE PTR FATONLY,0FFH		;say to allocate FATs
	MOV	SI,OFFSET %INBUFF		;encrypt name
	MOV	DI,OFFSET %CRYPTNM		;
	CALL	NAMENCRYPT			;
	JMP	CRYRET				;

GETU2:	CALL	CHKUSER 			;check for valid user, carry
	JNC	SHORT GETU5			;.set means invalid user

	JMP	INVUSER 			;invalid user

GETU5:	CALL	CHKBLKPSW			;check for no password (all
	JNC	SHORT GETU6			;.blanks) no carry = no psw

GETU5A: CALL	GETPSW				;get password from user; if
	JNC	SHORT GETU5B			;.an ESCAPE was typed then
	MOV	BYTE PTR %ESCFLG,0FFH		;.set flag and return with
	JMP	CRYRET				;.carry set

GETU5B: MOV	SI,OFFSET %INBUFF		;.encrypt entered password
	MOV	DI,OFFSET %CRYPPSW		;
	CALL	PSWENCRYPT			;

	MOV	SI,BX				;check with password in NU
	ADD	SI,NUPSW			;.entry
	MOV	DI,OFFSET %CRYPPSW		;
	MOV	CX,8				;
   REPZ CMPSB					;
	JNZ	SHORT INVPSW			;invalid password

GETU6:	MOV	AX,WORD PTR [BX+NUOPSYS]	;see if valid OS for this user
	XCHG	AH,AL				;flip due to byte sex
	CMP	AX,MSDOS			;MSDOS?
	JE	SHORT GETU7			;
	  IF	PSYSOK				;(4.05) conditional
	CMP	AX,UCSD 			;p-system?
	JNE	SHORT BADOS			;give bad OS message
	MOV	BYTE PTR PSYSTEM,0FFH		;set p-system flag
	  ELSE
	JMP	SHORT BADOS			;if P-system boot not
						;supported and not MSDOS
	 ENDIF

GETU7:	MOV	SI,BX				;decrypt and save home server
	ADD	SI,NUHSRV			;.name from user's NU entry
	MOV	DI,OFFSET %HOMSRV		;
	CALL	NAMDECRYPT			;

	CLC					;OK return
	RET					;

;Errors are handled below

INVDI:	MOV	DX,OFFSET MSGINVDI		;invalid DI table
	JMP	SHORT TRYAGAN			;
INVUSER:MOV	DX,OFFSET MSGUSER		;invalid user message
	JMP	SHORT TRYAGAN			;
BADOS:	MOV	DX,OFFSET MSGINVOS		;unsupported OS
TRYAGAN:CALL	ERRCON				;
	JMP	GETU1				;try again
INVPSW: MOV	DX,OFFSET MSGPSW		;invalid password message
	CALL	ERRCON				;
	JMP	GETU5A				;ask again for password

BADDI:	MOV	DX,OFFSET MSGBADDI		;bad DI table
	JMP	FATAL				;

CRYRET: STC					;set carry and return
	RET					;
GETUSER ENDP

PAGE
;**************************************************************************
;
; OMNINET ROUTINES
;
;**************************************************************************

;**************************************************************************
;
; FHELLO - does an 'Add Active' command for flat cable
;
;**************************************************************************

FHELLO	PROC NEAR
	MOV	SI,OFFSET USERNAM	;add our name
	MOV	DI,OFFSET ADDNAME	;
	MOV	CX,10			;
    REP MOVSB				;
	MOV	SI,OFFSET ADDACTIVE	;
	MOV	CX,18			;
	MOV	DX,0			;
	MOV	AH,1			;
	PUSH	CS			;
	CALL	CRVIO			;
	RET
FHELLO	ENDP

;**************************************************************************
;
; OHELLO - does a 'Hello' command for Omninet
;
;**************************************************************************

OHELLO	PROC NEAR
	MOV	SI,OFFSET USERNAM	;our name
	MOV	DI,OFFSET HNAME 	;
	MOV	CX,10			;
   REP	MOVSB				;
	MOV	AL,BYTE PTR XPORTER	;our address
	MOV	BYTE PTR HSRC,AL	;
	MOV	SI,OFFSET HELLO 	;
	MOV	CX,18			;
	MOV	BH,2			;
	MOV	AX,02FFH		;
	PUSH	CS			;
	CALL	CRVIO			;
	RET				;
OHELLO	ENDP

;**************************************************************************
;
; FINDSRVR -	find servers (Servers ,Omnidrives or Banks) on net
;		ON EXIT:
;			carry set means no devices found
;
;**************************************************************************

FINDSRV PROC   NEAR
	MOV	DX,OFFSET SEARCH	;print searching for servers message
	CALL	PRNTSTR 		;

	MOV	BX,OFFSET %ECHOTBL	;build table of active nodes
	MOV	CX,64			;
	MOV	DX,600H 		;DH = ECHO; DL = NODE
FSRV0:	CALL	ECHONET 		;
	INC	DL			;
	LOOP	SHORT FSRV0		;

	MOV	BX,OFFSET %SRVTBL	;send WHO ARE YOUs to active nodes
	MOV	SI,OFFSET %ECHOTBL	;
	MOV	CX,64			;
	MOV	DX,300H 		;DH = SND/RCV TO SERVER; DL = NODE
FSRV1:	CMP	BYTE PTR [SI],0FFH	;if active node do the WHO ARE YOU
	JE	SHORT FSRV2		;
	MOV	DL,BYTE PTR [SI]	;
	CALL	CHKSRV			;
  IF (SHADOW)
	CALL	CHK_SHADOW		;check for SHADOW drives (v4.20 nod)
  ENDIF
FSRV2:	INC	SI			;
	LOOP	SHORT FSRV1		;

	CMP	WORD PTR %NUMSRV,0	;if we found a device or two clear
	JA	SHORT FSRV3		;.carry and return, else set carry
	STC				;.and return
	RET				;

FSRV3:	CLC				;
	RET				;
FINDSRV ENDP

;**************************************************************************

ECHONET PROC	NEAR
	MOV	AX,DX			;AX has function code and node number
	PUSH	CX			;Fix a Companion bug that destroys CX
	PUSH	CS			;
	CALL	CRVIO			;do echo
	POP	CX			;Fix a Companion bug that destroys CX
	CMP	AL,0C0H 		;
	JNE	SHORT ECHO1		;
	MOV	BYTE PTR [BX],DL	;mark node as active
ECHO1:	INC	BX			;
	RET				;
ECHONET ENDP

;**************************************************************************

CHKSRV	PROC	NEAR
	PUSH	SI			;
	PUSH	CX			;
	PUSH	BX			;
	PUSH	DX			;

CSRVR0: MOV	SI,OFFSET WHOAREYOU	;check if we really found a server
	MOV	DI,OFFSET ID		;.and save name and node number if so
	MOV	AL,BYTE PTR XPORTER	;
	MOV	BYTE PTR [SI+5],AL	;
	MOV	AX,DX			;function code and node number
	MOV	BX,0301H		;three attempts, about a 1 second wait
	MOV	CX,8			;
	MOV	DX,18			;
	PUSH	CS			;
	CALL	CRVIO			;
	OR	AL,AL			;
	JZ	SHORT CSRVR2		;
	POP	DX			;
	POP	BX			;
	POP	CX			;
	POP	SI			;
	RET				;

CSRVR2: POP	DX			;
	POP	BX			;
	CMP	BYTE PTR IDDEV,BANK	;check if Bank
	JE	SHORT CSRVR3		;
	CMP	BYTE PTR IDDEV,ODRIVE	;check if old server or Omnidrive
	JE	SHORT CSRV2A		;
	CMP	BYTE PTR IDDEV,DSKSERV	;
	JNE	SHORT CSRVR4		;
CSRV2A: INC	BYTE PTR DEV1OR6	;indicate device 1 or 6 found
CSRVR3: CALL	SAVESRV 		;save server info
CSRVR4: POP	CX			;
	POP	SI			;
	RET				;
CHKSRV	ENDP

;**************************************************************************

SAVESRV PROC	NEAR
	MOV	AL,BYTE PTR IDDEV	;save type and address of
	MOV	BYTE PTR [BX],AL	;.responding device in server table
	MOV	BYTE PTR [BX+NODENUM],DL;
	MOV	CX,10			;.save name in server table
	MOV	SI,OFFSET IDNM		;
	MOV	DI,BX			;
	ADD	DI,SRVRNAM		;
    REP MOVSB				;
	ADD	BX,ENTRYSZ		;point at next entry in server table
	INC	WORD PTR %NUMSRV	;count server
SAVE1IT:RET				;
SAVESRV ENDP

;**************************************************************************
;
; HOMESRVR -
;
;**************************************************************************

HOMESRV PROC   NEAR
	MOV	BX,OFFSET %SRVTBL	;
	MOV	CX,WORD PTR %NUMSRV	;get number of servers and return
	JCXZ	SHORT HMSRV6		;.if no servers

HMSRV1: MOV	SI,BX			;
	ADD	SI,SRVRNAM		;
	MOV	DI,OFFSET %HOMSRV	;
	PUSH	CX			;
	MOV	CX,10			;
   REPZ CMPSB				;
	POP	CX			;
	JZ	SHORT HMSRV4		;
	ADD	BX,ENTRYSZ		;
	LOOP	SHORT HMSRV1		;

HMSRV2: CALL	HOME			;ask for server address
	MOV	DX,OFFSET ASKFORSRV	;
	CALL	PRNTSTR 		;
	MOV	BX,OFFSET %SRVTBL	;
	CALL	GETDEC			;returns server number in AX
	JC	SHORT HMSRV5		;
	MOV	CX,64			;

HMSRV3: MOV	AH,BYTE PTR [BX+NODENUM] ;
	CMP	AH,AL			;
	JE	SHORT HMSRV4		;
	ADD	BX,ENTRYSZ		;
	LOOP	SHORT HMSRV3		;
	JMP	SHORT HMSRV2		;server not found ask again

HMSRV4: MOV	AL,BYTE PTR [BX+NODENUM] ;replace boot server in"CORTAb" with
	MOV	BYTE PTR BSERVER,AL	;.the home server, mark home server
	OR	BYTE PTR [BX],80H	;.in server table

  IF (SHADOW)
;
;  Make sure the home server is not Offline.  If it is then switch it
;  to it's mates server number. (v4.20 nod)
;
	XOR	BX,BX
	MOV	BL,AL			; Get the home server number
	SHL	BX,1			; Convert it to a table offset
	CMP	BYTE PTR SHADOW_TBL[BX],DT_OFFLINE  ; Is it offline?
	JNZ	HMSRV6			; No, it's ok so exit
	MOV	AL,BYTE PTR SHADOW_TBL[BX+1] ; Get the address of the mate
	CMP	AL,0			; Make sure the new number is valid
	JL	HMSRV5
	CMP	AL,63
	JG	HMSRV5
	MOV	BYTE PTR BSERVER,AL	;Replace the boot server value again
  ENDIF


HMSRV6: RET

HMSRV5: CALL	HOME			;bad server address given
	JMP	FATAL1			;
HOMESRV ENDP

PAGE
;**************************************************************************
;
; MAKREAD -	makes a drive read command (512 bytes) in %RDCMD
;		ON ENTRY:
;			SI	 = contains a 4 byte disk address
;			%DRIVE	 = drive we want to read from
;
;		DESTROYS - AX,CL
;
;**************************************************************************

MAKREAD PROC	NEAR
	MOV	AL,BYTE PTR [SI+1]		;get high 4 bits of disk
	MOV	CL,4				;.address, shift, and add in
	ROL	AL,CL				;.drive number
	ADD	AL,BYTE PTR %DRIVE		;
	MOV	BYTE PTR %RDCMD+1,AL		;save in command
	MOV	AX,WORD PTR [SI+2]		;get low 16 bits, flip them
	XCHG	AH,AL				;.and save
	MOV	WORD PTR %RDCMD+2,AX		;
	RET					;
MAKREAD ENDP

;**************************************************************************
;
; READBLK -	read a block (512 bytes)
;		ON ENTRY:
;			%SERVER = server we want
;			%DRIVE	= drive we want
;			SI	= points to a 4 byte disk address
;			DI	= address of buffer to read into
;
;		ON RETURN:
;			%RETLEN = return length
;			If error carry set, error code in AL
;
;		DESTROYS:
;			AX,SI,DI
;
;**************************************************************************

READBLK PROC	NEAR
	PUSH	BX				;
	PUSH	CX				;
	PUSH	DX				;

	CALL	MAKREAD 			;make read command

	MOV	AH,ROM_READ			;read command to ROM code
	MOV	AL,BYTE PTR %SERVER		;get server we want
	MOV	SI,OFFSET %RDCMD		;address of drive command
	MOV	BX,XMIT 			;BH=retries, BL=wait time
	MOV	CX,4				;number bytes to send
	MOV	DX,200H 			;send 512 bytes

	PUSH	CS				;fake"FAR" call ala BRK
	CALL	CRVIO				;do I/O

	TEST	AL,80H				;save bytes returned, if any
	JNZ	SHORT RDBLK1			;.errors, set carry and save
	AND	CH,10011111B			;Strip off the Mode flag(v4.20)
	MOV	WORD PTR %RETLEN,CX		;.error code in AL
	CLC					;

RDBLK0: POP	DX				;
	POP	CX				;
	POP	BX				;
	RET					;

RDBLK1: MOV	BYTE PTR %ERRCOD,AL		;
	STC					;
	JMP	SHORT RDBLK0			;
READBLK ENDP					;

;**************************************************************************
;
; READDI -	 read Drive Info table
;
;**************************************************************************

READDI	PROC	NEAR
	MOV	SI,OFFSET %DIADDR	;address of DI table
	MOV	DI,OFFSET %DIREC	;read into DI buffer
	JMP	RDBF1			;go do read
READDI	ENDP

;**************************************************************************
;
; %READDI  -	read DI table ignoring errors
;
;**************************************************************************

%READDI PROC NEAR
	MOV	SI,OFFSET %DIADDR	;read block into %DIREC ignore
	MOV	DI,OFFSET %DIREC	;.errors
	CALL	READBLK 		;
	RET				;
%READDI ENDP

;**************************************************************************
;
; READBF2 -
;
;**************************************************************************

READBF2 PROC NEAR
	MOV	DI,OFFSET %BUFF2	;read block into second buffer
	MOV	SI,OFFSET BLKADDR	;
	JMP	RDBF1			;
READBF2 ENDP

;**************************************************************************
;
; READBF1 -
;
;**************************************************************************

READBF1 PROC NEAR
	MOV	DI,OFFSET %BUFF1	;read block into %BUFF1
	MOV	SI,OFFSET BLKADDR	;
RDBF1:	CALL	READBLK 		;read block
	JC	RDBF2			;carry set is block read error
	RET				;

RDBF2:	MOV	DX,OFFSET BLKERR	;block read error
	JMP	FATAL			;
READBF1 ENDP

;**************************************************************************
;
; SETADDR -	sets variable BLKADDR to 4 byte disk block address
;		ON ENTRY
;			SI = pointer to address
;
;		DESTROYS - SI,DI
;
;**************************************************************************

SETADDR PROC NEAR
	PUSH	CX			;
	MOV	CX,4			;
	MOV	DI,OFFSET BLKADDR	;

    REP MOVSB				;move address

	POP	CX			;
	RET				;
SETADDR ENDP

;**************************************************************************
;
; NEXTBLK -	add one to current block address
;
;**************************************************************************

NEXTBLK PROC	NEAR
	MOV	AX,1			;set AX to 1 and fall into ADDBLK
NEXTBLK ENDP

;**************************************************************************
;
; ADDBLK -	add AX to current block address
;
;**************************************************************************

ADDBLK	PROC NEAR
	PUSH	BX			;
	MOV	BX,AX			;
	MOV	AX,WORD PTR BLKADDR+2	;get low two bytes of address
	XCHG	AH,AL			;
	ADD	AX,BX			;increment
	XCHG	AH,AL			;
	MOV	WORD PTR BLKADDR+2,AX	;
	MOV	AX,WORD PTR BLKADDR	;if previous operation caused a
	XCHG	AH,AL			;.carry account for it
	ADC	AX,0			;
	XCHG	AH,AL			;
	MOV	WORD PTR BLKADDR,AX	;
	POP	BX			;
	RET				;
ADDBLK	ENDP

;**************************************************************************
;
; NXTNUBLK -	read next block of NU table
;
;**************************************************************************

NXTNUBLK PROC	NEAR
	CALL	NEXTBLK 		;add one to block address
	JMP	SHORT RDNU1		;
NXTNUBLK ENDP

;**************************************************************************
;
; READNU -	read a block of the NU table, flip entries, and set up for
;		search for a user's entry
;
;**************************************************************************

READNU	PROC	NEAR
	MOV	SI,OFFSET [%DIREC+NUADDR]	;
	CALL	SETADDR 			;
RDNU1:	CALL	READBF1 			;
	JC	SHORT RDNU2			;
	MOV	BX,OFFSET %BUFF1		;point at buffer
	MOV	DX,NURPB			;set counter to number of
RDNU2:	RET					;.entries in a block
READNU	ENDP

;**************************************************************************
;
; NXTDUBLK -	read next block of DU table
;
;**************************************************************************

NXTDUBLK PROC	NEAR
	CALL	NEXTBLK 		;add one to block address
	JMP	SHORT RDDU1		;
NXTDUBLK ENDP

;**************************************************************************
;
; READDU -	read a block of the DU table, flip entries, and set up for
;		search for a user's entry
;
;**************************************************************************

READDU	PROC	NEAR
	MOV	SI,OFFSET [%DIREC+DUADDR]	;
	CALL	SETADDR 			;
RDDU1:	CALL	READBF1 			;
	JC	SHORT RDDU2			;
	MOV	BX,OFFSET %BUFF1		;
	MOV	DX,DURPB			;
RDDU2:	RET					;
READDU	ENDP

;**************************************************************************
;
; NXTDABLK -	read next block of DA table
;
;**************************************************************************

NXTDABLK PROC	NEAR
	CALL	NEXTBLK 		;add one to block address
	JMP	SHORT RDDA1		;
NXTDABLK ENDP

;**************************************************************************
;
; READDA -	read a block of the DA table, flip entries, and set up for
;		search for a user's entry
;
;**************************************************************************

READDA	PROC	NEAR
	MOV	SI,OFFSET [%DIREC+DAADDR]	;
	CALL	SETADDR 			;
RDDA1:	CALL	READBF1 			;
	JC	SHORT RDDA2			;
	MOV	BX,OFFSET %BUFF1		;
	MOV	DX,DARPB			;
RDDA2:	RET					;
READDA	ENDP

;**************************************************************************
;
; NXTDVBLK -	read next block of DV table
;
;**************************************************************************

NXTDVBLK PROC	NEAR
	CALL	NEXTBLK 		;add one to block address
	JMP	SHORT RDDV1		;
NXTDVBLK ENDP

;**************************************************************************
;
; READDV -	read a block of the DV table, flip entries
;
;**************************************************************************

READDV	PROC	NEAR
	MOV	SI,OFFSET [%DIREC+DVADDR]	;
	CALL	SETADDR 			;
RDDV1:	CALL	READBF2 			;
	JC	SHORT RDDV2			;read into second buffer
	MOV	BX,OFFSET %BUFF2		;
	MOV	DX,DVRPB			;
RDDV2:	RET					;
READDV	ENDP

PAGE
;**************************************************************************
;
; VOLUME MOUNTING ROUTINES
;
;**************************************************************************
;**************************************************************************
;
; MOUNT -	mounts user's MSDOS volumes across all servers, starts
;		with user's home server
;
;	CALLS PROCEDURES: FINDVOL, MNTVOL, and CHKFAT
;
;**************************************************************************

MOUNT	PROC NEAR

	CMP	BYTE PTR DEV1OR6,0		;see if any type 1 or 6 devices
	JNE	SHORT MNT1A			;.found on net

	MOV	BYTE PTR BANKOK,0FFH		;no, but we found servers so
						;.we must have ONLY Banks
MNT1A:	MOV	AL,BYTE PTR BSERVER		;the home server

MNT2:	MOV	BYTE PTR %DRIVE,0		;start at drive one initially
	MOV	BYTE PTR %SERVER,AL		;set server to use

MNT3:	INC	BYTE PTR %DRIVE 		;

  IF (SHADOW)
;
;  Only mount the volume if it is on a Normal or Master drive, or
;  on a drive that does not have the shadow prom. (v4.20 nod)
;
	XOR	BX,BX				;
	MOV	BL,BYTE PTR %SERVER		;Get the server number
	ROL	BX,1				;Convert it to a tbl pointer
	CMP	SHADOW_TBL[BX],DT_NORMAL	;Is the drive a NORMAL drive?
	JZ	MNT3A				;Yes, then jump
	CMP	SHADOW_TBL[BX],DT_MASTER	;Is the drive a MASTER drive?
	JZ	MNT3A				;Yes, then jump
	CMP	SHADOW_TBL[BX],NO_SHADOW_PROM	;Does drive have SHADOW PROM?
	JZ	MNT3A				;No, then jump
	JMP	MNT10				;Yes, so get next server
  ENDIF
;
MNT3A:	CALL	%READDI 			;read DI table ignore errors
	JNC	SHORT MNT4			;carry means drive not there
	JMP	MNT10				;

MNT4:	CALL	CHKDI				;check for valid DI table
	JC	SHORT MNT3			;.and therefore a valid drive

;LOOK FOR USER'S DU ENTRY

	MOV	CX,WORD PTR [%DIREC+DUBLKS]	;DU table size
	DEC	CX				;account for first block read
	CALL	READDU				;read first block of DU table
	ADD	BX,32				;skip first 32 bytes (all FF's)
	DEC	DX				;account for skipped record

MNT5:	CMP	WORD PTR [BX],0 		;check if last entry in block
	JE	SHORT MNT5A			;.and read next block if so
	CMP	WORD PTR [BX],0FFFFH		;check for end of table
	JE	SHORT MNT3			;
	MOV	SI,BX				;search for user's DU record
	ADD	SI,DUUSER			;
	MOV	DI,OFFSET %CRYPTNM		;
	PUSH	CX				;
	MOV	CX,10				;
   REPZ CMPSB					;
	POP	CX				;
	JZ	SHORT MNT6			;found match

	ADD	BX,DURECSZ			;no match yet, point at next
	DEC	DX				;.entry, if we have checked
	JNZ	SHORT MNT5			;.all entries in this block,
MNT5A:	CALL	NXTDUBLK			;.then read in next block if
	LOOP	SHORT MNT5			;.any

	JMP	MNT3				;no match, check next drive

MNT6:	CMP	WORD PTR [BX+DUMNT],0		;if user has no volumes
	JE	SHORT MNT9			;.mounted check next drive
	MOV	AX,WORD PTR [BX+DUID]		;save user ID from DU entry
	MOV	WORD PTR %USERID,AX		;

;LOOK FOR DA ENTRIES AND MOUNT VOLUMES

	MOV	CX,WORD PTR [%DIREC+DABLKS]	;DA table size
	DEC	CX				;account for first block read
	CALL	READDA				;read first block
	ADD	BX,32				;skip first 32 bytes (all FF's)
	SUB	DX,4				;account for skipped records

MNT7:	MOV	AX,WORD PTR [BX+DAID]		;
	CMP	AX,0				;check if last entry in block
	JE	SHORT MNT8A			;.and get next block if so
	CMP	AX,0FFFFH			;skip if last entry
	JE	SHORT MNT9			;
	CMP	AX,WORD PTR %USERID		;if entry is less keep looking
	JL	SHORT MNT8			;.if entry is greater then
	JG	SHORT MNT9			;.stop

	CMP	BYTE PTR [BX+DAMNTINFO],0	;ignore unmounted volumes
	JE	SHORT MNT8			;

	CALL	FINDVOL 			;mount the volume if OK

	CMP	WORD PTR MOUNTED,CV_MAX 	;see if we have mounted the
	JE	MNTEXT				;.maximum number of volumes

MNT8:	ADD	BX,DARECSZ			;point at next entry, if
	DEC	DX				;.no more entries in this
	JNZ	SHORT MNT7			;.block read the next block
MNT8A:	CALL	NXTDABLK			;
	LOOP	SHORT MNT7			;

MNT9:	JMP	MNT3				;check next drive

MNT10:	DEC	WORD PTR %NUMSRV		;if we have checked all
	JZ	SHORT MNTEXT			;.servers, then return

MNT12:	MOV	BX,WORD PTR %SRVPTR		;get device type and address
	MOV	AX,WORD PTR [BX]		;.from server table; point to
	ADD	WORD PTR %SRVPTR,ENTRYSZ	;.next entry
	XCHG	AH,AL				;

	TEST	AH,80H				;ignore if Home Server, but
	JNZ	SHORT MNT12			;.don't decrement server count

	CMP	AL,BANK 			;go try to mount if NOT a Bank
	JNE	SHORT MNT13			;.else, see if we wish to mount
	CMP	BYTE PTR BANKOK,0FFH		;.from Banks and if OK do so
	JNE	SHORT MNT10			;

MNT13:	JMP	MNT2				;go mount

MNTEXT: RET					;done

MOUNT	ENDP

;**************************************************************************
;
; FINDVOL -
;
;**************************************************************************

FINDVOL PROC	NEAR
	PUSH	BX				;
	PUSH	CX				;
	PUSH	DX				;
	PUSH	WORD PTR [BLKADDR]		;save block address of DA
	PUSH	WORD PTR [BLKADDR+2]		;.record

	MOV	SI,BX				;save DA entry
	MOV	DI,OFFSET %DAREC		;
	MOV	CX,DARECSZ			;
    REP MOVSB					;

	MOV	CX,WORD PTR [%DIREC+DVBLKS]	;number of blocks in DV table
	DEC	CX				;account for first block read
	CALL	READDV				;read first block
	ADD	BX,32				;skip first 32 bytes
	DEC	DX				;adjust for skip

FVOL1:	CMP	WORD PTR [BX],0 		;check for last record in block
	JE	SHORT FVOL1A			;.and read next block if so
	CMP	WORD PTR [BX],0FFFFH		;check for end of table and
	JE	SHORT FVOL4			;.exit loop if so

	MOV	SI,BX				;compare starting addresses
	ADD	SI,DVSTBLK			;.from DA record and current
	MOV	DI,OFFSET [%DAREC+DAVADDR]	;.DV record
	PUSH	CX				;
	MOV	CX,4				;
   REPZ CMPSB					;
	POP	CX				;
	JZ	SHORT FVOL3			;

	ADD	BX,DVRECSZ			;point at next DV record
	DEC	DX				;check for last record in
	JNZ	SHORT FVOL1			;.block and get next blk if so
FVOL1A: CALL	NXTDVBLK			;
	LOOP	SHORT FVOL1			;

	JMP	SHORT FVOL4			;didn't find DV record

FVOL3:	CMP	BYTE PTR [BX+DVGLB],1		;ignore if no GLOBAL access
	JNE	SHORT FVOL4			;.or not an MSDOS volume
	CMP	BYTE PTR [BX+DVVTYPE],MSDOSVL	;
	JNE	SHORT FVOL4			;

	MOV	SI,OFFSET %DAREC		;point SI at DA record, set AL
	MOV	AL,BYTE PTR [SI+DAMNTINFO]	;.to the unit to mount on, and
	XOR	AH,AH				;.go mount the volume, BX
	CALL	MNTVOL				;.points to the DV record
	JC	SHORT FVOL5			;carry means unit already used

FVOL4:	POP	WORD PTR [BLKADDR+2]		;restore block address of
	POP	WORD PTR [BLKADDR]		;.DA record
	POP	DX				;
	POP	CX				;
	POP	BX				;
	RET					;

FVOL5:	MOV	DI,WORD PTR XTRAPTR		;save drive and server
	MOV	AL,BYTE PTR %DRIVE		;
	MOV	BYTE PTR [DI],AL		;
	MOV	AL,BYTE PTR %SERVER		;
	MOV	BYTE PTR [DI+1],AL		;
	ADD	DI,2				;
	MOV	SI,OFFSET %DAREC		;save DA record
	MOV	CX,DARECSZ			;
    REP MOVSB					;
	MOV	SI,BX				;save DV record
	MOV	CX,DVRECSZ			;
    REP MOVSB					;
	MOV	WORD PTR XTRAPTR,DI		;update pointer
	INC	WORD PTR NUMXTRA		;count volume
	JMP	SHORT FVOL4			;
FINDVOL ENDP

;**************************************************************************
;
; MNTVOL -
;		ON ENTRY:
;			AX = unit to mount on
;			BX = pointer to Drive Volume record
;			SI = pointer to DA record
;
;**************************************************************************

MNTVOL	PROC	NEAR
	MOV	DI,OFFSET MNTTBL	;check if a volume is already
	ADD	DI,AX			;mounted on this unit
	DEC	DI			;
	CMP	BYTE PTR [DI],0 	;
	JE	SHORT MNTVOL2		;
	STC				;unit already used so return
	RET				;

MNTVOL2:CALL	MNTMSG			;give message
	CMP	BYTE PTR [BX+DVWRITE],0 ;check R/W privleges
	JE	SHORT MNTVOL3		;
	TEST	BYTE PTR [SI+DARO],10H	;
	JZ	SHORT MNTVOL4		;

MNTVOL3:OR	AL,80H			;mark as read only
MNTVOL4:MOV	BYTE PTR [DI],AL	;place in mount table

	AND	AX,007FH		;get back unit to mount on and
	DEC	AX			;.make it zero relative

	PUSH	AX			;save unit number
	MOV	DX,5			;unit number times CORMAP entry
	IMUL	DX			;.size gives the offset into
	MOV	DI,OFFSET CORMAP	;.CORMAP
	ADD	DI,AX			;

	MOV	AL,BYTE PTR [BX+DVSTBLK+3]	;store volume start address
	ADD	AL,BYTE PTR [BX+DVVOFF] 	;
	MOV	BYTE PTR [DI],AL		;
	MOV	AL,BYTE PTR [BX+DVSTBLK+2]	;
	ADC	AL,0				;
	MOV	BYTE PTR [DI+1],AL		;
	MOV	AL,BYTE PTR [BX+DVSTBLK+1]	;
	ADC	AL,0				;
	MOV	BYTE PTR [DI+2],AL		;

	MOV	AL,BYTE PTR %DRIVE		;store server and drive
	MOV	BYTE PTR [DI+3],AL		;
	MOV	AL,BYTE PTR %SERVER		;
	MOV	BYTE PTR [DI+4],AL		;

	MOV	SI,BX				;BPB information is in
	ADD	SI,DVSTBLK			;.block 3 of the volume
	CALL	SETADDR 			;
	MOV	AX,3				;
	CALL	ADDBLK				;
	CALL	READBF2 			;
	POP	AX				;get unit number back
	MOV	DX,13			;unit number times BPBTBL entry
	IMUL	DX			;.size gives the offset into
	MOV	DI,OFFSET BPBTBL	;.BPBTBL
	ADD	DI,AX			;
	MOV	SI,OFFSET %BUFF2	;buffer address

	LODSW				;sector size in bytes (BPS)
	STOSW				;

	LODSW				;sectors/block(cluster) (SPC)
	STOSB				;NOTE: store one byte

	LODSW					;reserved sectors
	STOSW					;

	LODSW					;number of FATs
	STOSB					;NOTE: store one byte

	LODSW					;number of directory entries
	STOSW					;NOTE: store one byte

	LODSW					;sectors/volume (SPV)
	STOSW					;

	XOR	AX,AX				;zero media descripter
	STOSB					;NOTE: store one byte

	LODSW					;sectors/FAT
	STOSW					;

	INC	WORD PTR MOUNTED		;count volume as mounted

	CLC					;
	RET					;
MNTVOL	ENDP

;**************************************************************************
;
; MNTXTRA -	mount any left over volumes
;
;		DESTROYS - AX,BX,CX,SI,DI
;
;**************************************************************************

MNTXTRA PROC	NEAR
	CMP	WORD PTR NUMXTRA,0	;don't bother if no extra volumes
	JE	SHORT MNTX4		;
	CMP	WORD PTR MOUNTED,CV_MAX ;don't bother if no units left
	JE	SHORT MNTX4		;
	MOV	CX,CV_MAX		;maximum times through loop
	MOV	DI,OFFSET MNTTBL	;point at start of mount table
	MOV	BX,OFFSET XTRAVOL	;point to extra volumes

MNTX1:	CMP	BYTE PTR [DI],0 	;check for an empty unit
	JE	SHORT MNTX2		;
	JMP	SHORT MNTX3		;

MNTX2:	MOV	AL,BYTE PTR [BX]	;found a hole
	MOV	BYTE PTR %DRIVE,AL	;
	MOV	AL,BYTE PTR [BX+1]	;
	MOV	BYTE PTR %SERVER,AL	;
;
	ADD	BX,2			;
	MOV	SI,BX			;point SI at DA record
	ADD	BX,DARECSZ		;point BX at DV record
	MOV	AX,DI			;figure out unit number
	MOV	DX,OFFSET MNTTBL	;
	SUB	AX,DX			;
	INC	AX			;
	MOV	BYTE PTR [SI+DAMNTINFO],AL ;store in DA record for the
	PUSH	BX			;.benefit of the mount message
	PUSH	CX			;
	PUSH	DI			;
	CALL	MNTVOL			;mount the volume
	POP	DI			;
	POP	CX			;
	POP	BX			;
	ADD	BX,DVRECSZ		;set pointer to next extra volume
	DEC	WORD PTR NUMXTRA	;exit if mounted all extra vols.
	JZ	SHORT MNTX4		;

MNTX3:	INC	DI			;point at next unit
	LOOP	SHORT MNTX1		;
MNTX4:	RET				;
MNTXTRA ENDP

;**************************************************************************
;
; ADDFAT -	adds extra BPB entries so we can have a few extra units
;		BPB used is stored at DEFFAT
;
;		DESTROYS - AX,CX,DI,SI
;
;**************************************************************************

ADDFAT	PROC NEAR
	MOV	AX,CV_MAX		;add up to maximum number of volumes

	MOV	DI,OFFSET BPBTBL	;if first word of entry (sector size)
FAT0:	CMP	WORD PTR [DI],0 	;.is zero, then there isn't a volume
	JE	SHORT FAT1		;.mounted and we can use this BPB
	ADD	DI,BPBSZ		;.entry; else search through all BPB
	JMP	SHORT FAT1A		;.entries

FAT1:	MOV	SI,OFFSET DEFFAT	;found empty BPB entry, move BPB
	MOV	CX,BPBSZ		;.of volume with biggest FAT
    REP MOVSB				;
	INC	WORD PTR MOUNTED	;increment count of mounted volumes
FAT1A:	DEC	AX			;
	JNZ	SHORT FAT0		;

FAT2:	RET				;
ADDFAT	ENDP

;**************************************************************************
;
; SRV8NAME -
;
;**************************************************************************

SRV8NAME PROC	NEAR

	MOV	WORD PTR %NUMSRV,1	;set number of servers to 1
	MOV	DI,OFFSET %SRVTBL	;set device type to 1 (disk server),
	MOV	BYTE PTR [DI],DSKSERV	;.and address to boot server address
	MOV	AL,BYTE PTR BSERVER	;
	MOV	BYTE PTR [DI+1],AL	;
	OR	BYTE PTR [DI],80H	;mark as home server
	ADD	DI,SRVRNAM		;copy name from DI table into
	MOV	SI,OFFSET DISRVNM	;.server table
	MOV	CX,10			;
   REPZ MOVSB				;
	RET				;

SRV8NAME ENDP

  IF (SHADOW)

;**************************************************************************
;
; CHK_SHADOW - Check to see if the server is a SHADOW drive.
;	       If it is a SHADOW drive then only allow it's
;	       volumes to be mounted if it's the master drive
;	       in the SHADOW pair.  Also set up the SHADOW_TBL
;	       with the drive type and the server number of the
;	       mate. (v4.20 nod)
;
;**************************************************************************

CHK_SHADOW	PROC	NEAR
;
	PUSH	AX
	PUSH	BX
	PUSH	CX
	PUSH	DX
	PUSH	DI
	PUSH	SI
	MOV	SI,OFFSET READSTATUS	; Omninet command
	MOV	DI,OFFSET SHADOW_STATUS ; Location for returned data
	MOV	AL,DL			; Node number to talk to
	MOV	CX,2			; Number of bytes to send
	PUSH	DX			; Save the node number
	MOV	DX,4			; Number of bytes to receive
	MOV	AH,1			; ROM command
	MOV	BX,WORD PTR XMITDESC	; BL = wait, BH = retries
	PUSH	CS			;
	CALL	CRVIO			;
	POP	DX			;Restore the node number
	AND	CH,10011111B		;Strip off the Mode flag
	CMP	AL,8FH			;OMNIDRIVE without SHADOW PROM?
	JZ	NO_SHADO_PROM		;Yes -- then mark it as such
	CMP	AL,0
	JZ	CHK_RET_LEN
	JMP	CS_EXIT
CHK_RET_LEN:
	CMP	CX,5			;number of bytes received + return code
	JZ	SHADO_OK		;Looks ok
	JMP	CS_EXIT
;
NO_SHADO_PROM:				;This Omnidrive does not contain the
					;... Shadow Drive prom.
	MOV	AL,-1			;There is not a mate for this drive
	MOV	DRVTYPE,NO_SHADOW_PROM	;Set drive type to NO SHADOW PROM
	JMP	SET_SHDO_TBL
;
SHADO_OK:
	MOV	AL,MATEADR		;Get the mates address
	CMP	DRVMODE,DM_OFFLINE	;If the Mode flag is set to OFFLINE
	JZ	SET_SHDO_TBL		;...then set shadow table accordingly
;
	MOV	AL,DT_OFFLINE		;Default is OFFLINE
	CMP	DRVTYPE,DT_NORMAL	;Is Drivetype set to NORMAL?
	JNZ	TRY_MASTER		;No -- then try MASTER
	JMP	SET_SHDO_TBL
;
TRY_MASTER:
	CMP	DRVTYPE,DT_MASTER	;Is Drivetype set to MASTER?
	JNZ	TRY_SLAVE		;No -- then try SLAVE
;
;  Make sure this master drive is not really Offline by
;  doing a Read Shadow Status on its mate.
;
	MOV	SI,OFFSET READSTATUS	; Omninet command
	MOV	DI,OFFSET SHADOW_STAT2	; Location for returned data
	MOV	CX,2			; Number of bytes to send
	PUSH	DX			; Save the node number
	MOV	DX,4			; Number of bytes to receive
	MOV	AH,1			; ROM command
	MOV	AL,MATEADR		; Node number to talk to
	MOV	BX,WORD PTR XMITDESC	; BL = wait, BH = retries
	PUSH	CS			;
	CALL	CRVIO			;
	POP	DX			; Restore the node number
	MOV	AL,MATEADR		; Restore the mates node number
	CMP	DRVMOD2,DM_MATEOFF	;
	JNZ	SET_SHDO_TBL		; Drive seems to be OK so continue
;
;  Now try to tell the bad drive to go offline.
;
	PUSH	DX
	MOV	SI,OFFSET GOOFFLINE	; Omninet command
	MOV	AL,DL			; Node to talk to
	MOV	CX,2			; Number of bytes to send
	MOV	DX,0			; Number of bytes to receive
	MOV	BX,WORD PTR XMITDESC	; BL = wait, BH = retries
	MOV	AH,1			; ROM command
	PUSH	CS			;
	CALL	CRVIO			;
	POP	DX			;
	JMP	CS_EXIT 		; Drive is really offline so exit
;
TRY_SLAVE:
	CMP	DRVTYPE,DT_SLAVE
	JNZ	CS_EXIT 		;If the Drivetype is not set to NORMAL,
;					;...MASTER, or SLAVE then exit.
	MOV	AL,MATEADR
SET_SHDO_TBL:
	MOV	AH,DRVTYPE
	XOR	BX,BX
	MOV	BL,DL				;Load the node number
	SHL	BX,1				;Convert node nbr to tbl offset
	MOV	BYTE PTR SHADOW_TBL [BX],AH	;Load the Drivetype flag
	MOV	BYTE PTR SHADOW_TBL [BX+1],AL	;Load the Mate Address
;
CS_EXIT:
	POP	SI
	POP	DI
	POP	DX
	POP	CX
	POP	BX
	POP	AX
	RET
;
CHK_SHADOW	ENDP

  ENDIF



PAGE
;**************************************************************************
;
; MAIN -
;
;**************************************************************************

LOGON	PROC	NEAR			;

	CLD				;set direction flag
	PUSH	DS			;
	PUSH	ES			;
	MOV	AX,CS			;set segments the same
	MOV	DS,AX			;
	MOV	ES,AX			;

	MOV	AX,SP			;save stack pointer for abort
	MOV	WORD PTR %STKPTR,AX	;

	MOV	BX,OFFSET ROMJMPS	;set address of video routines
	MOV	AX,WORD PTR [BX-4]	;
	MOV	WORD PTR %VIDEO,AX	;
	MOV	AX,WORD PTR [BX-2]	;
	MOV	WORD PTR %VIDEO+2,AX	;

	MOV	AL,BYTE PTR BSERVER	;set server to boot server
	MOV	BYTE PTR %SERVER,AL	;
	MOV	BYTE PTR %DRIVE,1	;start with drive 1

	CALL	PARSE			;check installation line
	CMP	BYTE PTR %USRFLG,0FFH	;see if a user name was given
	JE	SHORT LOGON1		;

	CALL	PUTLOGO 		;display logo

	CALL	GETUSER 		;get username and password
	JNC	SHORT LOGON1		;

	CALL	HOME			;if <ESC> exit immediately, if
	CMP	BYTE PTR %ESCFLG,0FFH	;.internal username then allocate
	JE	SHORT %EXIT2		;.FATs to all units and exit
	JMP	SHORT %EXIT1		;

LOGON1: CMP	BYTE PTR XPORTER,0FFH	;check if flat cable
	JNE	SHORT LOGON2		;

	MOV	WORD PTR %NUMSRV,1	;flat cable has 1 "server"
	CALL	FHELLO			;if flatcable (the 0FFH) then
	JMP	SHORT LOGON3		;.ignore all the Omninet stuff
					;.and just do an 'Add Active'

LOGON2: CMP	BYTE PTR DVRTYP,1	;DVRTYP = 1 means Omnishare emulator
	JE	SHORT LOGON2A		;.so get server stuff from block 8

	CALL	HOME			;clear screen and try to find all
	CALL	FINDSRV 		;.servers
	JC	SHORT LOGON2A		;carry means no servers, but we got
	CALL	HOMESRV 		;.this far so probably old disk server
					;.so get name from blk 8; else find
	CALL	OHELLO			;do a "HELLO" and continue on
	JMP	SHORT LOGON3		;

LOGON2A:CALL	SRV8NAME		;get server name from block 8

LOGON3: CMP	BYTE PTR PSYSTEM,0FFH	;check if booting p-system
	JNE	SHORT LOGON4		;
	JMP	BTPSYS			;go boot p-system

LOGON4: CALL	HOME			;
	CALL	MOUNT			;mount volumes
	CALL	MNTXTRA 		;add in volumes that conflicted

%EXIT1: CALL	ADDFAT			;add extra units if we have the space

%EXIT2: MOV	AX,WORD PTR MOUNTED	;save number of volumes mounted
	MOV	BYTE PTR CV_SUP,AL	;
	MOV	SI,OFFSET %CRYPTNM	;save encrypted user name
	MOV	DI,OFFSET USER		;
	MOV	CX,10			;
    REP MOVSB				;

	MOV	DX,OFFSET CRLF		;finish with a CR LF
	CALL	PRNTSTR 		;

	POP	ES			;restore segments and return to
	POP	DS			;.CORDRV
	RET				;

;**************************************************************************
;
; FATAL -	fatal error message
;
;**************************************************************************

FATAL	LABEL	NEAR
	CALL	HOME			;
	CALL	ERRMSG			;
FATAL1: MOV	DX,OFFSET MNTABORT	;
	CALL	PRNTSTR 		;
	CALL	ADDFAT			;
	MOV	AX,WORD PTR MOUNTED	;
	MOV	BYTE PTR CV_SUP,AL	;
	CLI				;
	MOV	AX,WORD PTR %STKPTR	;
	MOV	SP,AX			;
	STI				;
	POP	ES			;
	POP	DS			;
	RET				;

;**************************************************************************
;
; P-SYSTEM STUFF
;
;**************************************************************************

LDOFFST EQU	7C00H			;load address in seg 0 (decimal)
LDSEG	EQU	1000H			;

PSYS:	DW	LDOFFST+6		;load address offset and segment
	DW	LDSEG			;
PFILSZ: DW	0			;file size
PSYSFIL:DB	'PBOOT.DAT',0           ;name

;**************************************************************************

NOBOOT: DB	"Cannot find p-system boot file, PBOOT.DAT, on boot disk."
	DB	CR,LF,"$"

LDERRMSG:DB	"Error loading p-system",CR,LF,"$"

;**************************************************************************

NOBTERR LABEL	NEAR			;
	MOV	DX,OFFSET NOBOOT	;
	JMP	SHORT HANG		;

PSYSERR LABEL	NEAR
	MOV	DX,OFFSET LDERRMSG	;
HANG:	CALL	PRNTSTR 		;
HANG1:	JMP	HANG1			;

BTPSYS	LABEL NEAR
	MOV	AH,03DH 		;open p-system boot file
	MOV	AL,0			;
	MOV	DX,OFFSET PSYSFIL	;
	INT	21H			;
	JC	SHORT NOBTERR		;
	MOV	BX,AX			;

	MOV	AH,03FH 		;get length from first two
	MOV	DX,OFFSET PFILSZ	;.bytes
	MOV	CX,2			;
	INT	21H			;
	JC	SHORT PSYSERR		;

	MOV	CX,WORD PTR PFILSZ	;load boot file
	MOV	DX,LDOFFST		;
	ADD	DX,2			;adjust for two bytes already read
	PUSH	DS			;set segment
	MOV	AX,LDSEG		;
	MOV	DS,AX			;
	MOV	AH,03FH 		;
	INT	21H			;
	POP	DS			;
	JC	SHORT PSYSERR		;

;Pass some info to p-system boot

	MOV	AH,BYTE PTR XPORTER	;our transporter number
	MOV	AL,BYTE PTR BSERVER	;home server number
	MOV	BX,OFFSET %CRYPTNM	;offset to name and password
	MOV	CX,WORD PTR %NUMSRV	;number of servers
	MOV	DX,OFFSET %SRVTBL	;offset to table of servers

	JMP	DWORD PTR [PSYS]	;jump into boot

;**************************************************************************

LOGON	ENDP

