PAGE	58,132
NAME	SMON
TITLE	SMON - Monitor shadow drives
;
IF2
	%OUT	<Starting Pass Two>
ENDIF
;
;
; * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
;									      *
; Filename:	SMON.ASM   (written for the Microsoft MACRO Assembler v1.26)  *
;									      *
; Purpose:	This program will monitor the status of shadow drives	      *
;									      *
; Author:	Norman O. Doyle  nod					      *
;									      *
; Created:	4/10/85 						      *
; Modified:	2/05/86 						      *
; Version:	0.01d							      *
;									      *
; Change log:								      *
;									      *
;      4/10/85	0.01a - Original version - nod				      *
;      7/18/85	0.01b - Fixed curser upon exit - nod			      *
;      8/20/85	0.01c - Fixed bug caused by the Companion.  On an ECHO net    *
;			command the companion destroys the CX register. - nod *
;      2/05/86	0.01d - Don't allow subroutine CHKSRV to wait for forever     *
;			when doing a WHO ARE YOU command. - nod 	      *
;									      *
;	  (c) Copyright 1985 Corvus Systems, Inc.  All rights reserved.       *
;									      *
; * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
;
;
CSEG	SEGMENT PARA PUBLIC 'CODE'

	ASSUME	CS:CSEG,DS:CSEG,ES:CSEG

	ORG	100H			;
START:	JMP	MAIN			;

;**************************************************************************
;
; EQUATES
;
;**************************************************************************
;
VER	EQU	0			; Version number
REVNBR	EQU	0			; Revision number
SUBREV	EQU	1			; Sub-revision number
REVLTR	EQU	'd'                     ; Revision letter (lower case)
;
; If you change these be sure you change the version error message
;
CORVER	EQU	6			;CORDRV version and revision needed
CORREV	EQU	0			;
;
; ASCII equates
;
BACKSPC EQU	08H			;ASCII backspace
BELL	EQU	07H			;ASCII bell
BLANK	EQU	20H			;ASCII blank
CR	EQU	0DH			;ASCII carriage return
DOT	EQU	2EH			;ASCII period
ESCAPE	EQU	1BH			;ASCII ESCAPE character
LF	EQU	0AH			;ASCII line feed
TAB	EQU	09H			;ASCII horizontal tab
;
; Keyboard scan codes
;
F1	EQU	59			;Key F1
F2	EQU	60			;Key F2
F9	EQU	67			;Key F9
F10	EQU	68			;Key F10
;
; Screen character equates
;
DOTPOS	EQU	0049H			;
MENUPOS EQU	1600H			;cursor position for options
ERRLINE EQU	1800H			;cursor position for the error line
MONPOS	EQU	1522H			;cursor position for getting node
STPPOS	EQU	152AH			;Cursor pos for getting node to stop
NODPOS	EQU	1500H			;cursor pos for Node # question
MSCRPS	EQU	0900H			;cursor position for monitor screen
;
; Drive type (OmniDrive or generic)
;
DSKSERV EQU	1			;generic disk server device type
ODRIVE	EQU	6			;Omni drive device type
;
; SHADOW drive type ( see CORDRV.ASM for further details)
;
OFFLINE 	EQU    -1		;drive is down and cannot be used.
NRML_ODRV	EQU	0		;drive is a normal drive (not shadow)
MASTER		EQU	1		;drive is a master in a shadow pair
SLAVE		EQU	2		;drive is a slave in a shadow pair
NO_SHADOW_PROM	EQU	3		;drive does not have the shadow prom
;
; SHADOW mode flag (see CORDRV.ASM for further details)
;
DM_NORMAL	EQU	0		;Mode flag set to NORMAL
DM_OFFLINE	EQU	1		;Mode flag set to OFFLINE
DM_MATEOFF	EQU	2		;Mode flag set to MATE OFFLINE
;
; Server table Equates
;
NODENUM 	EQU	0		;node number offset
SRVRNAM 	EQU	1		;server name offset
SRVRSIZ 	EQU	11		;server size offset
;					;server sizes are stored using the same
;					;method as for sending an OmniDrive
;					;a sector number. (ie. d, lsb, msb)
;					; d  =the most significant byte, add
;					;     10H to it and swap the nibbles.
;					; lsb=the least significant byte
;					; msb=the middle byte
ENTRYSZ 	EQU	14		;size of one entry
TBLSZ		EQU	64		;number of entries
;
; Drive type table Equates
;
DT_TBLSZ	EQU	6		;number of entries
DT_ENTSIZ	EQU	5		;size of one entry (in bytes)
DT_OUTPUT	EQU	1		;offset for ascii string to output
;
; Misc Equates
;
COLOR		EQU	0		;
MONOCHROME	EQU	1		;
DMODE_LEN	EQU	13
DTYPE_LEN	EQU	 7
%ODLLEN 	EQU	38		;length of string %ODLINE
%MNLEN		EQU	79		;length of string MONLINE
SHDO_OFST	EQU	42		;offset into CORTAb to find the
;					;... ptr to SHADOW_TBL
BUFFSIZ 	EQU	18		;number of sectors to buffer up for
;					;... a compare.
FREE		EQU	-1		;Index in MONTBL is available
OUTSTR_SIZ	EQU	6		;max number of digits in %OUTSTR
MONTBL_SIZ	EQU	10		;Size of MONTBL
TEN		EQU	10
ONEHUNDRED	EQU	100
ONETHOUSAND	EQU	1000
TENTHOUSAND	EQU	10000		;
TWOK		EQU	2048		;decimal value for 2k bytes
WAIT		EQU	00AH		;# of .86 sec ticks to wait on disk
;					; server
RETRIES 	EQU	00AH		;# of retransmissions before aborting
CURSOR_OFF	EQU	2000H		;Code to turn off the cursor
CURSOR_ON_COLOR EQU	0607H		;Turn on the cursor (color monitor)
CURSOR_ON_MONO	EQU	0B0CH		;Turn on the cursor (monichrome mon)
TRUE		EQU	0FFFFH		;Logical true
;
;**************************************************************************
;
; STORAGE
;
;**************************************************************************

EVEN
VIDEO:		DD	0		;address of video driver
CORPTR: 	DD	0		;address of CORTAB
PARMTAB:	DD	0		;offset & segment of parameter table
HANDLE: 	DW	0		;file handle
DRTN:		DW	0		;address of current display routine
TIMMULT:	DW	0		;time multiplier
%NUMOD: 	DW	0		;# of OmniDrives on the net (default=1)
%SRVR_TBL_PTR	DW	0		;pointer to the correct entry in the
;					;... %SRVTBL
CURSOR_ON	DW	CURSOR_ON_MONO	;
SCTNBR: 	DW	0		;
XMITDESC	LABEL	WORD
		DB	WAIT		;# of .86 sec ticks to wait on disk srvr
		DB	RETRIES 	;# of retransmissions before aborting

CNT		DB	1
NBR_SECTORS:	DB	0		;# of sectors left to read into buffer
ERR_TYPE	DB	0
SECONDS 	DB	0		;
%NUMBER:	DB	0		;1 = only allow numbers for input
%ECHO:		DB	0		;0 = echo character
%MAXCHR:	DB	0		;maximum number of characters wanted
%CHRTYP:	DB	0		;number of characters entered
%INBUFF:	DB	8 DUP(0)	;input buffer from console
%OUTSTR:	DB	OUTSTR_SIZ DUP (" "),"$"
MONLINE:	DB	10,%MNLEN DUP(" "),CR,LF,"$"
;
UTILSTR:	DB	"UTILHOOK",0    ;device 'UTILHOOK'
MAXCHR: 	DB	0		;maximum # of chars to input
CMD:		DB	0		;number chars read & cmd char
XPORTER:	DB	0FFH		;transporter # (gets patched in later)
NODE:		DB	0		;node number for a drive
SCREEN_TYPE	DB	MONOCHROME	;Default to a monochrome screen
ROWCOL		LABEL	WORD
COL		DB	0
ROW		DB	0
;
; CONSTELLATION II server commands
;
EVEN
WHOAREYOU LABEL NEAR
	DB	01,0FEH 		;protocol ID
	DB	02,0			;message type
	DB	0			;
WAYSRC: DB	0			;source
WAYDEV: DB	0,0FFH			;responding device type wanted

ID	LABEL	NEAR
	DW	0			;protocol ID
	DW	0			;message type
	DB	0			;
IDSRC:	DB	0			;sending station's address
	DB	0			;
IDDEV:	DB	0			;sending station's device type
IDNM:	DB	10 DUP (0)		;sending station's name

GETDRVPARMS	LABEL	NEAR
	DB	16			;protocol ID
DRVNBR: DB	1			;which drive do you want to respond

DRVPARMS LABEL	NEAR
	DB	37 DUP (0)		;1st 37 bytes returned are not needed
CAPACTY:DB	 3 DUP (0)		;capacity of drive in 512 byte sectors
	DB	88 DUP (0)		;last 88 bytes returned are not needed
;
CMDSTR	LABEL	NEAR
LSHOST	DB	0
LSDRIVE DB	0
LSADDH	DW	0
LSADDL	DW	0
LSCNTH	DW	0
LSCNTL	DW	0
LDHOST	DB	0
LDDRIVE DB	0
LDADDH	DW	0
LDADDL	DW	0
LDCNTH	DW	0
LDCNTL	DW	0
;
READSTATUS	LABEL	NEAR
	DB	53H			;Opcode = SHADOW command
	DB	05H			;Sub Op = Get SHADOW status

SHADOW_STATUS	LABEL	NEAR
DRVMODE DB	0			;Drive mode flag
DRVTYPE DB	0			;Drive type flag
MATEADR DB	0			;Mate address
MATESTS DB	0			;Mate status flag

;

;**************************************************************************
;
; Echo Table
;
%ECHOTBL:DB	(TBLSZ) DUP (0FFH)	;fill with FF's
;
; Server table
;
%SRVTBL:DB	(ENTRYSZ*TBLSZ) DUP (0) ;
;
; Table specifing which nodes to monitor
;
MONTBL	DB	MONTBL_SIZ DUP(FREE)
;
;**************************************************************************
;
; SYSTEM ID STRINGS
;
;**************************************************************************

IBMID:	DB	3,'IBM'                 ;

;**************************************************************************
;
; LITERALS
;
;**************************************************************************

BANNER: DB	15,"SHADOW Drive Monitor Program - ["
	DB	VER+30H,".",REVNBR+30H,SUBREV+30H,REVLTR,"]",CR,LF
	DB	"Copyright (c) 1985, Corvus Systems, Inc.",CR,LF,"$"
LINE:	DB	7,79 DUP (0CDH)
CRLF:	DB	CR,LF,"$"
SRVRST: DB	14,"Current OmniDrives:",CR,LF,"$"
ODLINE: DB	10,%ODLLEN DUP(" "),"$"
MENU:	DB	11,"      F1 = Monitor      F2 = Stop Monitor"
	DB	"      F9 = Pause      F10 = Exit","$"
MNSCRN: DB	14,CR,LF
	DB	" Node       Drive  Mode       Drive Type"
	DB	"       Mate Address       Mate Status",CR,LF
	DB	6 DUP (0C4H),5 DUP(32),13 DUP(0C4H),5 DUP(32),12 DUP(0C4H)
	DB	5 DUP(32),14 DUP(0C4H),5 DUP(32),13 DUP(0C4H),"$"
;
DMODE:	DB	"   Offline   "                 ;13 BYTES EACH
	DB	"Mate  Offline"
	DB	"Shado/Nrml OK"
	DB	"             "
	DB	"  E R R O R  "
	DB	"Regular Drive"
;
DTYPE:	DB	"Normal "                       ;7 BYTES EACH
	DB	"Master "
	DB	" Slave "
	DB	"Offline"
	DB	"       "

DOTLINE1:	DB     10,"<* >","$"
DOTLINE2:	DB     10,"< *>","$"
DOTLINE3:	DB     12,"< *>","$"

;
;**************************************************************************
;
MONWHO: DB	14,"Which drive to monitor ? (0-63): ","$"

STOPQUES: DB	14,"Which drive to stop monitoring ? (0-63): ","$"
CONT:	DB	7,"<Press any key to continue>","$"

EXITMSG:DB	10,"Exiting SMON",CR,LF,LF
	DB	"Remember, only your SHADOW knows for sure.",CR,LF,"$"

;**************************************************************************

ERRHDR: DB	12,CR,LF,BELL,"SMON [",VER+30H,".",REVNBR+30H,SUBREV+30H
	DB	REVLTR,"] - ","$"

NOCORMG:DB	4,"Cannot find CORTAb.",CR,LF,"$"

WRCORMG:DB	4,"CORDRV version [",CORVER+30H,".",CORREV+30H,"]"
	DB	" or above needed.",CR,LF,"$"

UNKID:	DB	4,"SMON only supports the IBM PC."
	DB	CR,LF,"$"

VERERR: DB	12,24 DUP (" "),"Invalid node number, try again.",BELL,"$"

NOSHDOMG: DB	12,"SHADOW version of CORDRV needed.",CR,LF,"$"

PAGE
;**************************************************************************
;
;  Table containing addresses of routines to call depending on which
;   menu item was selected
;
CMDTAB: DB	F1			;monitor a shadow pair
	DW	MONITOR 		;
	DB	F2			;stop monitoring a shadow pair
	DW	STOPMON
LCMDTAB EQU	(($-CMDTAB)/3)

;**************************************************************************

PAGE
;**************************************************************************
;
; MAIN -	main program loop
;
;**************************************************************************

MAIN	PROC	NEAR
	INT	3			; Debug entry point
	MOV	AX,CS			;
	MOV	DS,AX			; set up segments for ease of use
	MOV	ES,AX			;
	MOV	AH,1
	MOV	CX,CURSOR_OFF		;turn off the cursor
	INT	10H

	CALL	FINDVID 		;find video jump
	JC	SHORT IERROR1		;

	CALL	FINDID			;find system ID
	JC	SHORT IERROR1		;

	MOV	AH,15
	INT	10H			;Get the current video mode
	CMP	AL,0			;40x25 BW
	JZ	GTSRVRS
	CMP	AL,2			;80x25 BW
	JZ	GTSRVRS
	CMP	AL,7			;CRT MODE, 80x25 B&W card
	JZ	GTSRVRS
	MOV	SCREEN_TYPE,COLOR	;Set screen type to color
	MOV	CURSOR_ON,CURSOR_ON_COLOR
GTSRVRS:
	CALL	FINDSRV 		;find all disk servers
	CALL	SCRN			;display entire screen
;
;Main command loop
;
MAIN0:	MOV	BX,OFFSET CMDTAB	;start of command table
	CALL	GETKYBR 		;get character from keyboard if there
	JC	SHORT UPDATE		;carry means no char input
	CMP	AH,F10			;exit if F10
	JE	SHORT EXIT		;
	CMP	AH,F9			;Pause?
	JNZ	NO_PAUSE
	MOV	DX,DOTPOS
	CALL	POSCUR
	MOV	DX,OFFSET DOTLINE3
	CALL	PRNTCLR
	MOV	DX,ERRLINE
	ADD	DL,26
	CALL	POSCUR
	MOV	DX,OFFSET CONT		;
	CALL	PRNTCLR 		;
PAUSE:	CALL	GETKYBR 		;Wait for a character to be pressed
	JC	PAUSE
	MOV	DX,ERRLINE		;
	CALL	CLREOL			;clear the error message line
	JMP	SHORT UPDATE		;Get going again
NO_PAUSE:
	MOV	CX,LCMDTAB		;search through command table for
MAIN1:	CMP	BYTE PTR [BX],AH	;.character received from keyboard
	JE	SHORT DOCMD		;
	ADD	BX,3			;
	LOOP	SHORT MAIN1		;
	JMP	SHORT MAIN0		;didn't find it

DOCMD:	CALL	CLRCMD			;clear command window
	INC	BX			;point at command address
	CALL	WORD PTR [BX]		;do it
	JMP	SHORT MAIN0		;go set up for next command
;
; Update the screen
;
UPDATE:
	CALL	SCREEN			;
	JMP	SHORT MAIN0		;
;
;End main command loop
;
RSTERR: CALL	CLRCMD			;
					;
IERROR1:PUSH	DX			;save error message
	MOV	AH,1
	MOV	CX,CURSOR_ON		;restore the cursor
	INT	10H
	MOV	AX,600H 		;Function and blanking factor
	MOV	BH,7			;Screen attribute for blanked lines
	SUB	CX,CX			;Start at 0,0 (1,1)
	MOV	DX,184FH		;End at 24,79 (25,80)
	INT	10H			;Video interrupt
	MOV	DX,OFFSET ERRHDR	;print error header
	CALL	PRNTCLR 		;
	POP	DX			;restore error message and print
	CALL	PRNTCLR 		;
	JMP	EXIT2

EXIT:	MOV	AH,1
	MOV	CX,CURSOR_ON		;restore the cursor
	INT	10H
	MOV	AH,1			;clear the screen
	CALL	DWORD PTR [VIDEO]	;
EXIT2:	MOV	DX,OFFSET EXITMSG	;
	CALL	PRNTCLR 		;
;
	MOV	AH,4CH			;exit system call
	XOR	AL,AL			;show no error
	INT	21H			;bye

MAIN	ENDP

PAGE
;************************************************************************
;
; COMMAND ROUTINES
;
;************************************************************************
;
;
;
;************************************************************************
;*									*
;* Subroutine:	MONITOR 						*
;*									*
;* Function:	Start to monitor a drive.				*
;*									*
;* Input:	None							*
;*									*
;* Output:	None							*
;*									*
;* Updates:	Nothing 						*
;*									*
;* Destroys:								*
;*									*
;************************************************************************
;
MONITOR PROC	NEAR
	CALL	CLRWNDO
	MOV	DX,NODPOS
	CALL	POSCUR
	MOV	DX,OFFSET MONWHO	;ask which drive to monitor
	CALL	PRNTCLR 		;
GETMST: MOV	DX,MONPOS		;
	CALL	POSCUR			;
	CALL	GETDEC			;Response will be in AL
	JNC	SHORT SSCONT		;if carry set the exit
	JMP	SSEND			;if carry set the exit
SSCONT: CALL	VERIFY			;verify that the node is valid
	JC	SHORT GETMST		;get another answer
	MOV	DX,ERRLINE		;
	CALL	CLREOL			;clear the error message line
	MOV	CX,MONTBL_SIZ
	MOV	BX,OFFSET MONTBL	;
PUT_IN_TBL:
	CMP	BYTE PTR [BX],FREE	;Is the spot free?
	JNZ	CHKNXT
	MOV	BYTE PTR [BX],AL	;Load the node
	JMP	SSEND
CHKNXT: INC	BX
	LOOP	PUT_IN_TBL
;
;  Now set up the screen in preperation for the monitoring.
;
;
SSEND:	CALL	CLRWNDO 		;
	RET
MONITOR ENDP
;
;
;
;************************************************************************
;*									*
;* Subroutine:	STOPMON 						*
;*									*
;* Function:	Stop monitoring a drive.				*
;*									*
;* Input:	None							*
;*									*
;* Output:	None							*
;*									*
;* Updates:	Nothing 						*
;*									*
;* Destroys:								*
;*									*
;************************************************************************
;
STOPMON PROC	NEAR
	CALL	CLRWNDO
	MOV	DX,NODPOS
	CALL	POSCUR
	MOV	DX,OFFSET STOPQUES	;which node to stop monitoring
	CALL	PRNTCLR 		;
GETNML: MOV	DX,STPPOS		;
	CALL	POSCUR			;
	CALL	GETDEC			;Response will be in AL
	JC	SHORT NMLEND		;if carry set the exit
	CALL	VERIFY			;verify that the node is valid
	JC	SHORT GETNML		;get another answer
;
;  Now change MONTBL to reflect the change.
;
	MOV	CX,MONTBL_SIZ
	MOV	BX,OFFSET MONTBL	;
OUT_OF_TBL:
	CMP	BYTE PTR [BX],AL	;Is this the node we want?
	JNZ	CKNXT
	MOV	BYTE PTR [BX],FREE	;Free up this spot in the table
	JMP	NMLEND
CKNXT:	INC	BX
	LOOP	OUT_OF_TBL
;
NMLEND: CALL	CLRWNDO 		;
	RET
STOPMON ENDP
;
;
;
;************************************************************************
;*									*
;* procedure:	READ_STS						*
;*									*
;* input:	AX contains the server number to read the		*
;*		status from.						*
;*									*
;* output:	AL = Return code					*
;*		CX = number of bytes returned (should be 5)		*
;*									*
;* updates:	DRVMODE, DRVTYPE, MATEADR, MATESTS			*
;*									*
;* destroys:	CX, DX, SI, DI						*
;*									*
;************************************************************************
;
READ_STS	PROC	NEAR
;
	PUSH	AX
	MOV	SI,OFFSET READSTATUS	; Omninet command
	MOV	DI,OFFSET SHADOW_STATUS ; Location for returned data
	MOV	CX,2			; Number of bytes to send
	MOV	DX,4			; Number of bytes to receive
	MOV	AH,1			; ROM command
	PUSH	CS			;
	CALL	CRVIO			;
	MOV	ERR_TYPE,AL		; Save the return code
	POP	AX
	RET
;
READ_STS	ENDP
;
;
;
;
;************************************************************************
;*									*
;* procedure:	SCREEN							*
;*									*
;* input:								*
;*									*
;* output:								*
;*									*
;*									*
;* updates:	DRVMODE, DRVTYPE, MATEADR, MATESTS			*
;*									*
;* destroys:								*
;*									*
;************************************************************************
;
SCREEN	PROC	NEAR
;
;  Only update the screen once a second.
;
	MOV	AH,02CH 			;DOS get time function
	INT	21H
	CMP	DH,SECONDS			;Has the second changed?
	JNZ	SCR020				;Yes -- then update screen
	JMP	SCR900				;No -- then exit
;
SCR020: MOV	SECONDS,DH			;Save the seconds
	MOV	DX,DOTPOS
	CALL	POSCUR
	CMP	CNT,1
	JNZ	SCR025
	MOV	DX,OFFSET DOTLINE1
	INC	CNT
	JMP	SCR030
SCR025: MOV	DX,OFFSET DOTLINE2
	MOV	CNT,1
SCR030: CALL	PRNTCLR 		;
;
	MOV	CX,MONTBL_SIZ			;Initialize the counter
	MOV	BX,OFFSET MONTBL
	MOV	DX,MSCRPS
	CALL	POSCUR
SCR040: PUSH	CX
	MOV	CX,%MNLEN
	MOV	DI,OFFSET MONLINE
	INC	DI				;Skip over the color byte
	MOV	AL,BLANK
	REP	STOSB				;Init the line to blanks
;
	CMP	BYTE PTR [BX],FREE		;Is this location empty?
	JNZ	SCR050
	JMP	SCR400
;
SCR050: XOR	AX,AX
	MOV	AL,BYTE PTR [BX]		;Get the node number
	CALL	READ_STS			;Read the status of this drive
	CALL	CNVRT_SRVR			;Convert decimal to ASCII
	MOV	DI,OFFSET MONLINE
	ADD	DI,3				;Skip over colore byte
	MOV	[DI],AH 			;Get the tens digit
	INC	DI
	MOV	[DI],AL 			;Get the ones digit
	ADD	DI,8
;
	MOV	SI,OFFSET DMODE
	CMP	ERR_TYPE,0
	JZ	SCR055
	CMP	ERR_TYPE,8FH			; Illegal Opcode?
	JNZ	SCR052				; Must mean no shadow prom
	ADD	SI,13
SCR052: ADD	SI,52
	JMP	SCR120
SCR055: CMP	DRVMODE,DM_OFFLINE
	JNZ	SCR060
	ADD	SI,0
	JMP	SCR120
SCR060: CMP	DRVMODE,DM_MATEOFF
	JNZ	SCR080
	ADD	SI,13
	JMP	SCR120
SCR080: CMP	DRVMODE,DM_NORMAL
	JNZ	SCR100
	ADD	SI,26
	JMP	SCR120
SCR100: ADD	SI,39
SCR120: MOV	CX,DMODE_LEN
	REP	MOVSB				;Load the drive MODE definition
;
	CMP	ERR_TYPE,0
	JZ	SCR130
	JMP	SCR400
SCR130: ADD	DI,8
	MOV	SI,OFFSET DTYPE
	CMP	DRVTYPE,NRML_ODRV
	JNZ	SCR140
	ADD	SI,0
	JMP	SCR220
SCR140: CMP	DRVTYPE,MASTER
	JNZ	SCR160
	ADD	SI,7
	JMP	SCR220
SCR160: CMP	DRVTYPE,SLAVE
	JNZ	SCR180
	ADD	SI,14
	JMP	SCR220
SCR180: CMP	DRVTYPE,OFFLINE
	JNZ	SCR200
	ADD	SI,21
	JMP	SCR220
SCR200: ADD	SI,28
SCR220: MOV	CX,DTYPE_LEN
	REP	MOVSB				;Load the drive TYPE definition
;
; Get the mate number
;
	ADD	DI,13
	XOR	AX,AX
	MOV	AL,MATEADR			;Get the mates node number
	CALL	CNVRT_SRVR			;Convert decimal to ASCII
	MOV	[DI],AH 			;Get the tens digit
	INC	DI
	MOV	[DI],AL 			;Get the ones digit
;
; Get the mate status value
;
	ADD	DI,17
	XOR	AX,AX
	MOV	AL,MATESTS
	CALL	LOAD_VALUE
;
;  Output the line to the screen now
;
SCR400: MOV	DX,OFFSET MONLINE		;point to the output line again
	CALL	PRNTCLR 		;
;
SCR600: INC	BX
	POP	CX
	DEC	CX
	JZ	SCR900
	JMP	SCR040
SCR900:
	RET
SCREEN	ENDP
;
;
;
;
;****************************************************************************
;
LOAD_VALUE	PROC	NEAR
	PUSH	BX
;
;  Get the hundreds digit now.
;
	CWD				;Convert AX to double word DX,AX
	MOV	BX,ONEHUNDRED
	DIV	BX
	CMP	AL,0
	JZ	DO_TENS
	ADD	AL,30H			;convert decimal to ascii
	MOV	BYTE PTR [DI],AL
DO_TENS:
	INC	DI
	MOV	AX,DX			;get the remainder now
;
;  Get the tens digit and the ones digit (it's in the remainder) now.
;
	MOV	BH,TEN
	DIV	BH
	ADD	AX,3030H		;convert decimal to ascii
	MOV	WORD PTR [DI],AX

;	Now restor the registers before the return
;
	POP	BX
	RET
LOAD_VALUE	ENDP
;
;
;
;
;
;************************************************************************
;*									*
;* Subroutine:	VERIFY							*
;*									*
;* Function:	Verify that the node passed in AX exists		*
;*									*
;* Input:	AL = node number					*
;*									*
;* Output:	Sets the carry flag if node not found			*
;*									*
;* Updates:	Nothing 						*
;*									*
;* Destroys:	All registers preserved 				*
;*									*
;************************************************************************
;
VERIFY	PROC	NEAR
	PUSH	AX
	PUSH	BX
	PUSH	CX
	PUSH	DX
	MOV	BX,OFFSET %SRVTBL	;point to table
	MOV	CX,WORD PTR %NUMOD	;get the # of OmniDrives on the network
NXTONE: CMP	AL,BYTE PTR [BX]	;does it match?
	JE	SHORT VEROK		;yes so leave
	ADD	BX,ENTRYSZ		;point to next entry
	LOOP	NXTONE			;try to match with the next one
;
;  Could not find a match.  Clear answer and put up error message
;
	CALL	CLREOL			;clear the invalid answer
	MOV	DX,ERRLINE
	CALL	CLREOL			;clear the error line before displaying
	MOV	DX,OFFSET VERERR	;display the verify error message
	CALL	PRNTCLR 		;
	STC				;set the carr flag for error return
;
VEROK:	POP	DX
	POP	CX
	POP	BX
	POP	AX
	RET
VERIFY	ENDP
;
;
;
;************************************************************************
;*									*
;* Subroutine:	FINDSRVR						*
;*									*
;* Function:	Find all the active servers on the NET.  Then		*
;*		send a "WHO ARE YOU" to them to find all the            *
;*		OmniDrives.						*
;*									*
;* Input:	None							*
;*									*
;* Output:	None							*
;*									*
;* Updates:	%ECHOTBL, %SRVTBL, %NUMOD				*
;*									*
;* Destroys:	BX, CX, DX, SI						*
;*									*
;************************************************************************
;
FINDSRV PROC   NEAR

	MOV	BX,OFFSET %ECHOTBL	;build table of active nodes
	MOV	CX,64			;
	MOV	DX,600H 		;DH = ECHO; DL = NODE
FSRV0:	CALL	ECHONET 		;
	INC	DL			;
	LOOP	SHORT FSRV0		;

	MOV	BX,OFFSET %SRVTBL	;send WHO ARE YOUs to active nodes
	MOV	SI,OFFSET %ECHOTBL	;
	MOV	CX,64			;
	MOV	DX,300H 		;DH = SND/RCV TO SERVER; DL = NODE
FSRV1:	CMP	BYTE PTR [SI],0FFH	;if active node do the WHO ARE YOU
	JE	SHORT FSRV2		;
	MOV	DL,BYTE PTR [SI]	;
	CALL	CHKSRV			;
FSRV2:	INC	SI			;
	LOOP	SHORT FSRV1		;

	RET				;
FINDSRV ENDP
;
;
;
;************************************************************************
;*									*
;* Subroutine:	ECHONET 						*
;*									*
;* Function:	Send a ECHO command to a node on the net.		*
;*									*
;* Input:	DH = ECHO command, DL = Node, BX = pointer to %ECHOTBL	*
;*									*
;* Output:	None							*
;*									*
;* Updates:	%ECHOTBL, BX updated to point to the next entry 	*
;*		in %ECHOTBL						*
;*									*
;* Destroys:	AX, DX							*
;*									*
;************************************************************************
;
ECHONET PROC	NEAR
	PUSH	CX			;Save CX because of bug on Companion
	MOV	AX,DX			;AX has function code and node number
	PUSH	CS			;FAKE "FAR" CALL
	CALL	CRVIO			;do echo
	CMP	AL,0C0H 		;
	JNE	SHORT ECHO1		;
	MOV	BYTE PTR [BX],DL	;mark node as active
ECHO1:	INC	BX			;
	POP	CX			;
	RET				;
ECHONET ENDP
;
;
;
;************************************************************************
;*									*
;* Subroutine:	CHKSRV							*
;*									*
;* Function:	Send a "WHO ARE YOU" cmd to a server then check         *
;*		to see if it is an OmniDrive.  If it is then call	*
;*		a routine to save the node number and server name	*
;*		in %SRVTBL.						*
;*									*
;* Input:	DH = SND/RCV to server cmd, DL = node number		*
;*		BX = pointer to entry in %SRVTBL			*
;*									*
;* Output:	AL = status of ROM call 				*
;*									*
;* Updates:	BX is updated to point to the next entry in %SRVTBL	*
;*		%NUMOD is incremented if the server is an OmniDrive	*
;*									*
;* Destroys:	AH							*
;*									*
;************************************************************************
;
CHKSRV	PROC	NEAR
	PUSH	SI			;
	PUSH	CX			;
	PUSH	BX			;
	PUSH	DX			;

CSRVR0: MOV	SI,OFFSET WHOAREYOU	;check if we really found a server
	MOV	DI,OFFSET ID		;.and save name and node number if so
	MOV	AL,BYTE PTR XPORTER	;
	MOV	BYTE PTR [SI+5],AL	;
	MOV	AX,DX			;function code and node number
	MOV	BX,WORD PTR XMITDESC	; BL = wait, BH = retries
	MOV	CX,8			;
	MOV	DX,18			;
	PUSH	CS			;FAKE "FAR" CALL
	CALL	CRVIO			;
	OR	AL,AL			;
	JZ	SHORT CSRVR2		;
	POP	DX			;
	POP	BX			;
	POP	CX			;
	POP	SI			;
	RET				;

CSRVR2: POP	DX			;
	POP	BX			;
	CMP	BYTE PTR IDDEV,ODRIVE	;check if OmniDrive
	JNE	SHORT CSRVR4		;
CSRVR3: CALL	SAVESRV 		;save server info
CSRVR4: POP	CX			;
	POP	SI			;
	RET				;
CHKSRV	ENDP
;
;
;
;************************************************************************
;*									*
;* Subroutine:	SAVESRV 						*
;*									*
;* Function:	Save a servers node number and name in the		*
;*		server table (%SRVTBL). 				*
;*									*
;* Input:	DH = server number					*
;*		BX = pointer to entry in %SRVTBL			*
;*									*
;* Output:	None							*
;*									*
;* Updates:	BX is updated to point to the next entry in %SRVTBL	*
;*		%NUMOD is incremented if the server is an OmniDrive	*
;*									*
;* Destroys:	CX, DI, SI						*
;*									*
;************************************************************************
;
SAVESRV PROC	NEAR
	MOV	BYTE PTR [BX],DL	;save responding server's
	MOV	CX,10			;.address and name in server table
	MOV	SI,OFFSET IDNM		;
	MOV	DI,BX			;
	ADD	DI,SRVRNAM		;
	REP	MOVSB			;
	ADD	BX,ENTRYSZ		;point at next entry in server table
	INC	WORD PTR %NUMOD 	;count server
	RET				;
SAVESRV ENDP

PAGE
;************************************************************************
;									*
; FILE ROUTINES 							*
;									*
;************************************************************************
;
;
;
;
;
;
;************************************************************************
;*									*
;* Subroutine:	OPENUTL 						*
;*									*
;* Function:	Open the character device driver named 'UTILHOOK'       *
;*									*
;* Input:	None							*
;*									*
;* Output:	Carry flag set means error occured			*
;*									*
;* Updates:	HANDLE							*
;*									*
;* Destroys:	AX, DX							*
;*									*
;************************************************************************
;
OPENUTL PROC	NEAR
	MOV	DX,OFFSET UTILSTR	;open 'UTILHOOK' character device
	MOV	AH,3DH			;
	MOV	AL,2			;
	INT	21H			;
	MOV	WORD PTR HANDLE,AX	;save file handle
	RET				;carry set means error
OPENUTL ENDP
;
;
;
;************************************************************************
;*									*
;* Subroutine:	CLSFIL							*
;*									*
;* Function:	Close a file handle					*
;*									*
;* Input:	BX = file handle to close				*
;*									*
;* Output:	Carry flag set means error occured			*
;*									*
;* Updates:	None							*
;*									*
;* Destroys:	AX							*
;*									*
;************************************************************************
;
CLSFIL	PROC	NEAR
	MOV	AH,3EH			;close
	INT	21H			;
	RET				;carry set means error
CLSFIL	ENDP
;
;
;
;************************************************************************
;*									*
;* Subroutine:	FNDCOR							*
;*									*
;* Function:	Get the segment & offset to CORTAb			*
;*									*
;* Input:	None							*
;*									*
;* Output:	Carry flag set means error occured			*
;*									*
;* Updates:	CORPTR to contain the segment & offset of CORTAb	*
;*									*
;* Destroys:	AX, BX, CX, DX						*
;*									*
;************************************************************************
;
FNDCOR	PROC	NEAR
	MOV	BX,WORD PTR HANDLE	;get handle
	MOV	AH,40H			;write 2 characters to 'UTILHOOK'
	MOV	CX,2			;.this will reset pointer to
	MOV	DX,OFFSET UTILSTR	;.CORTAb, get characters from name
	INT	21H			;
	MOV	AH,3FH			;now read 4 bytes from 'UTILHOOK'
	MOV	CX,4			;.the segment & offset of CORTAb
	MOV	DX,OFFSET CORPTR	;
	INT	21H			;
	RET				;carry set means error
FNDCOR	ENDP
;
;
;
;************************************************************************
;*									*
;* Subroutine:	IOCNTRL 						*
;*									*
;* Function:	Read to or write from a device control channel. 	*
;*									*
;* Input:								*
;*									*
;* Output:	Carry flag set means error occured			*
;*									*
;* Updates:	PARMTAB 						*
;*									*
;* Destroys:	AX, BX, CX, DX						*
;*									*
;************************************************************************
;
IOCNTRL PROC	NEAR			;
READ:	MOV	DX,OFFSET PARMTAB	;where to save address
	MOV	CX,4			;read 4 bytes (segment & offset)
	MOV	AL,2			;
	JMP	SHORT IO1		;
WRITE:	MOV	AL,3			;write CX bytes, DX points to data
IO1:	MOV	AH,44H			;I/O control
	MOV	BX,WORD PTR HANDLE	;get handle
	INT	21H			;
	RET				;carry set means error
IOCNTRL ENDP

;**************************************************************************

FINDVID PROC	NEAR
	CALL	OPENUTL 		;open 'UTILHOOK'
	JC	SHORT FVIDERR		;
	CALL	FNDCOR			;get address of CORTAb
	JC	SHORT FVIDERR		;
	CALL	CLSFIL			;
	JC	SHORT FVIDERR		;
	PUSH	DS			;
	LDS	SI,DWORD PTR CORPTR	;get pointer to CORTAb

	MOV	AL,BYTE PTR [SI+6]	;check CORDRV version, if equal then
	CMP	AL,CORVER		;.check revision; if version is not
	JNE	SHORT FINDVD0		;.equal then check if version is
	MOV	AL,BYTE PTR [SI+7]	;.greater
	CMP	AL,CORREV		;
	JL	SHORT WRGCOR		;
;
;  Make sure that this is a shadow version of cordrv.
;
	MOV	AX,WORD PTR [SI+44]
	CMP	AX,TRUE 		; TRUE means it's a shadow version
	JZ	FINDVD1
	MOV	DX,OFFSET NOSHDOMG
	POP	DS
	STC
	RET

WRGCOR: MOV	DX,OFFSET WRCORMG	;wrong CORDRV version message
	POP	DS			;
	STC				;
	RET				;

FVIDERR:MOV	DX,OFFSET NOCORMG	;cannot find CORTAb message
	RET				;

FINDVD0:CMP	AL,CORVER		;if version is less than give error
	JL	SHORT WRGCOR		;

FINDVD1:MOV	AX,WORD PTR [SI+17H]	;the VIDEO routine jump is a FAR
	SUB	AX,5			;.jump right before ROM jumps in
	MOV	CS:WORD PTR VIDEO,AX	;.CORDRV, (see CORDRV for more info)
	MOV	CS:WORD PTR VIDEO+2,DS	;.save address of VIDEO jump
	CLC				;show no error
	POP	DS			;
	RET				;
FINDVID ENDP

;**************************************************************************

CMPID	PROC	NEAR
	MOV	SI,WORD PTR [BX+27H]	;get pointer to ID string in
	MOV	AL,BYTE PTR [SI]	;.CORDRV; first check length, if
	CMP	AL,CS:BYTE PTR [DI]	;.thats OK then compare
	JNE	SHORT NOGOOD		;
	XOR	AH,AH			;
	MOV	CX,AX			;
	INC	SI			;
	INC	DI			;
  REPZ	CMPSB				;
	JNZ	SHORT NOGOOD		;
	CLC				;say no error
	RET				;
NOGOOD: STC				;show error
	RET				;
CMPID	ENDP

;**************************************************************************

FINDID	PROC	NEAR
	CALL	OPENUTL 		;open 'UTILHOOK'
	JC	SHORT IDERR		;
	CALL	FNDCOR			;get address of CORTAb
	JC	SHORT IDERR		;
	CALL	CLSFIL			;close 'UTILHOOK'
	JC	SHORT IDERR		;
	PUSH	DS			;
	LDS	BX,DWORD PTR CORPTR	;get pointer to CORTAb
;
;  Copy the CORDRV ROM jump table into local area
;
	MOV	SI,[BX+23]		;get the ROM function table pointer
	MOV	DI,OFFSET LNKTAB	;local area to copy the table to
	MOV	CX,20			;number of bytes in table
	REP	MOVSB			;copy the table into this program
;
;  Copy the transporter number out of CORTAb
;
	MOV	AL,[BX+27]		;point to "XPORTER" in CORTAb
	MOV	CS:BYTE PTR XPORTER,AL
;
	MOV	CS:WORD PTR TIMMULT,18	;see if IBM
	MOV	DI,OFFSET IBMID 	;
	CALL	CMPID			;
	JNC	SHORT IDOK		;
;
IDERR:	MOV	DX,OFFSET UNKID 	;say unknown ID and return error
	STC				;
IDOK:	POP	DS			;
	RET				;
FINDID	ENDP

PAGE
;**************************************************************************
;
; VIDEO ROUTINES
;
;**************************************************************************

CLRCMD	PROC	NEAR
	MOV	DX,NODPOS	      ;
CLREOL	LABEL	NEAR
CLRCMD1:CALL	POSCUR			;
	MOV	AH,2			;
	CALL	CS:DWORD PTR [VIDEO]	;
	RET				;
CLRCMD	ENDP

;**************************************************************************

CLRWNDO PROC	NEAR
	MOV	DX,NODPOS		;
CLRAGN: CALL	SHORT CLRCMD1		;
	RET
CLRWNDO ENDP

;**************************************************************************

POSCUR	PROC	NEAR
	MOV	AH,3			;expects position to be in DX in
	CALL	CS:DWORD PTR [VIDEO]	;.the form (DH=ROW,DL=COLUMN)
	RET				;
POSCUR	ENDP

;**************************************************************************

PRNTSTR PROC	NEAR
	MOV	AH,09H			;MSDOS print string function
	INT	21H			;
	RET				;
PRNTSTR ENDP

;**************************************************************************

PRNTCLR PROC	NEAR			;Similure to DOS INT 21 function 9H
;					;...except that the characters are
;					;...printed in color.  The first byte
;					;...of the string contains the color.
;
	PUSH	AX			;Save the registers used
	PUSH	BX
	PUSH	CX
	PUSH	DI
	PUSH	SI
;
	CMP	SCREEN_TYPE,COLOR	;Is there a color screen
	JZ	DO_COLOR
	INC	DX			;Skip over the color byte
	CALL	PRNTSTR
	JMP	END_OF_STRING
;
DO_COLOR:
	MOV	AH,3			;Find the current cursor position
	XOR	BX,BX			;... for page 0
	PUSH	DX
	INT	10H
	MOV	WORD PTR ROWCOL,DX	;Save it.
	POP	DX
	MOV	SI,DX			;Point to the beginning of the string
	MOV	DI,DX			;...to print on the screen
	INC	DI
NXTCHR_TO_PRINT:
	CMP	BYTE PTR [DI],"$"       ;End of the string?
	JZ	END_OF_STRING		;Yes, then exit
	CMP	BYTE PTR [DI],CR	;Character = carriage return?
	JNZ	TRYLF			;No, then see if it's a line feed
	MOV	COL,-1			;Set the col to left edge of the screen
	INC	DI			;Point to the next character
	JMP	MOVCSR
TRYLF:	CMP	BYTE PTR [DI],LF	;Charcter = line feed?
	JNZ	TRYBS			;No, then see if it's a backspace char
	INC	ROW			;Put in the lf by advancing the row
	DEC	COL			;
	INC	DI			;Point to the next character
	JMP	MOVCSR
TRYBS:	CMP	BYTE PTR [DI],BACKSPC	;Character = backspace?
	JNZ	TRYBEL			;No, then see if it's a bell
	SUB	COL,2			;Put in the backspace
	INC	DI			;Point to the next character
	JMP	MOVCSR
TRYBEL: CMP	BYTE PTR [DI],BELL	;Character = bell?
	JNZ	NRML_CHR		;No, then process normal characters
	MOV	AX,0E07H		;Output the bell (AH=cmd, AL=bell)
	INT	10H
	INC	DI			;Point to the next character
	JMP	NXTCHR_TO_PRINT 	;Don't update the cursor position
NRML_CHR:
	MOV	AH,9
	MOV	BH,0
	MOV	CX,1
	MOV	AL,BYTE PTR [DI]	;Character to display
	MOV	BL,BYTE PTR [SI]	;Color of the character
	INT	10H
	INC	DI			;Point to the next character
;
MOVCSR: INC	COL			;Move the cursor one position to
	CMP	COL,80			;... the right.  If we are going past
	JNZ	MVCSR5			;... the right edge then wrap to col 1
	MOV	COL,0			;... and increment the row.  (if
	CMP	ROW,24			;... already at the bottom of the
	JZ	MVCSR5			;... screen then don't increment the
	INC	ROW			;... row)
MVCSR5: MOV	AH,2			;
	XOR	BX,BX
	MOV	DX,WORD PTR ROWCOL
	INT	10H
	JMP	NXTCHR_TO_PRINT
;
END_OF_STRING:
	POP	SI			;Restore all destroyed registers
	POP	DI
	POP	CX
	POP	BX
	POP	AX
	RET
PRNTCLR ENDP

PAGE
;**************************************************************************
;
; KEYBOARD ROUTINES
;
;**************************************************************************
;
;
;
;
;**************************************************************************
;
; BUFIN -	buffered input
;		requires a data space of the following form
;		BYTE1:	   # of chars wanted
;		BYTE2:	   # of chars typed
;		BYTE3 - N: buffer for chars, as least as big as BYTE 1
;
;		also requires a one byte flag %ECHO, 0 = echo character
;		also requires a one byte flag %NUMBER, 1 = numbers only
;
;		ON ENTRY - DX contains address of data space
;		ON EXIT  - carry set if ESCAPE	was typed or carriage
;			   return was first character typed; BYTE2 set
;			   to number of characters typed
;
;		All registers preserved; Uses routine 'GETKYB'
;
;**************************************************************************

BUFIN	PROC   NEAR
	PUSH	BX			;save regs used
	PUSH	DI			;
	PUSH	CX			;
	PUSH	AX			;
	PUSH	DX			;
	MOV	BX,DX			;address of data space
	MOV	DI,DX			;
	ADD	DI,2			;DI now points at buffer
	XOR	CX,CX			;clear count

BUFIN1: CALL	GETKYB			;get char from keyboard
	JC	SHORT ESCEXT		;carry set means ESCAPE
	CMP	AL,CR			;check for a carriage return,
	JE	SHORT GOTCR		;.backspace, control chars., etc.
	CMP	AL,BACKSPC		;
	JE	SHORT GOTBS		;
	CMP	AL,BLANK		;
	JL	SHORT BUFIN1		;
	CMP	CL,BYTE PTR [BX]	;see if we got all the characters
	JE	SHORT GOTALL		;.we want
;
;  Should we only allow numbers to be input?
;
	CMP	BYTE PTR %NUMBER,1	;allow numbers only?
	JNE	SHORT GETANY		;NO -- so continue
	CMP	AL,'0'                  ;is character between 0 and 9 ?
	JL	SHORT NUMERR
	CMP	AL,'9'
	JLE	SHORT GETANY
NUMERR: MOV	AL,BELL
	CALL	PRNT
	JMP	SHORT BUFIN1
GETANY: MOV	BYTE PTR [DI],AL	;save character
	INC	DI			;
	INC	CX			;
	CMP	BYTE PTR %ECHO,0	;check if we should echo the character
	JE	SHORT BUFIN2		;... if not print a dot
	MOV	AL,DOT			;
BUFIN2: CALL	PRNT			;display it
	JMP	SHORT BUFIN1		;get the next

GOTALL: MOV	AL,BELL 		;got all charcters we wanted so
	CALL	PRNT			;.bitch about any more
	JMP	SHORT BUFIN1		;

GOTBS:	JCXZ	SHORT BUFIN1		;if no chars yet ignore BS
	CALL	PRNT			;else back up cursor
	MOV	AL,BLANK		;blank out char
	CALL	PRNT			;
	MOV	AL,BACKSPC		;back up cursor again
	CALL	PRNT			;
	DEC	DI			;dec char count and buffer pointer
	DEC	CX			;
	MOV	AL,BLANK		;blank out char in buffer
	MOV	BYTE PTR [DI],AL	;
	JMP	SHORT BUFIN1		;go for more

ESCEXT: STC				;show ESCAPE
	MOV	BYTE PTR [BX+1],0	;no chars. returned
	JMP	SHORT BUFEXT		;
GOTCR:	JCXZ	SHORT ESCEXT		;if carriage return is first char
	CLC				;.return with carry set
	MOV	BYTE PTR [BX+1],CL	;
BUFEXT: POP	DX			;restore regs and return
	POP	AX			;
	POP	CX			;
	POP	DI			;
	POP	BX			;
	RET				;

;**************************************************************************

PRNT:	MOV	DL,AL			;
	MOV	AH,02			;
	INT	21H			;
	RET				;
BUFIN	ENDP

;**************************************************************************

GETKYB	PROC	NEAR
	MOV	AH,08H			;get character from keyboard
	JMP	GKCONT
GETKYBW LABEL	NEAR			;entry point to clear kybrd buffer 1st
	MOV	AX,0C08H		;
GKCONT: INT	21H			;
	CMP	AL,ESCAPE		;set carry and return if ESCAPE
	JE	SHORT GETK2		;
	CMP	AL,'a'                  ;
	JL	SHORT GETK1		;
	CMP	AL,'z'                  ;
	JG	SHORT GETK1		;
	SUB	AL,20H			;convert to upper case
GETK1:	CLC				;show that ESCAPE was pressed
	RET				;
GETK2:	STC				;
	RET				;
GETKYB	ENDP

;**************************************************************************

GETKYBR PROC	NEAR
	MOV	AH,01H			;see if character ready to read
	INT	16H			;
	JZ	SHORT GETK2R		;set carry and return if no char avail
	MOV	AH,0
	INT	16H
GETK1R: CLC				;
	RET				;
GETK2R: STC				;
	RET				;
GETKYBR ENDP

;**************************************************************************
;	RETURNS VALUE IN AL

GETDEC	PROC	NEAR
	PUSH	SI			;
	PUSH	BX			;
	PUSH	CX			;
	PUSH	DX			;
	MOV	BYTE PTR %ECHO,0	;echo characters
	MOV	BYTE PTR %MAXCHR,02	;two digits maximum
	MOV	DX,OFFSET %MAXCHR	;
	XOR	AX,AX			;return zero if no characters typed
	MOV	BYTE PTR %NUMBER,1	;tell BUFIN to allow only numbers
	CALL	BUFIN			;
	JC	SHORT GETDEC3		;
	XOR	CH,CH			;
	MOV	CL,BYTE PTR %CHRTYP	;loop for number of characters typed
	MOV	SI,OFFSET %INBUFF	;
GETDEC1:MOV	BL,BYTE PTR [SI]	;
	INC	SI			;
	SUB	BL,"0"                  ;
	JL	SHORT GETDEC4		;
	CMP	BL,9			;
	JG	SHORT GETDEC4		;
	CBW				;
	MOV	DX,10			;
	MUL	DX			;
	ADD	AX,BX			;
	LOOP	GETDEC1 		;

GETDEC3:POP	DX			;
	POP	CX			;
	POP	BX			;
	POP	SI			;
	RET				;

GETDEC4:STC				;show error
	JMP	SHORT GETDEC3		;
GETDEC	ENDP

PAGE
;**************************************************************************
;
; MISCELLANEOUS ROUTINES
;
;**************************************************************************
;
;
;
;
;**************************************************************************

SCRN	PROC	NEAR
	MOV	AH,1			;
	CALL	CS:DWORD PTR [VIDEO]	;
SCRN_NO_CLR	LABEL	NEAR		;entry point to display screen without
;					;... clearing the screen first
	MOV	DX,OFFSET BANNER	;get screen display
	CALL	PRNTCLR 		;show it
	MOV	DX,OFFSET LINE		;
	CALL	PRNTCLR 		;
	MOV	DX,OFFSET SRVRST	;
	CALL	PRNTCLR 		;
	CALL	SHOW_OD_STATUS		;
	CALL	SCRN1			;print a line
	MOV	DX,OFFSET MNSCRN
	CALL	PRNTCLR 		;
	MOV	DX,MENUPOS
	CALL	POSCUR
	CALL	SCRN1
	MOV	DX,OFFSET MENU		;
	CALL	PRNTCLR 		;
	RET
SCRN1:	MOV	DX,OFFSET LINE		;print line
	CALL	PRNTCLR 		;
	RET				;
SCRN	ENDP

;**************************************************************************

SHOW_OD_STATUS	PROC	NEAR
	MOV	CX,%ODLLEN
	MOV	DI,OFFSET ODLINE
	INC	DI			;Skip over the color byte
	MOV	AL,BLANK
	REP	STOSB			;init the line to blanks
	MOV	CX,1			;initialize counter
	MOV	SI,OFFSET %SRVTBL
	MOV	DI,OFFSET ODLINE
	ADD	DI,2			;Skip over the color byte
GETNXT:
	XOR	AH,AH
	MOV	AL,BYTE PTR [SI+NODENUM];get the node number
	CALL	CNVRT_SRVR		;convert decimal to ascii (0-64)
	MOV	[DI],AH 		;get tens digit
	INC	DI
	MOV	[DI],AL 		;get ones digit
;
	ADD	SI,ENTRYSZ		;point to next entry in %SRVTBL
	INC	CX
DONEYT: CMP	CX,WORD PTR %NUMOD	;have we done them all yet?
	JG	ADDLIN			;yes -- so lets get out of here
	INC	DI
	MOV	BYTE PTR [DI],","
	ADD	DI,2
	JMP	GETNXT			;no -- so do it again
ADDLIN:
;
;  Output the status line to the screen now
;
	MOV	DX,OFFSET ODLINE	;point to the output line again
	CALL	PRNTCLR 		;output the status line
	MOV	DX,OFFSET CRLF		;add a blank line
	CALL	PRNTSTR 		;
	RET
SHOW_OD_STATUS	ENDP
;
;
;
;************************************************************************
;*									*
;* procedure:	GET_STATUS						*
;*									*
;* input:	DX = node number					*
;*									*
;* output:	DH = Mate number					*
;*		DL = Drive type 					*
;*									*
;* updates:								*
;*									*
;* destroys:	BX, DL, SI						*
;*									*
;************************************************************************
;
GET_STATUS	PROC	NEAR

	PUSH	DS
	LDS	BX,DWORD PTR CORPTR	;get pointer to CORTAb
	MOV	SI,WORD PTR [BX+SHDO_OFST]  ;point to SHADOW_TBL ptr in CORDRV
	ROL	DX,1			;convert node number to table offset
	ADD	SI,DX			;
	MOV	DX,[SI] 		;get the drive type and mate number
	POP	DS
	RET

GET_STATUS	ENDP
;
;
;
;************************************************************************
;*									*
;* procedure:	CNVRT_SRVR						*
;*									*
;* input:	AX = Server number to convert to ASCII			*
;*									*
;* output:	AX = ASCII representation of server number.		*
;*		     AH = tens digit, AL = ones digit			*
;*									*
;* updates:								*
;*									*
;* destroys:	AX							*
;*									*
;************************************************************************
;
CNVRT_SRVR	PROC	NEAR
;
	PUSH	BX
	PUSH	CX
;
;  Convert the server number in AX to ASCII with AH holding the tens
;  digit and AL holding the ones digit.
;
	MOV	BX,3030H			; set up default to "00"
	CMP	AX,0				; do range testing on the srvr
	JLE	CS_END				; ... number to make sure it
	CMP	AX,63				; ... falls between 0-63.
	JG	CS_END
;
	MOV	CL,10				; divide the number by 10
	DIV	CL				; AL = quotient, AH = remainder
	XCHG	AH,AL				; put tens in AH, ones in AL
	XCHG	BX,AX				; put value in BX to work with
	ADD	BX,3030H			; convert tens and ones to ASCII
;
CS_END: MOV	AX,BX				; set up return value
	POP	CX
	POP	BX
	RET
;
CNVRT_SRVR	ENDP
;
;
;

PAGE
;**************************************************************************
;
;  Space to load the call table.  This table gets patched to "ROM" calls
;  See CORDRV "ROMJMPS" for more detail
;
LNKTAB	PROC	NEAR
;	JMP	FAR LABEL	;5 BYTES FOR FAR JUMP (DOES A RET)
	DB	5 DUP (?)
;	JMP	FAR LABEL	;5 BYTES FOR FAR JUMP (DOES A RET)
	DB	5 DUP (?)
;
CRVIO	LABEL	NEAR
;	JMP	FAR LABEL	;5 BYTES FOR FAR JUMP (DOES A RET)
	DB	5 DUP (?)
;
;	JMP	FAR LABEL	;5 BYTES FOR FAR JUMP (DOES AN IRET)
	DB	5 DUP (?)
LNKTAB	ENDP

CSEG	ENDS
	END	START
