{~_*}
{~(	}
{ Program~% : SPOOLER ~%	}
{~(	}
{ Author~& : DVH~&	}
{~(	}
{ Date	~& : Sep 12, 1983~%	}
{~(	}
{ Purpose~% : This program is intended to illustrate the use	}
{		of PIPES under MSDOS for IBM PERSONAL COMPUTER. }
{		It sends a file (selected by the user) to a	}
{		pipe.  The file is either formatted (i.e.	}
{		converted to the standard print format) by the	}
{		spooler, or it is left unformatted, depending	}
{		on what the user has specified.  Conversion to	}
{		the standard print format is handled by using	}
{		the Pascal READLN procedure, which automatical- }
{		ly expands the Tab characters found in TEXT	}
{		files.~&	}
{~'		}
{ Preprocessor keys: for MSDOS Pascal~$	}
{~#IMS~%	}
{~#I+ any debugging keys~#I}
{~(	}
{		~% for CP/M-80 MT/Pascal~#I}
{~#IMT~%	}
{~#IM0~%	}
{~#I+ any debugging keys~#I}
{~(	}
{		~% for CP/M-86 MT/Pascal~#I}
{~#IMT~%	}
{~#IM6~%	}
{~#I+ any debugging keys~#I}
{~(	}
{ Library used: for MSDOS Pascal~$	}
{		~ DRVIOC2~%	}
{~(	}
{		for CP/M-80 MT/Pascal~$	}
{		~ CPMFUNC.PAS~%	}
{		~ CPMIO.ASM~%	}
{		~ KEYIN.ASM~%	}
{		~ BLAZEIO.ERL~%	}
{		~ DSKLIB.ERL~%	}
{		~ STDLIB-F.ERL ~$	}
{		~ PASLIB.ERL~%	}
{~(	}
{	~' for CP/M-86 MT/Pascal~$	}
{		   CPMFUNC.PAS~%	}
{		~ CPMIO86.A86~%	}
{		~ KEYIN.A86~%	}
{		~ PASLIB.R86~%	}
{~(	}
{ Revision History :~#I~#I}
{	 1.0  : ~&	}
{		CORVUS preliminary release~#I}
{	 1.1  : 10 Sep 1982~$ Dibinh Ho~#I}
{		Beta sites release~$	}
{	 1.1a : 06 Oct 1982~$ Dibinh Ho~#I}
{		Use a new driver which is written in machine	}
{		language communicating with flat cable only.	}
{	 2.0  : 10 May 1983~$ DSO~$	}
{		Use a new drive I/O support module (DRVIOC2)	}
{		which handles both flatcable and Omninet, so	}
{		only one version of SPOOL is necessary.  This	}
{		new module supercedes DRIVEIO1 and ODRVIO.	}
{	 2.1  : 26 Apr 1983~$ Dibinh Ho~#I}
{		Change get pipe status to get the name table	}
{		first, then the pointer table because the new	}
{		driver does not support 1K read anymore.	}
{	 2.2  : 30 Jun 1983~$ Dibinh Ho~#I}
{		Port to CP/M-80 and fix display pipes bug.	}
{	 2.3  : 14 Jul 1983~$ Dibinh Ho~#I}
{		Port to CP/M-86.~$	}
{	 2.4  : 24 Aug 198383  Dibinh Ho~#I}
{		Fix display pipes bug on IBM version		}
{	 2.4a : 08 Dec 1983~$ BC~$	}
{		Corrected line truncation in PUTXTP and added	}
{		a selection to strip off every high bit of each }
{		char.~&	}
{	 2.4b : 	~' Dibinh Ho~#I}
{		Bug fix number of lines per page reset. 	}
{	 2.5  : 12 Sep 1983~$ Dibinh Ho~#I}
{		Cosmetic.~%	}
{	 2.6  : 17 Oct 1983~$ Dibinh Ho~#I}
{		<ESC> as input to next file name to spool exits }
{		spool menu.~%	}
{	 2.6a : 02 Nov 1983~$ Dibinh Ho~#I}
{		Prints the filename if open file error. 	}
{	 2.7  : 10 Jan 1984~$ Dibinh Ho~#I}
{		Bug fix in CPMIO.MAC (CP/M-80)~#I}
{	 2.7a : 22 Mar 1984~$ Dibinh Ho~#I}
{		Bug fix in CLOSEPIPE routine.  The spool prog.	}
{		sent an extra char. at the end of the file.	}
{	 2.7b : 28 Mar 1984~$ Dibinh Ho~#I}
{		Bug refix in PUTUNFP (re-introduced by W. Kline }
{		sysgening the SERVER1 Network's drive DRIVE1 !) }
{		20 heartbeat dots per line only.		}
{	 2.7c : 05 Apr 1984~$ Dibinh Ho~#I}
{		Screen changes for Apple CP/M which has 40	}
{		column screen.~%	}
{~(	}
{	 3.0  : 17 Apr 1984~$ Dibinh Ho~#I}
{		Spool to server # 0 only ~!~#I}
{		Because the printer server despool from server	}
{		# 0 only.~%	}
{		In case the driver is not found, the version #	}
{		is also printed before the program aborts.	}
{	 3.1  : 15 Aug 1984	Norman O. Doyle 		}
{		Changed to use assembly language functions	}
{		PipeOpWr~ - to open a pipe for write access	}
{		PipeWrite  - write to a pipe~#I}
{		PipeClWr~ - close a pipe opened for write	}
{		PipePurge  - purge a file from the pipe 	}
{		PipeStatus - obtain the status of a pipe	}
{~(	}
{~_*}

(*P*)
{!MS} (*TITTLE:'SPOOLER program for MSDOS 1.1 IBM PERSONAL COMPUTER'*)
{!MS}  (*$LINESIZE:132*)
{!MS}  (*$DEBUG-*)
{!MS}  program SPOOLER (input,output);


~' const

{!MS}  debug	  = false;
{!MS}  debug1	  = true;
{!MS}
~' version	  = '[3.1]';

~' sno	  = 0;	~' { always spool to server # 0 only ~! }

~' longstrmax = 536;
~' maxline	  = 253;~' { max # of char in line }
~' PipeTblLen = 64;

~' txt	  = 0;	~' { text }
~' data	  = 1;	~' { data }

~' beep	  = 7;	~' { beep }
~' ht	  = 9;	~' { horizontal tab }
~' lf	  = 10;~( { linefeed }
~' ff	  = 12;~( { formfeed }
~' cr	  = 13;~( { carriage return }
~' esc	  = 27;~( { escape }

~' NoErr	  = 0;	~' { No error }

~' { pipe error return codes ~. }
~' { Pipe errors returned by CDRECV are positive but are }
~' { negative here to be compatible with the way PIPEORD }
~' { is implemented on other systems.		~% }
~' PEmpty	  = -8;~( { tried to read an empty pipe	~' }
~' PNotOpen~ = -9;~( { pipe was not open for read or write~ }
~' PFull	  = -10;~' { tried to write to a full pipe	~' }
~' POpErr	  = -11;~' { tried to open (for read) an open pipe }
~' PNotThere  = -12;~' { pipe does not exist		~' }
~' PNoRoom	  = -13;~' { the pipe data structures are full, ~.}
~#I~' { ~. and there is no room for ~.~& }
~#I~' { ~. new pipes at the moment ~.~' }
~' PBadCmd	  = -14;~' { illegal command		~' }
~' PsNotInitted= -15;~& { pipes not initialized		~' }
~' { an error code less than -127 is a fatal disk error }

~& type

	kludge = (kludge1,kludge2,kludge3,kludge4);

	longstr = RECORD
	  len : INTEGER;
	  CASE kludge OF
	~$ kludge1 : ( str : PACKED ARRAY[1..longstrmax] OF CHAR);
	~$ kludge2 : ( int : PACKED ARRAY[1..longstrmax] OF byte);
	  END;

	name~ = packed array [1..8] of char;
	nmtbl  = packed array [1..PipeTblLen] of name;
	ptr~$ = packed array [1..8] of char;
	ptrtbl = packed array [1..PipeTblLen] of ptr;

	diskbuf = packed array [0..511] OF byte;

~& var

	ch	~& : char;
	pipenumber~$ : integer;~& { pipe # }
	pipeindex~% : integer;~& { index into pipe data buffer }
	blockwritten  : integer;~& { # of blocks written }
	ftype	~& : integer;~& { file type }
	lnperpage~% : integer; ~% { max. # of lines per page }
	lncount~' : integer;~& { line count }
	HTsize	~& : integer;~& { horizontal tab size }
	dotcnt	~& : integer;~& { hearbeat dot count }
	FFenabled~% : boolean;~& { form feed switch }
	INenabled  ~ : boolean;~& { include switch }
{!MS}	strip	~& : boolean;~& { strip high bit of char flag }
	xit	~& : boolean; ~% { exit condition for spooler }
	buf	~& : diskbuf;~& { pipe buffer }
	res	~' : integer;	  { pipe op result }
{!MS}	msg	~& : lstring(80);
{!MS}	pipename~& : lstring(80);
{!MS}	filename~& : lstring(80);
{!MS}	formfeedstr~ : lstring(80);
{!MS}	includestr~$ : lstring(80);
{!MS}	HTposn	~& : 0..133-1;


{!MS}	terminalin~$ : file of char; {terminal/binary mode for menu}

	nametbl~' : nmtbl;
	pointertbl~$ : ptrtbl;

{!MS}	function INITIO : integer; EXTERN;
{!MS}	function SETSRVR ( srvr : integer) : integer; extern;
{!MS}	procedure CDSEND (var st : longstr); EXTERN;
{!MS}	procedure CDRECV (var st : longstr); EXTERN;
	function PipeOpWr( var name: lstring ): INTEGER; EXTERN;
	function PipeWrite(pn: INTEGER; Len: INTEGER; var Info: Diskbuf ):
	~' INTEGER; EXTERN;
	function PipeClWr( pn: INTEGER): INTEGER; EXTERN;
	function PipePurge(pn: INTEGER): INTEGER; EXTERN;
	function PipeStatus( var Name: NmTbl; var Ptrs: PtrTbl ):
	~' INTEGER; EXTERN;


{!MS}  (*P*)
{!MS}  {~_-}
{!MS}  {~'	~' }
{!MS}  { Name	~' : INKEY~%	~' }
{!MS}  {~'	~' }
{!MS}  { Input	~' : None~%	~' }
{!MS}  {~'	~' }
{!MS}  { Output~( : a character~$	~' }
{!MS}  {~'	~' }
{!MS}  { Description~ : Waits for a key pressed at the keyboard and~ }
{!MS}  {		 returns that key. If the key is a lower case  }
{!MS}  {		 character, it is converted to upper case.~% }
{!MS}  {~'	~' }
{!MS}  {~_-}
{!MS}
{!MS}  function INKEY: char;
{!MS}
{!MS}  begin { INKEY }
{!MS}
{!MS}  repeat
{!MS}	GET(terminalin);
{!MS}  until (terminalin^ <> CHR(0));
{!MS}  if (terminalin^ in ['a'..'z']) then {converts to upper case}
{!MS}	 INKEY := CHR (ORD (terminalin^) - 32)
{!MS}  else
{!MS}	 INKEY := terminalin^;
{!MS}
{!MS} end; { INKEY }

(*P*)
{~_-}
{~(	}
{ Name		: PERROR~%	}
{~(	}
{ Input 	: Error number. ~$	}
{~(	}
{ Output	: None~&	}
{~(	}
{ Description	: Prints the appropriate error message on screen}
{~(	}
{~P-~/-}

procedure PERROR (enum : INTEGER);

begin { PERROR }

~% WRITELN;
~% WRITELN (CHR(beep), '~* Pipe error : ', enum:1, ' ~*');

~% case enum of
~' PEmpty	~ : WRITELN ('Tried to read an empty pipe');

~' PNotOpen~$ : WRITELN ('Pipe not open');

~' PFull	~ : WRITELN ('Pipe full');

~' POpErr	~ : WRITELN ('Tried to open a pipe which was already open');

~' PNotThere~ : WRITELN ('Pipe does not exist');

~' PNoRoom	~ : WRITELN ('Not enough room to open a new pipe');

~' PsNotInitted: WRITELN ('Pipes area has not been initialized');

{!MS}  otherwise~% WRITELN ('Unknown error');

~% end; { case }

end; { PERROR }

(*P*)
{~T-~+-}
{~(	}
{ Name		: WRITEONEBLOCK ~$	}
{~(	}
{ Input 	: None~&	}
{~(	}
{ Output	: true/false		~#I}
{~(	}
{ Description	: Write 1 512-byte block of data to pipe	}
{~(	}
{~G-~8-}

function WRITEONEBLOCK : boolean;

var
  count : integer;

begin { WRITEONEBLOCK }

~' res := PipeWrite( pipenumber, 512, buf );

~' { process result }
~' if res < 0 THEN
	 begin { error }
	~ WRITELN;
	~ WRITELN ('Pipe write failure', CHR(beep));
	~ WRITELN ('pipe ',pipenumber:1,' named : ',pipename);
	~ PERROR( res );
	 end
~' else
	 begin	{ everything OK }
	~ WRITEONEBLOCK := true;
	~ pipeindex := 0;
	 end;

end;  { WRITEONEBLOCK }

(*P*)
{~_-}
{~(	}
{ Name		: WRITEPIPE~%	}
{~(	}
{ Input 	: One byte~%	}
{~(	}
{ Output	: true/false~%	}
{~(	}
{ Description	: Write 1 byte to buffer that will be written	}
{		  to pipe. If buffer is full, then write buffer }
{		  out.~&	}
{~(	}
{~<-~C-}

function WRITEPIPE(onebyte : byte) : boolean;

var
  count2 : integer;

begin { WRITEPIPE }

~' WRITEPIPE := true;
~' pipeindex := pipeindex + 1;
~' HTposn := (HTposn+1) MOD HTsize;
{!MS}  if strip then onebyte := onebyte AND 127;
~' buf[pipeindex-1] := onebyte;
~' if pipeindex = 512 then begin { flush buffer }

{!MS}	 {$IF debug $THEN}
{!MS}	~ WRITE ('  data:');
{!MS}	~ for count2 := 1 to 512 do
{!MS}	~% WRITE (buf[count2-1]);
{!MS}	~ WRITE;
{!MS}	 {$END}

	 if WRITEONEBLOCK then begin
	~% if ((dotcnt MOD 20) = 0) then WRITELN;
	~% WRITE ('.');
	~% dotcnt := dotcnt + 1;
	~% blockwritten := blockwritten + 1;
	~% end
	 else
	~ WRITEPIPE := false;
~' end;

end;  {procedure WRITEPIPE}

(*P*)
{~_-}
{~(	}
{ Name		: OPENPIPE~%	}
{~(	}
{ Input 	: None~&	}
{~(	}
{ Output	: true/false~%	}
{~(	}
{ Description	: Send a pipeopen command to disk		}
{~(	}
{~_-}

function OPENPIPE : boolean;

var
  count : integer;

begin { OPENPIPE }

	pipenumber := PipeOpWr( pipename );

	{ process result }
	if pipenumber <= 0 THEN
	  begin
	~$ WRITE('Pipe open failure', CHR(beep));
	~$ WRITELN ('pipe ',pipenumber:1,' named : ',pipename);
	~$ PERROR( pipenumber );
	~$ OPENPIPE := false;
	  end
	else { pipeopen ok }
	  begin
	~$ OPENPIPE := true;
	  end;

end; { OPENPIPE }

(*P*)
{~_-}
{~(	}
{ Name		: CLOSEPIPE~%	}
{~(	}
{ Input 	: None~&	}
{~(	}
{ Output	: true/false~%	}
{~(	}
{ Description	: Write the last block out to pipe if there is	}
{		  data and send a pipe close command.		}
{~(	}
{~9-~F-}

function CLOSEPIPE : boolean;

var
~& count : integer;

begin { CLOSEPIPE }

~' if pipeindex > 0 then {flush buf}
~' begin
{!MS}	 for pipeindex := (pipeindex+1) to 512 do
{!MS}	~ buf[pipeindex-1] := 0;

	 if WRITEONEBLOCK then
	 begin
	~ WRITE('.'); {write 512 bytes to pipe}
	~ blockwritten := blockwritten + 1;
	 end;
~' end;

	res := PipeClWr( pipenumber );

~' CLOSEPIPE := true;

~' { process result }
~' if res < 0 THEN
~' begin
	 WRITE('Pipe close failure');
	 WRITELN ('pipe ',pipenumber:1,' named : ',pipename);
	~ PERROR (res);
	 CLOSEPIPE := false;
~' end;

end;  { CLOSEPIPE }

(*P*)
{~V-~)-}
{~(	}
{ Name		: PURGEPIPE~%	}
{~(	}
{ Input 	: pipenumber~%	}
{~(	}
{ Output	: None~&	}
{~(	}
{ Description	: Purge a pipe~%	}
{~(	}
{~_-}

procedure PURGEPIPE (pipenumber : INTEGER );

begin { PURGEPIPE }

	res := PipePurge( pipenumber );
	if res < 0 then
	begin
	  WRITE('Pipe purge failure');
	  WRITELN ('pipe ',pipenumber:1,' named : ',pipename);
	~$ PERROR (res);
	end;

end; { PURGEPIPE }

(*P*)
{~_-}
{~(	}
{ Name		: PRINTPARMS~%	}
{~(	}
{ Input 	: None~&	}
{~(	}
{ Output	: None~&	}
{~(	}
{ Description	: Print all necessary parameters.		}
{~(	}
{~_-}

~& procedure PRINTPARMS;

~%  begin { PRINTPARMS }

~& WRITELN;
~& WRITELN ('Corvus Spool Utility Version ', version);
~& WRITELN ('Change Spool Parameters');
~& WRITELN ('~G-');
~& WRITELN ('~ P - Pipe name~' : ', pipename);
~& WRITELN ('~ L - Lines per page  : ', lnperpage:1);
~& WRITELN ('~ C - Chaining symbol : ', includestr);
~& WRITELN ('~ N - New page symbol : ', formfeedstr);
~& WRITELN ('~ T - Tab length~& : ', HTsize:1);
{!MS} WRITELN ('~ S - Strip high bit  : ', strip);
~& WRITE~ ('~ F - File type~' : ');
~& if (ftype = txt) then
	WRITELN ('TEXT')
 ~% else
	WRITELN ('DATA');
~& WRITELN ('~ E - Exit to Main Menu');
~& WRITELN ('~D-~-');

~& end; { PRINTPARMS }

(*P*)
{~_-}
{~(	}
{ Name		: CHANGEPARMS~%	}
{~(	}
{ Input 	: None~&	}
{~(	}
{ Output	: None~&	}
{~(	}
{ Description	: Query for all necessary parameters.		}
{~(	}
{~_-}

procedure CHANGEPARMS;

var
	valid	  : boolean;
	xit	  : boolean;
	oldboolff : boolean;
	oldboolin : boolean;
{!MS}	temp  : lstring(80);
{!MS}	oldpn : lstring(80);
{!MS}	oldin : lstring(80);
{!MS}	oldff : lstring(80);
	oldln : integer;
	oldtb : integer;
	oldft : integer;
	count : integer;
	dno~ : integer; { network device # }
	rc~$ : integer; { result }

begin { CHANGEPARMS }

~& xit := false;

~& repeat
	PRINTPARMS;

	{ changing options }
	WRITE ('Please select an option: ');
	repeat
	  ch := INKEY;
{!MS}	  if (ch in ['P','L','C','N','T','F','E','S','U',CHR(esc)]) then
	~$ WRITELN (ch)
	  else
	~$ WRITE (CHR(beep));
{!MS}	until (ch in ['P','L','C','N','T','F','E','S','U',CHR(esc)]);

{!MS}	case ch of
{!MS}	'U': begin { change server #. THIS IS A HIDDEN OPTION ~! }
		WRITE ('Device # : ');
		READ (dno);
		rc := SETSRVR (dno);
	~% end;

{!MS}	'P': begin { pipe name }
	~' oldpn := pipename;
	~' WRITE ('Pipe name (up to 8 characters): ');
	~' READLN (pipename);
{!MS}	~' if (pipename.len = 0) then
		~ pipename := oldpn
	~' else
		 begin { build pipename }
{!MS}		   for count := 1 to ORD(pipename.len) do
{!MS}		~% if pipename[count] in ['a'..'z'] then
{!MS}		~' pipename[count] := CHR (ORD (pipename[count]) - 32);
{!MS}		~ if pipename.len > 8 then
{!MS}		~% DELETE (pipename, 9, ORD(pipename.len)-8);
{!MS}		~ while pipename.len < 8 do
{!MS}		~% CONCAT (pipename, ' ');
		 end;
	~% end; { pipe name }

{!MS}	'L': begin { lines/page }
	~' oldln := lnperpage;
	~' repeat
		 WRITE ('Lines/page : ');
		 READLN (temp);
		 valid := true;

{!MS}		 if (temp.len > 0) then
		~ begin
		~% valid := DECODE (temp, lnperpage);
		~% if valid then begin
		~' if (lnperpage < 0) then
~#I WRITELN
~#I ('Value must be >= 0 and <= 32767',
~&	 CHR (beep));
		~% end
		~& else
		~&  WRITELN ('Invalid number', CHR (beep));
		~ end
		 else
		~ lnperpage := oldln;
	~' until valid and (lnperpage >= 0);
	~% end; { lines/page }

{!MS}	'C': begin { chaining symbol }
	~' oldboolin := INenabled;
	~' oldin := includestr;
	~' WRITE ('Chaining symbol : ');
	~' READLN (includestr);
{!MS}	~' if (includestr.len = 0) then
		 begin
		~ INenabled := oldboolin;
		~ includestr := oldin;
		 end
	~' else
		 if (includestr[1] = ' ') then
		~ INenabled := false;
	~% end; { include file }

{!MS}	'N': begin { Form feed }
	~' oldff := formfeedstr;
	~' oldboolff := FFenabled;
	~' WRITE ('New page symbol : ');
	~' READLN (formfeedstr);
{!MS}	~' if (formfeedstr.len = 0) then
		 begin
		~ FFenabled := oldboolff;
		~ formfeedstr := oldff;
		 end
	~' else
		 if (formfeedstr[1] = ' ') then
		~ FFenabled := false;
	~% end; { form feed }
{!MS}
{!MS}	'S': strip := not strip;

{!MS}	'T': begin { Tab size }
	~' oldtb := HTsize;
	~' repeat
		 WRITE ('Tab Length : ');
		 READLN (temp);
		 valid := true;
{!MS}		 if (temp.len > 0) then begin
		~ valid := DECODE (temp, HTsize);
		~ if valid then begin
		~% if (HTsize < 1) or (HTsize > 133) then
~#I WRITELN ('Must be >=1 and <=133',
~&	CHR(beep));
		~ end
		~ else
		~% WRITELN ('Invalid number',CHR(beep));
		 end
		 else
		~$ HTsize := oldtb;
	~' until valid and (HTsize >= 1) and (HTsize <= 133);
	~% end;

{!MS}	'F': begin { file type }
	~' oldft := ftype;
	~' WRITE ('Text, Data : ');
	~' repeat
		 ch := INKEY;
		 if (ch in ['T','D',CHR(cr)]) then
		~ WRITELN (ch)
		 else
		~ WRITE (CHR(beep));
	~' until (ch in ['T','D',CHR(cr)]);

{!MS}	~' case ch of
{!MS}		 'D': ftype := data;
{!MS}		 'T': ftype := txt;
{!MS}		 CHR(cr): ftype := oldft;
{!MS}	~' end; {case}
	~% end;

{!MS}	'E',CHR (esc) : xit := true;

{!MS}	end; { case }

~& until xit;

~& ch := CHR(0);

end; { CHANGEPARMS }

(*P*)
{~_-}
{~(	}
{ Name		: PREAMBLE~%	}
{~(	}
{ Input 	: None~&	}
{~(	}
{ Output	: true/false~%	}
{~(	}
{ Description	: A preamble block is generated prior to	}
{		  spooling which passes information to the	}
{		  despooling procedure. ~#I}
{		  The format of the preamble block is:		}
{		  block[1] -	~ operating system type (not	}
{~$	~ used right now.)		}
{		  block[2] -	~ length of filename (up to 80 }
{~$	~ characters)~#I}
{		  block[3-82] -~$ filename (string of ASCII	}
{~$	~ characters)~#I}
{		  block[83] -	   length of message (up to 80	}
{~$	~ characters)~#I}
{		  block[84-163] -  mesage (a string of ASCII	}
{~$	~ characters)			}
{		  block[164] -	~ filetype ('0': printable,~$ }
{~%	~% '1': nonprintable.)}
{		  block[165-512] - not used~#I}
{~(	}
{~_-}

function PREAMBLE : boolean;

var
  count : integer;

begin { PREAMBLE }

	{ clr buf }
	for count := 1 to 512 do
	  buf[count-1] := 0;

	{ message }
{!MS}	buf[82] := msg.len;
	{put msg in buf}
{!MS}	for count := 1 to ORD(msg.len) do
	  buf[count+82] := WRD(msg[count]);

	{ filename }
	{ put filename in buffer }
{!MS}	buf[1] := filename.len;
{!MS}	for count := 1 to ORD(filename.len) do
	~ buf[count+1] := WRD(filename[count]);

	{ file type :'0' if formatted, else '1'}
	if (ftype = data) then
	  buf[163] := ORD('1')
	else
	  buf[163] := ORD('0');

	PREAMBLE := true;
	HTposn := 0;
	if not (WRITEONEBLOCK) then
	  PREAMBLE := false;

end; { PREAMBLE }


(*P*)
{~_-}
{~(	}
{ Name		: PUTUNFP~%	}
{~(	}
{ Input 	: filename~%	}
{~(	}
{ Output	: true/false~%	}
{~(	}
{ Description	: Reads from nontext input file and writes to	}
{		  pipe, 1 byte at a time.~#I}
{~(	}
{~_-}

{!MS}  function PUTUNFP (var filename : lstring) : boolean;

var
~' datafile : file of byte;

begin { PUTUNFP }

{!MS}	{$IF debug $THEN}
{!MS}	  WRITELN ( 'Filename: ', filename);
{!MS}	{$END}

{!MS}	datafile.trap := true;
{!MS}	datafile.errs := NoErr;
	ASSIGN(datafile,filename);
	RESET(datafile);
{!MS}	if datafile.errs <> noerr then
	begin
	  WRITELN;
	  WRITELN ('Error opening input file ',filename);
{!MS}	  WRITELN ('Return code = ',datafile.errs);
{!MS}	  RETURN;
	end;

{!MS}	datafile.trap := true;
	PUTUNFP := true;

{!MS}	while not EOF(datafile) do
	begin {process datafile^}

{!MS}	{$IF debug $THEN}
{!MS}	~$ WRITE (CHR(datafile^));
{!MS}	{$END}
{!MS}
	~ if (WRITEPIPE(datafile^)) then
	~& begin
		 GET(datafile);
{!MS}		 if (datafile.errs <> noerr) then begin
{!MS}		~ PUTUNFP := false;
{!MS}		~ RETURN; { error }
{!MS}		~ end;
	~& end
	~ else
	~& begin
		PUTUNFP := false;
{!MS}		RETURN; { ERROR }
	~& end;

	end;  {process datafile^}

{!MS}	CLOSE (datafile);

end; { PUTUNFP }

(*P*)
{~_-}
{~%	~#I}
{ Name		: PUTXTP~%	}
{~(	}
{ Input 	: filename~%	}
{~(	}
{ Output	: true/false~%	}
{~(	}
{ Description	: Putting text file to pipe~#I}
{~(	}
{~_-}

{!MS}  function PUTXTP (var filename : lstring) : boolean;

var
~' textfile : text;
{!MS}  lnbuf	: lstring(maxline);
{!MS}  fname	: lstring(80);
~' i	: integer;
~' ln	: integer;

(*P*)
{~V-~)-}
{~(	}
{ Name		: GETFNAME~%	}
{~(	}
{ Input 	: pos~&	}
{~(	}
{ Output	: none~&	}
{~&			}
{ Description	: assemble of the file to be included.		}
{~(	}
{~U-~*-}

function GETFNAME (pos : integer) : boolean;

var
~' fnstart	: integer;
~' i	: byte;
~' tempfile : file of byte;

begin { GETFNAME }

{!MS}	{$IF debug $THEN}
{!MS}	  WRITELN ( 'L: ', ORD(80-pos));
{!MS}	  WRITELN ( 'S: ', lnbuf);
{!MS}	  WRITELN ( 'I: ', ORD (pos+1));
{!MS}	{$END}

	GETFNAME := true;
	fnstart := SCANNE (ORD (maxline-pos), ' ', lnbuf, ORD(pos+1));

{!MS}	{$IF debug $THEN}
{!MS}	  WRITELN ('fnstart: ', fnstart);
{!MS}	 {$END}

	fnstart := fnstart + ORD (pos) + 1;

{!MS}	if (fnstart <= ORD(lnbuf.len)) then
	begin

{!MS}	~ {$IF debug $THEN}
{!MS}	~% WRITELN ('(GETFNAME) lnbuf.len: ', lnbuf.len);
{!MS}	~% WRITELN ('lnbuf: ', lnbuf);
{!MS}	~ {$END}

	~ i := 1;
	~ repeat

{!MS}	 ~$ {$IF debug $THEN}
{!MS}	~' WRITELN ('fnstart: ', fnstart);
{!MS}	~' WRITELN ('i: ', i);
{!MS}	~' WRITELN ('lnbuf[fnstart]: ', lnbuf[fnstart]);
{!MS}	~% {$END}

	~% fname[i] := lnbuf[fnstart];
	~% i := i + 1;
	~% fnstart := fnstart + 1;

{!MS}	~ until (fnstart > ORD (lnbuf.len)) or
		 (i > 80) or
		 (lnbuf[fnstart] = ' ') or
		 (ORD (lnbuf[fnstart]) = cr) or
		 (ORD (lnbuf[fnstart]) = ht) or
		 (ORD (lnbuf[fnstart]) = 26); { Got the filename ! }

	~ { Is INCLUDE file there ? }
{!MS}	~ fname.len := i-1;
{!MS}	~ tempfile.trap := true;
{!MS}	~ tempfile.errs := NoErr;
	~ ASSIGN(tempfile,fname);
	~ RESET(tempfile);
{!MS}	~ if tempfile.errs <> 0 then
	~% begin
	~' WRITELN (CHR(beep));
	~' WRITELN ('Error opening INCLUDE file ', fname);
{!MS}	~' WRITELN ('Return code = ',tempfile.errs:2);
	~' GETFNAME := false;
	 ~$ end
	~ else
{!MS}	~& CLOSE (tempfile);
	end
	else
	begin
	  WRITELN ('No chaining file name found !', CHR(beep));
	  GETFNAME := false;
	end;

{!MS}	{$IF debug $THEN}
{!MS}	  WRITELN ( 'filename found: ',fname);
{!MS}	{$END}

end;

(*P*)
begin { PUTXTP }

	PUTXTP := true;

{!MS}	if (filename.len = 0) then
	begin
	  PUTXTP := false;
{!MS}	  RETURN;
	end;

{!MS}	{$IF debug $THEN}
{!MS}	  WRITELN ( 'Filename: ', filename);
{!MS}	{$END}

{!MS}	textfile.trap := true;
{!MS}	textfile.errs := NoErr;
	ASSIGN(textfile,filename);
	RESET(textfile);
{!MS}	if (textfile.errs <> noerr) then
	begin
	  WRITELN (CHR(beep));
	  WRITELN ('Error opening file', filename);
{!MS}	  WRITELN ('Return code = ',textfile.errs:2);
	  PUTXTP := false;
{!MS}	  RETURN;
	end;

{!MS}	textfile.trap := true;

	{ process 1 line }
	while not EOF(textfile) do
	begin

	  READLN (textfile, lnbuf);
{!MS}	  if (textfile.errs <> NoErr) then
	  begin
{!MS}	~$ WRITELN ('File ', filename, ' read error ', textfile.errs, CHR(beep));
	~$ PUTXTP := false;
{!MS}	~$ RETURN;
	  end;

{!MS}	  ln := ORD(lnbuf.len);

{!MS}	  {$IF debug $THEN}
{!MS}	~$ WRITELN ( 'lnbuf.len: ', lnbuf.len);
{!MS}	~$ WRITELN (lnbuf);
{!MS}	  {$END}

	  { check for form feed }
	  if FFenabled then
{!MS}	~$ {$IF debug $THEN}
{!MS}	~' WRITELN ( 'Form feed string: ', formfeedstr);
{!MS}	~$ {$END}
	~$ if (POSITN (formfeedstr, lnbuf, 1) = 1) then begin
		if not (WRITEPIPE (ff)) then begin
		~$ PUTXTP := false;
{!MS}		~$ RETURN;
		~$ end;
		if not (WRITEPIPE (cr)) then begin
		~$ PUTXTP := false;
{!MS}		~$ RETURN;
		~$ end;
		if not (WRITEPIPE (lf)) then begin
		~$ PUTXTP := false;
{!MS}		~$ RETURN;
		~$ end;
		lncount := 0; { reset # of lines on this page (280384) }
{!MS}		CYCLE;
	~& end;

	  { check for include }
	  if INenabled then
	~$ if (POSITN (includestr, lnbuf, 1) = 1) then
	~$ begin
{!MS}	~& if (GETFNAME (ORD(includestr.len~) then
	~& begin
		 if (PUTXTP (fname)) then
{!MS}		~ CYCLE
		 else
		 begin
		~ PUTXTP := false;
{!MS}		~ RETURN;
		 end;
	~& end
	~& else
	  ~$ begin
		PUTXTP := false;
{!MS}		RETURN;
	~& end;
	~$ end;

	  { regular line }
	  for i := 1 to ln do
	~$ if lnbuf[i] = CHR (ht) then { Horizontal Tab }
	~& repeat
{!MS}		if not (WRITEPIPE (WRD(' '~) then
		begin
		~ PUTXTP := false;
{!MS}		~ RETURN;
		end;
	~& until HTposn = 0

	~$ else if lnbuf[i] = CHR (ff) then { form feed }
	~& begin
		if not (WRITEPIPE (ff)) then begin
		~$ PUTXTP := false;
{!MS}		~$ RETURN;
		~$ end;
		if not (WRITEPIPE (cr)) then begin
		~$ PUTXTP := false;
{!MS}		~$ RETURN;
		~$ end;
		if not (WRITEPIPE (lf)) then begin
		~$ PUTXTP := false;
{!MS}		 ~ RETURN;
		~$ end;
		lncount := 0; { reset # of lines on this page (280384) }
{!MS}		CYCLE;
	~& end
	~$ else { non-HT and non-FF }
{!MS}	~& if not (WRITEPIPE (WRD (lnbuf[i]~) then
	~& begin
		PUTXTP := false;
{!MS}		RETURN;
	~& end;

	  { carriage return }
	  if not (WRITEPIPE (cr)) then
	  begin
	~$ PUTXTP := false;
{!MS}	~$ RETURN;
	  end;

	  { line feed }
	  if not (WRITEPIPE (lf)) then
	  begin
	~$ PUTXTP := false;
{!MS}	~$ RETURN;
	  end;

	  HTposn := 0;	~& { reset tab }

	  { check line count and output form feed if needed }
	  lncount := lncount + 1;
	  if (lncount = lnperpage) then
	  begin
	~$ if not (WRITEPIPE (ff)) then
	~& begin
		PUTXTP := false;
{!MS}		RETURN;
	~& end
	~$ else
	~& lncount := 0;
	~$ HTposn := 0;
	  end;

	end;  { while loop : process 1 line }

{!MS}	CLOSE (textfile);

end; { PUTXTP }


(*P*)
{~_-}
{~(	}
{ Name		: SPOOLIT~%	}
{~(	}
{ Input 	: None~&	}
{~(	}
{ Output	: None~&	}
{~(	}
{ Description	: Actual spooling~$	}
{~$	~$	}
{~_-}

procedure SPOOLIT;


var
  tempfile : file of byte;
  dummy : boolean;
  count : integer;
  rslt	: integer;

begin { SPOOLIT }

~& repeat
	  WRITELN;
	  WRITELN ('Corvus Spool Utility Version ', version);
	  WRITELN ('Spool a file');
	  WRITELN ('~G-');

	  { Get file name and loop until no error }
	  repeat
	~% WRITE ('File name: ');
	~% READLN (filename);
{!MS}	~% if (filename.len = 0) or (filename[1] = CHR(esc)) then
		begin
		  WRITELN;
{!MS}		  RETURN;
		end
	~& else
		begin	 { converts file name to upper case }
{!MS}		  for count := 1 to ORD (filename.len) do
		~$ if (filename[count] in ['a'..'z']) then
		~& filename[count] := CHR (ORD (filename[count]) - 32);
		end;

{!MS}	~% tempfile.trap := true;
{!MS}	~% tempfile.errs := NoErr;
	~% ASSIGN(tempfile,filename);
	~% RESET(tempfile);
{!MS}	~% if tempfile.errs <> 0 then
	~' begin
		 WRITE (CHR(beep));
		 WRITELN ('Error opening input file', filename);
{!MS}		 WRITELN ('Return code = ',tempfile.errs:2);
	~' end
	~% else
{!MS}	~' CLOSE (tempfile);
{!MS}	  until (tempfile.errs = noerr);

{!MS}	  if not (OPENPIPE) then RETURN; { pipe open error }

	  WRITE ('  Message: ');
	  READLN (msg);
	  if (msg[1] = CHR(esc)) then
	  begin
	~$ WRITELN (CHR(beep));
{!MS}	~$ RETURN;
	  end;

{!MS}	  if not (PREAMBLE) then RETURN;

	  blockwritten := 1;
	  pipeindex := 0;
	  HTposn := 0;
	  lncount := 0;
	  dotcnt := 0;

	  WRITELN ('Spooling ', filename, ' to pipe ',
		 pipename, '[', pipenumber:1, ']~ ');

	  WRITE ('.');~- { 1st dot }
	  dotcnt := dotcnt + 1;

	  if (ftype=txt) then
	~$ dummy := PUTXTP (filename)
	  else
	~$ dummy := PUTUNFP (filename);

	  if not dummy then
	  begin
	~$ WRITELN;
	~$ WRITE ('Do you want to CLOSE or PURGE pipe ', pipenumber:1,
		~ ' named ', pipename, ' (C/P) ?');
	~$ repeat
	~& ch := INKEY;
	~& if (ch in ['C','P']) then
		WRITELN (ch)
	~& else
		WRITE (CHR(beep));
	~$ until (ch in ['C','P']);

	~$ if (ch = 'P') then
	~$ begin
	~& PURGEPIPE (pipenumber);
{!MS}	~& CYCLE;
	~$ end;
	  end;

{!MS}	  if not (CLOSEPIPE) then RETURN;

	  WRITELN;
	  WRITELN ( blockwritten:1,
		~$ ' block(s) spooled to pipe [',pipenumber:1,
		~ '] named ',pipename);
	  WRITELN ('~G-');

{!MS} until (filename.len <= 0);
{loop back until user type <cr> for filename}

end; { SPOOLIT }



(*P*)
{~_-}
{		~&	}
{ Name		: UTILITY~%	}
{~(	}
{ Input 	: None~&	}
{~(	}
{ Output	: None~&	}
{~(	}
{ Description	: Utility Menu (Close and Purge options)	}
{~(	}
{~_-}

procedure UTILITY;


var
  tempfile : file of byte;
  dummy : boolean;
  valid : boolean;
  count : integer;
  rslt	: integer;
  temp	: lstring(80);

begin { UTILITY }

~& repeat
	  WRITELN;
	  WRITELN ('Corvus Spool Utility Version ', version);
	  WRITELN ('Utilities');
	  WRITELN ('~G-');
	  WRITELN;
	  WRITELN ('~ C - Close a Pipe');
	  WRITELN;
	  WRITELN ('~ P - Purge a Pipe');
	  WRITELN;
	  WRITELN ('~ E - Exit');
	  WRITELN;
	  WRITELN ('~G-');

	  WRITE ('Please select an option: ');
	  repeat
	~$ ch := INKEY;
	~$ if (ch in ['C','P','E']) then
	~& WRITELN (ch)
	~$ else
	~& WRITE (CHR(beep));
	  until (ch in ['C','P','E']);

	  if (ch = 'P') then
	  begin
	~$ WRITE ('Pipe number to purge: ');
	~' repeat
		 READLN (temp);
		 valid := true;

{!MS}		 if (temp.len > 0) then
		~ begin
		~% valid := DECODE (temp, pipenumber);
		~% if valid then begin
		~' if (pipenumber < 0) then
~#I WRITELN
~#I ('Value must be >= 0 and <= 32767',
~&	 CHR (beep));
		~% end
		~& else
		~$ ~ WRITELN ('Invalid number', CHR (beep));
		~ end
		 else
		~ pipenumber := 0;
	~' until valid and (pipenumber >= 0);
	~$ PURGEPIPE (pipenumber);
{!MS}	~$ CYCLE;
	  end;

	  if (ch = 'C') then
	  begin
	~$ WRITE ('Pipe number to close: ');
	~' repeat
		 READLN (temp);
		 valid := true;

{!MS}		 if (temp.len > 0) then
		~ begin
		~% valid := DECODE (temp, pipenumber);
		~% if valid then begin
		~' if (pipenumber < 0) then
~#I WRITELN
~#I ('Value must be >= 0 and <= 32767',
~&	 CHR (beep));
		~% end
		~& else
		~' WRITELN ('Invalid number', CHR (beep));
		~ end
		 else
		~ pipenumber := 0;
	~' until valid and (pipenumber >= 0);
{!MS}	~% if not (CLOSEPIPE) then RETURN;
	  end;

{!MS} until (ch = 'E');
{loop back until user types an E to exit}
~& ch := CHR(0);
~& RETURN;

end; { UTILITY }

(*P*)
{-~^-}
{~(	}
{ Name		: FINDPTR~%	}
{~(	}
{ Input 	: pipe number~%	}
{~(	}
{ Output	: None~&	}
{~(	}
{ Description	:~&	}
{~(	}
{~;-~D-}

function FINDPTR (pnum : integer) : integer;

var
  i, n : integer;

begin { FINDPTR }

  i := 1;
  repeat
~$ i := i+1;
~$ n := ORD(pointertbl[i,1]);
  until ((n = pnum) or (n = 64));
  if (n = 64) then
~$ FINDPTR := -1
  else
~$ FINDPTR := i;

end; { FINDPTR }

(*P*)
{~Q-~.-}
{~(	}
{ Name		: DISPLAY~%	}
{~(	}
{ Input 	: ipee~&	}
{~(	}
{ Output	: None~&	}
{	~'	}
{ Description	: Display pipes and their status.		}
{~(	}
{~U-~*-}

procedure DISPLAY (i : integer);

var
  j, k : integer;
  pipebegin, pipeend, pipesize : integer;

begin { DISPLAY }

  j := FINDPTR (i-1);
  if (j > 0) then
~$ begin
~& pipebegin := ORD (BYWORD (pointertbl[j,2],
~$	pointertbl[j,3]));
~& pipebegin := pipebegin div 2;
~& pipeend	:= ORD (BYWORD (pointertbl[j,5],
~$	pointertbl[j,6]));
~& pipeend	:= pipeend div 2;
~& pipesize	:= pipeend - pipebegin;

~& WRITE (i-1, '.  ');
~& for k := 1 to 8 do
	WRITE (nametbl[i,k]);
~& WRITE ('~ ');

~& { last byte of the pointer entry is state }
~& case ORD(pointertbl[j,8]) of
	128: WRITE ('Closed~ ~-~% Contains data');
	129: WRITE ('Open~% Write~ Contains data');
	130: WRITE ('Open~% Read~  Contains data');
	  1: WRITE ('Open~% Write~ Empty~( ');
	  2: WRITE ('Open~% Read~$ Empty~( ');
~& end; { case }

~& WRITELN ('  ', pipesize:4,' blocks');
~$ end;

end; { DISPLAY }

(*P*)
{~?-~@-}
{~(	}
{ Name		: DISPPIPES~%	}
{~(	}
{ Input 	: None~&	}
{~(	}
{ Output	: None~&	}
{~(	}
{ Description	: Display pipes and their status.		}
{~(	}
{~A-~>-}

procedure DISPPIPES;

var
	i,j : integer;
{!MS}	tempname, pname : lstring(8);
	nopipes : boolean;

begin { DISPPIPES }

~& repeat
	WRITELN;
	WRITELN ('Corvus Spool Utility Version ', version);
	WRITELN ('Display pipe');
	WRITELN ('~G-');
	WRITE	('Pipe name : ');
	READLN (tempname);
{!MS}	if (tempname.len <= 0) or (tempname[1] = CHR(esc)) then
	  begin
	~$ WRITELN;
{!MS}	~$ RETURN
	  end
	else
	  begin
{!MS}	  ~ for i := 1 to ORD(tempname.len) do
	~' if tempname[i] in ['a'..'z'] then
		 tempname[i] := CHR (ORD (tempname[i]) - 32);
{!MS}	~% for i := (ORD(tempname[0]) + 1) to 8 do
		tempname[i] := ' ';
	~% tempname[0] := CHR(8);
	  end;

	res := PipeStatus( nametbl, pointertbl );
	if res < 0 THEN
	  begin
	~$ WRITELN ('Pipe status failure', CHR (beep));
	~$ WRITELN ('Disk error code = ', res );
{!MS}	~$ RETURN;
	  end;

	WRITELN;

	nopipes := true;

	for i := 2 to 63 do
	begin
	  if (nametbl[i,1] <> ' ') then
	  begin
	~% for j := 1 to 8 do
	~' pname[j] := nametbl[i,j];
{!MS}	~% pname.len := 8;

{!MS}  {$IF debug $THEN}
{!MS}	  WRITE ('Nametbl : ');
{!MS}	 for j := 1 to 8 do
{!MS}	~ WRITE (nametbl[i,j]);
{!MS}	 WRITELN;
{!MS}	 WRITELN ('Pname : ',pname);
{!MS}	 WRITELN ('tempname : ',tempname);
{!MS}	 WRITELN ('Positn returns : ',
{!MS}		  POSITN (tempname,pname,1));
{!MS}  {$END}

	~% if (POSITN (tempname,pname,1) = 1) then
	~% begin
		 DISPLAY (i);
		 nopipes := false;
	~% end;
	~ end;
	end;

	if nopipes then
	  WRITELN ('** No pipes of that name found **');
	WRITELN;

{!MS}  until (tempname.len <= 0);
{loop back until user type <cr> for pipename}

end; { DISPPIPES }

(*P*)
{~'-~X-}
{~(	}
{ Name		: HELP~&	}
{~(	}
{ Input 	: None~&	}
{~(	}
{ Output	: None~&	}
{~(	}
{ Description	:~&	}
{~(	}
{~I-~6-}

procedure HELP;

begin { HELP }

 WRITELN ('NOT IMPLEMENTED YET ! ',CHR(beep));


end; { HELP }


(*P*)
{~_-}
{~(	}
{ Name		: INIT~&	}
{~(	}
{ Input 	: None~&	}
{~(	}
{ Output	: None~&	}
{~(	}
{ Description	: Initialize spooling parameters		}
{~$	~$	}
{~_-}

procedure INIT;

var
  rc : integer;

begin { INIT }

	xit := false;
	rc := INITIO;
{!MS}	if (rc <> NoErr) then begin
	  WRITELN (CHR(beep), '~* Driver not found ~*');
	  xit := true;
{!MS}	  RETURN;
	  end;

~' rc := SETSRVR (sno);
{!MS}
{!MS}  terminalin.mode := terminal;
{!MS}  terminalin.errs := NoErr;
{!MS}  ASSIGN (terminalin, 'USER');
{!MS}  RESET (terminalin);

~' pipename := 'PRINTER ';
{!MS}  pipename.len := 8;
~' lnperpage := 55;
~' FFenabled := true;
~' INenabled := true;
{!MS}  strip	 := false;
 ~& formfeedstr := '(*P';
{!MS}  formfeedstr.len := 3;
~' includestr := '(*I';
{!MS}  includestr.len := 3;
~' ftype := txt;
~' HTsize := 8;

end; { INIT }


(*P*)
{~_-}
{~(	}
{ MAIN body of program spooler~%	}
{~(	}
{~_-}

begin

  INIT; { Initialize spool parameters }

  WRITELN;
  WRITELN ('(C)Copyright 1982, 1983, 1984  Corvus Systems, Inc.');
  WRITELN ('All Rights Reserved');
  WRITELN;
  if xit then WRITELN ('Corvus Spool Utility Version ',version);

  { the version is here so that the version # is printed in  }
  { case the driver cannot be found and the program aborts~ }

  if not xit then
~$ repeat
~& WRITELN ('Corvus Spool Utility Version ',version);
~& WRITELN ('Main Menu');
~& WRITELN ('~G-');
~& WRITELN;
~& WRITELN ('~ S - Spool a File');
~& WRITELN;
~& WRITELN ('~ C - Change Spool Parameters');
~& WRITELN;
~& WRITELN ('~ D - Display Pipes');
~& WRITELN;
~& WRITELN ('~ U - Utilities');
~& WRITELN;
~& WRITELN ('~ H - Help');
~& WRITELN;
~& WRITELN ('~ E - Exit');
~& WRITELN;
~& WRITELN ('~G-');

~& WRITE ('Please select an option: ');
~& repeat
	ch := INKEY;
	if not (ch in ['S','C','D','U','H','E']) then
	  WRITE (CHR(beep));
~& until (ch in ['S','C','D','U','H','E']);

~& WRITELN (ch);

~& case ch of
	'S': SPOOLIT;
	'C': CHANGEPARMS;
	'D': DISPPIPES;
	'U': UTILITY;
	'H': HELP;
	'E': { exit };
~& end; { case }

~$ until (ch = 'E');

end.
