/**********************************************************/
/* IBM 3278 keyboard to PS/2                              */
/*                                                        */
/* Copyright (c) 2013, Henk Stegeman                      */
/*                                                        */
/* All rights reserved.                                   */
/*                                                        */
/* This program is free software; you can redistribute it */
/* and/or modify it under the terms of the GNU General    */
/* Public License as published by the Free Software       */
/* Foundation; either version 2 of the License, or        */
/* (at your option) any later version.                    */
/*                                                        */
/* This program is distributed in the hope that it will   */
/* be useful, but WITHOUT ANY WARRANTY; without even the  */
/* implied warranty of MERCHANTABILITY or FITNESS FOR A   */
/* PARTICULAR PURPOSE.  See the GNU General Public        */
/* License for more details.                              */
/*                                                        */
/* You should have received a copy of the GNU General     */
/* Public License along with this program; if not, write  */
/* to the Free Software Foundation, Inc.,                 */
/* 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA */
/*                                                        */
/* Licence can be viewed at                               */
/* http://www.fsf.org/licenses/gpl.txt                    */
/*                                                        */
/**********************************************************/

// Initialize I/O pins

#include <inttypes.h>
#include <avr/io.h>
#include <avr/pgmspace.h>
#include <avr/interrupt.h>

#include "IBM_keyboard.h"

void init_io() {

// ### Initialize port PORTB ###

// PINB0 = KB_IDENT_0
DDRB &= ~(1 << DDB0);    // Set PB0 pin as input
PORTB |= (1 << PORTB0);  // Enable the Pull-up R

// PINB1 = KB_IDENT_1
DDRB &= ~(1 << DDB1);    // Set PB1 pin as input
PORTB |= (1 << PORTB1);  // Enable the Pull-up R

// PINB2 = PS2_CLK_OUT
DDRB |= (1 << DDB2);     // Set PB2 pin as output
PORTB |= (1 << PORTB2);  // Set init value to high

// PINB7 = KB_MAK_BRK
DDRB &= ~(1 << DDB7);    // Set PB7 pin as input
PORTB &= ~(1 << PORTB7); // Disable the Pull-up R

// ### Initialize port PORTC ###

// PINC0 -> PINC5 = KB_BUS
DDRC &= 0xC0;            // Set PC0-5 pin as input
PORTC &= 0xC0;           // Disable the Pull-up R

// ### Initialize port PORTD ###

// PIND0 = RS232_RX
DDRD &= ~(1 << DDD0);    // Set PD0 pin as input
PORTD &= ~(1 << PORTD0); // Disable the Pull-up 

// PIND1 = RS232_TX
DDRD |= (1 << DDD1);     // Set PD1 pin as output
PORTD |= (1 << PORTD1);  // Set init value to high

// PIND2 = PS2_DATA_INP
DDRD &= ~(1 << DDD2);    // Set PD2 pin as input
PORTD &= ~(1 << PORTD2); // Disable the Pull-up R

// PIND3 = KB_DATA_AVAIL
DDRD &= ~(1 << DDD3);    // Set PD3 pin as input
PORTD &= ~(1 << PORTD3); // Disable the Pull-up R

// PIND4 = KB_ACK
DDRD |= (1 << DDD4);     // Set PD4 pin as output
PORTD |= (1 << PORTD4);  // Set init value to high

// PIND5 = PS2_CLOCK_INP
DDRD &= ~(1 << DDD5);    // Set PD5 pin as input
PORTD &= ~(1 << PORTD5); // Disable the Pull-up R

// PIND6 = KB_SCAN6
DDRD &= ~(1 << DDD6);    // Set PD6 pin as input
PORTD &= ~(1 << PORTD6); // Disable the Pull-up R

// PIND7 = PS2_DATA_OUT
DDRD |= (1 << DDD7);     // Set PD7 pin as output
PORTD |= (1 << PORTD7);  // Set init value to high

}

