: 'Copyright 1986 Intel Corp.'
# Stage2 Synchronization Processing
# Runs on the Master node only, is rexec'd if not already there
#    Parm8 = full path of $LOGINID.Batch (or .Sched.Batch)

# 03/15/86 oer
# 03/30/86 oer misc. cleanup
# 04/09/86 oer make workqueue directory a parm, to allow for scheduled batches
# 05/08/86 oer change to reference the master node
# 05/28/86 oer make invokeable via rexec, to reduce network traffic
# 07/11/86 oer change Astage4.ss to Astage4

# if invoked via rexec, these won't be in the environment
iDIS=$1
iDISBIN=$2
OPENNET=$3
MASNODE=$4
MASNODEP=$5
MASSYNCH=$6
LOGINID=$7
dir=$8
PHYSYS=$MASNODE
export iDIS iDISBIN OPENNET MASNODE MASNODEP MASSYNCH LOGINID PHYSYS

# ignore hangup interrupt quit and s/w kill (continue even if user logs off)
trap "" 1 2 3 15
umask 0		# ensure other Stage4's can read our files
if [ -f $MASSYNCH/debug ] ; then
	exec >> $MASSYNCH/debug
	exec 2>&1
	set -x
	echo $0
fi

# Get a list of the various transaction types and
# and their associated transaction builders

set `cat $MASSYNCH/.TransBuilders`

cd $dir

time=even
for TYPE in $*
do
        case $time in
	   odd) time=even
             continue ;;
        esac
	if [ -f $LOGINID.idis$TYPE ] ; then
		# Invoke proper builder, with raw trans file as a parm
		eval $2 $LOGINID.idis$TYPE
	fi
	case $# in
		0) break ;;	# No more parms, don't shift
	esac
	shift; shift
	time=odd
done

# Indicate Stage2 processing is complete
> Stage2

# Start Stage3 processing, which deletes the current directory
$iDISBIN/Astage3
cd $MASSYNCH

# Start Stage4 processing
exec $iDISBIN/Astage4
