/*
 *    Copyright (c) 1982 Schmidt Associates all rights reserved
 */

/*
Title:	Generate-Parameters
	 O: parameter.pointers
	 I: size.of.pointer.array
	 I: parameter.string
	 O: number.of.parameters

Function:
	Set up parameter string so that EOS characters finish off a 
	parameter and there is a pointer assigned to point to that parameter.

Usage:
	Blanks separate parameters. End of line or EOS end a command.

Logic:
	Sequence through the parameter string picking up parameters, pointing
	to them, and terminating them with null strings.

Procedure:
 10	While not yet finding EOS or END_OF_LINE
 20	.  Skip all leading blanks in the parameter.string
 30	.  Switch on next character in parameter.string
 40	.  .  case EOS
 45	.  .  case END_OF_LINE
 50	.  .  .  Break
 60	.  .  case QUOTES
 70	.  .  .  assign next parameter.pointer to character after QUOTES
 80	.  .  .  find next QUOTES and replace with EOS
 90	.  .  default
100	.  .  .  assign param.pointer to current position in parameter.string
110	.  .  .  find next BLANK or EOS or END_OF_LINE and assign EOS
120	Return

HISTORY:

11.4.83 Removed EOL check at top of main while loop, incremented index past EOL
	in EOL case. aem
*/


# include "custproc.h"

	genparam( parptrs, ppsize, parstr, numpars )
	  char *parptrs[];
	  int  ppsize;
	  char parstr[];
	  int  *numpars;
	{
	  int ppidx, psidx, i, ch;

	*numpars = 0;
	ppidx = 0;
	psidx = 0;
	for ( i=0; i<ppsize; i++ )  parptrs[i] = 0;
L010:	while ( parstr[psidx]!=EOS ) {
	  if (ppidx >= ppsize){
	    errmsg(stderr, "Error: Too many arguments on list ");
	    errmsg(stderr, "- Max is %d\n", ppsize);
	    exit(1);
	    }
L020:	  for ( ; parstr[psidx] == BLANK ; psidx++ ) ;
	  ch = parstr[psidx];
L030:	  switch ( ch ) {
L040:	    case EOS:
	      break;
L045:	    case END_OF_LINE:
	      psidx++;
	      break;
L050:	    case QUOTES:
	      parptrs[ppidx++] = &parstr[psidx+1];
	      *numpars += 1;
	      for ( psidx++; parstr[psidx]!=QUOTES; psidx++ )
	        if (parstr[psidx]==EOS || parstr[psidx]==END_OF_LINE) {
	          errmsg(stderr, "Error: Quotes not closed\n");
	          exit(1);
	          }
	      parstr[psidx++] = EOS;
	      break;
L090:	    default:
	      parptrs[ppidx++] = &parstr[psidx];
	      *numpars += 1;
	      while ( parstr[psidx] != EOS ) {
	        if (parstr[psidx]==BLANK || parstr[psidx]==END_OF_LINE
	           || parstr[psidx]==TAB ) {
	          parstr[psidx++] = EOS;
	          break;
	          }
	        psidx++;
	        }
	      break;
	    }
	  }
L120:	return;
	}
