# awk script to print the customer report
BEGIN {
   FS=";";
   page=0;
   printf("");
   }

   { # for each input line
   if ( (i = NR % 8) != 0 ) {
      cno[i]=$1; name[i]=$2; addr[i]=$3; city[i]=$4; st[i]=$5; zip[i]=$6;
      flushed="NO";
      next;
      }
   else {
      cno[8]=$1; name[8]=$2; addr[8]=$3; city[8]=$4; st[8]=$5; zip[8]=$6;
      printf("+----------------------------------------------------------");
      printf("------------------+\n");
      printf("|                          Notable Accounting System       ");
      printf("                  |\n");
      printf("|                             Customer Information         ");
      printf("         Page %3d |\n",++page);
      printf("+----------------------------------------------------------");
      printf("------------------+\n");
      for ( i=1 ; i<=4 ; i++ ) {
         j = i + 4;
         printf("                                      |\n");
         printf("%-7s%-31s|%-7s%-31s\n",cno[i],name[i],cno[j],name[j]);
         printf("       %-31s|       %-31s\n",addr[i],addr[j]);
         printf("       %-15s  %-2s  %-10s|       %-15s  %-2s  %-10s\n",\
            city[i],st[i],zip[i],city[j],st[j],zip[j]);
         cno[i]=""; name[i]=""; addr[i]=""; city[i]=""; st[i]=""; zip[i]="";
         cno[j]=""; name[j]=""; addr[j]=""; city[j]=""; st[j]=""; zip[j]="";
         }
      printf("\n");
      printf("\n");
      flushed="YES";
      }
   }

END {
   if ( flushed == "NO" ) {
      printf("+----------------------------------------------------------");
      printf("------------------+\n");
      printf("|                          Notable Accounting System       ");
      printf("                  |\n");
      printf("|                             Customer Information         ");
      printf("         Page %3d |\n",++page);
      printf("+----------------------------------------------------------");
      printf("------------------+\n");
      for ( i=1 ; i<=4 ; i++ ) {
         j = i + 4;
         printf("                                      |\n");
         printf("%-7s%-31s|%-7s%-31s\n",cno[i],name[i],cno[j],name[j]);
         printf("       %-31s|       %-31s\n",addr[i],addr[j]);
         printf("       %-15s  %-2s  %-10s|       %-15s  %-2s  %-10s\n",\
            city[i],st[i],zip[i],city[j],st[j],zip[j]);
         }
      printf("\n");
      printf("\n");
      }
   }
