: 'Copyright 1986 Intel Corp.'
# create/delete group's /etc/group information
# Runs on the target node itself.
# This is called with an environment that contains the group's info.
# 03/15/86  oer
# 03/27/86  gll  removed extra case terminator ';;'.
# 03/30/86  oer  misc. cleanup
# 04/14/86  ugg  change to copy from master node and added RESTART logic
# 04/21/86  ugg  add "copying mailrc file to all nodes" and deleting
#                  mailrc entry for a group in RESTART
# 05/13/86  rhc add PATH for Ar usage
PATH=/bin:/usr/bin	export PATH

# ensure any errors stop processing
set -e

case $1 in
   # APPLY
   APPLY)
      # provide an execution trace, in case of error
      set -x
      copy -o	$MASNODEP/etc/group		/etc/cp$$
      mv	/etc/cp$$			/etc/group
      copy -o	$MASNODEP/usr/lib/mail/mailrc	/usr/lib/mail/cp$$
      mv	/usr/lib/mail/cp$$		/usr/lib/mail/mailrc
   ;;

   # RESTART only called to remove a group's entry from the master node
   RESTART)
      sed -e "/^$Ausr:/d" $MASNODEP/etc/group > $MASNODEP/etc/cp$$
      mv $MASNODEP/etc/cp$$  $MASNODEP/etc/group
      chmod 664 $MASNODEP/etc/group
      #  Delete the group's alias from the mailrc file
      sed -e "/^alias $Ausr /d" $MASNODEP/usr/lib/mail/mailrc > $MASNODEP/usr/lib/mail/cp$$
      mv $MASNODEP/usr/lib/mail/cp$$  $MASNODEP/usr/lib/mail/mailrc
      chmod 644 $MASNODEP/usr/lib/mail/mailrc
   ;;

esac
