: 'Copyright 1986 Intel Corp.'
# Transaction monitor
# Executes and removes individual transactions, runs on target node
# 03/15/86 oer
# 03/30/86 oer misc. cleanup
# 05/08/86 oer determine LOGIN from Batch file, needed when started as a result
#	       of /etc/rc actions.  Add completed and error msgs to logfile
# 05/15/86 oer enhance debug
# 05/17/86 oer fix problem when master node is updated from another node

PATH=/bin:/usr/bin:/iDISboot	export PATH

# The parameters are:
#	-a 		APPLY
#	-r		RESTART
#	-o		OpenNET installation
#	-i <path>	$iDIS, to locate the synch directory (starts '/usr')
#	-m <node>	Master node
#	-s <node>	Sending node
#	-t <node>	Target node
#	-n <number>	Transaction number
#	-b <number>	Batch number

OPENNET=n
set -- `getopt aroi:m:s:t:n:b: $*`

for i in $*
do
	case $i in
		-a|-r)	TYPE=$i;  shift ;;
		-o)	OPENNET=y;  shift ;;
		-i)	iDIS=$2;  shift; shift ;;
		-m)	MNODE=$2; shift; shift ;;
		-s)	SNODE=$2; shift; shift ;;
		-t)	NODE=$2;  shift; shift ;;
		-l)	LOGIN=$2; shift; shift ;;
		-n)     TNUM=$2;  shift; shift ;;
		-b)	BATCH=$2; shift; shift ;;
	esac
done

case $OPENNET in
   y) MNODEPATH=//$MNODE	# Get OpenNET paths
      NODEPATH=//$NODE ;;
   n) MNODEPATH=""
      NODEPATH="" ;;
esac

# determine LOGIN from Batch# file
LOGIN=`cat $MNODEPATH$iDIS/synch/Batch$BATCH`

export TYPE OPENNET iDIS MNODE SNODE NODE LOGIN TNUM BATCH MNODEPATH SNODEPATH NODEPATH

[ -f $MNODEPATH$iDIS/synch/debug ] &&
	echo "$0=$TYPE,$OPENNET,$iDIS,$MNODE,$SNODE,$NODE,$LOGIN,$TNUM,$BATCH,$MNODEPATH,$SNODEPATH,$NODEPATH" >> $MNODEPATH$iDIS/synch/debug

while :
do
   case $TYPE in
	# APPLY
	# Run transaction, saving the execution trace
	# If the transaction failed, mail it and the trace to originator
	-a)	exec >> /tmp/$SNODE.$$	# stdout and stderr to exec. trace
		exec 2>&1
		sh -x /tmp/$SNODE.$TNUM APPLY
		case $? in
			0) ;;
			*) { cat <<-HERE
		There was an error in the following transaction, which was run
		on node $NODE.  The transaction was part of Batch `expr $BATCH + 0`.
		The actual transaction will be presented, followed by its
		execution trace.  The last few lines of the execution trace
		should indicate the nature of the problem.

		================TRANSACTION FOLLOWS================

		HERE
		cat /tmp/$SNODE.$TNUM
		cat <<-HERE

		==============EXECUTION TRACE FOLLOWS==============
		
		HERE
		cat /tmp/$SNODE.$$
		} | mail -s "Error in transaction on $NODE node" $LOGIN
		{ echo "ERROR IN TRANSACTION ON $NODE NODE on `date`."
		echo "   Details sent via mail to user $LOGIN."
		} >>$MNODEPATH$iDIS/synch/logfile
		;;
		esac

		# Remove this transaction, so it won't run again
		# Remove "link" file, to indicate one more trans. completed
		# Remove lock file, so other transactions for this node can run
		# Remove local copy of the transaction
		rm -f	$MNODEPATH$iDIS/synch/$NODE.apply/$NODE.$TNUM \
			$MNODEPATH$iDIS/synch/$NODE.apply/.$NODE.$TNUM \
			$MNODEPATH$iDIS/synch/$NODE.apply/$NODE..L \
			/tmp/$SNODE.$TNUM

		# If we are the last transaction in this batch, send mail
		set X`ls -l $MNODEPATH$iDIS/synch/Batch$BATCH`
		case $2 in
			1)
				rm -f $MNODEPATH$iDIS/synch/Batch$BATCH
				mail -s "Batch `expr $BATCH + 0` completed" $LOGIN < /dev/null 2>&1
				echo "Batch `expr $BATCH + 0` completed on `date`" >>$MNODEPATH$iDIS/synch/logfile
			;;
		esac

		break ;;

	# RESTART
	# Run the "undo" part of the transaction and start the APPLY cycle
	-r)	exec >> /tmp/$SNODE.$$	# stdout and stderr to exec. trace
		exec 2>&1
		sh -x /tmp/$SNODE.$TNUM RESTART
		TYPE='-a' ;;
   esac
done
if [ -f $MNODEPATH$iDIS/synch/debug ] ; then
	cat /tmp/$SNODE.$$ >> $MNODEPATH$iDIS/synch/debug
	cat /tmp/$SNODE.$$ >> $MNODEPATH$iDIS/synch/$NODE.apply/debug
fi
rm -f /tmp/$SNODE.$$
