: 'Copyright 1986 Intel Corp.'
# Build transactions for a target node
# NOTE: There is a companion script to this AWnodeb.ss
# PLEASE KEEP THEM IN SYNCH, AS REQUIRED
#
#  04/25/86 ugg
#  05/08/86 oer change to reference master node
#  05/28/86 oer make PIDFILE 666, prevents problem when 1st trans. is deferred

MASSYNCH=$MASNODEP`$iDISBIN/Unonode $iDIS`/synch # Master node synch directory
export MASSYNCH

if [ -f $MASSYNCH/debug ] ; then
	set -x
	echo $0
fi

node=$1
. $2		# set up environment


txn=$node.`$iDISBIN/Anxtxn $node`	# get next transaction number

case $Ttype in
   # INITIALIZE SUB-NETWORK NODE 
   Init)
      # generate header part of the transaction
      cat <<-\HERE > $txn
	: /bin/sh
	# Initialize $Kind
	PIDFILE=/tmp/$SNODE.P$TNUM 	# Unique ID
	export PIDFILE
	HERE

      # ROUTE THE REMAINDER OF STDOUT TO THE END OF $txn,
      # overrides any called processes also
      exec >> $txn

      # incorporate environment into transaction
      cat $2

      # generate APPLY part of the transaction
      cat <<-\HERE

	# Quit if a non-zero return code is encountered
	set -e

	case $1 in

	APPLY)

	# Save away the PID of this transaction, so that RESTART can kill it.
	# This would only be the case if RESTART were issued before the
	# APPLY finished (this is not anticipated).
	echo "$0 $$" > $PIDFILE
	set +e
	chmod 666 $PIDFILE 2>/dev/null
	set -e

	HERE

      # generate network node entry 
      case $node in
	 $MASNODE) ;;	# if this the master node, is already done
	 *)
            cat <<-HERE
		# Apply the transaction to the node 
		/iDISboot/Ar /iDISboot/ANnode.ss APPLY
		HERE
	 ;;
      esac

      # generate RESTART part of the transaction, and end of APPLY
      cat <<-\HERE
	exit 0
	;;
	RESTART)
	# This is only used to back out transactions that have broken their
	# communications link with the sending node before/during the APPLY
	# part of the transaction.

	# Allow non-zero return codes
	set +e

	# Ensure that a previously running APPLY is killed
	if [ -f $PIDFILE ] ; then
	   set `cat $PIDFILE`
	   CMD=$1 PID=$2
	   ps -e |
	   egrep '^[ 	]*'$PID'[ 	]*.*[ 	]'$CMD'$' >/dev/null 2>&1 &&
	   kill -9 $PID
	fi
	HERE

      # No need to do anything for restart

      # generate tail of transaction
      cat <<-\HERE
	exit 0
	;;

	esac
	HERE
   ;;

   # MODIFY SUB-NETWORK NODE 
   Mod)
      # generate header part of the transaction
      cat <<-\HERE > $txn
	: /bin/sh
	# Modify $Kind
	PIDFILE=/tmp/$SNODE.P$TNUM 	# Unique ID
	export PIDFILE
	HERE

      # ROUTE THE REMAINDER OF STDOUT TO THE END OF $txn,
      # overrides any called processes also
      exec >> $txn

      # incorporate environment into transaction
      cat $2

      # generate APPLY part of the transaction
      cat <<-\HERE

        # Quit if non-zero return code is encountered
	set -e

	case $1 in

	APPLY)

	# Save away the PID of this transaction, so that RESTART can kill it.
	# This would only be the case if RESTART were issued before the
	# APPLY finished (this is not anticipated).
	echo "$0 $$" > $PIDFILE
	set +e
	chmod 666 $PIDFILE 2>/dev/null
	set -e

	HERE

      # modify sub-network node information 
      case $node in
	 $MASNODE) ;;	# if this the master node, is already done
	 *)
            cat <<-HERE
		# Copy all the required files 
		/iDISboot/Ar /iDISboot/ANnode.ss APPLY
		HERE
	 ;;
      esac # End case in $node

      # generate RESTART part of the transaction, and end of APPLY
      cat <<-\HERE
	exit 0
	;;
	RESTART)
	# This is only used to back out transactions that have broken their
	# communications link with the sending node before/during the APPLY
	# part of the transaction.

	# Allow non-zero return codes
	set +e

	# Ensure that a previously running APPLY is killed
	if [ -f $PIDFILE ] ; then
	   set `cat $PIDFILE`
	   CMD=$1 PID=$2
	   ps -e |
	   egrep '^[ 	]*'$PID'[ 	]*.*[ 	]'$CMD'$' >/dev/null 2>&1 &&
	   kill -9 $PID
	fi
	HERE

      # we don't need to do anything for RESTART of a modify sub-network node 
      # generate tail of transaction
      cat <<-\HERE
	exit 0
	;;
      esac
	HERE
    ;;

   # DELETE SUB-NETWORK NODE 
   Xdel)
      # generate header part of the transaction
      cat <<-\HERE > $txn
	: /bin/sh
	# Delete $Kind
	PIDFILE=/tmp/$SNODE.P$TNUM 	# Unique ID
	export PIDFILE
	HERE

      # ROUTE THE REMAINDER OF STDOUT TO THE END OF $txn,
      # overrides any called processes also
      exec >> $txn

      # incorporate environment into transaction
      cat $2

      # generate APPLY part of the transaction
      cat <<-\HERE

	# Quit if a non-zero return code is encountered
	set -e

	case $1 in

	APPLY)

	# Save away the PID of this transaction, so that RESTART can kill it.
	# This would only be the case if RESTART were issued before the
	# APPLY finished (this is not anticipated).
	echo "$0 $$" > $PIDFILE
	set +e
	chmod 666 $PIDFILE 2>/dev/null
	set -e

	HERE

      # delete sub-network node 
      case $node in
	 $MASNODE) ;;	# if this the master node, is already done
	 *)
            cat <<-HERE
		# Copy all the required files 
		/iDISboot/Ar /iDISboot/ANnode.ss APPLY
		HERE
	 ;;
      esac

      # generate RESTART part of the transaction, and end of APPLY
      cat <<-\HERE
	exit 0
	;;
	RESTART)
	# This is only used to back out transactions that have broken their
	# communications link with the sending node before/during the APPLY
	# part of the transaction.

	# Allow non-zero return codes
	set +e

	# Ensure that a previously running APPLY is killed
	if [ -f $PIDFILE ] ; then
	   set `cat $PIDFILE`
	   CMD=$1 PID=$2
	   ps -e |
	   egrep '^[ 	]*'$PID'[ 	]*.*[ 	]'$CMD'$' >/dev/null 2>&1 &&
	   kill -9 $PID
	fi
	HERE

      # we don't need to do anything for RESTART of a delete sub-net node 
      # generate tail of transaction
      cat <<-\HERE
	exit 0
	;;
      esac
	HERE
    ;;

   # INVALID TRANSACTION
   *) echo "$0: Unknown transaction type <$Ttype>" >> $MASSYNCH/logfile
      echo "$0: Unknown transaction type <$Ttype>" >  /dev/console
   ;;
esac
