:
# "Aaddnode.ss", a shell script to add the nfs entry in the master /net/data
#                file for a new node

#  Copyright 1986 Intel Corporation

#  Parameters:
#      1  --  Node name
#      2  --  Node's Ethernet address
#      3  --  Node type
#      4  --  Password

# 05/13/86  rhc  add PATH for Ar usage
# 06/12/86  gll  reworded error message displayed when connection to
#                target node unsuccessful as per problem report #1.
#                Also changed wording in other messages to say
#                "node <node>" instead of "the <node> node".
#                Also changed so that pre-existing vts/vtc entries
#                in /net/data are removed if VT is not listed in 
#                the SCP config file per probelm report 21.
# 06/25/86  gll  SPR 162.  Removed indentations from messages.
# 06/27/86  gll  SPR 99.  Added node password validation.
#                Also changed to Aconnect.ss to make connection
#                since each node might have a root password now.
# 06/27/86  gll  SPR 83.  Modified to ask user if init should continue
#                if node is already there, then to proceed if
#                the answer is yes.  Also remove duplicate
#                /net/data entries upon completion.
# 08/13/86  gll  Modified to abort if overinstall attempt detected.

PATH=/bin:/usr/bin	export PATH
node=$1
address=$2
type=$3
password=$4
export node address type password
oldnode=n

#    check for validity of the parameters.

a=`expr $address : '.*'`
if [ $a -lt 12 ] ; then
   echo
   echo "
The address $address is not valid.
The address MUST be 12 characters long.

Node $node has not been added to the sub-network."
   exit 1
else
   a=`expr $address : '[0-9a-fA-F]*'`
   if [ $a -lt 12 ] ; then
      echo
      echo "
The address $address is not valid.
The address MUST consist of only hexadecimal characters
(0,1,2,3,4,5,6,7,8,9,A,B,C,D,E,F) 

Node $node has not been added to the sub-network."
      exit 1
   fi
fi  

if [ "$type" = "personal-computer" ] ; then
   process=nfc
   type=msdos
else
   process=nfs
   type=XENIX
fi
#
#   Make sure the specified entry already does not exist.
#      We have to do this because mkns does not return an error code.

count=`grep -c "^$node/" $MASNODEP/net/data`
if [ $count -gt 0 ] ; then
  echo "
The entries for $node already exist in the nameserver database.

Node $node has NOT been overwritten."
  exit 1
fi 

#  Next make the nfs entry in /net/data
/etc/mkns <<HERE >/dev/null
addname
$node/$process
$type
y
8000
y
$address
done
HERE

if [ $? != 0 ] ; then
  echo "

Could not create nfs entry for $node in master /net/data file.

Node $node has not been added to the sub-network."
  exit 1
fi

#  Next try to talk to the new node only if it is XENIX type
if [ "$type" = "XENIX" ] ; then
    echo "
"
    $iDISBIN/Aconnect.ss -l root $node

    if [ $? != 0 ] ; then
        echo
        echo "
Node $node is not accessible.  Possible reasons for this are:

 -- The consumer and server processes on master node $MASNODE
    are disabled.

 -- The consumer and server processes on node $node are
    disabled.

 -- Node $node has been shutdown.

 -- The OpenNET hardware is not functioning properly.  Disconnected
    cables are the most common hardware problem.

Node $node has not been added to the sub-network."

        if [ "$oldnode" = "n" ]
        then # remove /net/data entry only if it wasnt already there.
             sed -e "/^$node\/$process/d" < $MASNODEP/net/data \
               > $MASNODEP/tmp/netdata$$
             mv $MASNODEP/tmp/netdata$$ $MASNODEP/net/data
             chmod 644 $MASNODEP/net/data
        fi
        exit 1

   else 
        # Check for previous installation of iDIS software.

        # Start by assuming no previous installations.

        piDIS=n

        # Now look for iDIS R1.6

        if [ -d //$node/iDISbin ]
        then echo "
Previously installed iDIS software found in /iDISbin on node $node."
             piDIS=y
        fi

        # Look for overinstall of iDIS R2.0

        if [ -d //$node/usr/iDISbin ]
        then echo "
Previously installed iDIS software found in /usr/iDISbin on node $node."
             piDIS=y
        fi

        if [ -d //$node/iDISboot ]
        then echo "
Previously installed iDIS software found in /iDISboot on node $node."
             piDIS=y
        fi

        # See if OpenNET Configuration files are as per instructions.

        set A `sed -e "/^$node/d" //$node/net/data | wc`
        numentry=$2

        if [ $numentry -ne 0 ]
        then echo "
There are nodes improperly listed in the nameserver database on node $node."
             piDIS=y
        fi

        if [ -f //$node/net/cdf ]
        then echo "
There should not be a consumer database on node $node yet."
             piDIS=y
        fi

        # Now see if we found anything and if so, abort.

        if [ "$piDIS" = "y" ]
        then echo "
This initialization cannot be completed for the above reasons.

Backing out initialization performed so far, please wait ..."

             #  Delete all the entries created so far.
             sed -e "/^$node\//d" < $MASNODEP/net/data \
	       > $MASNODEP/tmp/netdata$$
             mv $MASNODEP/tmp/netdata$$ $MASNODEP/net/data
             chmod 644 $MASNODEP/net/data

             # Disconnect from the node

             $iDISBIN/Adisconnect.ss $node

	     echo -n "
Press RETURN to continue ..."
	     read resp

             exit 1
        fi

        #  Now make the nfc and cdf entries.
        #
        
        # First, validate the password given.

        if [ `grep -c "$password" //$node/net/self` = 0 ]
        then echo "
The password specified, $password, is incorrect.

Node $node has not been added to the sub-network."

            sed -e "/^$node\/$process/d" < $MASNODEP/net/data > $MASNODEP/tmp/netdata$$
            mv $MASNODEP/tmp/netdata$$ $MASNODEP/net/data
            chmod 644 $MASNODEP/net/data

	    $iDISBIN/Adisconnect.ss $node
            exit 1
        fi 

	/etc/mkcon -c $node $password 1 1>/dev/null 2>&1

	if [ $? != 0 ] ; then
            echo
	    echo "
Could not create consumer process for node $node
in nameserver database.

Node $node has not been added to the sub-network."

            sed -e "/^$node\/$process/d" < $MASNODEP/net/data > $MASNODEP/tmp/netdata$$
            mv $MASNODEP/tmp/netdata$$ $MASNODEP/net/data
            chmod 644 $MASNODEP/net/data

            net use $node /d > /dev/null 2>&1
            exit 1
        fi 
	#  Next make the nfc entry in /net/data
	/etc/mkns <<HERE >/dev/null
addname
$node/nfc
$type
y
8100
y
$address
done
HERE
    	#   Determine whether scp is already performed on the new node. 
    	if [ ! -f //$node/usr/intel/scp/configurations/current ] ; then

           echo
           echo "
Can not access the Xenix System Configuration (scp) file on 
node $node. You MUST first perform system configuration on 
node $node. If you have already performed system configuration,
it is also possible that the 'usr' file system on node $node
is not mounted. Please check and try again.

Node $node has not been added to the sub-network."

           #
           #  Delete all the entries created so far.
           sed -e "/^$node\//d" < $MASNODEP/net/data > $MASNODEP/tmp/netdata$$
           mv $MASNODEP/tmp/netdata$$ $MASNODEP/net/data
           chmod 644 $MASNODEP/net/data

           sed -e "/^$node:/d" < $MASNODEP/net/cdf > $MASNODEP/tmp/netcdf$$
           mv $MASNODEP/tmp/netcdf$$ $MASNODEP/net/cdf
           chmod 644 $MASNODEP/net/cdf

           net use $node /d > /dev/null 2>&1
           exit 1
        else
    	   #   Determine whether VT server is installed on the new node.
    	   count=`grep -c "VT" //$node/usr/intel/scp/configurations/current`
           if [ $count -gt 0 ] ; then
	    	   #  Next make the vts entry in /net/data
	  	   /etc/mkns <<HERE >/dev/null
addname
$node/vts
XVTSRV
y
4000
y
$address
done
HERE
	     	   #  Next make the vtc entry in /net/data
	           /etc/mkns <<HERE >/dev/null
addname
$node/vtc
XVTCON
y
4100
y
$address
done
HERE
	      else # If no VT entry in configuration file, then
		   # make sure no vts or vtc entries in /net/data.
		   sed -e "/^${node}\/vts/d
/^${node}\/vtc/d" $MASNODEP/net/data.tmp
		   mv $MASNODEP/net/data.tmp $MASNODEP/net/data
              fi
        fi
          
	#  Next copy the /net/data and /net/cdf files to the new node.
    	cp /net/data //$node/net/data
    	cp /net/cdf //$node/net/cdf
    fi
else
  #   If the new node being added is PC node, just tell the user what to do.
  echo
  echo "
You MUST enter the required entries in the NETADDR file 
on personal computer node $node in order for you to access other
nodes on the network.
"
fi
