: # (forces Bourne shell)
#
#	This script requires only consumer access to the remote node.
#	The remote nodes consumer need not be active.
#
# Copyright 1986 Intel Corporation.
COMMANDS=$1
shift
case $# in
  1)
    nodename=$1 ;;
  2)
    nodename=$1
    log=$2 ;;
  *)
    cat <<-\HERE
	Aarmtviafil: runs commands on a remote node whose consumer is off
	usage: Aarmtviafil.ss <commands> <remote_node>
	    <commands> is the command string to be executed on the remote
		node (all commands & parameters must be enclosed in quotes)
	    <remote_node> is name of node where the desired commands will
	        be executed.
	HERE
    exit 1
    ;;
esac

netdelm=`net delimiter`		# network delimiters (usually //)
locnode=`net name`		# includes network delimiters
locnodename=`net lname`		# without network delimiters

if [ ! -f $netdelm$nodename/net/self ]
  then
    echo "Node $nodename not accessible."
    exit 1
fi

remotescript=$netdelm$nodename/tmp/$locnodename$$
cat >$remotescript <<-HERE
	: #	(place commands to be executed on remote node below # # # # #)
	#   	(\$1 is node name, \$2 is path to send stdout/stderr)
	PATH="/bin:/usr/bin:."
	trap "rm -f $remotescript; trap 0; exit" 0 1 2 3 15
	exec >>\$2 2>&1
	#						*** modify here ***
	$COMMANDS
	#						*** to here ***
	#
	# 	(end of commands to be executed on remote node      # # # # #)
HERE
chmod 0700  $remotescript

outlog=$netdelm$nodename/tmp/$locnodename$$.log
case $locnodename in
  $nodename)
    $remotescript $nodename $outlog ;;
  *)
    rexec  $remotescript $nodename $outlog -- /dev/null
esac

while  [ -f $remotescript ]
  do
    sleep 3 #  wait for shell script to finish
  done

cat $outlog | more
rm $outlog
