: 'retensions streamer tapes'
# Copyright 1986 Intel Corporation.
# 07/16/86 oer add lock logic
# NOTE: This routine is executed under Ar authority from Aasaveu1.ss or
#       Aasaveu2.ss and must not be changed in the field. To modify this 
#       routine will cause unit level restore to require root password
#       for execution unless a new Ar is generated.

if [ $# = 1 ]; then
	tape=$1
else
	tape=$CURDEV
fi
device=`Uselect -s : 3 0 $tape < /etc/drm/finder.rsrc`
if [ "$OPENNET" = "y" ]; then
	nodename=`Uselect -s : 2 0 $tape < /etc/drm/finder.rsrc`
	devnode=//$nodename
	echo " You are retensioning tapes on the $tape drive " \
		"on node $nodename"
else
	devnode=""
	echo " You are retensioning tapes on the $tape drive " 
fi

# name of the lock file
LOCK=$devnode/tmp/$CURDEV

# see if the device is in use
if [ -f $LOCK ] ; then
   set `cat $LOCK`
   menuid=$1
   owner=$2
   case $menuid in
      $MENUID) ;;	# It is us, everything is o.k.
      *)
	  echo "
 It is possible that the $CURDEV drive is in use by someone else.  Our
 information suggests that it is in use by a user whose login ID is $owner.
 It is recommended that you physically examine the drive to determine if it is
 in fact being used.

 You will be given an opportunity to go ahead with this operation.  If you
 do go ahead, and the $CURDEV drive IS in use it is possible that you will
 destroy any data that exists on $owner's media.\n"

	  while :
	  do
	      echo -n " Do you wish to go ahead with this operation (y or n)? "
	      read resp
	      case $resp in
		y*|Y*)	rm -f $LOCK
			break ;;
		n*|N*)	echo " Operation has been canceled."
			exit 1 ;;
		*)	echo "\n Invalid response <$resp>, please respecify"
	      esac
	  done
      ;;
   esac
fi

# remove lock when script exits (normally or abnormally)
trap "rm -f $LOCK; trap 0; exit" 0 1 2 3 15

# reserve the device
echo "$MENUID $LOGINID" > $LOCK
chmod 666 $LOCK

more=y
while [ "$more" = "y" ]
do
	echo -n " Please insert a tape to be retensioned.\n" \
		"Press return to start."
	read x
	echo -n " Retensioning tape, please wait ..."
	/iDISboot/Ar /bin/retension $devnode$device
	echo -n "\n retension another? (y or n): "
	read more
done
