:   Copyright 1986 Intel Corporation
#     Modify group or group workarea information
#
#   Parameter: 
#        1  -  Group name
#        2  -  y/n  (whether manager is modified)
#        3  -  manager name if $2=y
#        4  -  y/n
#        5  -  node name if $4=y
#        6  -  file system if $4=y
#
# 05/20/86  ugg  Initial
# 06/12/86  ugg  validate the home filesystem

# ignore quit signals
trap "" 1 2 3 15
#
Agrp=$1
if [ "$2" = "y" ] ; then
  Amgr=$3
fi
if [ "$4" = "y" ] ; then
    HomeNode=$5
    HomeFS=$6
    Grouptype=iDISGROUP
    #  First make sure the $HomeFS filesystem is valid.

    if [ "$OPENNET" = "y" ] ; then
       node=$HomeNode
       reference="the node $node"
       pattern=":file-system:$node:"
       command="$iDISBIN/Uselect -s : 3 2 $node"
       sedpat="$pattern"
       field=2
    else
       node=
       reference="this system"
       pattern=":file-system:"
       command="$iDISBIN/Uselect -s : 3"
       sedpat="$pattern\([^:]*\):"
       field=3
    fi

    if [ `grep ":file-system:" $MASNODEP/etc/drm/finder.rsrc | $command | grep -c "/dev/$HomeFS$" ` = 0 ] ; then
   
	 echo
         echo " 
The $HomeFS filesystem on $reference is not specified as a resource.
If the $HomeFS filesystem is present on $reference, you need to specify 
it as a 'file-system' type resource before you can define the group's home 
on $HomeFS filesystem.
	"

         if egrep "$pattern" $MASNODEP/etc/drm/finder.rsrc >/dev/null ; then 
            echo "
The following filesystem(s) are currently defined on $reference:
	"

            sed -n -e 's/^\([^:]*\)'$sedpat'\/dev\/\([^:]*\):.*$/'\\$field'/p' $MASNODEP/etc/drm/finder.rsrc | sort | pr -5 -w79 -t
         else
            echo "
No filesystems for $reference are specified in the iDIS resource 
specifications.
	"
         fi

         exit 1

    #
    else
         case $OPENNET in n) Home=/$HomeFS/$Agrp ;;
                          *) Home=//$HomeNode/$HomeFS/$Agrp ;;
         esac
    fi
else
  Grouptype=GROUP
fi
#
if [ "$Amgr" = "" ] && [ "$HomeNode" = "" ] ; then
  exit 0
fi

if [ "$Amgr" != "" ] ; then
   if egrep "^$Amgr:" $MASNODEP/etc/passwd > /dev/null 2>&1 ; then
      #
      # modify /etc/group and mailrc file to reflect the new manager
      #   First delete the login id from the group memberlist, if it is there 
      #
      sed -e "s/^\($Agrp::[^:]*:.*\)\($Amgr,\)\(.*\)$/\1\3/" \
          -e "s/^\($Agrp::[^:]*:.*\)\($Amgr,\)\(.*\)$/\1\3/" $MASNODEP/etc/group > $TMPDIR/group.tmp
      # cp $TMPDIR/group.tmp $MASNODEP/etc/group
      #
      #  Add the login as a manager
      #
      sed -e "s/^\($Agrp::[^:]*:\)\(.*\)$/\1$Amgr,\2/" $TMPDIR/group.tmp >$TMPDIR/group.tmp2
      cp $TMPDIR/group.tmp2 $MASNODEP/etc/group
      #
      #  Update the mailrc aliases
      #   First delete the login id from the mail aliases, if it is there 
      #
      sed -e "s/^\(alias $Agrp .*\)\( $Amgr\)\(.*\)$/\1\3/" $MASNODEP/usr/lib/mail/mailrc > $TMPDIR/mail.tmp
      # cp $TMPDIR/mail.tmp $MASNODEP/usr/lib/mail/mailrc
      #
      #  Add the login as a manager
      sed -e "s/^\(alias $Agrp \)\(.*\)$/\1$Amgr \2/" $TMPDIR/mail.tmp > $TMPDIR/mail.tmp2
      cp $TMPDIR/mail.tmp2 $MASNODEP/usr/lib/mail/mailrc
      #
      #   make sure the access rights are set right
      chmod 664 $MASNODEP/etc/group
      chmod 664 $MASNODEP/usr/lib/mail/mailrc
      #
      modified=yes
      rm $TMPDIR/group.tmp*
      rm $TMPDIR/mail.tmp*
   else
      echo "\nThe $Amgr login name is not a valid login name on this network."
      echo    "Please re-specify after checking for any spelling errors."
      exit 1
   fi
fi
#
#
ORIGIFS=$IFS
IFS=:
set `grep "^$Agrp:" $MASNODEP/etc/passwd`
type=$2
Agid=$3
comment=$4
Ahome=$5
      
IFS=$ORIGIFS
   
if [ "$Amgr" != "" ] ; then
   comment="Manager is $Amgr"
fi
if [ "$Grouptype" = "iDISGROUP" ] ; then
   type=iDISGROUP
   Ahome=$Home
fi

sed -e "/^\($Agrp:.*\)$/d" $MASNODEP/etc/passwd > $TMPDIR/passwd.tmp
   
echo "$Agrp:$type::$Agid:$comment:$Ahome:" >> $TMPDIR/passwd.tmp

cp $TMPDIR/passwd.tmp $MASNODEP/etc/passwd
rm $TMPDIR/passwd.tmp

# Build the raw transaction file, signal pending
>   /usr/tmp/$LOGINID.idisP
RAW=/usr/tmp/$LOGINID.idisW
cat <<-HERE >> $RAW
	#( Modify group $Agrp
	Ttype=Mod
	Kind=group 
	OPENNET="$OPENNET"
	MASNODE="$MASNODE"
	MASNODEP="$MASNODEP"
	Ausr="$Agrp"
	Auid="800"
	Amgr="$Amgr"
	Gid="$Agid"
	Aepw="$Grouptype"
	HomeNode="$HomeNode"
	HomeFS="$HomeFS"
	Home="$Home"
	export Ttype Kind OPENNET MASNODE Ausr Amgr Aepw HomeNode HomeFS
	export Home MASNODEP Auid Gid
	#) Modify group $Agrp
	HERE

chmod 666 /usr/tmp/$LOGINID.idisP
chmod 666 /usr/tmp/$LOGINID.idisW
exit 0
