: Copyright 1986 Intel Corporation.

# "Agrpv.ss", a shell script to display group information on the screen.

# 03/21/86  gll  Initial entry for iDIS R2.0.

# We do this until the user says to cancel, or we run out of groups.

# First, prime the loop.  If there is not at least one name (the invoking
# menu macro should insure this), we abort with an error message.

maxlines=19
maxcols=7
colwid=10
continue=yes
groupname=${1-absent}
grouplist=$*

if [ "$groupname" = "absent" ]
then echo "
$0: no group names specified!"
     exit 1
fi

# Enter the loop and process the first group name.

while [ "$continue" != "c" ]
do

# Clear the screen and indicate a slight pause.

$iDISBIN/Fclrscrn
echo "One moment please ..."

# Find the gid for this group.

gid=`$iDISBIN/Uselect -s : 2 0 $groupname < $MASNODEP/etc/group`

# Only do the rest if this is a real group

if [ "$gid" = "" ]
then echo "
No such group as \"$groupname\"!"

else

# Establish type of group (GROUP/USER LOGIN), (GROUP/NOLOGIN), 
# (GROUP/NO WORKAREA), (iDISGROUP WITH WORKAREA)
# (IMPROPERLY MADE XENIX GROUP)

pentry=`grep -c ${groupname}: $MASNODEP/etc/passwd`

password=`$iDISBIN/Uselect -s : 1 0 $groupname < $MASNODEP/etc/passwd`

case $password in   NOLOGIN) also="(GROUP/NOLOGIN)              "
                             alsof=y;;
                  iDISGROUP) also="(iDIS GROUP WITH WORKAREA)   "
                             alsof=y;;
                      GROUP) also="(iDIS GROUP WITHOUT WORKAREA)"
                             alsof=n;;
                          *) uid=`$iDISBIN/Uselect -s : 2 0 $groupname \
                                  < $MASNODEP/etc/passwd`
                             if [ "$uid" != "" ]
                             then also="(GROUP & USER LOGIN (uid=$uid))"
                                  alsof=y
                             else if [ $pentry -gt 0 ]
                                  then also="(IMPROPERLY MADE XENIX GROUP)"
                                       alsof=y
                                  else also="(XENIX GROUP ONLY)           "
                                       alsof=n
                                  fi
                             fi;;
esac

# Find the home path for the group workarea, or none if there
# is no workarea for this group.

if [ "$alsof" = "n" ]
then grphome="No workarea was created for this group."
else grphome=`$iDISBIN/Uselect -s : 5 0 $groupname < $MASNODEP/etc/passwd`
     if [ "$grphome" = "" ]
     then grphome="*** No home path found! ***"
     fi
fi

# Find the membership list (group manager is first one listed).

members=`$iDISBIN/Uselect -s : 3 0 $groupname < $MASNODEP/etc/group`

ORGIFS=$IFS
IFS=,
set $members LAST
IFS=$ORGIFS

# Now display the information nicely for the administrator.

newpage=y
mgrmsg="\n            (First one listed is the group Manager)"

while [ "$newpage" = "y" ]
do

$iDISBIN/Fclrscrn

echo "========================================================================

Group name: $groupname  $also Group id (gid): $gid

Home path for workarea: $grphome

========================================================================
                         Group Members $mgrmsg
"
if [ "$mgrmsg" != "" ]
then mgrmsg="(continued)"
     line=11
else line=10
fi

cnt=1
while [ "$1" != "LAST" ]
do

echo -n "$1"
memwid=`expr $1 : '.*'`
case $memwid in 1) echo -n "         ";;
                2) echo -n "        ";;
                3) echo -n "       ";;
                4) echo -n "      ";;
                5) echo -n "     ";;
                6) echo -n "    ";;
                7) echo -n "   ";;
                8) echo -n "  ";;
esac
shift
cnt=`$iDISBIN/Uinc $cnt`
if [ $cnt -gt $maxcols ]
then echo
     cnt=1
     line=`$iDISBIN/Uinc $line`
     if [ $line -gt $maxlines ]
     then echo "
===========
There are more group members -- press RETURN to continue list
  (\"n\" to go on to next group, \"c\" to cancel operation)"
          read resp
          if [ "$resp" = "c" ]
          then continue=c
               set LAST
          fi
          if [ "$resp" = "n" ]
          then set LAST
          fi
          break
     fi
fi
done

if [ "$1" = "LAST" ]
then newpage=n
fi

done

fi

# Now move to the next group, or quit if there are no more.

set $grouplist
shift
groupname=${1-absent}
grouplist=$*

if [ "$groupname" != "absent" ]
then crs=`$iDISBIN/Udec $maxlines $line`
     case $crs in 1) echo ;;
                  2) echo "\n";;
                  3) echo "\n\n";;
                  4) echo "\n\n\n";;
                  5) echo "\n\n\n\n";;
                  6) echo "\n\n\n\n\n";;
                  7) echo "\n\n\n\n\n\n";;
                  8) echo "\n\n\n\n\n\n\n";;
                  9) echo "\n\n\n\n\n\n\n\n";;
                 10) echo "\n\n\n\n\n\n\n\n\n";;
                 11) echo "\n\n\n\n\n\n\n\n\n\n";;
     esac
     echo -n "
Press RETURN to display information for the \"$groupname\" group,
        (\"c\" to cancel the remaining displays) "

     read continue
else continue=c
fi

done
echo
