: 'Copyright 1986 Intel Corp.'
# list the various nodes, and their types, in the sub-network

case $OPENNET in
   n)
      echo "
There is only this single node in a standalone (non-OpenNET) system.
"
      exit 0
   ;;
esac

echo "One moment please ..."

idisN=/usr/tmp/AUi$$
xenixN=/usr/tmp/AUx$$
xoN=/usr/tmp/AUxo$$
pN=/usr/tmp/AUp$$
sN=/usr/tmp/AUs$$
pcN=/usr/tmp/AUpc$$
output=/usr/tmp/AUout$$
trap "rm -f $idisN $xenixN $xoN $pN $sN; trap 0; exit" 0 1 2 3 15

{
echo "\t\t\tSub-Network Node Types"
LNM=`$iDISBIN/Uselect -s : 0 6 "The Logical Network Master" \
   < $MASNODEP/etc/drm/subnet`
echo "Logical Network Master is:
	$LNM\n"
echo "Sub-Network Master is:
	$MASNODE"

# get list of iDIS nodes and list of XENIX nodes
$iDISBIN/Uselect -s \: 2 1 idis < /etc/drm/finder.rsrc | sort -u > $idisN
$iDISBIN/Axnodes.ss > $xenixN
echo "\niDIS Execution Nodes are:"
pr -5 -w79 -t -o8 $idisN 2>/dev/null

# get list of nodes that are XENIX nodes, but not iDIS nodes
comm -23 $xenixN $idisN > $xoN
echo "\nUser Nodes are:"
pr -5 -w79 -t -o8 $xoN 2>/dev/null

# get list of public nodes
$iDISBIN/Uselect -s : 0 1 "Public Server" \
   < $MASNODEP/etc/drm/subnet > $pN
echo "\nPublic Server Nodes are:"
pr -5 -w79 -t -o8 $pN 2>/dev/null

# get list of SNRs
$iDISBIN/Uselect -s : 0 1 "Sub-Network" \
   < $MASNODEP/etc/drm/subnet > $sN
echo "\nSub-Network Receivers are:"
pr -5 -w79 -t -o8 $sN 2>/dev/null

# get list of PC nodes
$iDISBIN/Anetd1 < $MASNODEP/net/data > $pcN
echo "\nPC Nodes are:"
pr -5 -w79 -t -o8 $pcN 2>/dev/null

} > $output
$iDISBIN/Fclrscrn
more $output
exit 0
