/* A video object represents one video title, and entry in the 
   inventory of film titles. */!!

inherit(Object, #Video, #(title
quantityOnHand
minimumQuantity
reorderQuantity
unitPrice
manufacturer
phone
), 2, nil)!!

now(class(Video))!!

now(Video)!!

/* Calculates the total cost of a reorder. */
Def reorderCost(self)
{ ^reorderQuantity * unitPrice;
}
!!

/* Returns some of the video's fields in the form of 
  a string that can be used in a video list box. */
Def asLBString(self)
{ ^title + asString(Tab) + 
    right(asString(quantityOnHand), 5, " ") + 
    asString(Tab) + 
    "$" + format("%6.2lf", unitPrice);
}
!!

/* Returns the all the video's information in the form 
  of a string.  This string will become part of the 
  data exported to the Clipboard or to a file. */
Def asExportString(self)
{ ^title + asString(Tab) + 
    asString(quantityOnHand) + asString(Tab) + 
    asString(minimumQuantity) + asString(Tab) + 
    asString(reorderQuantity) + asString(Tab) + 
    asString(unitPrice) + asString(Tab) + 
    manufacturer + asString(Tab) +
    phone + asString(Tab);
}
!!

/* Returns the video information in the form of a 
  String that can be used in a reorder window. */
Def asReorderString(self)
{ ^left(title, 19, " ") + " " + 
    right(asString(reorderQuantity), 4, " ") + " $" + 
    format("%6.2lf", unitPrice) + " " +
    left(manufacturer, 19, " ") + " $" +
    format("%8.2lf", reorderQuantity * unitPrice);
}
!!

/* Loads the video from the specified file. */
Def load(self, aFile)
{ init(self, 
    readLine(aFile),
    asInt(readLine(aFile), 10),
    asInt(readLine(aFile), 10),
    asInt(readLine(aFile), 10),
    asReal(readLine(aFile)),
    readLine(aFile),
    readLine(aFile));
}
!!

/* Returns a string representing the total cost of 
  our current inventory of this video, such as
  "$ 44.50". */
Def costOfInventoryStr(self)
{ ^"$" + format("%6.2lf", quantityOnHand * 
    unitPrice);
}
!!

/* Adjusts the quantity on hand when videos are 
  shipped or received. */
Def ship(self, qty)
{ quantityOnHand := quantityOnHand - qty;
}
!!

/* Returns the quantity of videos with this title. */
Def quantityOnHand(self)
{ ^quantityOnHand;
}
!!

/* Returns the manufacturer's phone number. */
Def phone(self)
{ ^phone;
}
!!

/* Returns the manufacturer of the video. */
Def manufacturer(self)
{ ^manufacturer;
}
!!

/* Returns the reorder quantity. */
Def reorderQuantity(self)
{ ^reorderQuantity;
}
!!

/* Returns the minimum quantity. */
Def minimumQuantity(self)
{ ^minimumQuantity;
}
!!

/* Initializes a new Video object by setting the 
  object's instance variables to the values passed
  as arguments. */
Def init(self, tit, qtyOnHand, minQty, ordQty, price, man, phon)
{ title := tit;
  quantityOnHand := qtyOnHand;
  minimumQuantity := minQty;
  reorderQuantity := ordQty;
  unitPrice := price;
  manufacturer := man;
  phone := phon;
}
!!