/* Inherits common charting characteristics from VidChart.
   Adds behavior specific to vertical bar charts. */!!

inherit(VidChart, #VidVChart, #(/* No additional instance variables. */), 2, nil)!!

now(VidVChartClass)!!

now(VidVChart)!!

/* Resets the space between bars to a spacing 
  appropriate for vertical bar charts */
Def resetSpace(self)
{ space := 50;
}!!

/* Draws the labels at positions corresponding to
   the locations of the bars.  Converts the label
   into a string, in case it isn't one already. */
Def drawLabels(self, context | str, x, y)
{ y := asInt(y(area) - y(lead)+1);
  do(size(labels),
  {using(i) x := i*(x(scale)+space) + x(lead);
    str := asString(labels[i]);         /* label is string */
    drawText(self,x, y, str, context);  /* draw the label */
  });
}!!

/* Resets the scale to the proper scale for this 
  type of chart */
Def resetScale(self)
{ scale := point(20, 10);
}!!

/* Resets the lead to the proper value for this 
  chart. */
Def resetLead(self)
{ lead := point(10, 20);
}!!

/* Adjusts the scale based on the data and area.
   Makse the scale fit vertically.  */
Def adjustScale(self, max | y)
{ scale := point(20,(y(area) - 2 * y(lead)) / max);
}!!

/* Draws the data elements for the chart in a 
  vertical bar format.  The lead instance variable 
  will decide where the chart starts in relation to 
  the top and left side of the window.  The scale 
  instance variable will adjust the chart for window 
  resizing. */
Def drawData(self, context | dRect, x, y)
{ y := y(lead);
  do(size(data),
  {using(i) x := x(lead) + (i * (x(scale)+space));
    dRect:=rect(x+x(scale),y(area)-y(lead),x,
    asInt(y(area)-y(lead)-data[i]*y(scale)));
    fill(dRect, stock(GRAY_BRUSH), context);
  });
}!!
