
	   		// G06BASICDEFS.H

			//** Translated roughly from BCPL by bcpl2c.pl, 9/25/2005

         		//    ---- G06 basic structures ----


typedef short word;				// for i86, match orig Nova - 9/05 rgs 
typedef unsigned short uword;
typedef unsigned char byte;		// note: opposite endian

#ifndef offsetof
				  /* offset of Member in Structure */		// 9/05 rgs
#define offsetof(S,M) ((char *)&((S*)0)->M-(char*)(S*)0)	//
#endif


typedef struct {
	word VALUE;
	word RED;
	word GREEN;
	word BLUE;
} COLOR;

#define COLORLEN (4)
#define COLORPRIMASK (0377)


typedef struct 
{		// point array file header
	word FID;		// file identifier
	word SPARE1;

	word MODE;
	word SPARE3;
	word WINDOW;		// source window
	word SPARE5;

	word COLORTABPTR;
	word NUMVALS;
	word ALTCTABPTR;
	word NUMALTVALS;

	word VINTAGE;		// Reflects file format changes
                    		// 0 - old original format
                    		// 1 - 8 bits/primary in color table (~10/78)
                    		// 2 - reordered window def (~10/78)
                    		// 3 - added animation params (8/79)
	word ANSPEED;		// animation speed

	word FORMAT;		// tells how data is stored
                               		//     0 - runcoded
                               		//     1 - points (all runlengths =1)
                               		//     2 - 4 bits/point. 4 per word
                               		//     3 - 8 bits/point, 2 per word
                               		//     7 - rectangles, lsi layers format
                               		//     9 - flegal format: width, height, bits
	word DATAPTR;
	word NUMTABS;
	word SPARE15;

	word SPARE16;
	word SPARE17;
	word SPAREL8;
	word SPARE19;

	word ANMODE;		// animation mode
                                   		// 0 - none
                                   		// 1 - cycolors
                                   		// 2 - altcolors
                                   		// 3 - altcolors, hold
                                   		// 4 -
                                   		// 5 - colorchange tables
	word NUMFRAMES;	// number of frames in animation
	word CHANPTR;		// ptr to change vector
	word CHANTABPTR;	// ptr to change tables
} PAFH;

                    		// window, colors, animation tables, data
                    		//  follow (in that order)

#define PAFHLEN (24)		// header length (words)
#define CURPAFHVINTAGE (3)
               		// length of paf = pathlen
               		//   + winlen + 256colorlen
               		//   + numframes+1
               		//      + sum of chan!i for 0 to numframes (incl)
               		//   + numtabswindow>>win.h

#define PAFID (066666)		// file identifier = 0x6db6

typedef struct 
{		// Position
                             		//     must agree with Pos and Win
	word X;
	word Y;
} POS;

#define POSLEN (2)

typedef struct 
{		// rectangle
                             		//     must agree with Pos and Win
	word XORIG;
	word YORIG;
	word W;
	word H;
} GRECT;

#define GRECTLEN (4)


typedef struct 
{		// window
                            	//     must agree with Pos and Rect
	word XORIG;
	word YORIG;
	word W;
	word H;
	word XOFF;
	word YOFF;
} WIN;

#define WINLEN (6)


