
                     		// G06C.BCPL - GRAPHICS SYSTEM 06

			//** Translated roughly from BCPL by bcpl2c.pl, 9/28/2005

                     		// 1/21/75
                     		// Modified August 17, 1979


#include "G06DEFS.H"
#include "IOX.H"
#include "FREEDEFS.H"

#define GOYO (0120)		// GO button on tablet
#define GOXO (01240-040)	// put right next to Canvas, 9/05 rgs
#define GOH (0620)
#define GOW (0240)
#define DEFYO (0)		// DEFAULT button on tablet
#define DEFXO (GOXO)
#define DEFH (0120)
#define DEFW (GOW)

            word DEFMENU[] = {
                   		// XORIG  YORIG W  H
                      GOXO,  GOYO, GOW,  GOH,		// 0 - GO
                      DEFXO, DEFYO, DEFW, DEFH,		// 1 - DEFAULT
                      PMXLEFT, PMYBOT, PMWIDTH, PMHEIGHT };
            int DEFMENULEN = 3;
			VALTRANS VALUETABADD[256];
			char *CURFONT = NULL;



			void G06C_PROG() { }


                           		// ---- MISC ROUTINES ----


           void CLEARPM(N,VALUE,WINDOW,MODE) 
				WIN WINDOW;
		   {/*C*/ 
				int WX,W,H,NT,R,I,K; 
				RUNCODE *pRUNTAB; WIN *pWN=&WINDOW;

              switch (N) {/*1*/ 
                  case 0: EXIO(0,XXNIOC + XXPM0); break;
                  case 1: pWN = PMWINDOW;
                  case 2: MODE = BOTHQ;
                  case 3: { WX = pWN->XORIG;
                        W = pWN->W; H = pWN->H;
                        NT = W/255; R = W%255;
                        pRUNTAB = GETBLOCKX(H);
                        for (I=0; I<=H-1; I++) pRUNTAB[I].VALUE = VALUE;
                        for (K=NT; K>=0; K--) {
                           for (I=0; I<=H-1; I++) pRUNTAB[I].RUN = ((K>0) ? 255:R);
                           RUNTABSTOPM(4,*pWN,pRUNTAB,1,MODE);
                           pWN->XORIG = pWN->XORIG + 255;
                                     }
                        PUTBLOCK(pRUNTAB);
                        pWN->XORIG = WX;
                               }
                        break;
                  default: ERROR(2,"CLEARPM",0); }/*1*/
            }/*C*/ 


           void SETPMCONFIG(N,A1,A2) {
			   word T[] = { 0, 1, 010, 011 };

		       switch (N) { 
                  case 0: EXIO(0,XXDOA + XXPM3);
                     EXIO(0,XXDOA + XXPM2);
                     EXIO(0,XXDOA + XXPM4);
                     break;
                  case 2: switch (A1) 
                      { case 0: EXIO(T[A2] << 8,XXDOA+XXPM2);	// input switch
                           break;
                        case 3: EXIO(A2 << 12,XXDOA + XXPM4);	// color table addr
                           break;
                        default: ERROR(1,"SETPMCONFIG"); }
                     break;
				  default: ERROR(2,"SETPMCONFIG",0); } 
				}

                  		// Al = 0: SET INPUT SWITCH
                  		// A2 = 0: 8 BITS FROM NOVA
                  		//      1: 8 BITS FROM A/D
                  		//      2: 8 BITS FROM NOVA, SWAP Q0 AND Q1
                  		//      3: 8 BITS FROM A/D, SWAP Q0 AND Q1
                  		// Al = 3: SET COLOR MAP INPUT
                  		// A2 = 0: 8 BITS (Q0 AND Ql)
                  		//    #10: 4 BITS (Q1 ONLY)
                  		//    #14: 4 BITS (Q0 ONLY)
                  		//  + #01: AND DIM MAP0 TO HALF


            void CHANGEVAL(N,WIN,V1,V2,NEWVAL,MODE) 
				WIN WIN; word V1,V2,NEWVAL,MODE;
			{/*CH*/ 
				RUNCODE *RT; word *XT, OLDVAL; int NT, I;
                word BITS=0,MASK=0;

                if (N == 4) MODE = BOTHQ;
                switch (MODE) {
                   case Q0: BITS = 010000; MASK = 07400; break;
                   case Q1: BITS = 000400; MASK = 0170000; break;
                   case BOTHQ: BITS = 010400; MASK = 0; break;
                   default: ERROR(2,"CHANGEVAL",0); break; };
                if (0 && WIN.H == PMHEIGHT && WIN.W == PMWIDTH)	// no SP hardware, 9/05 rgs
                   { for (OLDVAL=V1; OLDVAL<=V2; OLDVAL++)
					{  PMVIWAIT(1);
                       EXIO(0,XXDOA + XXPM3);
                       EXIO(MASK,XXDOB + XXPM3);
                       EXIO(OLDVAL << 8,XXDOC + XXPM3);
                       EXIO(NEWVAL << 8,XXDOC + XXPM0);
                       EXIO(BITS,XXDOA + XXPM3);
                       PMVIWAIT(2);
                       EXIO(0,XXDOA + XXPM3); }
                           }
				else {
                       RT = GETBLOCKX(WIN.H);
                       XT = GETBLOCKX(WIN.H);
                       STUFFVEC(2,XT,WIN.H);
                       NT = 0;
                       do {
					   NT = PMTORUNTABS(6,WIN,RT,1,MODE,XT,FALSE);
                       for (I=V1; I<=V2; I++) SETVALTRANSTAB(2,I,NEWVAL);
                       if (!(NT < 1)) RUNTABSTOPM(6,WIN,RT,1,MODE,XT,TRUE);
                              } while (NT > 0);
                       PUTBLOCK(XT);
                       PUTBLOCK(RT);
                       INITVALTRANSTAB(0);
                           }
                              }/*CH*/ 


            void TTYWAIT(N,MESS,STRIN) 
				char MESS[], *STRIN;
              {/*T*/ 
				FILE *TTI, S[256];

                if (N >= 1) WRITEFORM(1,0,MESS);
                TTI = OPEN("$TTI");
                if (N < 2) STRIN = (char*)S;
                READLINE(TTI,STRIN);
                CLOSE(TTI);
				  }/*T*/ 


			int MIN(N1,N2) { return ((N1<=N2) ? N1:N2); }

			int MAX(N1,N2) { return ((N1>=N2) ? N1:N2); }

            int CHECKMINMAX(V,MINV,MAXV)
				{ return ((V<MINV) ? MINV:((V>MAXV) ? MAXV:V)); }

            int ABSVAL(N) { return ((N<0) ? -N:N); }


			void ERROR(N,NAME,MESSAGENUMBER) 
				char *NAME;
			{
 			  char *MESSAGE;
              if (N < 2) MESSAGENUMBER = 99;

               switch (MESSAGENUMBER) {
                   case 0: MESSAGE = "--INCORRECT ARGUMENTS";
                   case 1: MESSAGE = "--FILE IS NOT A PA FILE";
                   default: MESSAGE = " ";
			   }
               WRITEFORM(3,0,"ERROR: ",0,NAME,0,MESSAGE);
               if (MESSAGENUMBER >= 0)
                 {
                   RESETFILES(); FINISH();
                 }
               }


           void SETVALTRANSTAB(N,VALUE,NEWVALUE) {
               switch (N) {
               case 1: VALTRANSTAB[VALUE].ISNULL = FALSE;
                   break;
               case 2: if (NEWVALUE == -1)
                      VALTRANSTAB[VALUE].ISNULL = TRUE;
				   else { VALTRANSTAB[VALUE].VALUE = NEWVALUE;
						  VALTRANSTAB[VALUE].ISNULL = FALSE; }
                   break;
               default: ERROR(2,"SETVALTRANSTAB",0); };
               }


           void INITVALTRANSTAB(N,SOMETABLE) 
				VALTRANS *SOMETABLE;
		   {
			   int I;

               switch (N) {
               case 0: for (I=0; I<=255; I++) 
					   { VALTRANSTAB[I].VALUE = I; VALTRANSTAB[I].ISNULL = 0; }
                   break;
               case 1: for (I=0; I<=255; I++) 
					   { VALTRANSTAB[I].VALUE = SOMETABLE[I].VALUE;
						 VALTRANSTAB[I].ISNULL = SOMETABLE[I].ISNULL; }
				   break;
               default: ERROR(2,"INITVALTRANSTAB",0); }
			}


           void INITGSYS(N,M) {
               INITBCPLIO(2);
               INITFREESTORE(500);
               PMWINDOW = GETBLOCKX(WINLEN);
               FILLWIN(7,PMWINDOW,PMXMID,PMYMID,PMWIDTH,PMHEIGHT,PMXMID,PMYMID);
               FIELDMODE = BOTHFIELDS;
               VALTRANSTAB = VALUETABADD;
               INITVALTRANSTAB(0);
               TABGRID = 0;

               if (!(N > 0)) SETPMCONFIG(0);
				 }

                                                                                                    
            void OVERLAY(FNAME) {
               FILE *pF;
               word HEADER[15];		// program overlay
				return;				// not used, 9/05 rgs
			   pF = OPEN(FNAME);
               READSEQ(pF,&HEADER,2*16);
			   swapbytes(&HEADER,16);	//??
               READSEQ(pF,HEADER[0],HEADER[1]);
               CLOSE(pF);
                              }


            word FINDMENU(P,pMENU,MENULEN) 
				POS P; word *pMENU;
             {/*FM*/ 
				 word *MP; int I;

				 for (I=0; I<=MENULEN-1; I++) {
                  MP = pMENU+4*I;
                  if (P.X >= MP[0] &&
                    P.X < MP[0]+MP[2] &&
                    P.Y >= MP[1] &&
                    P.Y < MP[1]+MP[3])
                  return (I);
                        }
               return (-1);
                            }/*FM*/ 


            void FILLWIN(N,pWN,XORIG,YORIG,W,H,XOFF,YOFF)
				WIN *pWN;
              {
               pWN->XORIG = XORIG;
               pWN->YORIG = YORIG;
               if (N < 4) return; 
               pWN->W = W;
               pWN->H = H;
               if (N < 6) return; 
               pWN->XOFF = XOFF;
               pWN->YOFF = YOFF;
                        }


            void STUFFVEC(N,V,VLEN,i0,i1,i2,i3,i4,i5,i6,i7,i8) 
				word *V;
			{
				word I,J,*P;

               switch (N) {
                 case 2: for (I=0; I<=VLEN-1; I++) V[I] = 0;
                  break;
                 default:
              { P = V+2; J = 0;
               N = N-2;
               for (I=0; I<=VLEN-1; I++)
                { V[I] = P[J];
				J = ((J < N-1) ? J+1:0); } }
                            }
                               }




