
					// SFILL.BCPL - area fill

			//** Translated roughly from BCPL by bcpl2c.pl, 10/5/2005

#include "G06DEFS.H"
#include "IOX.H"
#include "FREEDEFS.H"


          		//pb february 23, 74
          		//fast area filling program
          		//MODS BY RGS 7/8/74


#define false FALSE
#define true TRUE
word userpanic();
void writestripe();
void readstripe();
void fillstripe();
void doupstripe();
void dodownstripe();
void overflow();
void storesegment();
word getsegment();
void storeupstripe();
void storedownstripe();
word next();
word check();
void findsegment(); 

word mode;
word newvalue;
word oldvalue;

word *segmenty;
word *segmentl;
word *segmentr;
word *upstripej;
word *upstripel;
word *upstriper;
word *downstripej;
word *downstripel;
word *downstriper;
word *nextleft;
word *nextright;
word spointer;
word upointer;
word dpointer;
word npointer;
word cpointer;
word up;
word down;

word *window;
word *runtable;
word lineread;

word nbsm1;
word nbstripes;
word laststripesize;
word sts;
word stsm1;
word runtabsize;
word stacktop = 100;
word stripesize = 40;
word linesize = 100;


void SFILL_PROG() { INITGSYS(); }



          void SFILL(word n, POS point2, word newval, word fillmode) 
            {/*0*/ 
				word j, *bos;

                   		//buffer allocation
                   GETBLOCK(16000);         		// SET AVAILMAX
                   stripesize = (AVAILMAX-12*stacktop)/linesize-1;

                   runtabsize = stripesize*linesize;
                   nbsm1 = 480/stripesize; 		//careful
                   laststripesize = 480 % stripesize;
                   nbstripes = nbsm1+1;
                   bos = GETBLOCKX(runtabsize + 12*stacktop);

                   window = bos+runtabsize+12*stacktop-10;
                   runtable = window-runtabsize;

                   segmenty = runtable-stacktop;
                   segmentl = segmenty-stacktop;
                   segmentr = segmentl-stacktop;
                   upstripej = segmentr-stacktop;
                   upstripel = upstripej-stacktop;
                   upstriper = upstripel-stacktop;
                   downstripej = upstriper-stacktop;
                   downstripel = downstripej-stacktop;
                   downstriper = downstripel-stacktop;
                   nextleft = downstriper-stacktop;
                   nextright = nextleft-stacktop;

                   ((WIN*)window)->XORIG = 0;
                   ((WIN*)window)->W = 640;
                   ((WIN*)window)->YOFF = 0;
                   ((WIN*)window)->XOFF = 0;
                   spointer = -1; upointer = -1; dpointer = -1; npointer = -1;

                   mode = fillmode;
                   newvalue = newval;

                   if (n < 3) mode = BOTHQ;
                    oldvalue = RPMPOINT(point2,mode);
                    if (!(oldvalue == newvalue)) 
			 {/*1*/ 
                    j = (point2.Y)/stripesize;
                    readstripe(j);
                    up = false; down = false;
                    fillstripe(j,(point2.Y) % stripesize,(point2.X),(point2.X));
                    writestripe();

                    do { if (upointer >= 0)
                        {
                              if (userpanic()) break;
                              doupstripe(upstripej[upointer]); }
                      else if (dpointer >= 0)
                              {
                              if (userpanic()) break;
                              dodownstripe(downstripej[dpointer]); }
                      else break; } while (1);
               }/*1*/ 
                   PUTBLOCK(bos);
          }/*0*/ 


          word userpanic()  {
                   POS P; PENSTAT S;
                   READTABLET(&P,&S);
                   return (S.DOWN);
          }

          void writestripe() {
                   RUNTABSTOPM(4,*(WIN*)window,(RUNCODE*)runtable,lineread,mode);
          }

          void readstripe(j) {
                   		//define window position (stripe j)
                   ((WIN*)window)->YORIG = j*stripesize;
                   sts = (j == nbsm1) ? laststripesize: stripesize;
                   stsm1 = sts-1;
                   ((WIN*)window)->H = sts;
                   runtabsize = sts*linesize;
                   lineread = PMTORUNTABS(4,*(WIN*)window,(RUNCODE*)runtable,linesize,mode);
                   }

          void fillstripe(j,ys,xl,xr) {
                   int y=ys, xleft=xl, xright=xr;
                   findsegment(y,xleft,xright);
                   while (getsegment(&y, &xleft, &xright)) {
                        if (y < stsm1) findsegment(y+1,xleft,xright);
                          else if (down ? check(xleft): (j < nbsm1))
                                 storeupstripe(j+1,xleft,xright);
                           if (y > 0) findsegment(y-1,xleft,xright);
                            else if (up ? check(xleft): (j > 0))
                                 storedownstripe(j-1,xleft,xright);
                           }
                     }

		  void doupstripe(j) {
                     int rght=0, lft=0;
                     up = true; down = false;
                     while ((upointer >= 0) && (upstripej[upointer] == j)) {
                           npointer = npointer+1;
                           nextleft[npointer] = upstripel[upointer];
                           nextright[npointer] = upstriper[upointer];
                           upointer = upointer-1;
                           }
                     cpointer = npointer;
                     readstripe(j);
                     while (next(&lft,&rght)) fillstripe(j,0,lft,rght);
                     writestripe();
                     }

           void dodownstripe(j) {
                     int lft=0, rght=0;
                     up = false; down = true;
                     while ((dpointer >= 0) && ((downstripej[dpointer]) == j)) {
                           npointer = npointer+1;
                           nextleft[npointer] = downstripel[dpointer];
                           nextright[npointer] = downstriper[dpointer];
                           dpointer = dpointer-1;
                           }
                     cpointer = npointer;
                     readstripe(j);
                     while (next(&lft, &rght)) fillstripe(j,stsm1,lft,rght);
                     writestripe();
                     }

           void overflow() {
                     WRITEFORM(1,0,"Sorry, I can't do this all at one time... try again");
                           }

           void storesegment(y,left,right) {
                     if (spointer == stacktop) overflow();
                       else { spointer = spointer+1;
                           segmenty[spointer] = y;
                           segmentr[spointer] = right;
                           segmentl[spointer] = left;
                           }
                     }

           word getsegment(int *yad, int *lad, int *rad)  {
                     		//returns false if stack is empty, true otherwise
                     if (spointer < 0) return (false);
                       else { *yad = segmenty[spointer];
                           *lad = segmentl[spointer];
                           *rad = segmentr[spointer];
                           spointer = spointer-1;
                           return (true);
                           }
                     }

           void storeupstripe(j,left,right) {
                     if (upointer == stacktop) overflow();
                       else { upointer= upointer+1;
                           upstripej[upointer] = j;
                           upstripel[upointer] = left;
                           upstriper[upointer] = right;
                           }
                     }

           void storedownstripe(j,left,right) {
                     if (dpointer == stacktop) overflow();
                     else { dpointer = dpointer+1;
                         downstripej[dpointer] = j;
                         downstripel[dpointer] = left;
                         downstriper[dpointer] = right;
                         }
                   }

          word next(int *lad, int *rad)  {
                   if (npointer < 0) return (false);
                     else { *lad = nextleft[npointer];
                         *rad = nextright[npointer];
                         npointer = npointer-1;
                         return (true);
                         }
                   }

          word check(left)  {
				   int i;
                   for (i=0; i<=cpointer; i++)
                         if (left == nextleft[i]) return (false);
                   return (true);
                   }

          void findsegment(y,leftseed,rightseed) {/*1*/ 
                   int x=leftseed, r=y, z=-1, xl, xr, i;
                   while (r <= runtabsize) {/*10*/ 
                         z = z+((RUNCODE*)runtable)[r].RUN;
                         if (z >= x) break;
                         r = r+sts;
                         }/*10*/ 
                   while (x <= rightseed) {/*2*/ 
                         if (((RUNCODE*)runtable)[r].VALUE == oldvalue) {/*3*/ 
                           xl=z+1, xr=z, i=r;
                           while (i >= 0) {/*4*/ 
                              if (((RUNCODE*)runtable)[i].VALUE != oldvalue) break;
                              ((RUNCODE*)runtable)[i].VALUE = newvalue;
                              xl = xl-(((RUNCODE*)runtable)[i].RUN);
                             i = i-sts;
                             }/*4*/ 
                           i = r+sts;
                           while (i < runtabsize) {/*5*/    		//*
                              if (((RUNCODE*)runtable)[i].VALUE != oldvalue) break;
                              r=i;
                              ((RUNCODE*)runtable)[i].VALUE = newvalue;
                              xr = xr+(((RUNCODE*)runtable)[i].RUN);
                             i = i+sts;
                             }/*5*/ 
                           storesegment(y,xl,xr);
                           z = xr;
                           }/*3*/ 
                         x = z+1;
                         r = r+sts;
                         z = z+(((RUNCODE*)runtable)[r].RUN);
                         }/*2*/ 
                   }/*1*/ 


