/****************************************************************************
*   Copyright 1999, Caldera Thin Client Systems, Inc.                       *
*   This software is licensed under the GNU Public License                  *
*   For further information, please see LICENSE.TXT                         *
*                                                                           *
*   Historical Copyright                                                    *
*                                                                           *
*   Copyright (c) 1985, 1987, 1991, 1992 Digital Research Inc.		    *
*   All rights reserved.						    *
*   The Software Code contained in this listing is proprietary to Digital   *
*   Research Inc., Monterey, California, and is covered by U.S. and other   *
*   copyright protection.  Unauthorized copying, adaption, distribution,    *
*   use or display is prohibited and may be subject to civil and criminal   *
*   penalties.  Disclosure to others is prohibited.  For the terms and      *
*   conditions of software code use, refer to the appropriate Digital       *
*   Research License Agreement.						    *
*****************************************************************************
*		      U.S. GOVERNMENT RESTRICTED RIGHTS			    *
*                    ---------------------------------                      *
*  This software product is provided with RESTRICTED RIGHTS.  Use, 	    *
*  duplication or disclosure by the Government is subject to restrictions   *
*  as set forth in FAR 52.227-19 (c) (2) (June, 1987) when applicable or    *
*  the applicable provisions of the DOD FAR supplement 252.227-7013 	    *
*  subdivision (b)(3)(ii) (May 1981) or subdivision (c)(1)(ii) (May 1987).  *
*  Contractor/manufacturer is Digital Research Inc. / 70 Garden Court /     *
*  BOX DRI / Monterey, CA 93940.					    *
*****************************************************************************
* $Header: m:/davinci/users//groups/panther/aes/rcs/gemaplib.c 4.3 92/03/12 11:24:40 sbc Exp $
z* $Log:	gemaplib.c $
 * Revision 4.3  92/03/12  11:24:40  sbc
 * Merge in Keiko Hatamori's changes required for Double-Byte Character Support
 * 

 *	Optimized by DRJ for ViewMAX. (#if GEM)	11/26/91	K.H	
     
 * Revision 4.2  92/02/27  15:22:18  rsf
 * Conversion to medium model. Replace GEM.H with VIEWRUN.H
 * 
 * Revision 4.2  92/02/03  11:23:53  Fontes
 * Conversion to medium model. Replace GEM.H with VIEWRUN.H
 * 
 * Revision 4.1  92/01/03  13:15:18  Fontes
 * Susan's cleanup
 * 
 * Revision 4.0  91/09/05  11:40:56  system
 * Prototyping and cleanup plus fix to file selector
 * 
*****************************************************************************/

#include "portab.h"
#include "machine.h"
#include "struct.h"
#include "basepage.h"
#include "obdefs.h"
#include "gemlib.h"
#include "viewrun.h"
#include "cproto.h"
#include "aproto.h"

#define TCHNG 0
#define BCHNG 1
#define MCHNG 2
#define KCHNG 3

EXTERN WORD		gl_ticktime;

EXTERN LONG		ad_valstr;
EXTERN LONG		ad_armice;
EXTERN LONG		ad_sysglo;

EXTERN BYTE		gl_logdrv;

GLOBAL WORD		gl_play;
GLOBAL WORD		gl_recd;
GLOBAL WORD		gl_rlen;
GLOBAL LONG		gl_rbuf;

/*
*	Routine to initialize the application
*/
WORD ap_init( void )
{
	WORD		pid;
#if GEM	
	LONG		scdir;
#endif

	pid = rlr->p_pid;
#if GEM    
	rs_gaddr(ad_sysglo, R_STRING, STSCDIR, &scdir);
	LBSET(scdir, gl_logdrv);		/* set drive letter	*/
	sc_write(scdir);
#endif	
	return( pid );
}


/*
*	APplication READ or WRITE
*/
	VOID
ap_rdwr(code, p, length, pbuff)
	WORD		code;
	REG PD		*p;
	WORD		length;
	LONG		pbuff;
{
	QPB		m;
						/* do quick version if	*/
						/*   it is standard 16	*/
						/*   byte read and the	*/
						/*   pipe has only 16	*/
						/*   bytes inside it	*/
	if ( (code == MU_MESAG) &&
	     (p->p_qindex == length) &&
	     (length == 16) )
	{
	  fmemcpy((BYTE FAR *)pbuff, (BYTE FAR *)p->p_qaddr, p->p_qindex);
	  p->p_qindex = 0;
	}
	else
	{
	  m.qpb_ppd = p;
	  m.qpb_cnt = length;
	  m.qpb_buf = pbuff;
	  ev_block(code, ADDR(&m));
	  }
}

/*
*	APplication FIND
*/
	WORD
ap_find(pname)
	LONG		pname;
{
	REG PD		*p;
	BYTE		temp[9];

	fstrcpy((BYTE FAR *)temp, (BYTE FAR *)pname);
 
	p = fpdnm(&temp[0], 0x0);
	return( ((p) ? (p->p_pid) : (-1)) );
}

void ap_exit( void )
{
	wm_update(TRUE);

	mn_clsda();

	if (rlr->p_qindex)
	  ap_rdwr(MU_MESAG, rlr, rlr->p_qindex, ad_valstr);
	gsx_mfset(ad_armice);
	wm_update(FALSE);
	all_run();
}

/* gemaplib.c */
