/****************************************************************************
*   Copyright 1999, Caldera Thin Client Systems, Inc.                       *
*   This software is licensed under the GNU Public License                  *
*   For further information, please see LICENSE.TXT                         *
*                                                                           *
*   Historical Copyright                                                    *
*                                                                           *
*   Copyright (c) 1985, 1987, 1990, 1991, 1992  Digital Research Inc.	    *
*   All rights reserved.						    *
*   The Software Code contained in this listing is proprietary to Digital   *
*   Research Inc., Monterey, California, and is covered by U.S. and other   *
*   copyright protection.  Unauthorized copying, adaption, distribution,    *
*   use or display is prohibited and may be subject to civil and criminal   *
*   penalties.  Disclosure to others is prohibited.  For the terms and      *
*   conditions of software code use, refer to the appropriate Digital       *
*   Research License Agreement.						    *
*****************************************************************************
*		      U.S. GOVERNMENT RESTRICTED RIGHTS			    *
*                    ---------------------------------                      *
*  This software product is provided with RESTRICTED RIGHTS.  Use, 	    *
*  duplication or disclosure by the Government is subject to restrictions   *
*  as set forth in FAR 52.227-19 (c) (2) (June, 1987) when applicable or    *
*  the applicable provisions of the DOD FAR supplement 252.227-7013 	    *
*  subdivision (b)(3)(ii) (May 1981) or subdivision (c)(1)(ii) (May 1987).  *
*  Contractor/manufacturer is Digital Research Inc. / 70 Garden Court /     *
*  BOX DRI / Monterey, CA 93940.					    *
*****************************************************************************
* $Header: m:/davinci/users//groups/panther/aes/rcs/gemctrl.c 4.4 92/03/16 12:32:18 sbc Exp $
* $Log:	gemctrl.c $
 * Revision 4.4  92/03/16  12:32:18  sbc
 * Merge in Keiko's changes from Jan 17
 * 
 *
 * From Keiko Hatamori 920107: The number of D.w_win structure is NUM_WIN,
 * but hctl_keybd() checked D.w_win[NUM_WIN] (one too many for zero-based).
 *
 * Revision 4.3  92/03/12  12:04:00  sbc
 * Merge in RSF's changes for click to top and select and icons on desktop.
 * 
 * Revision 4.3  92/03/04  14:15:10  Fontes
 * Enhance WM_TOPPED message to include mouse coordinates
 * 
 * Revision 4.2  92/02/27  15:21:41  rsf
 * Conversion to medium model. Replace GEM.H with VIEWRUN.H
 * 
 * Revision 4.3  92/01/27  16:09:53  Fontes
 * LONG -> TREE for trees, plus some cleanup and commenting
 * 
 * Revision 4.2  92/01/03  13:15:35  Fontes
 * Susan's cleanup
 * 
 * Revision 4.1  91/11/08  12:56:32  anderson
 * Reduce minimum window size a bit.
 * 
 * Revision 4.0  91/09/05  11:40:10  system
 * Prototyping and cleanup plus fix to file selector
 * 
*/

#include "portab.h"
#include "machine.h"
#include "struct.h"
#include "basepage.h"
#include "obdefs.h"
#include "gemlib.h"
#include "gemkeybd.h"
#include "cproto.h"
#include "aproto.h"

#define FIXLATER	0

#define THEDESK 3

#define MBDOWN 0x0001
#define BELL 0x07				/* bell			*/

extern TREE	gl_mntree;
extern PD	*gl_mnppd;
extern WORD	gl_dabox;
extern PD	*desk_ppd[];


extern TREE	gl_awind;

extern WORD	gl_wtop;
extern WORD	gl_wbox;
extern WORD	gl_hbox;
extern GRECT	gl_rmenu;

extern WORD	button, xrat, yrat;
extern PD 	*gl_mowner;
extern LONG	ad_armice, ad_mouse;
extern WORD	gl_moff;

extern BOOLEAN  root_on_top;

extern THEGLO	D;

GLOBAL MOBLK	gl_ctwait;
GLOBAL WORD	gl_ctmown;

GLOBAL WORD	appl_msg[8];
						/* used to convert from	*/
						/*   window object # to	*/
						/*   window message code*/
GLOBAL WORD	gl_wa[] =
{
	WA_UPLINE,
	WA_DNLINE,
	WA_UPPAGE,
	WA_DNPAGE,
	0x0,
	WA_LFLINE,
	WA_RTLINE,
	WA_LFPAGE,
	WA_RTPAGE
};


MLOCAL WORD		gl_tmpmoff;


/*----------------------------------------------------------------------
*	Send message and wait for the mouse button to come up
*/
void ct_msgup( WORD message, PD * owner, WORD wh, 
			    WORD m1, WORD m2, WORD m3, WORD m4)
{
	if (message == NULL)
	  return;

	ap_sendmsg(appl_msg, message, owner, wh, m1, m2, m3, m4);
						/* wait for button to	*/
						/*   come up if not an	*/
						/*   an arrowed message	*/
	if ( message != WM_ARROWED &&
	   ( message != WM_CLOSED &&
	   !(D.w_win[wh].w_kind & HOTCLOSE) ) )
	{
	  while( (button & 0x0001) != 0x0 )
	    dsptch();
	}
}

/*----------------------------------------------------------------------
*
*/
MLOCAL void hctl_window( WORD w_handle, WORD mx, WORD my )
{
	GRECT		t, f, pt;
	WORD		x, y, w, h, ii;
	WORD		kind;
	REG WORD	cpt, message;
	TREE		tree;
	
	message = 0;
	if ( (w_handle == gl_wtop) || (D.w_win[gl_wtop].w_cotop == w_handle) ||
	     ( (D.w_win[w_handle].w_flags & VF_SUBWIN) &&
	       (D.w_win[gl_wtop].w_flags & VF_SUBWIN) )  )
	{
						/* went down on active	*/
						/*   window so handle	*/
						/*   control points	*/
	  w_bldactive(w_handle);
	  tree = gl_awind;
	  cpt = ob_find(gl_awind, 0, 10, mx, my);
	  w_getsize(WS_CURR, w_handle, &t);
	  r_get(&t, &x, &y, &w, &h);
	  kind = D.w_win[w_handle].w_kind;
	  switch(cpt)
	  {
	    case W_CLOSER:
		if ( kind & HOTCLOSE )
		{
		  message = WM_CLOSED;
		  break;
		}
						/* else fall thru	*/
	    case W_FULLER:
					/* Lest the app change its top	*/
					/*  wrongly.			*/
		if (w_handle != gl_wtop)
			w_handle = gl_wtop;

		if ( gr_watchbox(gl_awind, cpt, SELECTED, NORMAL) )
		{
		  message = (cpt == W_CLOSER) ? WM_CLOSED : WM_FULLED;
		  ob_change(gl_awind, cpt, NORMAL, TRUE);
		}
		break;
	    case W_NAME:
	        if ( kind & MOVER )
		{
		  r_set(&f, 0, gl_hbox, 10000, 10000);
		  gr_dragbox(w, h, x, y, &f, &x, &y);
		  message = WM_MOVED;
		}
		break;
	    case W_SIZER:
	    	if (kind & SIZER)
		{
		  w_getsize(WS_WORK, w_handle, &t);
		  t.g_x -= x;
		  t.g_y -= y;
		  t.g_w -= w;
		  t.g_h -= h;
#if 0	/* (hca: allow smaller minimum window size) */
		  gr_rubwind(x, y, 7 * gl_wbox, 7 * gl_hbox, &t, &w, &h);
#else
		  gr_rubwind(x, y, 6 * gl_wbox, 6 * gl_hbox, &t, &w, &h);
#endif	      
		  message = WM_SIZED;
		}
		break;
	    case W_HSLIDE:
	    case W_VSLIDE:
		ob_actxywh(tree, cpt + 1, &pt);
		if ( cpt == W_HSLIDE )
		{
						/* APPLE change		*/
		  pt.g_y -= 2;
		  pt.g_h += 4;
		  if ( inside(mx, my, &pt) )
		  {
		    cpt = W_HELEV;
		    goto doelev;
		  }
						/* fix up for index	*/
						/*   into gl_wa		*/
		  if ( !(mx < pt.g_x) )
		    cpt += 1;
		}
		else
		{
		  pt.g_x -= 3;
		  pt.g_w += 6;
		  if ( inside(mx, my, &pt) )
		  {
		    cpt = W_VELEV;
		    goto doelev;
		  }
		  if ( !(my < pt.g_y) )
		    cpt += 1;
		}
						/* fall thru		*/
	    case W_UPARROW:
	    case W_DNARROW:
	    case W_LFARROW:
	    case W_RTARROW:
		message = WM_ARROWED;
		break;
	    case W_HELEV:
	    case W_VELEV:
doelev:		message = (cpt == W_HELEV) ? WM_HSLID : WM_VSLID;
		ob_relxywh(tree, cpt - 1, &pt);
		if ( message == WM_VSLID )
		{
		  pt.g_x += 3;		/* APPLE	*/
		  pt.g_w -= 6;
		  (tree+(cpt-1))->ob_x = pt.g_x ;
		  (tree+(cpt-1))->ob_width = pt.g_w ;
		}
		else
		{
		  pt.g_y += 2;		/* APPLE	*/
		  pt.g_h -= 4;
		  (tree+(cpt-1))->ob_y = pt.g_y ;
		  (tree+(cpt-1))->ob_height = pt.g_h ;
		}
		x = gr_slidebox(gl_awind, cpt - 1, cpt, (cpt == W_VELEV));
		if ( message == WM_VSLID )
		{
		  pt.g_x -= 3;
		  pt.g_w += 6;
		  (tree+(cpt-1))->ob_x = pt.g_x ;
		  (tree+(cpt-1))->ob_width = pt.g_w ;
		}
		else
		{
		  pt.g_y -= 2;
		  pt.g_h += 4;
		  (tree+(cpt-1))->ob_y = pt.g_y ;
		  (tree+(cpt-1))->ob_height = pt.g_h ;
		}
					/* slide is 1 less than elev	*/
		break;
	    default:
		if (w_handle == D.w_win[gl_wtop].w_cotop)
		{
		    /* We only treat co-top as active for control surfaces */
		    /*    Since it's not a control, go treat it like an	   */
		    /*    inactive window.				   */
		    goto inact_win;
		}
		break;
	  } /* end switch */
	  if (message == WM_ARROWED)
	    x = gl_wa[cpt - W_UPARROW];
	}
	else
	{
inact_win:		
	  ct_msgup(WM_UNTOPPED, D.w_win[gl_wtop].w_owner, gl_wtop,
			x, y, w, h);
          for(ii=0; ii<NUM_ACCS; ii++)
	    dsptch();
						/* went down on inactive*/
						/*   window so tell ap.	*/
						/*   to bring it to top	*/

	  message = WM_TOPPED;
  	  x = mx;
	  y = my;

	}
	ct_msgup(message, D.w_win[w_handle].w_owner, w_handle, 
			x, y, w, h);
}

/*----------------------------------------------------------------------
*
*/
MLOCAL void hctl_rect( WORD key )
{
	WORD		title, item;
	REG WORD	mesag;
	REG PD		*owner;
        WORD		ii;
	
	if ( gl_mntree != 0x0L )
	{
	  mesag = 0;
	  if ( mn_do(&title, &item, key) )
	  {
	    owner = gl_mnppd;
	    mesag = MN_SELECTED;
						/* check system menu:	*/
	    if ( title == THEDESK )
	    {
	      if (item > 2)
	      {
		item -= 3;
	        owner = desk_ppd[item];
#if FIXLATER
	/* use w, new mnlib	 */
		item  = mn_indextoid(item);
#endif
	        do_chg(gl_mntree, title, SELECTED, FALSE, TRUE, TRUE);
		if (gl_wtop >= 0 )
		{
		  ct_msgup(WM_UNTOPPED, D.w_win[gl_wtop].w_owner, gl_wtop,
			  0, 0, 0, 0);
		  for (ii=0; ii<NUM_ACCS; ii++)
		    dsptch();
	        }
		
		mesag = AC_OPEN;
	      }
	      else
		item += gl_dabox;
	    }
						/* application menu	*/
						/*   item has been 	*/
						/*   selected so send it*/
	    ct_msgup(mesag, owner, title, item, 0, 0, 0);
	  }
	}
}

/*----------------------------------------------------------------------
*	Control change of ownership to this rectangle and this process.
*	Doing the control rectangle first is important.
*/
#if FIXLATER
void ct_chgown( PD * mpd, PD * cpd, GRECT * pr)
#else
void ct_chgown( PD * mpd, GRECT * pr)
#endif
{
	set_ctrl(pr);
	if (!gl_ctmown)
#if FIXLATER
	  set_mown(mpd, cpd); 
#else
	  set_mown(mpd); 
#endif
}

/*----------------------------------------------------------------------
*
*/
void ct_mouse( WORD grabit )
{
	
	if (grabit)
	{
	  wm_update(TRUE);
	  gl_ctmown = TRUE;
	  gl_mowner = rlr;
	  gsx_mfset(ad_armice);
	  gl_tmpmoff = gl_moff; 
	  if (gl_tmpmoff)
	    ratinit();
	}
	else
	{
	  if (gl_tmpmoff)
	    gsx_moff();
	  gl_moff = gl_tmpmoff;
	  gsx_mfset(ad_mouse);
	  gl_ctmown = FALSE;
	  wm_update(FALSE);
	}
}

/*----------------------------------------------------------------------
*
*/
MLOCAL void hctl_keybd( WORD cpt )
{
	GRECT		t;
	WORD		x, y, w, h;
	WORD		w_handle;
	REG WORD	message;
	WORD		i;			/* (hca) */
	BYTE		open[5];		/* (hca) */
	
	/* Don't process anything except TAB/BACKTAB if root_on_top */
	if (root_on_top && !((cpt == TAB) || (cpt == BACKTAB)))
		return;
	
	message = 0;
	w_handle = gl_wtop;
	w_bldactive(w_handle);
	w_getsize(WS_CURR, w_handle, &t);
	r_get(&t, &x, &y, &w, &h);
	message = WM_ARROWED;
	switch( cpt )
	  {
	    case W_CLOSER:
		message = WM_CLOSED;
		break;				/* else fall thru	*/
	    case W_FULLER:
	    	message = WM_FULLED;
		break;
	    case W_UPARROW:
	        x = WA_UPPAGE;
		break;
	    case W_DNARROW:
	        x = WA_DNPAGE;
		break;
	    case W_LFARROW:
	        x = WA_LFPAGE;
	        break;
	    case W_RTARROW:
		x = WA_RTPAGE;
		break;
	    case TAB:
	    case BACKTAB:
 	        ct_msgup(WM_UNTOPPED, D.w_win[gl_wtop].w_owner, gl_wtop,
			x, y, w, h);
/* (hca) Go through a whole lot of hassle to figure out what handle number
 *  should come next.  First 4 handles are special.  They are always created.
 *  3 & 4 are NOT always open.  1 & 2 ARE always open.
 */     
		for (i = 4; i; i--)
		    open[i] = D.w_win[i].w_flags & VF_INTREE;
		
		if (w_handle > 4)	/* already in the accessories */
		{
		    if (cpt == TAB)	/* (~same as TAB case 2 below) */
		    {
			do {
			    w_handle++;
					    /* RSF: can top background now */
/* KH 920107			    
			    if (w_handle > NUM_WIN) w_handle = ROOT; 
*/			    if (w_handle >= NUM_WIN) w_handle = ROOT; 
/* end of changes KH 920107 */
			} while( !(D.w_win[w_handle].w_flags & VF_INUSE) &&
				 (w_handle != 1) );
			if ((w_handle == 1) && open[3])
			    w_handle = 3;
		    }
		    else do {		/* (~same as BACKTAB case 3 below) */
				w_handle--;
				if (w_handle == 4) w_handle = 2;
			    } while( !(D.w_win[w_handle].w_flags & VF_INUSE) &&
				     (w_handle != 2) );
		}
		else if (cpt == TAB)
		    switch (w_handle)
		    {
			case ROOT:
			    if (open[3]) w_handle = 3;
			    else w_handle = 1;
			    break;
			case 3:		/* easy cases */
			case 4:
			    w_handle -= 2;	     /* TREE -> SIBL */
			    break;
			case 2:
			    /* Move into the accessories */
			    w_handle = 4;	/* start beyond desktop */
			    do {
				w_handle++;
/* KH 920107			    
				if (w_handle > NUM_WIN) w_handle = ROOT; 
*/				if (w_handle >= NUM_WIN) w_handle = ROOT; 
/* end of changes KH 920107 */
			    } while( !(D.w_win[w_handle].w_flags & VF_INUSE) &&
				     (w_handle != 1) );
			    if ((w_handle == 1) && open[3])
				w_handle = 3;
			    break;
			case 1:
			    if (open[4]) w_handle = 4;
			    else w_handle = 2;
			    break;
		    }
		else /* BACKTAB */
		    switch (w_handle)
		    {
			case 4:		/* easy case */
			    w_handle = 1;
			    break;
			case 2:
			    if (open[4])
				w_handle = 4;
			    else w_handle = 1;
			    break;
			case 1:
			    if (open[3]) 
			    {
				w_handle = 3;
				break;
			    }
			    /* else fall through to case 3 */
			case 3:
			    w_handle = ROOT;
			    break;
			case 0:
			    /* Move into the accessories */
/* KH 920107			    
			    w_handle = NUM_WIN + 1;
*/			    w_handle = NUM_WIN ;
/* end of changes KH 920107 */

			    do {
				w_handle--;
				if (w_handle == 4) w_handle = 2;
			    } while( !(D.w_win[w_handle].w_flags & VF_INUSE) 
				    && (w_handle != 2) );
			    break;
		    }

		message = WM_TOPPED;
		x = -1;		/* Indicates that the TOPPED message	*/
		x = -1;		/* was not the result of a mouse click.	*/
		break;
	}
	ct_msgup(message, D.w_win[w_handle].w_owner, w_handle, x, y, w, h);
}

/*------------------------------------------------------------------------
*	Internal process context used to control the screen for use by
*	the menu manager, and the window manager.
*	This process never terminates and forms an integral part of
*	the system.
*/
void ctlmgr( void )
{
	REG WORD	ev_which;
	WORD		rets[6];
	WORD		i, wh;
						/* set defaults for 	*/
						/*  multi wait		*/
	gl_ctwait.m_out = FALSE;
	memmove( (GRECT *)&gl_ctwait.m_x, &gl_rmenu, sizeof(GRECT) );
	while(TRUE)
	{
	  if( gl_mntree != 0x0L )	/* A menu bar is active so ...  */
            menu_keys( gl_mntree, THEACTIVE ); /* Find shortcuts for titles */

	     					/* fix up ctrl rect	*/
	  w_setactive();
						/* wait for something to*/
						/*   happen, keys need	*/
						/*   to be eaten inc.	*/
						/*   fake key sent by	*/
						/*   or if button already*/
						/*   down, then let other*/
						/*   guys run then do it*/
						
	  

	  if (button)
	  {
	    for (i=0; i<(NUM_PDS*2); i++)
	      dsptch();
	    
	    ev_which = MU_BUTTON;
	    rets[0] = xrat;
	    rets[1] = yrat;
	  }
	  else
	  {
	    rets[4]=0;
	    ev_which = MU_KEYBD | MU_BUTTON ;

	    if ( gl_mntree != 0x0L )	/* only wait on bar when there	*/
	      ev_which |= MU_M1;	/* is a menu 			*/


	    ev_which = ev_multi(ev_which, &gl_ctwait, &gl_ctwait, 
			0x0L, 0x0001ff01L, 0x0L, (UWORD*)&rets[0]);
	  }					/* grab screen sink	*/
	  ct_mouse(TRUE);
						/* button down over area*/
						/*   ctrl mgr owns	*/
						/* find out which wind.	*/
						/*   the mouse clicked  */
						/*   over and handle it	*/
	  if (ev_which & MU_BUTTON)
	  {
	    wh = wm_find(rets[0], rets[1]);
	    if ( wh > 0 )
		hctl_window( wh, rets[0], rets[1] );
	  }

				/* If F10 or ALT/something was pressed */
						/* Transfer the keystroke */
						/* to menu bar owner */
						/* mouse over menu bar	*/
	  if ( ev_which & (MU_M1 | MU_KEYBD) ){	/* or F10 etc... was pressed */
	    switch( rets[4] ){
	      case ALT_F4:		/* Close window ? */
	        hctl_keybd( W_CLOSER );
		break;
	      case ALT_F5:
	        hctl_keybd( W_FULLER );
		break;
	      case P_UP:		/* Page window vertical slider up ? */
	        hctl_keybd( W_UPARROW );
		break;
	      case P_DOWN:		/* Page window vertical slider down ? */
	        hctl_keybd( W_DNARROW );
	        break;
	      case CTL_P_UP:		/* Page window horizontal slider left ? */
	        hctl_keybd( W_LFARROW );
		break;
	      case CTL_P_DOWN:		/* Page window horizontal slider right ? */
	        hctl_keybd( W_RTARROW );
	        break;
	      case TAB:
	        hctl_keybd( TAB );
		break;
	      case BACKTAB:
	        hctl_keybd( BACKTAB );
		break;
	      default:
	        hctl_rect( rets[4] );
	        break;
	     }
	   }					/* give up screen sink	*/

	   ct_mouse(FALSE);
	}
}

/* gemctrl.c */
