/****************************************************************************
*   Copyright 1999, Caldera Thin Client Systems, Inc.                       *
*   This software is licensed under the GNU Public License                  *
*   For further information, please see LICENSE.TXT                         *
*                                                                           *
*   Historical Copyright                                                    *
*                                                                           *
*   Copyright (c) 1985, 1987, 1990, 1991  Digital Research Inc.		    *
*   All rights reserved.						    *
*   The Software Code contained in this listing is proprietary to Digital   *
*   Research Inc., Monterey, California, and is covered by U.S. and other   *
*   copyright protection.  Unauthorized copying, adaption, distribution,    *
*   use or display is prohibited and may be subject to civil and criminal   *
*   penalties.  Disclosure to others is prohibited.  For the terms and      *
*   conditions of software code use, refer to the appropriate Digital       *
*   Research License Agreement.						    *
*****************************************************************************
*		      U.S. GOVERNMENT RESTRICTED RIGHTS			    *
*                    ---------------------------------                      *
*  This software product is provided with RESTRICTED RIGHTS.  Use, 	    *
*  duplication or disclosure by the Government is subject to restrictions   *
*  as set forth in FAR 52.227-19 (c) (2) (June, 1987) when applicable or    *
*  the applicable provisions of the DOD FAR supplement 252.227-7013 	    *
*  subdivision (b)(3)(ii) (May 1981) or subdivision (c)(1)(ii) (May 1987).  *
*  Contractor/manufacturer is Digital Research Inc. / 70 Garden Court /     *
*  BOX DRI / Monterey, CA 93940.					    *
*****************************************************************************
* $Header: m:/davinci/users//groups/panther/aes/rcs/gemdisp.c 4.2 92/02/27 15:21:56 rsf Exp $
* $Log:	gemdisp.c $
 * Revision 4.2  92/02/27  15:21:56  rsf
 * Conversion to medium model. Replace GEM.H with VIEWRUN.H
 * 
 * Revision 4.2  92/01/27  16:12:58  Fontes
 * LONG -> TREE for trees, plus some cleanup and commenting
 * 
 * Revision 4.1  92/01/03  13:15:42  Fontes
 * Susan's cleanup
 * 
 * Revision 4.0  91/09/05  11:40:18  system
 * Prototyping and cleanup plus fix to file selector
 * 
*/

/****************************************************************************
* File:		gemdisp.c
*
* Description:	
*
* Build Info:	ndmake -f aes.mak
*
*****************************************************************************/

/*	GEMDISP.C	1/27/84 - 09/13/85	Lee Jay Lorenzen	*/
/*	merge High C vers. w. 2.2 & 3.0		8/19/87		mdf	*/ 
/*	add beep in chkkbd			11/12/87	mdf	*/
/*	910313 WHF	Changed name to make things a bit more clear	*/
/*	910607 RSF	Separate ctl&TAB from others in chkkbd		*/

/*	$Header: m:/davinci/users//groups/panther/aes/rcs/gemdisp.c 4.2 92/02/27 15:21:56 rsf Exp $	*/

/*
*	-------------------------------------------------------------
*	GEM Application Environment Services		  Version 2.3
*	Serial No.  XXXX-0000-654321		  All Rights Reserved
*	Copyright (C) 1987			Digital Research Inc.
*	-------------------------------------------------------------
*/

#include "portab.h"
#include "machine.h"
#include "struct.h"
#include "basepage.h"
#include "obdefs.h"
#include "gemlib.h"
#include "gemkeybd.h"
#include "cproto.h"
#include "aproto.h"

#define KEYSTOP 0x00002b1cL			/* control backslash	*/

EXTERN WORD		gl_fmactive;
EXTERN WORD		gl_play;
EXTERN WORD		gl_recd;
EXTERN WORD		gl_rlen;
EXTERN LONG		gl_rbuf;

EXTERN PD		*gl_mowner;
EXTERN PD		*ctl_pd;	/* Menu manager pd */

EXTERN WORD		kstate;


EXTERN THEGLO		D;

#if MULTIAPP
GLOBAL LONG		gl_prret;
GLOBAL LONG		gl_prpid;
EXTERN WORD	 	gl_ldpid;
EXTERN SHELL		sh[];
EXTERN TREE		gl_mntree;
EXTERN PD		*gl_mnppd;
GLOBAL PD		*gl_displock = 0;
#endif
EXTERN TREE		gl_mntree;

/* forkq puts a fork block with a routine in the fork ring	*/

	VOID
forkq(fcode, lodata, hidata)
	VOID		(*fcode)();
	WORD		lodata, hidata;
{
	REG FPD		*f, *prev;
						/* q a fork process,	*/
						/*   enter with ints OFF*/
	if (fpcnt == 0)
	    fpt = fph = 0;

	if (fpcnt < NFORKS)
	{
	    f = &D.g_fpdx[fpt++];
	    prev = f -1;

	    if ((fpt > 1) && 
	       ((prev->f_code == mchange) && (fcode == mchange)))
	    {
		f = prev;
		fpt--;
		fpcnt--;
	    }
	    if (fpt == NFORKS)
	    {
	        v_sound(TRUE, 440, 2);
	        fpt = 0;
	    }
	    f->f_code = fcode;
	    f->f_data = MAKELONG( hidata, lodata );

	    fpcnt++;
	}
}



MLOCAL	VOID
disp_act(REG PD *p)
{      
						/* process is ready,	*/
						/*   so put him on RLR	*/
	p->p_stat &= ~WAITIN;
	insert_process(p, &rlr);	
}


MLOCAL	VOID
mwait_act(REG PD *p)
{	
						/* sleep on nrl if	*/
						/*   event flags are 	*/
						/*   not set		*/
	if (p->p_evwait & p->p_evflg)
	  disp_act(p);
	else
	{ 
						/* good night, Mrs.	*/
						/*   Calabash, wherever	*/
						/*   you are 		*/
	  p->p_link = nrl;
	  nrl = p;
	}
}


	VOID
forker()
{
	REG FPD		*f;
	REG PD		*oldrl;
#ifdef PLAYRECD	
	REG LONG	amt;
#endif
	FPD		g;
	
	oldrl = rlr;
	rlr = (PD *) -1;
	while(fpcnt)
	{
/* critical area	*/
	  cli();
	  fpcnt--;
	  f = &D.g_fpdx[fph++];
  					/* copy FPD so an interrupt	*/
					/*  doesn't overwrite it.	*/
	  fmemcpy((BYTE FAR *)(&g), (BYTE FAR *)f, sizeof(FPD) );
	  if (fph == NFORKS) 
	    fph = 0;
	  sti();
/* */
						/* see if recording	*/
#ifdef PLAYRECD
	  if (gl_recd)
	  {
						  /* check for stop key	*/
	    if ( (g.f_code == kchange) &&
	         ((g.f_data & 0x0000ffffL) == KEYSTOP) )
	      gl_recd = FALSE;
						/* if still recording	*/
						/*   then handle event	*/
	    if (gl_recd)
	    {
						/* if its a time event &*/
						/*   previously recorded*/
						/*   was a time event	*/
						/*   then coalesce them	*/ 
						/*   else record the	*/
						/*   event		*/
	      if ( (g.f_code == tchange) &&
	           (LWGET(gl_rbuf - sizeof(FPD)) == tchange) )
	      {
	        amt = g.f_data + LLGET(gl_rbuf-sizeof(LONG));
	        LLSET(gl_rbuf - sizeof(LONG), amt);	      
	      }
	      else
	      {
	        fmemcpy(gl_rbuf, ADDR(f), sizeof(FPD));
	        gl_rbuf += sizeof(FPD);
	        gl_rlen--;
		gl_recd = gl_rlen;
	      }
	    }
	  }
#endif
	  (*g.f_code)(g.f_data);
	}
	rlr = oldrl;
}

	VOID
chkkbd()
{
	REG UWORD	achar, kstat;
						/* poll keybd 		*/
	if (!gl_play)
	{
	  kstat = gsx_kstate();
	  achar = gsx_char();
	

	if( !gl_fmactive ){	/* WIndow controls not active during form_do */
	 switch( achar ){
	  case ALT_F4:		/* Close window ? */
	  case ALT_F5:		/* Full window ? */
	  case P_UP:		/* Page window vertical slider up ? */
	  case P_DOWN:		/* Page window vertical slider down ? */
	  case CTL_P_UP:	/* Page window horizontal slider left ? */
	  case CTL_P_DOWN:	/* Page window horizontal slider right ? */
#if 0 
RSF: let app do this
	  case HOME:		/* Move window vertical slider to top ? */ 
	  case END:		/* Move window vertical slider to bottom ? */
#endif
	  case TAB:
	    if( (kstat&0x04) && (achar != CTL_P_UP)
		    && (achar != CTL_P_DOWN) ) /* Let CTRL+I through as TAB */
	      break;
	  case BACKTAB:
	    kstate=kstat;
	    post_keybd( ctl_pd->p_cda, achar );
	    return;
	 }
	}
	
        if( gl_mntree != 0x0L && achar && 
	/* if not ctrl key and menu bar is active and F10 or F1 or */
	    ( achar == FUN_10 || achar == FUN_1 || /* an ALT short cut */
	    ( !(achar & 0x00FF) && find_shortcut( achar )!=NIL)) ){
		kstate=kstat;	/* Give F10 or shortcut to menu bar */
		post_keybd( ctl_pd->p_cda, achar );
	}
	else{
    
	  if (achar && (gl_mowner->p_cda->c_q.c_cnt >= KBD_SIZE))
	  {
	    achar = 0x0;			/* buffer overrun	*/
	    v_sound(TRUE, 880, 2);
	  }
	  if ( (achar) ||
	     (kstat != kstate) )
	  {
	    cli();
	    forkq(kchange, achar, kstat);
	    sti();
	  }
	}
    }
}


MLOCAL	VOID
schedule( void )
{
	REG PD		*p;

						/* run through lists	*/
						/*   until someone is	*/
						/*   on the rlr or the	*/
						/*   fork list		*/
	do
	{
						/* poll the keyboard	*/
	  chkkbd();
						/* now move drl		*/
						/*   processes to rlr	*/
	  while ( drl )
	  {
	    drl = (p = drl) -> p_link;
	    disp_act(p);
	  }
						/* check if there is	*/
						/*   something to run	*/
	} while ( !rlr && !fpcnt );
}


/************************************************************************/
/*									*/
/* dispatcher maintains all flags/regs so it looks like an rte to	*/
/*   the caller.							*/
/*   dispatch() = rte							*/
/*   rlr -> p_stat determines the action to perform on the process that	*/
/*		was in context						*/
/*   rlr -> p_uda -> dparam is used by the action routines		*/
/*									*/
/************************************************************************/

	VOID
dispx()
{
	REG PD		*p;
/* savestate() is a machine (& compiler) dependent routine which:
 *	1) saves any flags that will be trashed by the TAS
 *	2) if (indisp) restore flags, return to dsptch caller
 *	3) otherwise 
 *		save machine state, 
 *		return to dsptch here 
*/

 	savestat(rlr->p_uda);

#if MULTIAPP
skip:
#endif
						/* take the process p	*/
						/*   off the ready list	*/
						/*   root		*/
	rlr = (p=rlr) -> p_link;
						/* based on the state	*/
						/*   of the process p	*/
						/*   do something	*/
	if (p->p_stat & WAITIN) 
	  mwait_act(p);
	else
	  disp_act(p);
						/* run through and 	*/
						/*   execute all the	*/
						/*   fork processes	*/
	do 
	{
	  if (fpcnt)
	    forker();
	  schedule();
	} while (fpcnt);


/* switchto() is a machine dependent routine which:
 *	1) restores machine state
 *	2) clear "indisp" semaphore
 *	3) returns to appropriate address
 *		so we'll never return from this
 */
#if MULTIAPP
	if (gl_displock && (rlr != gl_displock))
	  goto skip;

	if (rlr->p_pid == 1)
	{
	  if (gl_mntree)
	    pr_load(gl_mnppd->p_pid);	
	}
	else
	  pr_load(rlr->p_pid);
#endif
	switchto(rlr->p_uda);
}
/*  DEC/CMS REPLACEMENT HISTORY, Element GEMDISP.C	*/
/*  DRDOS 12-Jun-1990 12:00:00 JFL  "Let CTRL+I thorugh as TAB" */
/*  DRDOS 11-Jun-1990 12:00:00 JFL  "Dispatch special keyboard events to menu and dialogue handlers" */
/*  *1B2   4-OCT-1988 14:10:27 PANG "forkq() limits buffer overrun on mchange() queueing"	*/
/*   8     4-OCT-1988 14:09:12 PANG "really wanted 1b1"	*/
/*   7     4-OCT-1988 14:07:10 PANG "forkq() limits buffer overrun on mouse data queueing"	*/
/*   6    30-AUG-1988 15:13:40 PANG "major change to taddr.h required these changes, code can be " 28,800"	*/
/*   5    22-AUG-1988 09:49:39 PANG "code " 32kbytes, data @ 27f0"	*/
/*   4     4-AUG-1988 11:18:46 PANG "creation of Overlayed AES for GEM 3.20 still in progress"	*/
/*  *1B1   4-AUG-1988 09:50:39 PANG "bug fix for Perkin/Elmer losing data on COM2 & Nixdorf microsoft mouse losing motion	*/
/* data"	*/
/*   3     7-MAR-1988 16:17:51 PANG "position bug of desktop info bars"	*/
/*   2    26-FEB-1988 09:55:02 PANG "xm alpha 1.1a"	*/
/*  *1    26-FEB-1988 09:09:01 PANG "er1/28/88"	*/
/*  DEC/CMS REPLACEMENT HISTORY, Element GEMDISP.C	*/
