/****************************************************************************
*   Copyright 1999, Caldera Thin Client Systems, Inc.                       *
*   This software is licensed under the GNU Public License                  *
*   For further information, please see LICENSE.TXT                         *
*                                                                           *
*   Historical Copyright                                                    *
*                                                                           *
*   Copyright (c) 1985, 1987, 1990, 1991, 1992  Digital Research Inc.	    *
*   All rights reserved.						    *
*   The Software Code contained in this listing is proprietary to Digital   *
*   Research Inc., Monterey, California, and is covered by U.S. and other   *
*   copyright protection.  Unauthorized copying, adaption, distribution,    *
*   use or display is prohibited and may be subject to civil and criminal   *
*   penalties.  Disclosure to others is prohibited.  For the terms and      *
*   conditions of software code use, refer to the appropriate Digital       *
*   Research License Agreement.						    *
*****************************************************************************
*		      U.S. GOVERNMENT RESTRICTED RIGHTS			    *
*                    ---------------------------------                      *
*  This software product is provided with RESTRICTED RIGHTS.  Use, 	    *
*  duplication or disclosure by the Government is subject to restrictions   *
*  as set forth in FAR 52.227-19 (c) (2) (June, 1987) when applicable or    *
*  the applicable provisions of the DOD FAR supplement 252.227-7013 	    *
*  subdivision (b)(3)(ii) (May 1981) or subdivision (c)(1)(ii) (May 1987).  *
*  Contractor/manufacturer is Digital Research Inc. / 70 Garden Court /     *
*  BOX DRI / Monterey, CA 93940.					    *
*****************************************************************************
* $Header: m:/davinci/users//groups/panther/aes/rcs/gemgrlib.c 4.3 92/03/26 14:48:07 sbc Exp $
* $Log:	gemgrlib.c $
 * Revision 4.3  92/03/26  14:48:07  sbc
 * Merge in RSF's changes
 * 
 * Revision 4.3  92/03/20  20:16:53  Fontes
 * Removed bmp file processing from AES
 * 
 * Revision 4.2  92/02/27  15:23:33  rsf
 * Conversion to medium model. Replace GEM.H with VIEWRUN.H
 * 
 * Revision 4.3  92/02/11  11:11:46  Fontes
 * Background image display implementation
 * 
 * Revision 4.2  92/01/27  16:10:38  Fontes
 * LONG -> TREE for trees, plus some cleanup and commenting
 * 
 * Revision 4.1  92/01/03  13:16:35  Fontes
 * Susan's cleanup
 * 
 * Revision 4.0  91/09/05  11:54:26  system
 * Prototyping and cleanup plus fix to file selector code
 * 
*/

/****************************************************************************
* File:		gemgrlib.c
*
* Description:	
*
* Build Info:	ndmake -f aes.mak
*
*****************************************************************************/

/*	GEMGRLIB.C	4/11/84 - 09/20/85	Gregg Morris		*/
/*	merge High C vers. w. 2.2 		8/21/87		mdf	*/ 

/*
*	-------------------------------------------------------------
*	GEM Application Environment Services		  Version 2.3
*	Serial No.  XXXX-0000-654321		  All Rights Reserved
*	Copyright (C) 1987			Digital Research Inc.
*	-------------------------------------------------------------
*/

#include "portab.h"
#include "machine.h"
#include "struct.h"
#include "basepage.h"
#include "obdefs.h"
#include "gemlib.h"
#include "cproto.h"
#include "aproto.h"
#include "viewrun.h"


EXTERN GRECT	gl_rscreen;
EXTERN GRECT	gl_rzero;

EXTERN WORD	xrat, yrat, button, kstate;

/*
*	Routine to watch the mouse while the button is down and
*	it stays inside/outside of the specified rectangle.
*	Return TRUE as long as the mouse is down.  Block until the
*	mouse moves into or out of the specified rectangle.
*/
MLOCAL	WORD gr_stilldn( WORD out, WORD x, WORD y, WORD w, WORD h )
{
UWORD		rets[6];
MOBLK		moblk ;

    moblk.m_out = out ;
    moblk.m_x = x ;
    moblk.m_y = y ;
    moblk.m_w = w ;
    moblk.m_h = h ;
    dsptch();
    
    if ( MU_BUTTON & ev_multi(MU_KEYBD | MU_BUTTON | MU_M1, &moblk, 
		(MOBLK*)NULLPTR, 0x0L, 0x0001ff00L, 0x0L, rets) )
	return(FALSE);
    
    return(TRUE);
    
} /* gr_stilldn */

MLOCAL	VOID
gr_setup(WORD color)
{
	gsx_sclip(&gl_rscreen);
	gsx_attr(FALSE, MD_XOR, color);
}

MLOCAL	VOID
gr_clamp(WORD xorigin, WORD yorigin, WORD wmin, WORD hmin, 
		WORD *pneww, WORD *pnewh)
{
	*pneww = max(xrat - xorigin + 1, wmin);
	*pnewh = max(yrat - yorigin + 1, hmin);
}

MLOCAL	VOID
gr_scale(REG WORD xdist, REG WORD ydist, WORD *pcnt, 
		REG WORD *pxstep, REG WORD *pystep)
{
	REG WORD	i;
	REG WORD	dist;


	gr_setup(BLACK);

	dist = (xdist + ydist) / 2;

	for(i=0; dist; i++)
	  dist /= 2;

	if ((*pcnt = i) != 0)
	{
	  *pxstep = max(1, xdist / i);
	  *pystep = max(1, ydist / i);
	}
	else
	  *pxstep = *pystep = 1;
}


	VOID
gr_stepcalc(orgw, orgh, pt, pcx, pcy, pcnt, pxstep, pystep)
	WORD		orgw, orgh;
	REG GRECT	*pt;
	REG WORD	*pcx, *pcy;
	WORD		*pcnt, *pxstep, *pystep;
{
	*pcx = (pt->g_w/2) - (orgw/2);
	*pcy = (pt->g_h/2) - (orgh/2);

	gr_scale(*pcx, *pcy, pcnt, pxstep, pystep);

	*pcx += pt->g_x;
	*pcy += pt->g_y;
}


MLOCAL	VOID
gr_xor(WORD clipped, WORD cnt, WORD cx, WORD cy, WORD cw, WORD ch, 
	REG WORD xstep, REG WORD ystep, WORD dowdht)
{
	do
	{
	  if (clipped)
	    gsx_xcbox((GRECT*)&cx);
	  else
	    gsx_xbox((GRECT*)&cx);
	  cx -= xstep;
	  cy -= ystep;
	  if (dowdht)
	  {
	    cw += (2 * xstep);
	    ch += (2 * ystep);
	  }
	} while (cnt--);
}


MLOCAL	VOID
gr_draw(WORD have2box, REG GRECT *po, REG GRECT *poff)
{
	GRECT		t;

	gsx_xbox(po);
	if (have2box)
	{
	  r_set(&t, po->g_x + poff->g_x, po->g_y + poff->g_y,
		      po->g_w + poff->g_w, po->g_h + poff->g_h );
	  gsx_xbox(&t);
	}
}


MLOCAL	WORD
gr_wait(REG GRECT *po, GRECT *poff)
{
	REG WORD	have2box;
	REG WORD	down;
	
	have2box = memcmp( (char *)&gl_rzero, (char *)poff, sizeof( GRECT ) ) ;
						/* draw/erase old	*/
	gsx_moff();
	gr_draw(have2box, po, poff);
	gsx_mon();
						/* wait for change	*/
	down = gr_stilldn(TRUE, xrat, yrat, 1, 1);
						/* draw/erase old	*/
	gsx_moff();
	gr_draw(have2box, po, poff);
	gsx_mon();
						/* return exit event	*/
	return(down);
}


/*
*	Stretch the free corner of an XOR box(w,h) that is pinned at
*	another corner based on mouse movement until the button comes
*	up.  Also draw a second box offset from the stretching box.
*/
	VOID
gr_rubwind(xorigin, yorigin, wmin, hmin, poff, pwend, phend)
	WORD		xorigin, yorigin;
	WORD		wmin, hmin;
	GRECT		*poff;
	WORD		*pwend, *phend;
{
	WORD		down;
	GRECT		o;

	
	wm_update(TRUE);
	gr_setup(BLACK);
	
	r_set(&o, xorigin, yorigin, 0, 0);
						/* clamp size of rubber	*/
						/*   box to no smaller	*/
						/*   than wmin, hmin	*/
	do
	{
	  gr_clamp(o.g_x, o.g_y, wmin, hmin, &o.g_w, &o.g_h);
	  down = gr_wait(&o, poff);
	} while (down);
	*pwend = o.g_w;
	*phend = o.g_h;
	wm_update(FALSE);
} /* gr_rubwind */


/*
*	Stretch the free corner of a XOR box(w,h) that is pinned at
*	another corner based on mouse movement until the button comes
*	up.  This is also called a rubber-band box.
*/
	VOID
gr_rubbox(xorigin, yorigin, wmin, hmin, pwend, phend)
	WORD		xorigin, yorigin;
	WORD		wmin, hmin;
	WORD		*pwend, *phend;
{
	gr_rubwind(xorigin, yorigin, wmin, hmin, &gl_rzero, pwend, phend);
}



/*
*	Drag a moving XOR box(w,h) that tracks relative to the mouse
*	until the button comes up.  The starting x and y represent
*	the location of the upper left hand corner of the rectangle
*	relative to the mouse position.  This relative distance should
*	be maintained.  A constraining rectangle is also given.  The
*	box should not be able to be dragged out of the contraining
*	rectangle.
*/
	VOID
gr_dragbox(w, h, sx, sy, pc, pdx, pdy)
	WORD		w, h;
	REG WORD	sx, sy;
	GRECT		*pc;
	WORD		*pdx, *pdy;
{
	WORD		offx, offy, down;
	GRECT		o;

	wm_update(TRUE);
	gr_setup(BLACK);

	gr_clamp(sx+1, sy+1, 0, 0, &offx, &offy);
	r_set(&o, sx, sy, w, h);

						/* get box's x,y from	*/
						/*   mouse's x,y then	*/
						/*   constrain result	*/
	do
	{
	  o.g_x = xrat - offx;
	  o.g_y = yrat - offy;
	  rc_constrain(pc, &o);
	  down = gr_wait(&o, &gl_rzero);
	} while (down);
	*pdx = o.g_x;
	*pdy = o.g_y;
	wm_update(FALSE);
} /* gr_dragbox */


	VOID
gr_2box(flag1, cnt, pt, xstep, ystep, flag2)
	WORD		flag1;
	WORD		cnt;
	GRECT		*pt;
	WORD		xstep, ystep;
	WORD		flag2;
{
	REG WORD	i;

	gsx_moff();
	for (i=0; i<2; i++)
	  gr_xor(flag1, cnt, pt->g_x, pt->g_y, pt->g_w, pt->g_h, 
			xstep, ystep, flag2);
	gsx_mon();
}


/*
*	Draw a moving XOR box(w,h) that moves from a point whose upper
*	left corner is at src_x, src_y to a point at dst_x, dst_y
*/

	VOID
gr_movebox(w, h, srcx, srcy, dstx, dsty)
	WORD		w, h;
	REG WORD	srcx, srcy;
	WORD		dstx, dsty;
{
	REG WORD	signx, signy;
	WORD		cnt, xstep, ystep;
	GRECT		t;

	r_set(&t, srcx, srcy, w, h);

	signx = (srcx < dstx) ? -1 : 1;
	signy = (srcy < dsty) ? -1 : 1;

	gr_scale(signx*(srcx-dstx), signy*(srcy-dsty), &cnt, &xstep, &ystep);

	gr_2box(FALSE, cnt, &t, signx*xstep, signy*ystep, FALSE);
}


/*
*	Draw an small box that moves from the origin x,y to a spot
*	centered within the rectangle and then expands to match the
*	size of the rectangle.
*/
/*
	VOID
gr_growbox(po, pt)
	REG GRECT	*po;
	GRECT		*pt;
{
	WORD		cx, cy;
	WORD		cnt, xstep, ystep;

	gr_stepcalc(po->g_w, po->g_h, pt, &cx, &cy, &cnt, &xstep, &ystep);
	gr_movebox(po->g_w, po->g_h, po->g_x, po->g_y, cx, cy);
	po->g_x = cx;
	po->g_y = cy;
	gr_2box(TRUE, cnt, po, xstep, ystep, TRUE);
}
*/

/*
*	Draw a box that shrinks from the rectangle given down around
*	a small box centered within the rectangle and then moves to the
*	origin point.
*/
/*
	VOID
gr_shrinkbox(po, pt)
	REG GRECT	*po;
	REG GRECT	*pt;
{
	WORD		cx, cy;
	WORD		cnt, xstep, ystep;

	gr_stepcalc(po->g_w, po->g_h, pt, &cx, &cy, &cnt, &xstep, &ystep);
	gr_2box(TRUE, cnt, pt, -xstep, -ystep, TRUE);
	gr_movebox(po->g_w, po->g_h, cx, cy, po->g_x, po->g_y);
}

*/
	WORD
gr_watchbox(tree, obj, instate, outstate)
	REG TREE	tree;
	REG WORD	obj;
	WORD		instate;
	WORD		outstate;
{
	REG WORD	out;
	REG WORD	state;
	GRECT		t;

	gsx_sclip(&gl_rscreen);
	ob_actxywh(tree, obj, &t);
	
	out = FALSE;
	do
	{
	  state = (out) ? outstate : instate;
	  ob_change(tree, obj, state, TRUE);
	  out = !out;
	} while( gr_stilldn(out, t.g_x, t.g_y, t.g_w, t.g_h) );

	return( out );
}


	WORD
gr_slidebox(tree, parent, obj, isvert)
	REG TREE	tree;
	WORD		parent;
	WORD		obj;
	WORD		isvert;
{
	GRECT		t, c;
	WORD		divnd, divis;

	ob_actxywh(tree, parent, &c);
	ob_relxywh(tree, obj, &t);
	gr_dragbox(t.g_w, t.g_h, t.g_x + c.g_x, t.g_y + c.g_y, 
			&c, &t.g_x, &t.g_y); 

	if ( isvert )
	{
	  divnd = t.g_y - c.g_y;
	  divis = c.g_h - t.g_h;
	}
	else
	{
	  divnd = t.g_x - c.g_x;
	  divis = c.g_w - t.g_w;
	}
	if (divis)
	  return( (WORD)mul_div( divnd, 1000, divis) );
	else
	  return(0);
}


	VOID
gr_mkstate(pmx, pmy, pmstat, pkstat)
	WORD		*pmx, *pmy, *pmstat, *pkstat;
{
	*pmx = xrat;
	*pmy = yrat;
	*pmstat = button;
	*pkstat = kstate;
}
