/****************************************************************************
*   Copyright 1999, Caldera Thin Client Systems, Inc.                       *
*   This software is licensed under the GNU Public License                  *
*   For further information, please see LICENSE.TXT                         *
*                                                                           *
*   Historical Copyright                                                    *
*                                                                           *
*   Copyright (c) 1985, 1987, 1990, 1991  Digital Research Inc.		    *
*   All rights reserved.						    *
*   The Software Code contained in this listing is proprietary to Digital   *
*   Research Inc., Monterey, California, and is covered by U.S. and other   *
*   copyright protection.  Unauthorized copying, adaption, distribution,    *
*   use or display is prohibited and may be subject to civil and criminal   *
*   penalties.  Disclosure to others is prohibited.  For the terms and      *
*   conditions of software code use, refer to the appropriate Digital       *
*   Research License Agreement.						    *
*****************************************************************************
*		      U.S. GOVERNMENT RESTRICTED RIGHTS			    *
*                    ---------------------------------                      *
*  This software product is provided with RESTRICTED RIGHTS.  Use, 	    *
*  duplication or disclosure by the Government is subject to restrictions   *
*  as set forth in FAR 52.227-19 (c) (2) (June, 1987) when applicable or    *
*  the applicable provisions of the DOD FAR supplement 252.227-7013 	    *
*  subdivision (b)(3)(ii) (May 1981) or subdivision (c)(1)(ii) (May 1987).  *
*  Contractor/manufacturer is Digital Research Inc. / 70 Garden Court /     *
*  BOX DRI / Monterey, CA 93940.					    *
*****************************************************************************
* $Header: m:/davinci/users//groups/panther/aes/rcs/gemgsxif.c 4.2 92/02/27 15:23:39 rsf Exp $
* $Log:	gemgsxif.c $
 * Revision 4.2  92/02/27  15:23:39  rsf
 * Conversion to medium model. Replace GEM.H with VIEWRUN.H
 * 
 * Revision 4.3  92/02/03  11:23:40  Fontes
 * Conversion to medium model. Replace GEM.H with VIEWRUN.H
 * 
 * Revision 4.2  92/01/03  13:16:40  Fontes
 * Susan's cleanup
 * 
 * Revision 4.0  91/09/05  11:53:14  system
 * Prototyping and cleanup plus fix to file selector code
 * 
*/

/****************************************************************************
* File:		gemgsxif.c
*
* Description:	
*
* Build Info:	ndmake -f aes.mak
*
*****************************************************************************/

/*	GEMGSXIF.C	05/06/84 - 06/13/85	Lee Lorenzen		*/
/*	merge High C vers. w. 2.2 		8/21/87		mdf	*/ 
/*	910404 WHF	Added bindings for  vsf_udpat() and v_fillarea()*/

/*
*	-------------------------------------------------------------
*	GEM Application Environment Services		  Version 2.3
*	Serial No.  XXXX-0000-654321		  All Rights Reserved
*	Copyright (C) 1987			Digital Research Inc.
*	-------------------------------------------------------------
*/

#include "portab.h"
#include "machine.h"
#include "dos.h"
#include "obdefs.h"
#include "gsxdefs.h"
#include "funcdef.h"
#include "viewrun.h"
#include "cproto.h"
#include "aproto.h"


/*
*	Calls used in Crystal:
*
*	vsf_interior();
*	vr_recfl();
*	vst_height(); 
*	vsl_type();
*	vsl_udsty();
*	vsl_width();
*	v_pline();
*	vst_clip();
*	vex_butv();
*	vex_motv();
*	vex_curv();
*	vex_timv();
*	vr_cpyfm();
*	v_opnwk();
*	v_clswk();
*	vq_extnd();
*	v_clsvwk( handle )
*	v_opnvwk( pwork_in, phandle, pwork_out )
*/

						/* in GSX2.A86		*/

EXTERN LONG	drwaddr;
						/* in APGSXIF.C		*/
EXTERN WORD	xrat, yrat, button;

EXTERN WORD	gl_nplanes;
EXTERN WORD 	gl_handle;

EXTERN WORD	gl_wchar;
EXTERN WORD	gl_hchar;

EXTERN FDB	gl_src;
EXTERN FDB	gl_dst;

EXTERN WS	gl_ws;
EXTERN WORD	contrl[];
EXTERN WORD	intin[];
EXTERN WORD	ptsin[];
EXTERN WORD	intout[];
EXTERN WORD	ptsout[];
EXTERN PBLK	pblock ;

EXTERN LONG	ad_intin;

EXTERN WORD	gl_ctmown;
EXTERN LONG	ad_mouse;

GLOBAL FDB	gl_tmp;

GLOBAL LONG	old_mcode;
GLOBAL LONG	old_bcode;
GLOBAL WORD	gl_moff;			/* counting semaphore	*/
						/*  == 0 implies ON	*/
						/*  >  0 implies OFF	*/
GLOBAL LONG	gl_mlen;
GLOBAL WORD	gl_graphic;


#define GRAFMEM		0xFFFFFFFFl

/*----------------------------------------------------------------------*/
MLOCAL	ULONG	
gsx_gbufflen( void )
{
	gsx_1code(EXTENDED_INQUIRE, 1);
	return(LLGET(ADDR(&intout[26])));
}

/*----------------------------------------------------------------------*/
ULONG gsx_mcalc( void )
{
	gsx_fix(&gl_tmp, 0x0L, 0, 0);		/* store screen info	*/
	gl_mlen = gsx_gbufflen();
	if (gl_mlen != 0x0l)
	  gl_tmp.fd_addr = GRAFMEM;		/* buffer not in sys mem */
	else
	  gl_mlen =  63L * (LONG)gl_wchar * (LONG)gl_hchar * (LONG)gl_nplanes;
	return(gl_mlen);
}

/*----------------------------------------------------------------------*/
void gsx_malloc( void )
{
	ULONG	mlen;

	mlen = gsx_mcalc();			/* need side effects now     */
	if (gl_tmp.fd_addr != GRAFMEM)		/* buffer on graphics board? */
	  gl_tmp.fd_addr = dos_alloc(mlen);	/*  no -- get from sys mem   */
}
#if SBC
/*----------------------------------------------------------------------*/
	void
gsx_mfree()
{
	dos_free(gl_tmp.fd_addr);
}
#endif
/*----------------------------------------------------------------------*/
void gsx_mret( LONG * pmaddr, LONG * pmlen)
{
	if (gl_tmp.fd_addr == GRAFMEM)
	{
	  *pmaddr = 0x0l;
	  *pmlen = 0x0l;
	}
	else
	{
	  *pmaddr = gl_tmp.fd_addr;
	  *pmlen = gl_mlen;
	}
}

/*----------------------------------------------------------------------*/
void gsx_ncode( WORD code, WORD n, WORD m)
{
	contrl[0] = code;
	contrl[1] = n;
	contrl[3] = m;
	contrl[6] = gl_handle;
	gsx2();
}

/*----------------------------------------------------------------------*/
void gsx_1code( WORD code, WORD value)
{
	intin[0] = value;
	gsx_ncode(code, 0, 1);
}

/*----------------------------------------------------------------------*/
MLOCAL void v_opnwk( WORD *pwork_in, WORD *phandle, REG WORD *pwork_out )
{
	pblock.pIntin  = (WORD far *)pwork_in ;
	pblock.pIntout = (WORD far *)pwork_out ;
	pblock.pPtsout = (WORD far *)(pwork_out + 45) ; 
	
	gsx_ncode( OPEN_WORKSTATION, 0, 11 );

	*phandle = contrl[6];	
	pblock.pIntin  = (WORD far *)intin ;
	pblock.pPtsin  = (WORD far *)ptsin ;
	pblock.pIntout = (WORD far *)intout ;
	pblock.pPtsout = (WORD far *)ptsout ;
}

/*----------------------------------------------------------------------*/
MLOCAL void gsx_wsopen( void )
{
	WORD		i;

	for(i=0; i<10; i++)
	  intin[i] = 1;
	intin[10] = 2;			/* device coordinate space */
	v_opnwk( &intin[0], &gl_handle, (WORD*)&gl_ws );
	gl_graphic = TRUE;
}

/*----------------------------------------------------------------------*/
MLOCAL	void gsx_setmb(UWORD *boff, UWORD *moff, LONG *pdrwaddr)
{
	i_lptr1( MAKELONG(0, boff) );	
	gsx_ncode(BUT_VECX, 0, 0);
	m_lptr2( &old_bcode );

	i_lptr1( MAKELONG(0, moff) );	
	gsx_ncode(MOT_VECX, 0, 0);
	m_lptr2( &old_mcode );

	i_lptr1( MAKELONG(0, justretf) );	
	gsx_ncode(CUR_VECX, 0, 0);
	m_lptr2( pdrwaddr );
}

/*----------------------------------------------------------------------*/
MLOCAL	void gsx_resetmb( void )
{
	i_lptr1( old_bcode );	
	gsx_ncode(BUT_VECX, 0, 0);

	i_lptr1( old_mcode );
	gsx_ncode(MOT_VECX, 0, 0);

	i_lptr1( drwaddr );	
	gsx_ncode(CUR_VECX, 0, 0);
}

/*----------------------------------------------------------------------*/
void gsx_init( void )
{
	gsx_wsopen();
	gsx_start();
	gsx_setmb((UWORD*)far_bcha, (UWORD*)far_mcha, &drwaddr);
	gsx_ncode(MOUSE_ST, 0, 0); 
	xrat = ptsout[0];
	yrat = ptsout[1];
}

/*----------------------------------------------------------------------*/
void gsx_exec(pcspec, segenv, pcmdln, pfcb1, pfcb2)
	LONG		pcspec;
	WORD		segenv;
	LONG		pcmdln;
	LONG		pfcb1;
	LONG		pfcb2;
{
	EXEC_BLK	exec;
	LONG		lpstr;

	exec.eb_segenv = segenv;
	exec.eb_pcmdln = pcmdln;
	exec.eb_pfcb1 = pfcb1;
	exec.eb_pfcb2 = pfcb2;

	intin[0] = LOWORD(pcspec);
	intin[1] = HIWORD(pcspec);
	intin[2] = LOWORD(ADDR(&exec));
	intin[3] = HIWORD(ADDR(&exec));
	lpstr = ADDR(rs_str(STGDOS));
	intin[4] = LOWORD( lpstr );
	intin[5] = HIWORD( lpstr );
	contrl[5] = 1;
	gsx_ncode(-1, 0, 6);
}
/*----------------------------------------------------------------------*/
void gsx_graphic(tographic)
	WORD		tographic;
{
	if (gl_graphic != tographic)
	{
	  gl_graphic = tographic;
	  if (gl_graphic)
	  {
	    contrl[5] = 2;
	    gsx_ncode(5, 0, 0);
	    gsx_setmb((UWORD*)far_bcha, (UWORD*)far_mcha, &drwaddr);
	  }
	  else
	  {
	    contrl[5] = 3;
	    gsx_ncode(5, 0, 0);
	    gsx_resetmb();
	  }
	}
}
#if SBC
/*----------------------------------------------------------------------*/
	void
gsx_wsclose()
{
	gsx_ncode(CLOSE_WORKSTATION, 0, 0);
}
#endif
/*----------------------------------------------------------------------*/
void ratinit( void )
{
	gsx_1code(SHOW_CUR, 0);
	gl_moff = 0;
}
#if SBC
/*----------------------------------------------------------------------*/
void
ratexit()
{
	gsx_moff();
}
#endif
/*----------------------------------------------------------------------*/
MLOCAL	void
bb_set(REG WORD sx, REG WORD sy, REG WORD sw, REG WORD sh, 
		REG WORD *pts1, REG WORD *pts2, 
		FDB *pfd, FDB *psrc, FDB *pdst)
{
	WORD		oldsx;

						/* get on word boundary	*/
	oldsx = sx;
	sx = (sx / 16) * 16;
	sw = ( ((oldsx - sx) + (sw + 15)) / 16 ) * 16;

	gl_tmp.fd_stand = TRUE;
	gl_tmp.fd_wdwidth = sw / 16;
	gl_tmp.fd_w = sw;
	gl_tmp.fd_h = sh;

	gsx_moff();
	pts1[0] = sx;
	pts1[1] = sy;
	pts1[2] = sx + sw - 1;
	pts1[3] = sy + sh - 1;
	pts2[0] = 0;
	pts2[1] = 0;
	pts2[2] = sw - 1;
	pts2[3] = sh - 1 ;

	gsx_fix(pfd, 0L, 0, 0);
	vro_cpyfm( S_ONLY, &ptsin[0], psrc, pdst );
	gsx_mon();
}

/*----------------------------------------------------------------------*/
void bb_save(ps)
	GRECT		*ps;
{	
	bb_set(ps->g_x, ps->g_y, ps->g_w, ps->g_h, &ptsin[0], &ptsin[4], 
		&gl_src, &gl_src, &gl_tmp);
}

/*----------------------------------------------------------------------*/
void bb_restore(pr)
	GRECT		*pr;
{
	bb_set(pr->g_x, pr->g_y, pr->g_w, pr->g_h, &ptsin[4], &ptsin[0], 
		&gl_dst, &gl_tmp, &gl_dst);
}

/*----------------------------------------------------------------------*/
WORD gsx_tick(tcode, ptsave)
	LONG		tcode;
	LONG		*ptsave;
{
	i_lptr1( tcode );	
	gsx_ncode(TIM_VECX, 0, 0);
	m_lptr2( ptsave );
	return(intout[0]);
}

/*----------------------------------------------------------------------*/
void gsx_mfset(pmfnew)
	LONG		pmfnew;
{
	gsx_moff();
	if (!gl_ctmown)
	    fmemcpy( (char far *)ad_mouse, (char far *)pmfnew, 37*2);
	fmemcpy( (char far *)ad_intin, (char far *)pmfnew, 37*2);
 	gsx_ncode(ST_CUR_FORM, 0, 37);
	gsx_mon();
}

/*----------------------------------------------------------------------*/
void gsx_mxmy(pmx, pmy)
	WORD		*pmx, *pmy;
{
	*pmx = xrat;
	*pmy = yrat;
}

/*----------------------------------------------------------------------*/
WORD gsx_kstate( void )
{
	gsx_ncode(KEY_SHST, 0, 0);
	return(intout[0]);
}

/*----------------------------------------------------------------------*/
void gsx_moff( void )
{
	if (!gl_moff)
	  gsx_ncode(HIDE_CUR, 0, 0);

	gl_moff++;
}

/*----------------------------------------------------------------------*/
void gsx_mon( void )
{
	gl_moff--;
	if (!gl_moff)
	  gsx_1code(SHOW_CUR, 1);
}

/*----------------------------------------------------------------------*/
WORD gsx_char( void )
{
	intin[0] = 4;
	intin[1] = 2;
	gsx_ncode(33, 0, 2);
	intin[0] = -1;
	intin[1] = FALSE;        /* no echo */
	gsx_ncode(31, FALSE, 2);
	if (contrl[4])
	  return(intout[0]);
	else
	  return(0);
}

/*----------------------------------------------------------------------*/
void v_pline( count, pxyarray )
	WORD		count;
	WORD		*pxyarray;
{
    pblock.pPtsin = (WORD far *)pxyarray ;
    gsx_ncode( POLYLINE, count, 0);
    pblock.pPtsin = (WORD far *)ptsin ;
}

/*----------------------------------------------------------------------*/
void vst_clip( clip_flag, pxyarray )
	REG WORD	clip_flag;
	WORD		*pxyarray;
{
	WORD		value;

	value = ( clip_flag != 0 ) ? 2 : 0;
	pblock.pPtsin = (WORD far *)pxyarray ;
	intin[0] = clip_flag;
	gsx_ncode(TEXT_CLIP, value, 1);
	pblock.pPtsin = (WORD far *)ptsin;
}

/*----------------------------------------------------------------------*/
void vst_height( height, pchr_width, pchr_height, pcell_width, pcell_height )
	WORD	height;
	WORD	*pchr_width;
	WORD	*pchr_height;
	WORD	*pcell_width;
	WORD	*pcell_height;
{
	ptsin[0] = 0;
	ptsin[1] = height;
	gsx_ncode(CHAR_HEIGHT, 1, 0);
	*pchr_width = ptsout[0];
	*pchr_height = ptsout[1];
	*pcell_width = ptsout[2];
	*pcell_height = ptsout[3];
}

/*----------------------------------------------------------------------*/
void vr_recfl( pxyarray, pdesMFDB )
	WORD	*pxyarray;
	WORD	*pdesMFDB;
{
	*(LONG*)&contrl[7] = (LONG)(WORD far *)pdesMFDB ;
	pblock.pPtsin = (WORD far *)pxyarray;
	gsx_ncode(FILL_RECTANGLE, 2, 1);
	pblock.pPtsin = (WORD far *)ptsin;
}

/*----------------------------------------------------------------------*/
void vro_cpyfm( wr_mode, pxyarray, psrcMFDB, pdesMFDB )
	WORD	wr_mode;
	WORD	*pxyarray;
	FDB	*psrcMFDB;
	FDB	*pdesMFDB;
{
	intin[0] = wr_mode;
	*(LONG*)&contrl[7] = (LONG)(FDB far *)psrcMFDB ;
	*(LONG*)&contrl[9] = (LONG)(FDB far *)pdesMFDB ;
	pblock.pPtsin = (WORD far *)pxyarray;
	gsx_ncode(COPY_RASTER_FORM, 4, 1);
	pblock.pPtsin = (WORD far *)ptsin;
}

/*----------------------------------------------------------------------*/
void vrt_cpyfm( wr_mode, pxyarray, psrcMFDB, pdesMFDB, fgcolor, bgcolor )
	WORD    wr_mode;
	WORD    *pxyarray;
	WORD    *psrcMFDB;
	WORD    *pdesMFDB;
	WORD	fgcolor, bgcolor;
{
	intin[0] = wr_mode;
	intin[1] = fgcolor;
	intin[2] = bgcolor;
	*(LONG*)&contrl[7] = (LONG)(WORD far *)psrcMFDB ;
	*(LONG*)&contrl[9] = (LONG)(WORD far *)pdesMFDB ;
	pblock.pPtsin = (WORD far *)pxyarray;
	gsx_ncode(121, 4, 3);
	pblock.pPtsin = (WORD far *)ptsin;
}

/*----------------------------------------------------------------------*/
void vrn_trnfm( psrcMFDB, pdesMFDB )
	WORD	*psrcMFDB;
	WORD	*pdesMFDB;
{
	*(LONG*)&contrl[7] = (LONG)(WORD far *)psrcMFDB ;
	*(LONG*)&contrl[9] = (LONG)(WORD far *)pdesMFDB ;
	gsx_ncode( TRANSFORM_FORM, 0, 0);
}

/*----------------------------------------------------------------------*/
void vsl_width( width )
	WORD	width;
{
	ptsin[0] = width;
	ptsin[1] = 0;
	gsx_ncode(S_LINE_WIDTH, 1, 0);
}

/*----------------------------------------------------------------------*/
void vq_color( WORD index, WORD set_flag, WORD *rgb)
{
	pblock.pIntout = (WORD far *)rgb ;
	intin[0] = index;
	intin[1] = set_flag;
	contrl[2] = 0;
	contrl[4] = 4;
	gsx_ncode( INQUIRE_COLOR_REP, 0, 2);
	pblock.pIntout = (WORD far *)intout ;
}

/*----------------------------------------------------------------------*/
void vs_color( WORD *rgb )
{
	pblock.pIntin = (WORD far *)rgb ;
	contrl[2] = 0;
	contrl[4] = 0;
	gsx_ncode(SET_COLOR_REP, 0, 4);
	pblock.pIntin = (WORD far *)intin ;
}

/*----------------------------------------------------------------------*/
/* contrl[5] = 61 for make a sound, 62 for get/set mute status.		*/
WORD v_sound( BOOLEAN isfreq, WORD freq, WORD dura)
{
WORD		cnt;

	intin[0] = freq;
	intin[1] = dura;
	contrl[5] = ( isfreq ) ? 61 : 62 ;
	cnt       = ( isfreq ) ?  2 :  1 ;
	
	gsx_ncode( 5, 0, cnt );
	
	return( intout[0] );
	
} /* v_sound() */

/* end of gemgsxif.c */
