/****************************************************************************
*   Copyright 1999, Caldera Thin Client Systems, Inc.                       *
*   This software is licensed under the GNU Public License                  *
*   For further information, please see LICENSE.TXT                         *
*                                                                           *
*   Historical Copyright                                                    *
*                                                                           *
*   Copyright (c) 1985, 1987, 1990, 1991, 1992  Digital Research Inc.	    *
*   All rights reserved.						    *
*   The Software Code contained in this listing is proprietary to Digital   *
*   Research Inc., Monterey, California, and is covered by U.S. and other   *
*   copyright protection.  Unauthorized copying, adaption, distribution,    *
*   use or display is prohibited and may be subject to civil and criminal   *
*   penalties.  Disclosure to others is prohibited.  For the terms and      *
*   conditions of software code use, refer to the appropriate Digital       *
*   Research License Agreement.						    *
*****************************************************************************
*		      U.S. GOVERNMENT RESTRICTED RIGHTS			    *
*                    ---------------------------------                      *
*  This software product is provided with RESTRICTED RIGHTS.  Use, 	    *
*  duplication or disclosure by the Government is subject to restrictions   *
*  as set forth in FAR 52.227-19 (c) (2) (June, 1987) when applicable or    *
*  the applicable provisions of the DOD FAR supplement 252.227-7013 	    *
*  subdivision (b)(3)(ii) (May 1981) or subdivision (c)(1)(ii) (May 1987).  *
*  Contractor/manufacturer is Digital Research Inc. / 70 Garden Court /     *
*  BOX DRI / Monterey, CA 93940.					    *
*****************************************************************************
* $Header: g:/groups/panther/aes/rcs/geminit.c 4.6 92/04/09 14:59:40 sbc Exp $
* $Log:	geminit.c $
 * Revision 4.6  92/04/09  14:59:40  sbc
 * AES no longer frees the prev background for a new one. (done in dsk)
 * 
 * Revision 4.4  92/03/12  11:24:04  sbc
 * Merge in Keiko Hatamori's changes required for Double-Byte Character Support
 * 

*	Changed sh_init to use international strupr instead of toupper.
*	Add supporting double byte character set. (#if DBCS)		
*						14 Oct 91	K.H	
*	Use horizontal bar character in resource file.			
*						31 Oct 91	K.H	
*	Optimized for ViewMAX. (#if GEM)	26 Nov 91	K.H	
*	Changed needed memory of ldaccs.	28 Nov 91	K.H	

 * Revision 4.3  92/02/27  15:21:01  rsf
 * Conversion to medium model. Replace GEM.H with VIEWRUN.H
 * 
 * Revision 4.4  92/02/03  11:20:06  Fontes
 * Conversion to medium model. Replace GEM.H with VIEWRUN.H
 * 
 * Revision 4.3  92/01/27  16:11:27  Fontes
 * LONG -> TREE for trees, plus some cleanup and commenting
 * 
 * Revision 4.2  92/01/03  13:16:46  Fontes
 * Susan's cleanup
 * 
 * Revision 4.1  91/09/17  13:45:11  system
 * Pointer fix
 * 
 * Revision 4.0  91/09/05  11:39:54  system
 * Prototyping and cleanup plus fix to file selector
 * 
 *	Add load drive and root to PATH=	11 June 90	jfl
 *	Clean up warnings			02 May 91	rsf
 *	Add signoff message			17 May 91	whf
 *
******************************************************************************/

#include "portab.h"
#include "machine.h"
#include "obdefs.h"
#include "struct.h"
#include "basepage.h"
#include "gemlib.h"
#include "crysbind.h"
#include "funcdef.h"
#include "viewrun.h"
#include "dos.h"
#include "viewapps.h"
#include "cproto.h"
#include "aproto.h"

/*
*	In an effort to save bytes, the initialization code in this module
*	and in GEMSTART.A86 that precedes this will be overlayed with data.
*	Actually the overlapping of data must stop prior to the call to 
*	sh_main() at the bottom of this module, so we can get back to the 
*	routine that called us.
*	HOWEVER, THIS DOES NOT WORK IN 68K. This data area is static and must
*	be apart of bss for 68k.
*/

#define ROPEN 0

#define ARROW 0
#define HGLASS 2

WORD	gl_numaccs;

EXTERN WORD	DOS_ERR;

EXTERN WORD	gl_bvdisk;
EXTERN WORD	gl_bvhard;

EXTERN WORD	gl_recd;
EXTERN WORD	gl_rlen;
EXTERN LONG	gl_rbuf;

EXTERN WORD	gl_mnclick;

EXTERN PD	*gl_mowner;
EXTERN PD	*ctl_pd;

EXTERN BYTE FAR	*ad_scmd;
EXTERN BYTE FAR	*ad_stail;

EXTERN LONG	ad_ssave;
EXTERN LONG	ad_dta;
EXTERN LONG	ad_path;
#if GEM
EXTERN LONG	ad_scrap;
#endif /* GEM */
EXTERN LONG	ad_windspb;
#if GEM
EXTERN LONG	ad_tmp1;
EXTERN BYTE	gl_tmp1[];
EXTERN LONG	ad_tmp2;
EXTERN BYTE	gl_tmp2[];
EXTERN LONG	ad_fsdta;
#endif /* GEM */
EXTERN WORD	hdr_buff[];

EXTERN LONG	ad_g2loc;

EXTERN LONG	ad_tmpstr;
EXTERN LONG	ad_rawstr;
EXTERN LONG	ad_fmtstr;
EXTERN LONG	ad_edblk;
EXTERN LONG	ad_bi;
#if GEM
EXTERN TREE	ad_fstree;
#endif /* GEM */
EXTERN LONG	ad_pfile;
#if GEM
EXTERN GRECT	gl_rfs;
#endif /* GEM */
EXTERN TEDINFO	edblk;
EXTERN BITBLK	bi;
EXTERN ICONBLK	ib;

EXTERN WORD	gl_bclick;
EXTERN WORD	gl_bdesired;
EXTERN WORD	gl_btrue;
EXTERN WORD	gl_bdely;

EXTERN LONG	tikaddr;
EXTERN LONG	tiksav;
EXTERN WORD	gl_ticktime;
EXTERN WORD	totpds;				/* 2 if on 256k system,	*/
						/*   else NUM_PDS	*/
EXTERN WORD	gl_dacnt;

EXTERN WORD	gl_shgem;
EXTERN SHELL	sh[];

EXTERN THEGLO	D;

GLOBAL LONG	ad_g1loc;
GLOBAL LONG	ad_hdrbuff;
GLOBAL LONG	ad_valstr;

GLOBAL LONG	ad_sysglo;
GLOBAL LONG	ad_armice;
GLOBAL LONG	ad_hgmice;
GLOBAL LONG	ad_mouse;
GLOBAL LONG	ad_envrn;		/* initialized in GEMSTART	*/
GLOBAL TREE	ad_stdesk;

GLOBAL BYTE	gl_dta[128];
GLOBAL BYTE	gl_dir[130];
GLOBAL BYTE	gl_1loc[256];
GLOBAL BYTE	gl_2loc[256];
GLOBAL BYTE	pqueue[128];
#if GEM
GLOBAL BYTE	usuper[128];
#else /* GEM */
GLOBAL BYTE	usuper[128-82];
#endif /* GEM */
GLOBAL WORD	gl_mouse[37];
GLOBAL LONG	ad_scdir;
GLOBAL BYTE	gl_logdrv;

/* 911031 K.H */
GLOBAL UBYTE 	gl_hbc;
/* */

MLOCAL	VOID
ini_dlongs(void)
{
	REG BYTE	*ps;
						/* use all of this 	*/
						/*   initialization	*/
						/*   code area for the	*/
						/*   save area, must be	*/
						/*   on para. boundary	*/
						/*   so new environment	*/
						/*   can be copied here	*/
	ad_ssave =  LLCS() + MAKELONG(0,start);
						/* init. long pointer	*/
						/*   to global array	*/
						/*   which is used by	*/
						/*   resource calls	*/
	ad_sysglo = (LONG)(char far *)D.g_sysglo ;
	ad_windspb = (LONG)(char far *)&wind_spb ;
	ad_mouse = (LONG)(char far *)gl_mouse ;
#if GEM	
						/* gemfslib longs	*/
	ad_tmp1 = (LONG)(char far *)gl_tmp1 ;
	ad_tmp2 = (LONG)(char far *)gl_tmp2 ;
#endif /* GEM */
						/* gemrslib		*/
	ad_hdrbuff = (LONG)(char far *)(&hdr_buff[0]);
						/* gemoblib		*/
	ad_valstr = (LONG)(char far *)D.g_valstr ;
	ad_fmtstr = (LONG)(char far *)D.g_fmtstr ;
	ad_rawstr = (LONG)(char far *)D.g_rawstr ;
	ad_tmpstr = (LONG)(char far *)D.g_tmpstr ;
	ad_edblk = (LONG)(char far *)&edblk ;
	ad_bi = (LONG)(char far *)&bi;

	D.s_cmd = (BYTE *) pqueue ;
	ad_scmd = (BYTE FAR *)((LONG)(char far *)D.s_cmd);
						/* put scrap and some	*/
						/*   other arrays at	*/
						/*   at top of the	*/
						/*   screen mgr stack	*/
#if GEM	
	ps = D.g_scrap = (BYTE *)usuper ;
	ad_scrap = (LONG)(char far *)(ps);
	D.s_cdir = ps += 82;
#else /* GEM */
	ps = D.s_cdir = (BYTE *) &usuper[0];
#endif /* GEM */
	ad_scdir = (LONG)(char far *)(ps);
	D.g_loc1 = ps = &gl_1loc[0];
	ad_g1loc = (LONG)(char far *)(ps);
	D.g_loc2 = ps = &gl_2loc[0];
	ad_g2loc = (LONG)(char far *)(ps);
	D.g_dir = ps = &gl_dir[0];
	ad_path = (LONG)(char far *)(ps);
	D.g_dta = ps = &gl_dta[0];
	ad_dta = (LONG)(char far *)(ps);
#if GEM	
	ad_fsdta = (LONG)(char far *)(&gl_dta[30]);
#endif /* GEM */	
}

	WORD
sizeglo( void )
{
	return(sizeof(THEGLO) );
}

/*
*	called from startup code to get the stack for process 0
*/
	WORD
sizeuda( void )
{
	return( sizeof(UDA) - sizeof(WORD) );
}

MLOCAL	VOID
ev_init(EVB *evblist, WORD cnt)
{
	WORD		i;

	for(i=0; i<cnt; i++)
	{
	  evblist[i].e_nextp = eul;
	  eul = &evblist[i];
	}
}

/*
*	Create a local process for the routine and start him executing.
*	Also do all the initialization that is required.
*/
MLOCAL	PD
*iprocess(BYTE *pname, VOID (*routine)())
{
	REG ULONG	ldaddr;

						/* figure out load addr	*/
	ldaddr = LLCS() + ((LONG)((WORD)( routine) & 0xffff));
/*	ldaddr = LLCS() + ((ULONG) routine); */
						/*   create process to	*/
						/*   execute it		*/
	return( pstart(routine, pname, ldaddr) );
}

#if GEM
/*
*	Start up the file selector by initializing the fs_tree
*/
MLOCAL	VOID
fs_start( void )
{
	TREE		tree;

	rs_gaddr(ad_sysglo, R_TREE, FSELECTR, (LONG*)&tree);

	ad_fstree = tree;
	ob_center(tree, &gl_rfs);
}
#endif /* GEM */

/*
*	Routine to load program file pointed at by pfilespec, then
*	create new process context for it.  This uses the load overlay
*	function of DOS.  The room for accessories variable will be
*	decremented by the size of the accessory image.  If the
*	accessory is too big to fit it will be not be loaded.
*/
MLOCAL	VOID
sndcli(REG BYTE *pfilespec, UWORD *paccroom)
					/* paccroom is in paragraphs*/
{
	REG WORD	handle;
	WORD		err_ret;
	LONG		ldaddr;


	strcpy( D.s_cmd, pfilespec );

	handle = dos_open( ad_scmd, ROPEN );
	if (!DOS_ERR)
	{
	  err_ret = pgmld(handle, &D.s_cmd[0], &ldaddr, paccroom);
	  dos_close(handle);
						/* create process to	*/
						/*   execute it		*/
	  if (err_ret != -1)
	    pstart(gotopgm, pfilespec, ldaddr);
	}
}

/*
*	Routine to load in desk accessory's.  Files by the name of *.ACC
*	will be loaded, if there is sufficient room for them in the system.
*	The number that this gives is the room available for desk accessories.
*
*	0x20000		128 kb for app
*	0x01000		  4 kb for virt wk station
*	0x00800		  2 kb for file selector
*	0x02000		  8 kb for fudge factor
*	-------
*	0x23800
*
*	FOR GEM2.0 max is 192kb
*	0x33800
*	FOR ViewMAX max is 300kb
*	0x4e800
*/
MLOCAL	VOID
ldaccs( void )
{
	REG WORD	i;
	WORD		ret;
	ULONG		laccroom;
	UWORD		accroom;
#if GEM
	laccroom = dos_avail() - 0x00033800L - gsx_mcalc();
#else /* GEM */
	laccroom = dos_avail() - 0x0004e800L - gsx_mcalc();
#endif /* GEM */
	accroom = (UWORD)((laccroom + 0x0000000fL) >> 4);
	strcpy( D.g_dir, rs_str(STACC) );
	dos_sdta(ad_dta);
	ret = TRUE;
	for(i=0; (i<NUM_ACCS) && (accroom > 0) && (ret); i++)
	{
	  ret = (i==0) ? dos_sfirst(ad_path, F_RDONLY) : dos_snext();
	  if (ret)
	    sndcli(&gl_dta[30], &accroom);
	}
}

MLOCAL	VOID sh_addpath( void )
{
BYTE FAR *old_envr, FAR *new_envr;
BYTE FAR *path_ptr, FAR *env_ptr, FAR *load_ptr, FAR *rest_ptr;
WORD	size,n;
#if DBCS
BYTE	ch;
WORD	i;
#endif /* DBCS */

	old_envr = (BYTE FAR *)ad_envrn; /* Point to existing environment */
	new_envr = (BYTE FAR *)ad_ssave; /* Allocate new environment	*/
	sh_envrn((LONG FAR *)&path_ptr, (BYTE FAR *)rs_str(STPATH)); /* Find PATH= */
	size = (WORD)( path_ptr-old_envr );
	fmemcpy( new_envr, old_envr, size);	/* Copy upto end of PATH= */
	env_ptr = new_envr+size;
	
	/* Point to rest of environment */
	rest_ptr = path_ptr+fstrlen(path_ptr);
	
	/* Find the load path */
	for( load_ptr=path_ptr ; LWGET(load_ptr) ; load_ptr++ );
	load_ptr+=4;
	
	/* Copy load path + prog name */
	fstrcpy( env_ptr, load_ptr );	

#if DBCS
	for( i=0, n=0; (ch = LBGET(env_ptr+i)) != 0; i++ );
	{
	    if (dbcs_lead(ch) && LBGET(env_ptr+i+1))
		i++;
	    else if (ch == '\\')
		n = i;
	}
#else /* DBCS */
	for( n=fstrlen(env_ptr) ; n && LBGET(env_ptr+n)!='\\' ; n-- );
#endif /* DBCS */    
	if( n && LBGET(env_ptr+n-1)==':' )
	    n++;
	LBSET((env_ptr+n),';');	/* Chop program name */
	LBSET((env_ptr+n+1),0);
	
	/* Append original path */
	fstrcpy((env_ptr+n+1),path_ptr );
	n=fstrlen(env_ptr);
	
	/* Append extra search directories from rsc file	*/
	LBSET( env_ptr+n,';' );
	n++;
	fmemcpy( env_ptr+n, (BYTE FAR*)ADDR(rs_str(STINPATH)), 
		strlen(rs_str(STINPATH))+1 );
	
	/* Fixup the drive letter with current drive */
	for( path_ptr=env_ptr+n ; LBGET(path_ptr) ; path_ptr++ ){
	  if( LBGET(path_ptr)==':' )
	    LBSET( path_ptr-1,gl_logdrv );
	}
	n=fstrlen(env_ptr);
	
	/* Append rest of environment */
	fmemcpy( env_ptr+n, rest_ptr, (WORD)(load_ptr-rest_ptr) );
	 	
	/* Append load path/filename */
	fstrcpy( (BYTE FAR *)((LONG)env_ptr+n+((LONG)load_ptr-(LONG)rest_ptr)), load_ptr );
	
	ad_ssave += (LONG)((LONG)env_ptr+n+((LONG)load_ptr-(LONG)rest_ptr)+fstrlen(load_ptr)+1);
	ad_envrn = (LONG)new_envr;
	
}

MLOCAL	VOID
sh_init( void )
{
	WORD	 	cnt, need_ext;
	BYTE		*psrc, *pdst, *pend;
	BYTE		*s_tail;
	SHELL		*psh;
	BYTE		savch;

	psh = &sh[0];

	sh_desk(2, ADDR(&ad_pfile));
						/* add in internal 	*/
						/*   search paths with	*/
						/*   right drive letter	*/
	
	sh_addpath();
						/* set defaults		*/
	psh->sh_doexec = psh->sh_dodef = gl_shgem
		 = psh->sh_isgem = TRUE;
	psh->sh_fullstep = FALSE;

						/* parse command tail	*/
						/*   that was stored in	*/
						/*   geminit		*/
	psrc = s_tail = &D.g_dir[0];		/* reuse part of globals*/
	fmemcpy((BYTE FAR *)&s_tail[0], ad_stail, 128);
	cnt = *psrc++;
	if (cnt)
	{
						/* null-terminate it	*/
	  pend = psrc + cnt;
	  *pend = NULL;
						/* scan off leading 	*/
						/*   spaces		*/
	  while( (*psrc) &&
		 (*psrc == ' ') )
	    psrc++;
						/* if only white space	*/
						/*   get out don't	*/
						/*   bother parsing	*/
	  if (*psrc)
	  {
	    pdst = psrc;
	    while ( (*pdst) && (*pdst != ' ') )
	      pdst++;				/* find end of app name	*/

						/* save command to do	*/
						/*   instead of desktop	*/
	    savch = *pdst;
	    *pdst = '\0';			/* mark for sh_name()	*/
	    pend = sh_name(psrc);		/* see if path also	*/
	    *pdst = savch;			/* either blank or null	*/
	    pdst = &D.s_cmd[0];
	    if (pend != psrc)
	    {
	      if (*(psrc+1) != ':')		/* need drive		*/
	      {
		*pdst++ = gl_logdrv;		/* current drive	*/
		*pdst++ = ':';
	        if (*psrc != '\\')
		  *pdst++ = '\\';
	      }
	      while (psrc < pend)		/* copy rest of path	*/
		*pdst++ = *psrc++;
	      if (*(pdst-1) == '\\')		/* back up one char	*/
	        pdst--;
	      *pdst = '\0';
	      pend = &D.s_cmd[0];
#ifdef KH_911014
	      while (*pend)			/* upcase the path	*/
	      {
	        *pend = toupper(*pend);
	        pend++;
	      }
#else /* KH_911014 */
	      strupr(pend);			/* upcase the path	*/
#endif /* KH_911014 */
	      dos_sdrv(D.s_cmd[0] -'A');
	      dos_chdir((LONG)ad_scmd);
	      *pdst++ = '\\';
	    }
	    need_ext = TRUE;
	    while ( (*psrc) &&
		    (*psrc != ' ') )
	    {
	      if (*psrc == '.')
	        need_ext = FALSE;
	      *pdst++ = *psrc++;
	    }
						/* append .APP if no	*/
						/*   extension given	*/
	    if (need_ext)
	      strcpy( pdst, rs_str(STGEM) );
	    else
	      *pdst = NULL;
	    pdst = &D.s_cmd[0];
#ifdef KH_911014
	    while (*pdst)			/* upcase the command	*/
	    {
	      *pdst = toupper(*pdst);
	      pdst++;
	    }
#else /* KH_911014 */
	      strupr(pdst);			/* upcase the command	*/
#endif /* KH_911014 */

	    psh->sh_dodef = FALSE;
						/* save the remainder	*/
						/*   into command tail	*/
						/*   for the application*/
	    pdst = &s_tail[1];
/*	    if ( (*psrc) &&			* if tail then take	*
	       (*psrc != 0x0D) &&		*  out first space	*
	       (*psrc == ' ') )
	          psrc++;
*/
	    if (*psrc == ' ')
	      psrc++;
					      /* the batch file allows	*/
					      /*  three arguments	*/
					      /*  one for a gem app	*/
					      /*  and 2 for arguments	*/
					      /*  to the gem app.	*/
					      /*  if there are " three	*/
					      /*  there will be a space	*/
					      /*  at the end of the last*/
					      /*  arg followed by a 0D	*/
	    while ( (*psrc) && 
	    	    (*psrc != 0x0D) &&
	    	    (*psrc != 0x09) &&		/* what is this??	*/
		    !((*psrc == '/') && (toupper(*(psrc+1)) == 'D')) )
	    {
	      if ( (*psrc == ' ') &&
	           ( (*(psrc+1) == 0x0D) ||
		     (*(psrc+1) == NULL)) )
	        psrc++;
	      else
#ifdef KH_911014		  
	        *pdst++ = toupper(*psrc++);
#else /* KH_911014 */	    
	        *pdst++ = *psrc++;
#endif /* KH_911014 */	    
	    }
	    *pdst = NULL;
	    strupr(&s_tail[1]);			/* upcase the command tail*/
	    
	    s_tail[0] = strlen(&s_tail[1]);
						/* don't do the desktop	*/
						/*   after this command	*/
						/*   unless a /d was	*/
						/*   encounterd		*/
	    psh->sh_doexec = (toupper(*(psrc+1)) == 'D');
	  }
	}
	fmemcpy(ad_stail, (BYTE FAR *)(&s_tail[0]), 128);
}



        VOID
gem_main()
{
	WORD		i;
	LONG		tmpadbi;

						/* init longs		*/
	ini_dlongs();
						/* no ticks during init	*/
	cli();
						/* take the 0efh int.	*/
	takecpm();
						/* init event recorder	*/
	gl_recd = FALSE;
	gl_rlen = 0;
	gl_rbuf = 0x0L;
						/* initialize pointers	*/
						/*   to heads of event	*/
						/*   list and thread	*/
						/*   list		*/
	elinkoff = (BYTE *) &(D.g_intevb[0].e_link) - (BYTE *) &(D.g_intevb[0]);
						/* link up all the evb's*/
						/*   to the event unused*/
						/*   list		*/
	eul = NULLPTR;
	ev_init(&D.g_intevb[0], NUM_IEVBS);
	if (totpds > 2)
	  ev_init(&D.g_extevb[0], NUM_EEVBS);

						/* initialize list	*/
						/*   and unused lists	*/
	nrl = drl = NULLPTR;
	dlr = zlr = NULLPTR;
	fph = fpt = fpcnt = 0;
						/* initialize sync	*/
						/*   blocks		*/
	wind_spb.sy_tas = 0;
	wind_spb.sy_owner = NULLPTR;
	wind_spb.sy_wait = 0;
						/* init initial process	*/
	for(i=totpds-1; i>=0; i--)
	{
	  rlr = pd_index(i);
	  if (i < 2) 
	  {
	    rlr->p_uda = &D.g_intuda[i];
	    rlr->p_cda = &D.g_intcda[i];
	  }
	  else
	  {
	    rlr->p_uda = &D.g_extuda[i-2];
	    rlr->p_cda = &D.g_extcda[i-2];
	  }
	  rlr->p_qaddr = ADDR(&rlr->p_queue[0]);
	  rlr->p_qindex = 0;
	  memset( &rlr->p_name[0], ' ', 8 );
						/* if not rlr then	*/
						/*   initialize his	*/
						/*   stack pointer	*/
	  if (i != 0)
	    rlr->p_uda->u_spsuper = &rlr->p_uda->u_supstk;
	  rlr->p_pid = i;
	  rlr->p_stat = 0;
	}
	curpid = 0;
	rlr->p_pid = curpid++;
	rlr->p_link = NULLPTR;
						/* restart the tick	*/
	sti();
						/* screen manager 	*/
						/*   process init. this	*/
						/*   process starts out	*/
						/*   owning the mouse	*/
						/*   and the keyboard.	*/
						/*   it has a pid == 1	*/
	gl_dacnt = 0;
	gl_mowner = ctl_pd = 
		iprocess("SCRENMGR", ctlmgr);
	    
	init_lib();			/* get international information */
	
						/* load gem resource	*/
						/*   and fix it up 	*/
						/*   before we go	*/
	if ( !rs_readit(ad_sysglo, (BYTE FAR *)("VIEWRUN.RSC")) ) 
	{
	  /* bad resource load, so dive out */
	}
	else
	{
						/* get mice forms	*/
	  rs_gaddr(ad_sysglo, R_BIPDATA, 3 + ARROW, &ad_armice);
	  ad_armice = LLGET(ad_armice);
	  rs_gaddr(ad_sysglo, R_BIPDATA, 3 + HGLASS, &ad_hgmice);
	  ad_hgmice = LLGET(ad_hgmice);
						/* init button stuff	*/
	  gl_btrue = 0x0;
	  gl_bdesired = 0x0;
	  gl_bdely = 0x0;
	  gl_bclick = 0x0;

	  gl_logdrv = dos_gdrv() + 'A';		/* boot directory	*/
						/* do gsx open work	*/
						/*   station	 	*/
	  gsx_init();
						/* load all desk acc's	*/
	  if (totpds > 2)
	    ldaccs();
						/* fix up icons		*/
	  for(i=0; i<3; i++)
	  {
	    rs_gaddr(ad_sysglo, R_BITBLK, i, &tmpadbi);
	    fmemcpy((BYTE FAR *)ad_bi, (BYTE FAR *)tmpadbi, sizeof(BITBLK));
	    gsx_trans(bi.bi_pdata, bi.bi_wb, bi.bi_pdata, bi.bi_wb, bi.bi_hl);
	  }
						/* take the critical err*/
						/*   handler int.	*/
	  cli();
	  takeerr();
	  sti();
						/* go into graphic mode	*/
	  sh_tographic();
						/* take the tick int.	*/
	  cli();
	  gl_ticktime = gsx_tick(tikaddr, &tiksav);
	  sti();
						/* set init. click rate	*/
	  ev_dclick(3, TRUE);
						/* fix up the GEM rsc.	*/
						/*   file now that we	*/
						/*   have an open WS	*/ 
	  rs_fixit(ad_sysglo);
						/* get st_desk ptr	*/
	  rs_gaddr(ad_sysglo, R_TREE, 2, (LONG*)&ad_stdesk);	
	  gl_hbc = *rs_str(HORIZBAR);		/* get horizontal bar char */
	  
	  					/* init. window vars.	*/
	  wm_start();
#if GEM	  
						/* startup gem libs	*/
	  fs_start();
#endif /* GEM */      
						/* remember current	*/
						/*   desktop directory	*/
	  sh_curdir((BYTE FAR *)ad_scdir);
	  					/* read the desktop.inf	*/
						/* 2/20/86 LKW		*/
						/* off we go !!!	*/
	  dsptch();
						/* let them run		*/
	  all_run();
						/* init for shell loop	*/
						/*   up thru here it is	*/
						/*   okay for system	*/
						/*   to overlay this 	*/
						/*   initialization code*/
	  sh_init();
						/* main shell loop	*/
						/*   from here on down	*/
						/*   data should not	*/
						/*   overlay this code	*/
	  sh_main();
						/* free up resource	*/
						/*   space		*/
	  rs_free(ad_sysglo);
						/* give back the tick	*/
	  cli();
 	  gl_ticktime = gsx_tick(tiksav, &tiksav);
	  sti();
						/* close workstation	*/
	  gsx_ncode(CLOSE_WORKSTATION, 0, 0);
	}
						/* return GEM's 0xEF int*/
	cli();
	givecpm();
	sti();

	sh_signoff();				/* output signoff msg	*/
}


/*
*	Give everyone a chance to run, at least once
*/
	VOID
all_run()
{
	WORD		i;

						/* let all the acc's run*/
	  for(i=0; i<NUM_ACCS; i++)
		  dsptch();
						/* then get in the wait	*/
						/*   line		*/
	  wm_update(TRUE);
	  wm_update(FALSE);
}


	VOID
sh_desk(obj, plong)
	WORD		obj;
	LONG		plong;
{
	REG TREE	tree;

	tree = ad_stdesk;
	LLSET( plong, (tree+obj)->ob_spec );
}

/* geminit.c */

