/****************************************************************************
*   Copyright 1999, Caldera Thin Client Systems, Inc.                       *
*   This software is licensed under the GNU Public License                  *
*   For further information, please see LICENSE.TXT                         *
*                                                                           *
*   Historical Copyright                                                    *
*                                                                           *
*   Copyright (c) 1985, 1987, 1990, 1991, 1992 Digital Research Inc.	    *
*   All rights reserved.						    *
*   The Software Code contained in this listing is proprietary to Digital   *
*   Research Inc., Monterey, California, and is covered by U.S. and other   *
*   copyright protection.  Unauthorized copying, adaption, distribution,    *
*   use or display is prohibited and may be subject to civil and criminal   *
*   penalties.  Disclosure to others is prohibited.  For the terms and      *
*   conditions of software code use, refer to the appropriate Digital       *
*   Research License Agreement.						    *
*****************************************************************************
*		      U.S. GOVERNMENT RESTRICTED RIGHTS			    *
*                    ---------------------------------                      *
*  This software product is provided with RESTRICTED RIGHTS.  Use, 	    *
*  duplication or disclosure by the Government is subject to restrictions   *
*  as set forth in FAR 52.227-19 (c) (2) (June, 1987) when applicable or    *
*  the applicable provisions of the DOD FAR supplement 252.227-7013 	    *
*  subdivision (b)(3)(ii) (May 1981) or subdivision (c)(1)(ii) (May 1987).  *
*  Contractor/manufacturer is Digital Research Inc. / 70 Garden Court /     *
*  BOX DRI / Monterey, CA 93940.					    *
*****************************************************************************
* $Header: m:/davinci/users//groups/panther/aes/rcs/gemobed.c 4.5 92/03/26 14:48:21 sbc Exp $
* $Log:	gemobed.c $
 * Revision 4.5  92/03/26  14:48:21  sbc
 * Merge in RSF's changes
 * 
 * Revision 4.4  92/03/23  14:13:41  Fontes
 * Fix for text field editing
 * 
 * Revision 4.4  92/03/16  12:31:37  sbc
 * Merge in Keiko's fixes from Jan 17
 * 
 * 920117 KH Fixed bug for editing double-byte characters. This change is only
 * for DBCS country.
 * 
 * Revision 4.3  92/03/12  11:24:53  sbc
 * Merge in Keiko Hatamori's changes required for Double-Byte Character Support
 * 
 * KH: Add supporting double byte character set. (#if DBCS)
 *
 * Revision 4.2  92/02/27  15:22:30  rsf
 * Conversion to medium model. Replace GEM.H with VIEWRUN.H
 * 
 * Revision 4.3  92/02/03  11:20:14  Fontes
 * Conversion to medium model. Replace GEM.H with VIEWRUN.H
 * 
 * Revision 4.2  92/01/27  16:12:52  Fontes
 * LONG -> TREE for trees, plus some cleanup and commenting
 * 
 * Revision 4.1  92/01/03  13:17:09  Fontes
 * Susan's cleanup
 * 
 * Revision 4.0  91/09/05  11:41:13  system
 * Prototyping and cleanup plus fix to file selector
 * 
****************************************************************************/

#include "portab.h"
#include "machine.h"
#include "struct.h"
#include "basepage.h"
#include "obdefs.h"
#include "viewrun.h"
#include "gemlib.h"
#include "gemkeybd.h"
#include "viewapps.h"
#include "cproto.h"
#include "aproto.h"

#if DBCS
#define	DMY_SPC		3
#define	TYP_END		4
#define	DB_SPACE	0x8140	/* This is for only Shift-JIS code system */
#endif /* DBCS */

EXTERN WORD	gl_wchar;
EXTERN WORD	gl_hchar;

EXTERN WORD	gl_wbox;
EXTERN WORD	gl_hbox;

EXTERN WORD	gl_width;
EXTERN WORD	gl_height;
EXTERN TEDINFO	edblk;

EXTERN LONG	ad_tmpstr;
EXTERN LONG	ad_valstr;
EXTERN LONG	ad_rawstr;

EXTERN THEGLO	D;

/*----------------------------------------------------------------------------
 *
 *--------------------------------------------------------------------------*/
MLOCAL void
ob_getsp(REG TREE tree, REG WORD obj, TEDINFO *pted)
{
	WORD		flags;
	REG LONG	spec;

	flags = (tree+obj)->ob_flags ;
	spec =  (tree+obj)->ob_spec ;
	if (flags & INDIRECT)
	  spec = LLGET(spec);
	fmemcpy((BYTE FAR*)pted, (BYTE FAR *)spec, sizeof(TEDINFO));
}

/*----------------------------------------------------------------------------
 *
 *--------------------------------------------------------------------------*/
void ob_center( TREE tree, GRECT * pt)
{
	REG WORD	xd, yd, wd, hd;
	WORD		height;
	OBJECT far *	pRoot ;

	pRoot = tree + ROOT ;
	wd = pRoot->ob_width ;
	hd = pRoot->ob_height ;
	xd = ((gl_width - wd) / 2) / gl_wchar * gl_wchar;
					/* don't center on xtra long screens */
	height = min(gl_height, 25 * gl_hchar);
	yd = gl_hbox + ((height - gl_hbox - hd) / 2);
	pRoot->ob_x = xd ;
	pRoot->ob_y = yd ;
						/* account for outline	*/
						/*   or shadow		*/
	if ( pRoot->ob_state & (OUTLINED | SHADOWED) )
	{
	  xd -= 8;
	  yd -= 8;
 	  wd += 16;
	  hd += 16;
	}
	
	r_set(pt, xd, yd, wd, hd);
}

/*----------------------------------------------------------------------------
*	Routine to scan thru a string looking for the occurrence of
*	the specified character.  IDX is updated as we go based on
*	the '_' characters that are encountered.  The reason for
*	this routine is so that if a user types a template character
*	during field entry the cursor will jump to the first 
*	raw string underscore after that character.
*/
MLOCAL WORD scan_to_end( REG BYTE *pstr, REG WORD idx, BYTE chr )
{
#if DBCS
	while( (*pstr) &&
	       (*pstr != chr) )
	{
	  if (dbcs_lead(*pstr) && *(pstr+1))
	    pstr+=2;
	  else if (*pstr++ == '_')
	    idx++;
	}
#else /* DBCS */
	while( (*pstr) &&
	       (*pstr != chr) )
	{
	  if (*pstr++ == '_')
	    idx++;
	}
#endif /* DBCS */	
	return(idx);
}

/*----------------------------------------------------------------------------
*	Routine that returns a format/template string relative number
*	for the position that was input (in raw string relative numbers).
*	The returned position will always be right before an '_'.
*/
MLOCAL WORD find_pos( REG BYTE *str, REG WORD pos )
{
REG WORD	i;

#if DBCS
	for (i=0; pos > 0; i++) 
	{
	  if (dbcs_lead(str[i]))
	    i++;
	  else if (str[i] == '_')
	    pos--;
	}
						/* skip to first one	*/
	while( (str[i]) &&
	       (str[i] != '_') )
	  if (dbcs_lead(str[i++]) && str[i])
	    i++;
#else /* DBCS */
	for (i=0; pos > 0; i++) 
	{
	  if (str[i] == '_')
	    pos--;
	}
						/* skip to first one	*/
	while( (str[i]) &&
	       (str[i] != '_') )
	  i++;
#endif /* DBCS */      
	return(i);
}

/*----------------------------------------------------------------------------
 *
 *--------------------------------------------------------------------------*/
MLOCAL void pxl_rect( REG TREE tree, REG WORD obj, WORD ch_pos, REG GRECT *pt)
{
	GRECT		o;

	ob_actxywh(tree, obj, &o);
	gr_just(edblk.te_just, edblk.te_font, edblk.te_ptmplt, 
				o.g_w, o.g_h, &o);
	pt->g_x = o.g_x + (ch_pos * gl_wchar);
	pt->g_y = o.g_y;
	pt->g_w = gl_wchar;
	pt->g_h = gl_hchar;
}

/*----------------------------------------------------------------------------
*	Routine to redraw the cursor or the field being editted.
*/
MLOCAL void curfld( TREE tree, WORD obj, WORD new_pos, WORD dist)
{
	GRECT		oc, t;

        pxl_rect(tree, obj, new_pos, &t);
	if (dist)
	  t.g_w += (dist - 1) * gl_wchar;
	else
	{
	  gsx_attr(FALSE, MD_XOR, BLACK);
	  t.g_y -= 3;
	  t.g_h += 6;
	}
						/* set the new clip rect*/
	gsx_gclip(&oc);
	gsx_sclip(&t);
						/* redraw the field	*/
	if (dist)
	  ob_draw(tree, obj, 0);
	else{
	  gsx_cline(t.g_x, t.g_y, t.g_x, t.g_y+t.g_h-1);
	  gsx_cline(t.g_x+1, t.g_y, t.g_x+1, t.g_y+t.g_h-1);
	}					/* turn on cursor in	*/
						/*   new position	*/
        gsx_sclip(&oc);
}

/*----------------------------------------------------------------------------
*	Routine to check to see if given character is in the desired 
*	range.  The character ranges are
*	stored as enumerated characters (xyz) or ranges (x..z)
*/
MLOCAL WORD instr( REG BYTE chr, REG BYTE *str )
{
	REG BYTE	test1, test2;

	while(*str)
	{
	  test1 = test2 = *str++;
	  if ( (*str == '.') &&
	       (*(str+1) == '.') )
	  {
	    str += 2;
	    test2 = *str++;
	  }
	  if ( (chr >= test1) &&
	       (chr <= test2) )
	    return(TRUE);
	}
	return(FALSE);
}

/*----------------------------------------------------------------------------
*	Routine to verify that the character matches the validation
*	string.  If necessary, upshift it.
*/
MLOCAL WORD
#if DBCS
check( REG BYTE *in_char, BYTE valchar, WORD ctype)
#else /* DBCS */
check( REG BYTE *in_char, BYTE valchar)
#endif /* DBCS */
{
	REG WORD	upcase;
	REG WORD	rstr;

#if DBCS
	if ( ctype == CT_DBC1 || ctype == CT_DBC2 ) {
	    switch(toupper(valchar)) {
		case 'P':
     	        case 'F':	
		case 'S':
		case 'X':
		    return(TRUE);
	        default :
		    return( FALSE );
		}
	    }
#endif /* DBCS */
	upcase = TRUE;
	rstr = -1;
	switch(valchar)
	{
	  case '9':				/* 0..9			*/
	    rstr = ST9VAL;
	    upcase = FALSE;
	    break;
	  case 'A':				/* A..Z, <space>	*/
	    rstr = STAVAL;
	    break;
	  case 'N':				/* 0..9, A..Z, <SPACE>	*/
	    rstr = STNVAL;
	    break;
	  case 'P':	    /* DOS pathname + '\', '?', '*', ':','.',','*/
	    rstr = STPVAL;
	    break;
	  case 'p':			/* DOS pathname + '\` + ':'	*/
	    rstr = STLPVAL;
	    break;
	  case 'F':
	  case 'S':			/* DOS filename + ':', '?' + '*' */
	    rstr = STFVAL;		/* S=silent echo */
	    break;
	  case 'f':
	  case 's':				/* DOS filename */
	    rstr = STLFAVAL;			/* s=silent echo */
	    break;
	  case 'a':				/* a..z, A..Z, <SPACE>	*/
	    rstr = STLAVAL;
	    upcase = FALSE;
	    break;
	  case 'n':				/* 0..9, a..z, A..Z,<SP>*/
	    rstr = STLNVAL;
	    upcase = FALSE;
	    break;
	  case 'x':
	    *in_char = toupper(*in_char);
	    return(TRUE);
	  case 'X':
	    return(TRUE);
	}
	if (rstr != -1)
	{
	  if ( instr(*in_char, rs_str(rstr)) )
	  {
	     if (upcase)
	       *in_char = toupper(*in_char);
	     return(TRUE);
	  }
	}

	return(FALSE);
}

/*----------------------------------------------------------------------------
*	Find STart and FiNish of a raw string relative to the template
*	string.  The start is determined by the InDeX position given.
*/
MLOCAL void ob_stfn( WORD idx, WORD *pstart, WORD *pfinish)
{
	*pstart = find_pos(&D.g_tmpstr[0], idx);
	*pfinish = find_pos(&D.g_tmpstr[0], strlen(&D.g_rawstr[0]) );
}

#if DBCS
WORD init_type( WORD idx )
{
	REG WORD	i;
	REG WORD	type = CT_ADE;

	for (i=0; i<idx; i++)
	    D.g_typstr[i] = (type = chkctype(D.g_rawstr[i], type));
	D.g_typstr[i] = TYP_END;
	return( type );
}

/*----------------------------------------------------------------------------
 *
 *--------------------------------------------------------------------------*/
void ob_insrt( WORD idx, UBYTE chr, WORD type, WORD maxlen)
{
REG WORD	i, last;

	last = strlen( &D.g_rawstr[0] );
	for (i = last; i > idx; i--)
	{
	    D.g_rawstr[i] = D.g_rawstr[i-1];
	    D.g_typstr[i] = D.g_typstr[i-1];
	}
	D.g_rawstr[i] = chr;
	D.g_typstr[i] = type;

	if (last >= maxlen-1)
	{
	   last = maxlen-2;
	   if (D.g_typstr[last] == CT_DBC1)
	      last--;
	}
	D.g_rawstr[last+1] = NULL;
	D.g_typstr[last+1] = TYP_END;
}
#endif /* DBCS */

/*----------------------------------------------------------------------------
 *
 *--------------------------------------------------------------------------*/
MLOCAL WORD ob_delit( WORD idx)
{
#if DBCS
	REG WORD	s, d;
#endif /* DBCS */
	if (D.g_rawstr[idx])
	{
#if DBCS
	  d = idx;
	  s = (D.g_typstr[idx] == CT_DBC1)? idx+2 : idx+1;
	  strcpy(&D.g_rawstr[d], &D.g_rawstr[s]);
	  while(s < MAX_LEN)
	      if ((D.g_typstr[d++] = D.g_typstr[s++]) == TYP_END)
		   break;
#else /* DBCS */
	  strcpy( &D.g_rawstr[idx], &D.g_rawstr[idx+1] );
#endif /* DBCS */      
	  return(FALSE);
	}
	return(TRUE);
}

#if DBCS
/*----------------------------------------------------------------------------
 *
 *--------------------------------------------------------------------------*/
void ins_dummy( REG WORD rawidx, REG WORD tmpidx, WORD maxlen)
{
	if (dbcs_expected())		/* are we looking out for DBCS? */
	while (D.g_rawstr[rawidx] != '\0')
	{
	    if (D.g_tmpstr[tmpidx] == '_')
	    {
		tmpidx++;
		rawidx++;
	    }
	    else
	    {
		tmpidx++;
		if (D.g_typstr[rawidx] == CT_DBC2)
		    ob_insrt(rawidx - 1, ' ', DMY_SPC, maxlen);
	    }
	}
}

/*----------------------------------------------------------------------------
 *
 *--------------------------------------------------------------------------*/
void del_dummy( REG WORD idx)
{
	if (dbcs_expected())		/* are we looking out for DBCS? */
	while(D.g_typstr[idx] != TYP_END)
	{
	    while(D.g_typstr[idx] == DMY_SPC)
		ob_delit(idx);
	    idx++;
	}
}

#ifdef DB_SPACE
/*----------------------------------------------------------------------------
 *
 *--------------------------------------------------------------------------*/
WORD chk_dbsp( void )
{
	REG WORD	i;
	WORD		ret = FALSE;

	for(i=0; D.g_rawstr[i]; i++)
	{
	    if ( (D.g_typstr[i] == CT_DBC2) &&
		((((UWORD)D.g_rawstr[i-1] << 8) | D.g_rawstr[i]) == DB_SPACE) )
	    switch(toupper(D.g_valstr[i]))
	    {
		case 'P':
		case 'F':
		case 'S':
		    D.g_rawstr[i-1] = ' ';
		    D.g_typstr[i-1] = CT_ADE;
		    D.g_rawstr[i] = ' ';
		    D.g_typstr[i] = CT_ADE;
		    ret = TRUE;
	    }
	}
	return(ret);
}
#endif /* DB_SPACE */
#endif /* DBCS */

/*----------------------------------------------------------------------------
 *
 *--------------------------------------------------------------------------*/
WORD ob_edit( REG TREE tree, REG WORD obj, WORD in_char, 
						    REG WORD * idx, WORD kind)
{
	WORD		pos, len;
	WORD		ii, no_redraw, start, finish, nstart, nfinish;
	REG WORD	dist, tmp_back, cur_pos;
	BYTE		bin_char;
#if DBCS
static  WORD		ctype = CT_ADE;
#endif /* DBCS */

	if ( (kind == EDSTART) ||
	     (obj <= 0) )
	  return(TRUE);
						/* copy TEDINFO struct	*/
						/*   to local struct	*/
	ob_getsp(tree, obj, &edblk);
						/* copy passed in strs	*/
						/*   to local strs	*/
	fstrcpy((BYTE FAR *)ad_tmpstr, (BYTE FAR *)edblk.te_ptmplt);
	fstrcpy((BYTE FAR *)ad_rawstr, (BYTE FAR *)edblk.te_ptext);
	len = ii = fstrlen( (BYTE FAR *)edblk.te_pvalid );
	fstrcpy((BYTE FAR *)ad_valstr, (BYTE FAR *)edblk.te_pvalid);
						/* expand out valid str	*/
	while ( (ii > 0) &&
		(len < edblk.te_tmplen) )
	  D.g_valstr[len++] = D.g_valstr[ii-1];
	D.g_valstr[len] = NULL;
						/* init formatted	*/
						/*   string		*/
	ob_format(edblk.te_just, &D.g_rawstr[0], &D.g_tmpstr[0], 
			&D.g_fmtstr[0]);
	switch(kind)
	{
	  case EDINIT:
		*idx = strlen(&D.g_rawstr[0]);
#if DBCS
		ctype = init_type(*idx);
#endif /* DBCS */
		break;
	  case EDCHAR:
		/* at this point, D.g_fmtstr has already been formatted--*/
		/*   it has both template & data. now update D.g_fmtstr	*/
		/*   with in_char; return it; strip out junk & update	*/
		/*   ptext string.					*/
		no_redraw = TRUE;
						/* find cursor & turn	*/
						/*   it off		*/
		ob_stfn(*idx, &start, &finish);
						/* turn cursor off	*/
		cur_pos = start;
		curfld(tree, obj, cur_pos, 0);
#if DBCS
		ctype = chkctype((UBYTE)in_char, ctype);
#endif /* DBCS */

		switch(in_char)
		{
		  case BACKSPACE:
			if (*idx > 0)
			{
			  *idx -= 1;
#if DBCS
	   		  if (D.g_typstr[*idx] == CT_DBC2)
			     *idx -= 1;
			  del_dummy(*idx);
#endif /* DBCS */
			  no_redraw = ob_delit(*idx);
#if DBCS
			  cur_pos = find_pos(&D.g_tmpstr[0], *idx);
			  ins_dummy(*idx, cur_pos, edblk.te_txtlen);
#endif /* DBCS */
			}
			break;
		  case CTL_BACKSPACE:
			*idx = 0;
			D.g_rawstr[0] = NULL;
			no_redraw = FALSE;
#if DBCS
			ctype = init_type(*idx);
#endif /* DBCS */
			break;
		  case DELETE:
			if (*idx <= (edblk.te_txtlen - 2))
#if DBCS
			{
			  del_dummy(*idx);
#endif /* DBCS */
			  no_redraw = ob_delit(*idx);
#if DBCS
			  ins_dummy(*idx, cur_pos, edblk.te_txtlen);
			}
#endif /* DBCS */
			break;
		  case LEFT:
			if (*idx > 0)
		  	  *idx -= 1;
#if DBCS
			if (D.g_typstr[*idx] == CT_DBC2)
			  *idx -= 1;
#endif /* DBCS */
			break;
		  case RIGHT:
			if ( *idx < strlen(&D.g_rawstr[0]) )
			  *idx += 1;
#if DBCS
			if (D.g_typstr[*idx] == CT_DBC2)
			  *idx += 1;
#endif /* DBCS */
			break;
		  case TAB:
		  case BACKTAB:
		  case RETURN:
		  	break;
		  default:
#if DBCS
			if (ctype == CT_DBC2 ) {
			    if ( D.g_typstr[*idx] == CT_DBC1) {
				*idx += 1;
				cur_pos++;
			    }
			    else
				break ;
			}
			tmp_back = 0;
			if ( *idx > 
		  	     (edblk.te_txtlen - ((ctype == CT_DBC1) ? 3 : 2)) )
			{
			  tmp_back++;
			  if ( (ctype == CT_DBC1) && 
			       (*idx > (edblk.te_txtlen-2)) )
			    tmp_back++;
			  if (D.g_typstr[*idx-tmp_back] == CT_DBC2)
			    tmp_back++;
			  if (*idx < tmp_back)
			      break ;
			  cur_pos -= tmp_back;
			  start = cur_pos;
			  *idx -= tmp_back;
			}
#else /* DBCS */
			tmp_back = FALSE;
			if (*idx > (edblk.te_txtlen - 2))
			{
			  cur_pos--;
			  start = cur_pos;
			  tmp_back = TRUE;
			  *idx -= 1;
			}
#endif /* DBCS */
			bin_char = in_char & 0x00ff;
			if (bin_char)
			{
						/* make sure char is	*/
						/*   in specified set	*/
#if DBCS
			  if ( check(&bin_char, D.g_valstr[*idx], ctype) )
			  {
			    if (ctype != CT_DBC2)
			        del_dummy(*idx);
			    ob_insrt(*idx, bin_char, ctype, edblk.te_txtlen);
			    if (ctype == CT_DBC1)
			        break;
			    ins_dummy(*idx, cur_pos, edblk.te_txtlen);
			    while (D.g_typstr[*idx] == DMY_SPC)
	    			*idx += 1;
			    *idx += 1;
			    if (D.g_typstr[*idx] == CT_DBC2)
			        *idx += 1;
#else /* DBCS */
			  if ( check(&bin_char, D.g_valstr[*idx]) )
			  {
			    ins_char(&D.g_rawstr[0], *idx, bin_char, 
					edblk.te_txtlen);
			    *idx += 1;
#endif /* DBCS */
			    no_redraw = FALSE;
			  }
		  	  else
			  {		/* see if we can skip ahead	*/
			    if (tmp_back)
			    {
#if DBCS
		  	      *idx += tmp_back;
			      cur_pos += tmp_back;
#else /* DBCS */
		  	      *idx += 1;
			      cur_pos++;
#endif /* DBCS */			      
			    }
#if DBCS
			    if (ctype != CT_ADE)
			      break;
#endif /* DBCS */			    
		 	    pos = scan_to_end(&D.g_tmpstr[0]+cur_pos, *idx,
								 bin_char);

		 	    if (pos < (edblk.te_txtlen - 2) )
			    {
			      memset( &D.g_rawstr[*idx], SPACE, pos - *idx );
			      D.g_rawstr[pos] = NULL;
#if DBCS
			      memset( &D.g_typstr[*idx], CT_ADE, pos - *idx );
			      D.g_typstr[pos] = TYP_END;
#endif /* DBCS */
			      *idx = pos;
		 	      no_redraw = FALSE;
			    }
			  }
			}
			break;
		}

		fstrcpy((BYTE FAR *)edblk.te_ptext, (BYTE FAR *)ad_rawstr);

		if (!no_redraw)
		{
		  ob_format(edblk.te_just, &D.g_rawstr[0], &D.g_tmpstr[0],
				 &D.g_fmtstr[0]);
		  ob_stfn(*idx, &nstart, &nfinish);
	 	  start = min(start, nstart);
		  dist = max(finish, nfinish) - start;
		  if (dist)
		    curfld(tree, obj, start, dist);
		}
	        break;
	  case EDEND:
#ifdef DB_SPACE
		if (chk_dbsp())
		    fstrcpy(edblk.te_ptext, ad_rawstr);
#endif /* DB_SPACE */
		break;
	}
						/* draw/erase the cursor*/
	cur_pos = find_pos(&D.g_tmpstr[0], *idx);
	curfld(tree, obj, cur_pos, 0);
	return(TRUE);
}

/* gemobed.c */
