/****************************************************************************
*   Copyright 1999, Caldera Thin Client Systems, Inc.                       *
*   This software is licensed under the GNU Public License                  *
*   For further information, please see LICENSE.TXT                         *
*                                                                           *
*   Historical Copyright                                                    *
*                                                                           *
*   Copyright (c) 1985, 1987, 1990, 1991  Digital Research Inc.		    *
*   All rights reserved.						    *
*   The Software Code contained in this listing is proprietary to Digital   *
*   Research Inc., Monterey, California, and is covered by U.S. and other   *
*   copyright protection.  Unauthorized copying, adaption, distribution,    *
*   use or display is prohibited and may be subject to civil and criminal   *
*   penalties.  Disclosure to others is prohibited.  For the terms and      *
*   conditions of software code use, refer to the appropriate Digital       *
*   Research License Agreement.						    *
*****************************************************************************
*		      U.S. GOVERNMENT RESTRICTED RIGHTS			    *
*                    ---------------------------------                      *
*  This software product is provided with RESTRICTED RIGHTS.  Use, 	    *
*  duplication or disclosure by the Government is subject to restrictions   *
*  as set forth in FAR 52.227-19 (c) (2) (June, 1987) when applicable or    *
*  the applicable provisions of the DOD FAR supplement 252.227-7013 	    *
*  subdivision (b)(3)(ii) (May 1981) or subdivision (c)(1)(ii) (May 1987).  *
*  Contractor/manufacturer is Digital Research Inc. / 70 Garden Court /     *
*  BOX DRI / Monterey, CA 93940.					    *
*****************************************************************************
* $Header: g:/groups/panther/aes/rcs/gemobjop.c 4.5 92/04/09 15:00:15 sbc Exp $
* $Log:	gemobjop.c $
 * Revision 4.5  92/04/09  15:00:15  sbc
 * AES no longer frees the prev background for a new one. (done in dsk)
 * 
 * Revision 4.3  92/02/28  12:22:59  sbc
 * rm refs to LBYTE2, LBYTE3, LLGET. Replace with LOBYTE(HIWORD()), castings, etc.
 * 
 * Revision 4.2  92/02/27  15:24:25  rsf
 * Conversion to medium model. Replace GEM.H with VIEWRUN.H
 * 
 * Revision 4.2  92/01/27  16:09:36  Fontes
 * LONG -> TREE for trees, plus some cleanup and commenting
 * 
 * Revision 4.1  92/01/03  13:17:14  Fontes
 * Susan's cleanup
 * 
 * Revision 4.0  91/09/05  11:54:37  system
 * Prototyping and cleanup plus fix to file selector code
 * 
*/

/****************************************************************************
* File:		gemobjop.c
*
* Description:	
*
* Build Info:	ndmake -f aes.mak
*
*****************************************************************************/

/*	GEMOBJOP.C	03/15/84 - 05/27/85	Gregg Morris		*/
/*	merge High C vers. w. 2.2 		8/21/87		mdf	*/ 
/*	fix get_par				11/12/87	mdf	*/

/*
*	-------------------------------------------------------------
*	GEM Application Environment Services		  Version 2.3
*	Serial No.  XXXX-0000-654321		  All Rights Reserved
*	Copyright (C) 1987			Digital Research Inc.
*	-------------------------------------------------------------
*/

#include "portab.h"
#include "machine.h"
#include "obdefs.h"
#include "cproto.h"
#include "aproto.h"

#if SBC
	TREE
obaddr(tree, obj, fld_off)
	TREE		tree;
	WORD		obj;
	WORD		fld_off;
{
	return( (TREE)((LONG)tree + ((obj) * sizeof(OBJECT) + fld_off)) );
}
#endif

	BYTE
ob_sst(tree, obj, pspec, pstate, ptype, pflags, pt, pth)
	TREE		tree;
	WORD		obj;
	REG LONG	*pspec;
	WORD		*pstate, *ptype;
	REG WORD	*pflags;
	REG GRECT	*pt;
	WORD		*pth;
{
	WORD		th;
	OBJECT far *	tmp;

	tmp = tree + obj ;
	pt->g_w = tmp->ob_width;
	pt->g_h = tmp->ob_height;
	*pflags = tmp->ob_flags;
	*pspec = tmp->ob_spec;

	if (*pflags & INDIRECT)
	  *pspec = *(LONG far *)tmp->ob_spec ;

	*pstate = tmp->ob_state;
	*ptype = tmp->ob_type & 0x00ff;
	th = 0;
	switch( *ptype )
	{
	  case G_TITLE:
		th = 1;
		break;
	  case G_TEXT:
	  case G_BOXTEXT:
	  case G_FTEXT:
	  case G_FBOXTEXT:
		th = (WORD)*(LONG far *)(*pspec+22);
		break;
	  case G_BOX:
	  case G_BOXCHAR:
	  case G_IBOX:
		th = LOBYTE( HIWORD( *pspec ) ) ;
		break;
	  case G_BUTTON:
		th--;
		if ( *pflags & EXIT ){
#if 0000
			/* slim down buttons (for nicer 3D effects */
		  th--;
#endif
		  if( *pflags & DEFAULT )
		    th--;
		}
		break;
	}
	if (th > 128)
	  th -= 256;
	*pth = th;
	return( HIBYTE( HIWORD( *pspec ) ) ) ;
}


/***********************************************************************
	This routine performs the passed in routine on every object
	in the tree.
***********************************************************************/
	VOID
everyobj(tree, this, last, routine, startx, starty, maxdep)
	REG TREE	tree;
	REG WORD	this, last;
	VOID		(*routine)(TREE, WORD, WORD, WORD);
	WORD		startx, starty;
	WORD		maxdep;
{
	REG WORD	tmp1;
	REG WORD	depth;
	WORD		x[8], y[8];

	x[0] = startx;
	y[0] = starty;
	depth = 1;
						/* non-recursive tree	*/
						/*   traversal		*/
child:
						/* see if we need to	*/
						/*   to stop		*/
	if ( this == last)
	  return;
						/* do this object	*/
	x[depth] = x[depth-1] + (tree+this)->ob_x ;
	y[depth] = y[depth-1] + (tree+this)->ob_y ;

	(*routine)(tree, this, x[depth], y[depth]);
						/* if this guy has kids	*/
						/*   then do them	*/
	tmp1 = (tree+this)->ob_head ;

	if ( tmp1 != NIL )
	{
 	  if ( !( (tree+this)->ob_flags & HIDETREE ) && ( depth <= maxdep ) )
	  {
	    depth++;
	    this = tmp1;
	    goto child;
	  }
	}
sibling:
						/* if this is the root	*/
						/*   which has no parent*/
						/*   or it is the last	*/
						/*   then stop else... 	*/
 	tmp1 = (tree+this)->ob_next ;
	if ( (tmp1 == last) ||
	     (this == ROOT) )	
	  return;
						/* if this obj. has a	*/
						/*   sibling that is not*/
						/*   his parent, then	*/
						/*   move to him and do	*/
						/*   him and his kids	*/
 	if ( (tree+tmp1)->ob_tail != this )
	{
	  this = tmp1;
	  goto child;
	}
						/* else move up to the	*/
						/*   parent and finish	*/
						/*   off his siblings	*/ 
	depth--;
	this = tmp1;
	goto sibling;
}


/*
*	Routine that will find the parent of a given object.  The
*	idea is to walk to the end of our siblings and return
*	our parent.  If object is the root then return NIL as parent.
*	Also have this routine return the immediate next object of
*	this object.
*
*

*/
	WORD
get_par(tree, obj, pnobj)
	REG TREE	tree;
	REG WORD	obj;
	WORD		*pnobj;
{
	REG WORD	pobj;
	REG WORD	nobj;

	pobj = obj;
	nobj = NIL;
	if (obj == ROOT)
	  pobj = NIL;
	else
	{
	  do
	  {
	    obj = pobj;
	    pobj = (tree+obj)->ob_next ;
	    if (nobj == NIL)
	      nobj = pobj;
	  } while ( pobj >= ROOT && (tree+pobj)->ob_tail != obj );
	}
	*pnobj = nobj;
	return(pobj);
} /* get_par */


/* end of gemobjop.c */
