/****************************************************************************
*   Copyright 1999, Caldera Thin Client Systems, Inc.                       *
*   This software is licensed under the GNU Public License                  *
*   For further information, please see LICENSE.TXT                         *
*                                                                           *
*   Historical Copyright                                                    *
*                                                                           *
*   Copyright (c) 1985, 1987, 1990, 1991  Digital Research Inc.		    *
*   All rights reserved.						    *
*   The Software Code contained in this listing is proprietary to Digital   *
*   Research Inc., Monterey, California, and is covered by U.S. and other   *
*   copyright protection.  Unauthorized copying, adaption, distribution,    *
*   use or display is prohibited and may be subject to civil and criminal   *
*   penalties.  Disclosure to others is prohibited.  For the terms and      *
*   conditions of software code use, refer to the appropriate Digital       *
*   Research License Agreement.						    *
*****************************************************************************
*		      U.S. GOVERNMENT RESTRICTED RIGHTS			    *
*                    ---------------------------------                      *
*  This software product is provided with RESTRICTED RIGHTS.  Use, 	    *
*  duplication or disclosure by the Government is subject to restrictions   *
*  as set forth in FAR 52.227-19 (c) (2) (June, 1987) when applicable or    *
*  the applicable provisions of the DOD FAR supplement 252.227-7013 	    *
*  subdivision (b)(3)(ii) (May 1981) or subdivision (c)(1)(ii) (May 1987).  *
*  Contractor/manufacturer is Digital Research Inc. / 70 Garden Court /     *
*  BOX DRI / Monterey, CA 93940.					    *
*****************************************************************************
* $Header: m:/davinci/users//groups/panther/aes/rcs/gempd.c 4.1 92/01/06 11:57:39 sbc Exp $
* $Log:	gempd.c $
 * Revision 4.1  92/01/06  11:57:39  sbc
 * Misc Housekeeping
 * 
 * Revision 4.0  91/09/05  11:40:33  system
 * Prototyping and cleanup plus fix to file selector
 * 
*/

/****************************************************************************
* File:		gempd.c
*
* Description:	
*
* Build Info:	ndmake -f aes.mak
*
*****************************************************************************/

/*	GEMPD.C		1/27/84 - 03/20/85	Lee Jay Lorenzen	*/
/*	merge High C vers. w. 2.2 		8/21/87		mdf	*/ 

/*
*	-------------------------------------------------------------
*	GEM Application Environment Services		  Version 2.3
*	Serial No.  XXXX-0000-654321		  All Rights Reserved
*	Copyright (C) 1987			Digital Research Inc.
*	-------------------------------------------------------------
*/

#include "portab.h"
#include "machine.h"
#include "struct.h"
#include "basepage.h"
#include "obdefs.h"
#include "gemlib.h"
#include "cproto.h"
#include "aproto.h"

EXTERN THEGLO	D;				/* in GLOBAL.C		*/

EXTERN WORD	totpds;


	PD
*pd_index(i)
	WORD		i;
{
	return( (i<2) ? &D.g_intpd[i] : &D.g_extpd[i-2] );
}


	PD
*fpdnm(pname, pid)
	BYTE		*pname;
	UWORD		pid;
{
	WORD		i;
	BYTE		temp[9];
	PD		*p;

	temp[8] = NULL;
	for(i=0; i<totpds; i++)
	{
	  p = pd_index(i);
	  if (pname != NULLPTR)
	  {
	    memmove( temp, p->p_name, 8 );
	    if ( !strcmp(pname, &temp[0]) )
	      return(p);
	  }
	  else
	    if (p->p_pid == pid)
	      return(p);
	}
	return(0);
}


MLOCAL	PD 
*getpd( void )
{
	REG PD		*p;
						/* we got all our 	*/
						/*   memory so link it	*/
	p = pd_index(curpid);
	p->p_pid = curpid++;
						/* initialize his DS&SS	*/
						/*   registers so	*/
						/*   stproc works	*/
	setdsss(p->p_uda);
						/* return the pd we got	*/
	return(p);
}


	VOID
p_nameit(p, pname)
	PD		*p;
	BYTE		*pname;
{
	memset( &p->p_name[0], ' ', 8 );
	strscn(pname, &p->p_name[0], '.');
}


	PD
*pstart(pcode, pfilespec, ldaddr)
	VOID		(*pcode)();
	BYTE		*pfilespec;
	LONG		ldaddr;
{
	REG PD		*px;
						/* create process to	*/
						/*   execute it		*/
	px = getpd();
	px->p_ldaddr = ldaddr;
						/* copy in name of file	*/
	p_nameit(px, pfilespec);
						/* cs, ip, use 0 flags	*/
	psetup(px, pcode);
						/* link him up		*/
	px->p_stat &= ~WAITIN;
	px->p_link = drl;
	drl = px;

	return(px);
}

						/* put pd pi into list 	*/
						/*   *root at the end	*/
	VOID
insert_process(pi, root)
	PD		*pi, **root;
{
	REG PD		*p, *q;
						/* find the end		*/
	for ( p = (q = (PD *) root) -> p_link ; p ; p = (q = p) -> p_link); 
						/* link him in		*/
	pi->p_link = p;
	q->p_link = pi;
}


