/****************************************************************************
*   Copyright 1999, Caldera Thin Client Systems, Inc.                       *
*   This software is licensed under the GNU Public License                  *
*   For further information, please see LICENSE.TXT                         *
*                                                                           *
*   Historical Copyright                                                    *
*                                                                           *
*   Copyright (c) 1985, 1987, 1990, 1991  Digital Research Inc.		    *
*   All rights reserved.						    *
*   The Software Code contained in this listing is proprietary to Digital   *
*   Research Inc., Monterey, California, and is covered by U.S. and other   *
*   copyright protection.  Unauthorized copying, adaption, distribution,    *
*   use or display is prohibited and may be subject to civil and criminal   *
*   penalties.  Disclosure to others is prohibited.  For the terms and      *
*   conditions of software code use, refer to the appropriate Digital       *
*   Research License Agreement.						    *
*****************************************************************************
*		      U.S. GOVERNMENT RESTRICTED RIGHTS			    *
*                    ---------------------------------                      *
*  This software product is provided with RESTRICTED RIGHTS.  Use, 	    *
*  duplication or disclosure by the Government is subject to restrictions   *
*  as set forth in FAR 52.227-19 (c) (2) (June, 1987) when applicable or    *
*  the applicable provisions of the DOD FAR supplement 252.227-7013 	    *
*  subdivision (b)(3)(ii) (May 1981) or subdivision (c)(1)(ii) (May 1987).  *
*  Contractor/manufacturer is Digital Research Inc. / 70 Garden Court /     *
*  BOX DRI / Monterey, CA 93940.					    *
*****************************************************************************
* $Header: m:/davinci/users//groups/panther/aes/rcs/gemqueue.c 4.1 92/01/06 11:57:57 sbc Exp $
* $Log:	gemqueue.c $
 * Revision 4.1  92/01/06  11:57:57  sbc
 * Misc Housekeeping
 * 
 * Revision 4.0  91/09/05  11:40:37  system
 * Prototyping and cleanup plus fix to file selector
 * 
*/

/****************************************************************************
* File:		gemqueue.c
*
* Description:	
*
* Build Info:	ndmake -f aes.mak
*
*****************************************************************************/

/*	GEMQUEUE.C	1/27/84 - 07/09/85	Lee Jay Lorenzen	*/
/*	merge High C vers. w. 2.2 		8/21/87		mdf	*/ 
/*	Fix constant out of range		5/2/91		RSF	*/

/*
*	-------------------------------------------------------------
*	GEM Application Environment Services		  Version 2.3
*	Serial No.  XXXX-0000-654321		  All Rights Reserved
*	Copyright (C) 1987			Digital Research Inc.
*	-------------------------------------------------------------
*/

#include "portab.h"
#include "machine.h"
#include "struct.h"
#include "basepage.h"
#include "obdefs.h"
#include "gemlib.h"
#include "cproto.h"
#include "aproto.h"

MLOCAL	VOID
doq(WORD donq, REG PD *p, QPB *m)
{
	REG WORD	n, index;
	REG WORD	*om, *nm;

	n = m->qpb_cnt;
	if (donq)
	{
	  fmemcpy((BYTE FAR *)(p->p_qaddr + p->p_qindex), 
		  (BYTE FAR *)m->qpb_buf, n);
						/* if its a redraw msg	*/
						/*   try to find a 	*/
						/*   matching msg and	*/
						/*   union the redraw	*/
						/*   rects together	*/
	  nm = (WORD *) &p->p_queue[p->p_qindex];
	  if ( (nm[0] == WM_REDRAW) ||
	       (nm[0] == WM_ARROWED) ||
	       (nm[0] == WM_HSLID) ||
	       (nm[0] == WM_VSLID) )
	  {
	    index = 0;
	    while ( (index < p->p_qindex) &&
		    (n) )
	    {
	      om = (WORD *) &p->p_queue[index];
						/* if redraw and same	*/
						/*   handle then union	*/
	      if ( (om[0] == WM_REDRAW) &&
		   (nm[3] == om[3]) )
	      {
		rc_union((GRECT*)&nm[4], (GRECT*)&om[4]);
	        n = 0;
	      }
	      else
	      {
						/* if another arrow	*/
						/*   command then copy  */
						/*   over with new msg	*/
						/*   else add in length	*/
						/*   and get next messg	*/
	        if (om[0] == WM_ARROWED)
		{
		  memmove( (BYTE*)&om[0], (BYTE*)&nm[0], 16 );
	          n = 0;
		}
		else		/* (RSF) Change 0xFFFF to -1 so const in
					range.				*/
		  index += (om[2] != -1) ? (om[2] + 16) : 16;
	      }
	    }
	  }
	  p->p_qindex += n;
	}
	else
	{
	  fmemcpy((BYTE FAR*)m->qpb_buf, (BYTE FAR *)p->p_qaddr, n);
	  p->p_qindex -= n;
	  if ( p->p_qindex )
	    fmemcpy((BYTE FAR *)p->p_qaddr, (BYTE FAR*)(p->p_qaddr + n), 
		    p->p_qindex);
	}
}


	VOID
aqueue(isqwrite, e, lm)
	WORD		isqwrite;
	REG EVB		*e;
	LONG		lm;
{
	REG PD		*p;
	REG QPB		*m;
	EVB		**ppe;
	WORD		qready;
	
	m = (QPB *) lm;

	p = m->qpb_ppd;

	if (isqwrite)
	  qready = ( m->qpb_cnt <= (QUEUE_SIZE - p->p_qindex) );
	else
	  qready = ( p->p_qindex > 0 );

	ppe = (isqwrite ^ qready) ? &p->p_qnq : &p->p_qdq;
						/* room for message	*/
						/*  or messages in q	*/
	if (qready)
	{
	  doq(isqwrite, p, m);
	  azombie(e, 0);
	  if (( e = *ppe ) != 0)		/* assignment ok	*/
	  {
	    e->e_flag |= NOCANCEL;
	    *ppe = e->e_link;

	    if ( e->e_link )
	      e->e_link->e_pred = e->e_pred;

	    doq(!isqwrite, p, (QPB *) e->e_parm);
	    azombie(e, 0);
	  }
	}
	else					/* "block" the event	*/
	{
	  e->e_parm = lm;
	  evinsert(e, ppe);
	}
}

