/****************************************************************************
*   Copyright 1999, Caldera Thin Client Systems, Inc.                       *
*   This software is licensed under the GNU Public License                  *
*   For further information, please see LICENSE.TXT                         *
*                                                                           *
*   Historical Copyright                                                    *
*                                                                           *
*   Copyright (c) 1985, 1987, 1990, 1991, 1992  Digital Research	    *
*   All rights reserved.						    *
*   The Software Code contained in this listing is proprietary to Digital   *
*   Research Inc., Monterey, California, and is covered by U.S. and other   *
*   copyright protection.  Unauthorized copying, adaption, distribution,    *
*   use or display is prohibited and may be subject to civil and criminal   *
*   penalties.  Disclosure to others is prohibited.  For the terms and      *
*   conditions of software code use, refer to the appropriate Digital       *
*   Research License Agreement.						    *
*****************************************************************************
*		      U.S. GOVERNMENT RESTRICTED RIGHTS			    *
*                    ---------------------------------                      *
*  This software product is provided with RESTRICTED RIGHTS.  Use, 	    *
*  duplication or disclosure by the Government is subject to restrictions   *
*  as set forth in FAR 52.227-19 (c) (2) (June, 1987) when applicable or    *
*  the applicable provisions of the DOD FAR supplement 252.227-7013 	    *
*  subdivision (b)(3)(ii) (May 1981) or subdivision (c)(1)(ii) (May 1987).  *
*  Contractor/manufacturer is Digital Research Inc. / 70 Garden Court /     *
*  BOX DRI / Monterey, CA 93940.					    *
*****************************************************************************
* $Header: m:/davinci/users//groups/panther/aes/rcs/gemsuper.c 4.4 92/03/26 14:48:27 sbc Exp $
* $Log:	gemsuper.c $
 * Revision 4.4  92/03/26  14:48:27  sbc
 * Merge in RSF's changes
 * 
 * Revision 4.4  92/03/20  20:16:57  Fontes
 * Removed bmp file processing from AES
 * 
 * Revision 4.3  92/03/20  15:10:15  Fontes
 * Merged from Susan, March 18
 * 
 * Revision 4.3  92/03/12  11:24:32  sbc
 * Merge in Keiko Hatamori's changes required for Double-Byte Character Support
 * 
 * 911126	K.H	Optimized for ViewMAX. (#if GEM)
 *     
 * Revision 4.2  92/02/27  15:22:11  rsf
 * Conversion to medium model. Replace GEM.H with VIEWRUN.H
 * 
 * Revision 4.5  92/02/11  11:32:23  Fontes
 * Background image display implementation
 * 
 * Revision 4.4  92/02/03  11:23:10  Fontes
 * Conversion to medium model. Replace GEM.H with VIEWRUN.H
 * 
 * Revision 4.3  92/01/27  16:30:45  Fontes
 * Improper type in call to rs_obfix, fixed
 * 
 * Revision 4.2  92/01/27  16:10:32  Fontes
 * LONG -> TREE for trees, plus some cleanup and commenting
 * 
 * Revision 4.1  92/01/03  13:17:52  Fontes
 * Susan's cleanup
 * 
 * Revision 4.0  91/09/05  11:40:49  system
 * Prototyping and cleanup plus fix to file selector
 * 
*/

#include "portab.h"
#include "machine.h"
#include "struct.h"
#include "basepage.h"
#include "obdefs.h"
#include "gemlib.h"
#include "crysbind.h"
#include "viewrun.h"
#include "cproto.h"
#include "aproto.h"


#define CONTROL LLGET(pcrys_blk)
#define GGLOBAL LLGET(pcrys_blk+4)
#define INT_IN LLGET(pcrys_blk+8)
#define INT_OUT LLGET(pcrys_blk+12)
#define ADDR_IN LLGET(pcrys_blk+16)
#define ADDR_OUT LLGET(pcrys_blk+20)

EXTERN WORD	gl_wchar;
EXTERN WORD	gl_hchar;
EXTERN WORD	gl_wbox;
EXTERN WORD	gl_hbox;
EXTERN WORD	gl_handle;
EXTERN LONG	ad_sysglo;
EXTERN WORD	gl_nplanes;

EXTERN PD	*gl_mnppd;
EXTERN TREE	gl_mntree;
EXTERN TREE	menu_tree[];

EXTERN LONG	desk_acc[];

EXTERN GRECT	gl_rfull;

EXTERN THEGLO	D;

GLOBAL WORD	gl_bvdisk;
GLOBAL WORD	gl_bvhard;
GLOBAL WORD	gl_dspcnt;
GLOBAL WORD	gl_mnpds[NUM_PDS];
GLOBAL WORD	gl_mnclick;

MLOCAL LONG	ad_rso;


	UWORD
crysbind(opcode, pglobal, int_in, int_out, addr_in)
	WORD		opcode;
	REG LONG	pglobal;
	REG UWORD	int_in[];
	REG UWORD	int_out[];
	REG LONG	addr_in[];
{
	LONG		maddr;
	TREE		tree;
	REG WORD	ret;

	ret = TRUE;
	switch(opcode)
	{	
				/* Application Manager			*/
	  case APPL_INIT:
	  	LWSET(pglobal, 0x0300);		/* version number	*/
	  	LWSET(pglobal+2, 0x0001);	/* num of concurrent procs*/
		LWSET(pglobal+4, rlr->p_pid);
		sh_desk(0, pglobal+6);
		LWSET(pglobal+20, gl_nplanes);
		LLSET(pglobal+22, ADDR(&D));
		LWSET(pglobal+26, gl_bvdisk);
		LWSET(pglobal+28, gl_bvhard);
						/* reset dispatcher 	*/
						/*  count to let the app*/
						/*  run a while.	*/
		gl_dspcnt = NULL;
		ret = ap_init();
		break;
	  case APPL_READ:
	  case APPL_WRITE:
		ap_rdwr(opcode == APPL_READ ? MU_MESAG : MU_SDMSG, 
			fpdnm(NULLPTR, AP_RWID), AP_LENGTH, AP_PBUFF);
		break;
	  case APPL_FIND:
		ret = ap_find( AP_PNAME );
		break;
	  case APPL_BVSET:
		gl_bvdisk = AP_BVDISK;
		gl_bvhard = AP_BVHARD;
		break;
	  case APPL_YIELD:
		dsptch();
		break;
	  case APPL_EXIT:
		ap_exit();
		break;
				/* Event Manager			*/
	  case EVNT_KEYBD:
		  ret = ev_block(MU_KEYBD, 0x0L);
		break;
	  case EVNT_BUTTON:
		ret = ev_button(B_CLICKS, B_MASK, B_STATE, &EV_MX);
		break;
	  case EVNT_MOUSE:
		ret = ev_mouse((MOBLK*)&MO_FLAGS, &EV_MX);
		break;
	  case EVNT_MESAG:
		ap_rdwr(MU_MESAG, rlr, 16, ME_PBUFF);
		break;
	  case EVNT_TIMER:
		ev_timer( MAKELONG( T_HICOUNT, T_LOCOUNT ) );
		break;
	  case EVNT_MULTI:
		if (MU_FLAGS & MU_TIMER)
		maddr = MAKELONG( MT_HICOUNT, MT_LOCOUNT );
		if ((MB_MASK == 3) && (MB_STATE == 1))
		{
			MB_STATE = 0;  
		}
		tree = (TREE)MAKELONG( MB_CLICKS, (MB_MASK << 8) | MB_STATE );
		ret = ev_multi(MU_FLAGS, (MOBLK*)&MMO1_FLAGS, 
			(MOBLK*)&MMO2_FLAGS, 
			maddr, (LONG)tree, MME_PBUFF, &EV_MX);
		break;
	  case EVNT_DCLICK:
		ret = ev_dclick(EV_DCRATE, EV_DCSETIT);
		break;
				/* Menu Manager				*/
	  case MENU_BAR:
                if (gl_mnppd == rlr)
		  mn_bar((TREE)MM_ITREE, SHOW_IT, rlr->p_pid);
		else
		  menu_tree[rlr->p_pid] = (SHOW_IT) ? (TREE)MM_ITREE : 0x0L;
		break;
	  case MENU_ICHECK:
		do_chg((TREE)MM_ITREE, ITEM_NUM, CHECKED, CHECK_IT, 
			FALSE, FALSE);
		break;
	  case MENU_IENABLE:
				  /* Make sure disabled are not selected */
		tree = (TREE)MM_ITREE;
		if ( !(	(tree+(ITEM_NUM&0x7fff))->ob_state
			& DISABLED))
		  do_chg((TREE)MM_ITREE, (ITEM_NUM & 0x7fff), SELECTED , 
			FALSE, FALSE, FALSE);
		do_chg((TREE)MM_ITREE, (ITEM_NUM & 0x7fff), DISABLED , 
			!ENABLE_IT, ((ITEM_NUM & 0x8000) != 0x0), FALSE);
		break;
	  case MENU_TNORMAL:
		if (gl_mntree == menu_tree[rlr->p_pid])
		  do_chg((TREE)MM_ITREE, TITLE_NUM, SELECTED, !NORMAL_IT, 
				TRUE, TRUE);
		break;
	  case MENU_TEXT:
		tree = (TREE)MM_ITREE;
		if (HIWORD((LONG)tree))
		  fstrcpy((BYTE FAR *)((tree+ITEM_NUM)->ob_spec),
			  (BYTE FAR *)MM_PTEXT);	
		else
		  fstrcpy((BYTE FAR *)desk_acc[ gl_mnpds[ LOWORD(tree) ] ], 
			  (BYTE FAR *)MM_PTEXT);
		break;
	  case MENU_REGISTER:
		ret = mn_register(MM_PID, MM_PSTR);
		break;
	  case MENU_UNREGISTER:
		if (MM_MID == 0xFFFF)	/* (RSF) change -1 to 0xFFFF 'cause
					    MM_MID is unsigned.		*/
		  MM_MID = gl_mnpds[rlr->p_pid];
		mn_unregister( MM_MID );
		break;
				/* Object Manager			*/
	  case MENU_CLICK:
		if (MN_SETIT)
		  gl_mnclick = MN_CLICK;
		ret = gl_mnclick;
		break;

	  case OBJC_ADD:
		ob_add((TREE)OB_TREE, OB_PARENT, OB_CHILD);
		break;
	  case OBJC_DELETE:
		ob_delete((TREE)OB_TREE, OB_DELOB);
		break;
	  case OBJC_DRAW:
		gsx_sclip((GRECT*)&OB_XCLIP);
		ob_draw((TREE)OB_TREE, OB_DRAWOB, OB_DEPTH);
		break;
	  case OBJC_FIND:
		ret = ob_find((TREE)OB_TREE, OB_STARTOB, OB_DEPTH, 
				OB_MX, OB_MY);
		break;
	  case OBJC_OFFSET:
		ob_offset((TREE)OB_TREE, OB_OBJ, (WORD*)&OB_XOFF, (WORD*)&OB_YOFF);
		break;
	  case OBJC_ORDER:
		ob_order((TREE)OB_TREE, OB_OBJ, OB_NEWPOS);
		break;
	  case OBJC_EDIT:
		gsx_sclip(&gl_rfull);
		OB_ODX = OB_IDX;
		ret = ob_edit((TREE)OB_TREE, OB_OBJ, OB_CHAR, 
			(WORD*)&OB_ODX, OB_KIND);
		break;
	  case OBJC_CHANGE:
		gsx_sclip((GRECT*)&OB_XCLIP);
		ob_change((TREE)OB_TREE, OB_DRAWOB, OB_NEWSTATE, OB_REDRAW);
		break;
				/* Form Manager				*/
	  case FORM_DO:
		ret = fm_do((TREE)FM_FORM, FM_START);
		break;
	  case FORM_DIAL:
		ret = fm_dial(FM_TYPE, (GRECT*)&FM_X);
		break;
	  case FORM_ALERT:
		ret = fm_alert(FM_DEFBUT, FM_ASTRING);
		break;
	  case FORM_ERROR:
		ret = fm_error(FM_ERRNUM);
		break;
	  case FORM_CENTER:
		ob_center((TREE)FM_FORM, (GRECT*)&FM_XC);
		break;
	  case FORM_KEYBD:
		gsx_sclip(&gl_rfull);
		FM_OCHAR = FM_ICHAR;
		FM_ONXTOB = FM_INXTOB;
		ret = fm_keybd((TREE)FM_FORM, FM_OBJ, 
			(WORD*)&FM_OCHAR, (WORD*)&FM_ONXTOB);
		break;
	  case FORM_BUTTON:
		gsx_sclip(&gl_rfull);
		ret = fm_button((TREE)FM_FORM, FM_OBJ, FM_CLKS, (WORD*)&FM_ONXTOB);
		break;
				/* Graphics Manager			*/
	  case GRAF_RUBBOX:
		  gr_rubbox(GR_I1, GR_I2, GR_I3, GR_I4, 
					(WORD*)&GR_O1, (WORD*)&GR_O2);
		  break;
	  case GRAF_DRAGBOX:
		  gr_dragbox(GR_I1, GR_I2, GR_I3, GR_I4, (GRECT *)&GR_I5, 
					(WORD*)&GR_O1, (WORD*)&GR_O2);
		  break;
	  case GRAF_MBOX:
		  gr_movebox(GR_I1, GR_I2, GR_I3, GR_I4, GR_I5, GR_I6);
		  break;
	  case GRAF_GROWBOX:
/*
		gr_growbox(&GR_I1, &GR_I5);
*/
		break;
	  case GRAF_SHRINKBOX:
/*
		gr_shrinkbox(&GR_I1, &GR_I5);
*/
		break;
	  case GRAF_WATCHBOX:
		ret = gr_watchbox((TREE)GR_TREE, GR_OBJ, GR_INSTATE, GR_OUTSTATE);
		break;
	  case GRAF_SLIDEBOX:
		ret = gr_slidebox((TREE)GR_TREE, GR_PARENT, GR_OBJ, GR_ISVERT);
		break;
	  case GRAF_HANDLE:
		GR_WCHAR = gl_wchar;
		GR_HCHAR = gl_hchar;
		GR_WBOX = gl_wbox;
		GR_HBOX = gl_hbox;
		ret = gl_handle;
		break;
	  case GRAF_MOUSE:
		if (GR_MNUMBER > 255)
		{
		  if (GR_MNUMBER == M_OFF)
		    gsx_moff();
		  if (GR_MNUMBER == M_ON)
		    gsx_mon();
		}
		else
		{
		  if (GR_MNUMBER != 255)		
		  {
		    rs_gaddr(ad_sysglo, R_BIPDATA, 3 + GR_MNUMBER, &maddr);
		    maddr = LLGET(maddr);
		  }
		  else
		    maddr = GR_MADDR;
		  gsx_mfset(maddr);
		}
		break;
	  case GRAF_MKSTATE:
		gr_mkstate((WORD*)&GR_MX, (WORD*)&GR_MY, 
			(WORD*)&GR_MSTATE, (WORD*)&GR_KSTATE);
		break;
#if GEM		
				/* Scrap Manager			*/
	  case SCRP_READ:
		ret = sc_read(SC_PATH);
		break;
	  case SCRP_WRITE:
		ret = sc_write(SC_PATH);
		break;
	  case SCRP_CLEAR:
	  	ret = sc_clear();
	  	break;
				/* File Selector Manager		*/
	  case FSEL_INPUT:
		ret = fs_input(FS_IPATH, FS_ISEL, (WORD*)&FS_BUTTON);
		break;
#endif /* GEM */
				/* Window Manager			*/
	  case WIND_CREATE:
		ret = wm_create(WM_KIND, (GRECT*)&WM_WX);
		break;
	  case WIND_OPEN:
		wm_open(WM_HANDLE, (GRECT*)&WM_WX);
		break;
	  case WIND_CLOSE:
		wm_close(WM_HANDLE);
		break;
	  case WIND_DELETE:
		wm_delete(WM_HANDLE);
		break;
	  case WIND_GET:
		wm_get(WM_HANDLE, WM_WFIELD, (WORD*)&WM_OX);
		break;
	  case WIND_SET:
		wm_set(WM_HANDLE, WM_WFIELD, (WORD*)&WM_IX);
		break;
	  case WIND_FIND:
		ret = wm_find(WM_MX, WM_MY);
		break;
	  case WIND_UPDATE:
		wm_update(WM_BEGUP);
		break;
	  case WIND_CALC:
		wm_calc(WM_WCTYPE, WM_WCKIND, WM_WCIX, WM_WCIY, 
			WM_WCIW, WM_WCIH, (WORD*)&WM_WCOX, (WORD*)&WM_WCOY, 
			(WORD*)&WM_WCOW, (WORD*)&WM_WCOH);
		break;
				/* Resource Manager			*/
	  case RSRC_LOAD:
		ret = rs_load(pglobal, (BYTE FAR *)RS_PFNAME);
		break;
	  case RSRC_FREE:
		ret = rs_free(pglobal);
		break;
	  case RSRC_GADDR:
		ret = rs_gaddr(pglobal, RS_TYPE, RS_INDEX, &ad_rso);
		break;
	  case RSRC_SADDR:
		ret = rs_saddr(pglobal, RS_TYPE, RS_INDEX, RS_INADDR);
		break;
	  case RSRC_OBFIX:
		rs_obfix(RS_TREE, RS_OBJ);
		break;
				/* Shell Manager			*/
	  case SHEL_READ:
		sh_read((BYTE FAR *)SH_PCMD, (BYTE FAR *)SH_PTAIL);
		break;
	  case SHEL_WRITE:
		ret = sh_write(SH_DOEX, SH_ISGR, SH_ISCR, 
			(BYTE FAR *)SH_PCMD, (BYTE FAR *)SH_PTAIL);
		break;
	  case SHEL_GET:
		sh_get((BYTE FAR *)SH_PBUFFER, SH_LEN);
		break;
	  case SHEL_PUT:
		sh_put((BYTE FAR *)SH_PDATA, SH_LEN);
		break;
	  case SHEL_FIND:
		ret = sh_find((BYTE FAR *)SH_PATH);
		break;
	  case SHEL_ENVRN:
		sh_envrn((LONG FAR *)SH_PATH, (BYTE FAR *)SH_SRCH);
		break;
	  case SHEL_RDEF:
		sh_rdef((BYTE FAR *)SH_LPCMD, (BYTE FAR *)SH_LPDIR);
		break;
	  case SHEL_WDEF:
		sh_wdef((BYTE FAR *)SH_LPCMD, (BYTE FAR *)SH_LPDIR);
		break;
	  case XGRF_STEPCALC:
	  	gr_stepcalc( XGR_I1, XGR_I2, (GRECT*)&XGR_I3, (WORD*)&XGR_O1,
		   (WORD*)&XGR_O2, (WORD*)&XGR_O3, (WORD*)&XGR_O4, (WORD*)&XGR_O5 );
		break;
	  case XGRF_2BOX:
	  	gr_2box(XGR_I4, XGR_I1, (GRECT*)&XGR_I6, XGR_I2,
			XGR_I3,	XGR_I5 );
		break;
	  case XGRF_COLOR:
		gsx_setclr(XGR_I1, XGR_I2, XGR_I3, XGR_I4, XGR_I5);
		break;
	  case XGRF_DTIMAGE:
		change_desktop((FDB FAR *)XGR_IMAGE); 
		break;
	  default:
		fm_show(ALNOFUNC, NULLPTR, 0x0101);
		ret = -1;
		break;
	}
	return(ret);
}

/*
*	Routine that copies input parameters into local buffers,
*	calls the appropriate routine via a case statement, copies
*	return parameters from local buffers, and returns to the
*	routine.
*/
MLOCAL	VOID xif( LONG pcrys_blk )
{
	UWORD		control[C_SIZE];
	UWORD		int_in[I_SIZE];
	UWORD		int_out[O_SIZE];
	LONG		addr_in[AI_SIZE];

	fmemcpy( (char far *)control, (char far *)CONTROL, C_SIZE*2 );
	if (IN_LEN)
	  fmemcpy( (char far *)int_in, (char far *)INT_IN, IN_LEN*2 );
	if (AIN_LEN)
	  fmemcpy( (char far *)addr_in, (char far *)ADDR_IN, AIN_LEN*4);

	int_out[0] = crysbind(OP_CODE, GGLOBAL, &int_in[0], &int_out[0], 
				&addr_in[0]);

	if (OUT_LEN)
	  fmemcpy( (char far *)INT_OUT, (char far *)int_out, OUT_LEN*2 );
	if (OP_CODE == RSRC_GADDR)
	  LLSET(ADDR_OUT, ad_rso);
}


/*
*	Supervisor entry point.  Stack frame must be exactly like
*	this if supret is to work.
*/
VOID super( LONG pcrys_blk)
{
	xif(pcrys_blk);
	
	if ( (gl_dspcnt++ % 10) == 0 )
	  dsptch();
	supret(0);
}

/*
*	Supervisor entry point.  Stack frame must be exactly like
*	this if supret is to work.
*/
void nsuper( LONG pcrys_blk)
{
    return ;
}

/* gemsuper.c */
