/****************************************************************************
*   Copyright 1999, Caldera Thin Client Systems, Inc.                       *
*   This software is licensed under the GNU Public License                  *
*   For further information, please see LICENSE.TXT                         *
*                                                                           *
*   Historical Copyright                                                    *
*                                                                           *
*   Copyright (c) 1985, 1987, 1990, 1991, 1992  Digital Research Inc.	    *
*   All rights reserved.						    *
*   The Software Code contained in this listing is proprietary to Digital   *
*   Research Inc., Monterey, California, and is covered by U.S. and other   *
*   copyright protection.  Unauthorized copying, adaption, distribution,    *
*   use or display is prohibited and may be subject to civil and criminal   *
*   penalties.  Disclosure to others is prohibited.  For the terms and      *
*   conditions of software code use, refer to the appropriate Digital       *
*   Research License Agreement.						    *
*****************************************************************************
*		      U.S. GOVERNMENT RESTRICTED RIGHTS			    *
*                    ---------------------------------                      *
*  This software product is provided with RESTRICTED RIGHTS.  Use, 	    *
*  duplication or disclosure by the Government is subject to restrictions   *
*  as set forth in FAR 52.227-19 (c) (2) (June, 1987) when applicable or    *
*  the applicable provisions of the DOD FAR supplement 252.227-7013 	    *
*  subdivision (b)(3)(ii) (May 1981) or subdivision (c)(1)(ii) (May 1987).  *
*  Contractor/manufacturer is Digital Research Inc. / 70 Garden Court /     *
*  BOX DRI / Monterey, CA 93940.					    *
*****************************************************************************
* $Header: m:/davinci/users//groups/panther/aes/rcs/machine.h 4.3 92/03/12 11:24:14 sbc Exp $
* $Log:	machine.h $
 * Revision 4.3  92/03/12  11:24:14  sbc
 * Merge in Keiko Hatamori's changes required for Double-Byte Character Support
 * 
Date	Who	SPR#	Comments
-------	-------	----	------------------------------------------------------
911126	K.H		Reduced number of NUM_ACCS and NUM_DESKACC for ViewMAX.
911118	K.H		Add GEM define to optimize code.
911028	K.H		Add DBCS define.
910502	RSF		Give parms in LST* prototypes.
910313	WHF		Convert L??GET/L??SET routines from EXTERNS to macros
******************************************************************************/

#define	DBCS	1	/* Support Double Byte Character Set */
#define	GEM	0	/* Streamlined AES for ViewMAX use only */

#define MULTIAPP 0
#define SINGLAPP 1

#if GEM
#define NUM_WIN 8		/* 8 for main app and 3 desk accs	*/
#define NUM_ACCS 3		/* 3 for number of desk accs	*/

#define NUM_DESKACC 12		/* at least 12 slots for	*/
				/*   3 desk accessories or	*/
				/*   11 process entries		*/
				/* requires new string array	*/
				/*   in gemmnlib.c if num != 12	*/
#else
#define NUM_WIN 8		/* 8 for main app and desk acc	*/
#define NUM_ACCS 1		/* 1 for number of desk accs	*/
#define NUM_DESKACC 3		/* 3 for 1 desk accessory	*/
#endif

/* return low word of a long value	*/
#define LOWORD(x) ((unsigned short)(x))

/* return high word of a long value	*/
#define HIWORD(x) ((unsigned short)(x >> 16))

/* return low byte of a word value	*/
#define LOBYTE(x) ((unsigned char)(x))

/* return high byte of a word value	*/
#define HIBYTE(x) ((unsigned char)(x >> 8))

#define MAKELONG(seg,off)	(((unsigned long)(seg) << 16) | (unsigned)(off))

#define FAR	far				/* long pointer		*/

/* return long address of short ptr	*/
#define ADDR(x) ((LONG) (WORD FAR *) (x))

/* return a single byte	pointed at by long ptr		*/
#define LBGET(x) ( (UBYTE) *((BYTE FAR * )(x)) )

/* set a single byte pointed at by long ptr, LBSET(lp, bt)	*/
#define LBSET(x, y)  ( *((BYTE FAR *)(x)) = y)

/* return a single word pointed at by long ptr		*/
#define LWGET(x) ( (WORD) *((WORD FAR *)(x)) )

/* set a single word pointed at by long	ptr, LWSET(lp, bt)	*/
#define LWSET(x, y)  ( *((WORD FAR *)(x)) = y)

/* return a single long pointed at by long ptr		*/
#define LLGET(x) ( *((LONG FAR *)(x)))

/* set a single long pointed at by long	ptr, LLSET(lp, bt)	*/
#define LLSET(x, y) ( *((LONG FAR *)(x)) = y)


/* end of machine.h */
