/****************************************************************************
*   Copyright 1999, Caldera Thin Client Systems, Inc.                       *
*   This software is licensed under the GNU Public License                  *
*   For further information, please see LICENSE.TXT                         *
*                                                                           *
*   Historical Copyright                                                    *
*                                                                           *
*   Copyright (c) 1992  Digital Research Inc.				    *
*   All rights reserved.						    *
*   The Software Code contained in this listing is proprietary to Digital   *
*   Research Inc., Monterey, California, and is covered by U.S. and other   *
*   copyright protection.  Unauthorized copying, adaption, distribution,    *
*   use or display is prohibited and may be subject to civil and criminal   *
*   penalties.  Disclosure to others is prohibited.  For the terms and      *
*   conditions of software code use, refer to the appropriate Digital       *
*   Research License Agreement.						    *
*****************************************************************************
*		      U.S. GOVERNMENT RESTRICTED RIGHTS			    *
*                    ---------------------------------                      *
*  This software product is provided with RESTRICTED RIGHTS.  Use, 	    *
*  duplication or disclosure by the Government is subject to restrictions   *
*  as set forth in FAR 52.227-19 (c) (2) (June, 1987) when applicable or    *
*  the applicable provisions of the DOD FAR supplement 252.227-7013 	    *
*  subdivision (b)(3)(ii) (May 1981) or subdivision (c)(1)(ii) (May 1987).  *
*  Contractor/manufacturer is Digital Research Inc. / 70 Garden Court /     *
*  BOX DRI / Monterey, CA 93940.					    *
*****************************************************************************
* $Header: m:/davinci/users//groups/panther/aes/rcs/viewapps.c 4.3 92/03/26 14:48:34 sbc Exp $
* $Log:	viewapps.c $
 * Revision 4.3  92/03/26  14:48:34  sbc
 * Merge in RSF's changes
 * 
 * Revision 4.2  92/03/23  14:15:31  Fontes
 * Eliminate use of RTL toupper() function. Move define to viewapps.h
 * 
 * Revision 4.1  92/03/20  15:14:05  Fontes
 * New in merge from Susan, March 18
 * 
 * Revision 4.2  92/03/13  14:37:00  sbc
 * country => _country, rm refs to ADDR, misc cleanup.
 * 
 * Revision 4.2  92/03/13  14:35:48  sbc
 * country => _country, rm refs to ADDR, misc cleanup.
 * 
 * Revision 4.1  92/03/11  12:47:43  sbc
*	history
*	30-Oct-91  K.H	Work began.
*/

#include "portab.h"	/* Portability definitions	*/
#include "machine.h"	/* Compiler dependencies	*/
#include "viewapps.h"	/* VIEWAPPS definitions		*/


#define	DBCS_LEN	24		/* maximum length of DBCS table */

extern WORD	__DOS(void);

extern UWORD	DOS_AX;
extern UWORD	DOS_BX;
extern UWORD	DOS_CX;
extern UWORD	DOS_DX;
extern UWORD	DOS_DS;
extern UWORD	DOS_ES;
extern UWORD	DOS_SI;
extern UWORD    DOS_DI;
extern UWORD	DOS_ERR;


/* Common system variables used by applications. */

BYTE	ptch;				/* pathname separator */

struct internat				/* country code info structure */
{
    WORD	dt_fmt;		/* 0=MM/DD/YY 1=DD/MM/YY 2=YY/MM/DD	*/
    BYTE	currcy[5];	/* currency symbol + nulls		*/
    BYTE	d1000[2];	/* thousands delimiter + null		*/
    BYTE	ddecm[2];	/* decimal delimiter + null		*/
    BYTE	ddate[2];	/* date delimiter + null		*/
    BYTE	dtime[2];	/* time delimiter + null		*/
    BYTE	cflg;		/* currcy sym bits: 01 trailing, 02 = spaced */
    BYTE	cdec;		/* number of decimal places in currency */
    BYTE	ampm;		/* 0=am/pm 1=24h clock			*/
    WORD	ucase[2];	/* address of toupper function */
    BYTE	dlist[2];	/* data list separator + null 		*/
    WORD	reserved[5];
    UWORD code;	/* Country code	*/
} _country;			/* international info */


/*
* The Double Byte Character Set lead byte table.
* Each entry in the table except the last specifies a valid lead byte range.
*
*	+---------------+---------------+
*	|   number of bytes in table 	|
*	|	       (n)		|
*   0	+---------------+---------------+
*   	|    start of	|    end of 	|	DBCS table entry 0
*	|    range 0	|    range 0	|
*   2	+---------------+---------------+
*    	|    start of	|    end of 	|	DBCS table entry 1
*	|    range 1	|    range 1	|
*	+---------------+---------------+
*			:
*    n-2+---------------+---------------+
*	|       0	|       0 	|	end of DBCS table
*	|    		|    		|
*	+---------------+---------------+
*/

UBYTE	dbcs_table[DBCS_LEN];


/*---------
* To initialise the double byte character set (DBCS) lead byte table.
* MUST be called before the first call to dbcs_lead() or dbcs_expected().
* Entry
*	none
* Exit
*	none (side effect: DBCS table initialised)
*/

void	dbcs_init()
{
struct dibuf
{
    BYTE buf_id;
    LONG buf_ptr;
} di;
REG WORD     i;
REG BYTE far *s;
REG UBYTE    *d;

    *(WORD *)dbcs_table = 0;	/* default is not dbcs */
    DOS_AX = 0x6507;		/* Extended Country Info: get DBCS ptr */
    DOS_BX = -1;		/* codepage number: -1 for global cp */
    DOS_CX = 5;			/* size of info. buffer */
    DOS_DX = -1;		/* country code: -1 for current country */
    DOS_DI = LOWORD( (long)(void far *)&di );
    DOS_ES = HIWORD( (long)(void far *)&di );
    __DOS();
    if ( !DOS_ERR && di.buf_id == 7 )	/* is table for DBCS? */
    {
	s = (BYTE far *)di.buf_ptr;	/* system DBCS table */
	d = dbcs_table;			/* local DBCS table */
	if ((i = *(WORD far *)s) <= DBCS_LEN)
	for (s+=2; i>0; i--)
	    *d++ = *s++;	/* copy table from system to local */
    }
}


/*-------------
* Returns true if double byte characters are to be expected.
* A call to dbcs_init() MUST have been made.
* Entry
*	none
* Exit
*	ax	= 1 - double byte characters are currently possible
*		  0 - double byte characters are not currently possible
*/

BOOLEAN	dbcs_expected()
{
    return(*(WORD *)dbcs_table);	/* return expect DBCS or not */
}


/*---------
* Returns true if given byte is a valid lead byte of a 16 bit character.
* A call to init_dbcs() MUST have been made.
* Entry
*	2[bp]	= possible lead byte
* Exit
*	ax	= 1 - is a valid lead byte
*		  0 - is not a valid lead byte
*/

BOOLEAN	dbcs_lead(c)
BYTE	c;
{
REG UBYTE *tp;

    c &= 0xff;
    for(tp=dbcs_table; *(WORD *)tp; tp+=2)
	if (*tp <= c && c <= *(tp+1))	/* check start/end of range */
	    return(TRUE);		/* valid lead byte */
    return(FALSE);				/* not valid lead byte */
}


/****************************************************************************
 *                                                                          *
 *        Initialisation for APPSLIB routines                               *
 *        Sets country and operating system version structures              *
 *                                                                          *
 ****************************************************************************/

void init_lib( void )
{
    DOS_AX = 0x3800;			/* Get country info 	*/
    DOS_DX = LOWORD( (long)(void far *)&_country ) ;
    DOS_DS = HIWORD( (long)(void far *)&_country ) ;
    __DOS();
    if (!DOS_ERR)
	_country.code = DOS_BX;
    ptch = '\\';
    DOS_AX = 0x3700;			/* Get switch character info 	*/
    __DOS();
    if( (DOS_DX & 0xff) == '\\' )
	ptch = '/';
    dbcs_init();			/* init Double Byte Char Set table */
}


/* Convert all lowercase characters in ASCIIZ string to uppercase. 
   Double byte characters are not changed. */

BYTE	*strupr(s)
BYTE	*s;
{
REG BYTE *bp;

    if (dbcs_expected())		/* are we looking out for DBCS? */
    {					/*  yes - DON'T CHANGE DBCS CHARS */
	for (bp = s; *bp; bp++)
	{
    	    if (dbcs_lead(*bp))		/* is this first of a DBCS pair? */
	    {
	    	bp++;			/*  yes - skip over it */
		if (*bp == '\0')	/* it is followed by its partner? */
		    break;		/*  no - invalid DBCS, exit loop */
	    }
	    else
	    	*bp = toupper(*bp);	/*  no - upper case it */
	}
    }
    else
    	for (bp = s; *bp; bp++)
    	    *bp = toupper(*bp);

    return s;
}


/* Convert all uppercase characters in ASCIIZ string to lowercase. 
   Double byte characters are not changed. */

BYTE	*strlwr(s)
BYTE	*s;
{
REG BYTE *bp;

    if (dbcs_expected())		/* are we looking out for DBCS? */
    {					/*  yes - DON'T CHANGE DBCS CHARS */
	for (bp = s; *bp; bp++)
	{
    	    if (dbcs_lead(*bp))		/* is this first of a DBCS pair? */
	    {
	    	bp++;			/*  yes - skip over it */
		if (*bp == '\0')	/* it is followed by its partner? */
		    break;		/*  no - invalid DBCS, exit loop */
	    }
	    else
	    	*bp = tolower(*bp);	/*  no - lower case it */
	}
    }
    else
    	for (bp = s; *bp; bp++)
    	    *bp = tolower(*bp);

    return s;
}


/* Return a pointer to the next path character or end of string. */

UBYTE	*next_path_ch(s)
UBYTE	*s;
{
    while (*s)
    {
	if (dbcs_lead(*s) && *(s+1) != '\0')
	    s++;		/* skip DBCS lead (skip 2nd byte later) */

	else if (*s == ptch)
	    return s;

	s++;
    }

    return s;
}


/* Return a pointer to the previous path character or (start)
   if none present. */

UBYTE	*prev_path_ch(start, s)
UBYTE	*start, *s;
{
REG UBYTE *ptr1, *ptr2;

    for (ptr1 = start, ptr2 = next_path_ch(start); ptr2 < s; )
    {
	ptr1 = ptr2;			/* record location of this ptch */
	ptr2 = next_path_ch(ptr2 + 1);	/* try to find next path char */
    }
    return ptr1;			/* return pointer to last ptch found */
}


/*----------------------------------------------------------------------
 * strchr - find a one-byte character in a null terminated string
 *
 * Search a string for a given character,  skipping over double-byte
 * characters.  If found, return a pointer to the found character.
 * Otherwise, return a NULL pointer.  The termination \0 character
 * is considered part of the string.
 */

BYTE	*strchr(str, c)
const BYTE *str;		/* *str  pointer of string for check	*/
WORD       c;			/*  c	 character for check 		*/
{
    while(*str != '\0' && *str != c)
    {
	if (dbcs_lead(*str++) && *str != '\0')
	    str++;
    }
    if (*str || c == '\0')
	return ((BYTE *) str);
    else
	return ((BYTE *) 0);
}


/*----------------------------------------------------------------------
 * strrchr - find a one-byte character in a null terminated string
 *		in reverse order
 *
 * Search a string from the end to the beginning for a given character,
 * skipping over double-byte characters.  If found, return a pointer to
 * the found character.  Otherwise, return a NULL pointer.  The
 * termination \0 character is considered part of the string.
 */

BYTE	*strrchr(sstr, c)
const BYTE *sstr;		/* *sstr  start of string for check	*/
WORD 	   c;			/*  c	  character for check 		*/
{
REG BYTE *lastp;

    lastp = (BYTE *) 0;
    while(*sstr != '\0')
    {
	if (dbcs_lead(*sstr) && *(sstr+1))
	    sstr++;
	else
	    if (*sstr == c)
		lastp = (BYTE *) sstr;
	sstr++;
    }
    if (c == '\0')
	return ((BYTE *) sstr);
    else
	return (lastp);
}


/*----------------------------------------------------------------------
 * strpbrk - find first of a set of characters in a double-byte
 *		character string
 *
 * Search a string str for the first occurrence of any character from
 * the set chstr,  skipping over double-byte characters.  If found,
 * return a pointer to the found character.  Otherwise, return a
 * NULL pointer.
 */

BYTE *strpbrk(str, chstr)
const BYTE *str;		/* *str   pointer of string for check 	*/
const BYTE *chstr;		/* *chstr pointer of character set 	*/
{
REG BYTE *p;

    while(*str != '\0')
    {
	if (dbcs_lead(*str) && *(str+1))
	    str++;
	else
	{
	    for (p = (BYTE *) chstr; *p != '\0'; p++)
		if (*str == *p)
		    return ((BYTE *) str);
	}
	str++;
    }
    return ((BYTE *) 0);
}


/*----------------------------------------------------------------------
 * strstr - scan a string for the occurence of a given substring.
 *
 * Search a string str1 for the first occurrence of a string str2,
 * skipping over double-byte characters.  If found, return a pointer
 * to the element in str1 where str2 begins.  Otherwise, return a
 * NULL pointer.
 */

BYTE *strstr(str1, str2)
const BYTE *str1;		/* *str   pointer of string for check 	*/
const BYTE *str2;		/* *chstr pointer of character set 	*/
{
REG BYTE *p1;
REG BYTE *p2;
REG BYTE *foundp;

    foundp = (BYTE *) str1;
    while(*foundp)
    {
	p2 = (BYTE *) str2;
	if ((foundp = strchr(foundp, *p2)) == (BYTE *) 0)
	    return (foundp);
	for(p1=foundp; *p2 && (*p1 == *p2); p1++, p2++);
	if (*p2 == '\0')
	    return (foundp);
	foundp++;
    }
    return ((BYTE *) 0);
}


/*----------------------------------------------------------------------
 * Check the character using previous type, and return its type.
 * If previous type is CT_DBC1, it returns only CT_DBC2.
 * If previous type isn't CT_DBC1, it returns CT_DBC1 or CT_ADE.
*/

WORD	chkctype(c, ptype)
WORD	c;			/* c     character for check       	*/
WORD	ptype;			/* ptype type of previous character 	*/
{
REG WORD type = CT_ADE;			/* Default is not double byte code */

    if (dbcs_expected())		/* are we looking out for DBCS? */
    {
	if (c)
	{
	   if (ptype == CT_DBC1)	/* Previous type is first byte code? */
		 type = CT_DBC2;	/* Second byte of double byte code*/
	   else if (dbcs_lead(c))	/* Is it first byte code? 	*/
		 type = CT_DBC1;	/* First byte of double byte code */
	}
    }
    return(type);
}


/*----------------------------------------------------------------------
 * isequalto - check that nth character in string str is equal to c
 *
 * Return TRUE if the character at str[n] is equal to c.
 * The character's type should be CT_ADE, i.e. it must not be part
 * of a double-byte character.
*/

WORD	isequalto(str, n, c)
BYTE	*str;			/* *str  pointer of string for check 	*/
WORD	n;			/*  n	 byte number from string pointer*/
WORD	c;			/*  c	 character value for check 	*/
{
REG WORD type = CT_ADE;

    if (dbcs_expected())		/* are we looking out for DBCS? */
    {
	if ( (str[n] & 0xff) != (c & 0xff) )
	    return( 0 );
	while(n-- >= 0)
	    type = chkctype(*str++, type);
	return( type == CT_ADE );
    }
    else
	return( (str[n] & 0xff) == (c & 0xff) );
}

/* viewapps.c */
