/****************************************************************************
*   Copyright 1999, Caldera Thin Client Systems, Inc.                       *
*   This software is licensed under the GNU Public License                  *
*   For further information, please see LICENSE.TXT                         *
*                                                                           *
*   Historical Copyright                                                    *
*                                                                           *
*   Copyright (c) 1992  Digital Research Inc.				    *
*   All rights reserved.						    *
*   The Software Code contained in this listing is proprietary to Digital   *
*   Research Inc., Monterey, California, and is covered by U.S. and other   *
*   copyright protection.  Unauthorized copying, adaption, distribution,    *
*   use or display is prohibited and may be subject to civil and criminal   *
*   penalties.  Disclosure to others is prohibited.  For the terms and      *
*   conditions of software code use, refer to the appropriate Digital       *
*   Research License Agreement.						    *
*****************************************************************************
*		      U.S. GOVERNMENT RESTRICTED RIGHTS			    *
*                    ---------------------------------                      *
*  This software product is provided with RESTRICTED RIGHTS.  Use, 	    *
*  duplication or disclosure by the Government is subject to restrictions   *
*  as set forth in FAR 52.227-19 (c) (2) (June, 1987) when applicable or    *
*  the applicable provisions of the DOD FAR supplement 252.227-7013 	    *
*  subdivision (b)(3)(ii) (May 1981) or subdivision (c)(1)(ii) (May 1987).  *
*  Contractor/manufacturer is Digital Research Inc. / 70 Garden Court /     *
*  BOX DRI / Monterey, CA 93940.					    *
*****************************************************************************
 *	name		VIEWAPPS.H
 *	purpose		Provide external definitions and documentation
 *			for all functions in the VIEWAPPS.LIB library.
 *			It is assumed that strong argument type checking
 *			is required. Hence all library function definitions
 *			include the parameter types.
 * $Header: m:/davinci/users//groups/panther/aes/rcs/viewapps.h 4.2 92/03/26 14:48:43 sbc Exp $
 * $Log:	viewapps.h $
 * Revision 4.2  92/03/26  14:48:43  sbc
 * Merge in RSF's changes
 * 
 * Revision 4.2  92/03/23  14:15:12  Fontes
 * Eliminate use of RTL toupper() function. Move define to viewapps.h
 * 
 *	history
 *	29-Oct-91 K.H	Work began.
 */


/* Character types returned by chkctype() */
#define	CT_ADE	0		/* ASCII decimal equivalent */
#define	CT_DBC1	1		/* 1st byte of double byte character */
#define	CT_DBC2	2		/* 2nd byte of double byte character */


/* So we don't use the runtime library's version */
#define toupper(c) ((c >= 'a' && c <= 'z') ? c&0xdf : c)
#define tolower(c) ((c >= 'A' && c <= 'Z') ? c|0x20 : c)



/* BYTE *strchr( str, c )
 *****************************************************************************
 * Search a string for a given character,  skipping over double-byte
 * characters.  If found, return a pointer to the found character.
 * Otherwise, return a NULL pointer.  The termination \0 character
 * is considered part of the string.
 */
BYTE *strchr( const BYTE*, WORD );




/* BYTE *strrchr( sstr, c )
 *****************************************************************************
 * Search a string from the end to the beginning for a given character,
 * skipping over double-byte characters.  If found, return a pointer to
 * the found character.  Otherwise, return a NULL pointer.  The
 * termination \0 character is considered part of the string.
 */
BYTE *strrchr( const BYTE*, WORD );




/* BYTE *strpbrk( str, chstr )
 *****************************************************************************
 * Search a string str for the first occurrence of any character from
 * the set chstr,  skipping over double-byte characters.  If found,
 * return a pointer to the found character.  Otherwise, return a
 * NULL pointer.
 */
BYTE *strpbrk( const BYTE*, const BYTE* );




/* BYTE *strstr( str1, str2 )
 *****************************************************************************
 * Search a string str1 for the first occurrence of a string str2,
 * skipping over double-byte characters.  If found, return a pointer
 * to the element in str1 where str2 begins.  Otherwise, return a
 * NULL pointer.
 */
BYTE *strstr( const BYTE*, const BYTE* );




/* WORD chkctype( c, ptype )
 *****************************************************************************
 * Check the character using previous type, and return its type.
 * If previous type is CT_DBC1, it returns only CT_DBC2.
 * If previous type isn't CT_DBC1, it returns CT_DBC1 or CT_ADE.
 */
WORD chkctype( WORD, WORD );




/* WORD isequalto( str, n, c )
 *****************************************************************************
 * Return TRUE if the character at str[n] is equal to c.
 * The character's type should be CT_ADE, i.e. it must not be part
 * of a double-byte character.
 */
WORD isequalto( BYTE*, WORD, WORD );




/* VOID	init_lib();
 ******************************************************************************
 *
 *	Initialises global variables used by appslib:
 *
 *	country
 *	os_version
 *	ptch
 *	swch
 *	
 * Note that os_version must be initialised before calling this function.
 */
VOID	init_lib(VOID);




/* UBYTE *next_path_ch( s )
 *****************************************************************************
 * Return a pointer to the next path character in the string from point s
 * or the end of the string
 */
UBYTE *next_path_ch( UBYTE* );




/* UBYTE *prev_path_ch( string,ptr )
 *****************************************************************************
 * Return a pointer a previous path character in the 'string' from point 's'
 * or the end of the string
 */
UBYTE *prev_path_ch( UBYTE*, UBYTE* );




/* BOOLEAN	dbcs_expected()
 *****************************************************************************
 * Return true if Double Byte Characters are to be expected.
 *
 * For example, if the current country code and codepage are set
 * appropriately for Japan, dbcs_expected() will return true indicating
 * that the application can expect the user to enter 16 bit Kanji characters.
 *
 * A call to dbcs_init() MUST have been made before calling this routine.
 */
BOOLEAN	dbcs_expected(VOID);




/* VOID		dbcs_init()
 ******************************************************************************
 * Setup Double Byte Character Set table.
 * MUST be called before the first call to dbcs_lead() or dbcs_expected().
 */
VOID	dbcs_init(VOID);




/* BOOLEAN	dbcs_lead(c)
 *****************************************************************************
 * Entry parameter...
 * BYTE		c;			byte to be tested
 *
 * Return true if a given character is the first byte of a Double Byte
 * Character.
 *
 * For example, if the current country code and codepage are set
 * appropriately for Japan, dbcs_lead(0x81) will return true indicating
 * that 0x81 is a valid first byte of a 16 bit Kanji character.
 *
 * A call to dbcs_init() MUST have been made before calling this routine.
 */
BOOLEAN	dbcs_lead(BYTE);




/* BYTE		*strupr(s)
 ******************************************************************************
 * BYTE		*s;			NULL terminated string to be uppercased
 *
 * Convert all characters in the given NULL terminated string to uppercase
 * using the international toupper function. Return a pointer to this string.
 *
 * ASCII characters between 'a' and 'z' are converted to 'A' through 'Z' 
 * appropriately. For characters above 80h the international toupper function
 * defined in the internat structure is called. "country" must be defined and
 * initialised. All other characters are unchanged in the string.
 */
BYTE	*strupr(BYTE *);




/* BYTE		*strlwr(s)
 ******************************************************************************
 * BYTE		*s;			ASCIIZ string to be lowercased
 *
 * Convert all uppercase characters in ASCIIZ string to lowercase.
 */
BYTE	*strlwr(BYTE *);




/******************   E N D   O F   V I E W A P P S . H   ********************/
