/*	BUTTON.C		06/21/1988		Dan Brown	    */
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
/*    Copyright 1999, Caldera Thin Client Systems, Inc.                     */
/*    This software is licensed under the GNU Public License.               */
/*    Please see LICENSE.TXT in this archive for futher information.        */
/*                                                                          */
/*    Historical Copyright:                                                 */
/*    	Copyright (c) 1988 Digital Research Inc.			    */
/*    The software contained in this listing is proprietary to		    */
/*    Digital Research Inc., Monterey, California and is		    */
/*    covered by U.S. and other copyright protection.  Unaurthorized	    */
/*    copying, adaptation, distribution, use or display is prohibited	    */
/*    and may be subject to civil and criminal penalties.  Disclosure	    */
/*    to others is prohiited.  For the terms and conditions of soft-	    */
/*    ware code use refer to the appropriate Digital Research		    */
/*    license agreement.						    */
/*--------------------------------------------------------------------------*/
/* 891206 DLB #41: Add redraw flag to dsel_rbut.			    */
/*
 * 891128 rs added considering of hidden items in lb_scroll()
 * 900329 ts split off from EXOBINIT.C
 */
#include "shell.h"
#include "danutil.h"
#include "list.h"
#include "exobdefs.h"
#include "exproto.h"

/*--------------------------------------------------------------------------*/
/* NAME: tggl_button							    */
/*									    */
/* PURPOSE: Toggles the selection of the toggle buton each pass through the */
/*	    event loop.							    */
/*--------------------------------------------------------------------------*/
    MLOCAL WORD
tggl_button( EVMULT	*evm,		/* Event Multi data.		    */
	     TREE	tree,		/* tree address of toggle button.   */
	     WORD	obj,		/* Object number of togglt button.  */
	     WORD	off_x,		/* Unused.			    */
	     WORD	off_y,		/* Unused.			    */
	     FBYTE	*new_state	/* New state to be XORed with the   */
					/* current state of the toggle	    */
					/* button.			    */
	     )
{
    evm->em_1inout = ( evm->em_1inout == RETURN_ON_ENTRY ) ? RETURN_ON_EXIT :
							     RETURN_ON_ENTRY;
    upd_ob_state( tree, obj, *((WORD *)new_state), TRUE, TRUE );
    return( TRUE );
}

/*--------------------------------------------------------------------------*/
/* NAME: toggle_button							    */
/*									    */
/* PURPOSE: Manages a toggle exit button that has been click on.	    */
/*--------------------------------------------------------------------------*/
    GLOBAL WORD
toggle_button( TREE	tree,		/* Tree address of toggle button.   */
	       WORD	obj,		/* Object number of toggle button.  */
	       MSTAT	*mst		/* Mouse state at time of touch exit*/
	       )
{
    EVMULT	evm;			/* Event multi data.		    */
    FDOBJECT	*obj_ptr;		/* Pointer to toggle object.	    */
    WORD	old_state;		/* State of toggle on entry.	    */
    WORD	new_state;		/* State to be XORed with current   */
					/* state each pass thru the event   */
					/* loop.			    */
    
    obj_ptr = tree + obj;
    old_state = obj_ptr->ob_state;
    new_state = SELECTED;
    
    init_evmulti( &evm );
    evm.em_events = MU_BUTTON | MU_M1;
    evm.em_bst = BUTTON_UP;
    evm.em_1inout = RETURN_ON_ENTRY;
    get_obloc( tree, obj, &evm.em_1box );
    fmemcpy( (void far *)&evm.em_mstat,  (void far *)mst, sizeof(MSTAT) );
    
    evnt_loop( &evm, MU_BUTTON, tree, obj, tggl_button, (FBYTE *)&new_state );
    
    return( old_state == obj_ptr->ob_state );
}

/*--------------------------------------------------------------------------*/
/* NAME: radio_button							    */
/*									    */
/* PURPOSE: Manages a radio exit button that has been click on.		    */
/*--------------------------------------------------------------------------*/
    GLOBAL WORD
radio_button( TREE	tree,		/* Tree address of radio button.    */
	      WORD	obj,		/* Object number of radio button.   */
	      MSTAT	*mst		/* Mouse state at time of touch exit*/
	      )
{

    FDOBJECT	*obj_ptr;		/* Pointer to radio object.	    */
    WORD	old_state;		/* State of radio on entry.	    */
    WORD	new_state;		/* State to be ORed with current    */
					/* state each pass thru the event   */
					/* loop.			    */
    
    obj_ptr = tree + obj;
    old_state = obj_ptr->ob_state;
    if( !(old_state & SELECTED) )
    {
	/* 891206 DLB #41: Add redraw flag to dsel_rbut.		    */
	dsel_rbut( tree, obj, TRUE );
	
	new_state = SELECTED;
	upd_ob_state( tree, obj, new_state, FALSE, TRUE );
	
	evnt_button( 1, 1, BUTTON_UP, &mst->mst_x, &mst->mst_y, 
		&mst->mst_b, &mst->mst_ks);
    }
    
    return( old_state == obj_ptr->ob_state );
}
