/*	DANUTIL.C		06/24/1988		Dan Brown	    */
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
/*   Copyright 1999, Caldera Thin Client Systems, Inc.                      */
/*   This software is licensed under the GNU Public License.                */
/*   See LICENSE.TXT for further information.                               */
/*                                                                          */
/*   Historical Copyright                                                   */
/*                                                                          */
/*    Copyright (c) 1988,1992 Digital Research Inc.			    */
/*    The software contained in this listing is proprietary to		    */
/*    Digital Research Inc., Monterey, California and is		    */
/*    covered by U.S. and other copyright protection.  Unaurthorized	    */
/*    copying, adaptation, distribution, use or display is prohibited	    */
/*    and may be subject to civil and criminal penalties.  Disclosure	    */
/*    to others is prohiited.  For the terms and conditions of soft-	    */
/*    ware code use refer to the appropriate Digital Research		    */
/*    license agreement.						    */
/*--------------------------------------------------------------------------*/
/*
$Header: m:/davinci/users//groups/panther/dsk/rcs/danutil.c 3.4 92/03/13 14:40:14 sbc Exp $
$Log:	danutil.c $
 * Revision 3.4  92/03/13  14:40:14  sbc
 * Merge in Keiko's changes required for Double Byte Character Support
 * 

Date	Who	Spr	Comments
----	---	---	--------
911119  K.H		Optimized by DRJ. (#if JOPTIMIZE)
911016  K.H		Add supporting double byte character set. (#if DBCS)
910502	RSF		Warning removal.
910426	RSF		Uncommented lstrncpy.
910419	RSF		Changed strcpy to strcpy since VM's strcpy uses 
			opposite arg order.
910404	RSF		Changed numeric uses of LONG to SLONG because ViewMAX
			defines LONG as unsigned for some unknown reason.
910322	RSF		Adapt for use in ViewMAX.
*****************************************************************************/

#define	JOPTIMIZE	0

#include "shell.h"
#include "danutil.h"
#include "viewapps.h"

/*--------------------------------------------------------------------------*/
/* Defines for format word of formatted atoi or itoa calls.		    */
/*--------------------------------------------------------------------------*/

GLOBAL	BYTE	decimal = '.';		/* Decimal charater.		    */

/*--------------------------------------------------------------------------*/
/* NAME: lmid								    */
/*									    */
/* PURPOSE: Find the middle value of three long values.			    */
/*									    */
/* INPUT:   LONG	lo	-   minimum value.			    */
/*	    LONG	val	-   value to test.			    */
/*	    LONG	hi	-   maximum value.			    */
/*									    */
/* OUTPUT:  LONG	return()-   middle value of the three.		    */
/*--------------------------------------------------------------------------*/
    GLOBAL SLONG
lmid(    SLONG	lo, 
	 SLONG	val,
	 SLONG	hi
	 )
{
    if (val < lo)
      return(lo);
    if (val > hi)
      return(hi);
    return(val);
}

/*--------------------------------------------------------------------------*/
/* NAME: mid								    */
/*									    */
/* PURPOSE: Find the middle value of three WORD values.			    */
/*									    */
/* INPUT:   WORD	lo	-   minimum value.			    */
/*	    WORD	val	-   value to test.			    */
/*	    WORD	hi	-   maximum value.			    */
/*									    */
/* OUTPUT:  WORD	return()-   middle value of the three.		    */
/*--------------------------------------------------------------------------*/
    GLOBAL WORD
mid(    WORD	lo, 
	WORD	val,
	WORD	hi
	)
{
    if (val < lo)
      return(lo);
    if (val > hi)
      return(hi);
    return(val);
}

/*--------------------------------------------------------------------------*/
/* NAME: lround								    */
/*									    */
/* PURPOSE: Rounds the given integer to the closest multiple of the given   */
/*	    step.							    */
/*									    */
/* INPUT:   LONG	i	-   Integer to round.			    */
/*	    LONG	step	-   step to round to.			    */
/*									    */
/* OUTPUT:  LONG	return()-   rounded value.			    */
/*									    */
/*--------------------------------------------------------------------------*/
    GLOBAL SLONG
lround(     SLONG	i,
	    SLONG	step
	    )
{
    SLONG	isign;
    
    isign = ( i < 0 ) ? -1 : 1;
    return( ( ((i<<1) + (isign*step)) / (step<<1) ) * step );
}

/*--------------------------------------------------------------------------*/
/* NAME: mask_value							    */
/*									    */
/* PURPOSE: Gets the value of the mask part of an integer.		    */
/*									    */
/* INPUT:   WORD	fmt	-   Format word.			    */
/*	    WORD	mask	-   Mask for word.			    */
/*									    */
/* OUTPUT:  WORD	return()-   Value of masked part of word.	    */
/*--------------------------------------------------------------------------*/
    GLOBAL WORD
mask_value(     WORD	fmt,
		WORD	mask
		)
{
    fmt &= mask;
    while( !(mask & 0x0001) )
    {
	mask >>= 1;
	fmt >>= 1;
    }
    return( fmt );
}

#if JOPTIMIZE
/*--------------------------------------------------------------------------*/
/* NAME: path_exists							    */
/*									    */
/* PURPOSE: CHecks the existence of the given directory.		    */
/*--------------------------------------------------------------------------*/
    GLOBAL WORD
path_exists( 
	     BYTE    *path		/* Directory to check for.	    */
	   )
{
    BYTE    *b_ptr, *slash, *p_ptr, save;
    WORD    ret;
    FCB FAR *dt;
    FCB	    dtaBlk;
    
    slash = strchr( path, '\\' );
    if( slash != path && slash != path + 2 ) /* Check that the first slash  */
        return( FALSE );		/* is in the right spot.	    */
    
    /* If a path name with more the the proper number of characters in a    */
    /* level is passed into DOS search first it will still return true if   */
    /* there is a directory that matches the first eight chacters of that   */
    /* level. The following loop verifies that all the levels are the	    */
    /* correct length.							    */
    while( (b_ptr = strchr( slash+1, '\\')) != 0 )
    {
        if( b_ptr - slash > 9 )
	{
	    *b_ptr = '\0';
	    p_ptr = strchr( slash+1, '.' );
	    *b_ptr = '\\';
	    if( !p_ptr || p_ptr - slash > 9 || b_ptr - p_ptr > 4 )
		return( FALSE );
	}
        slash = b_ptr;
    }
    if( strlen( slash ) > 9 )		/* Check the last level.	    */
    {
	p_ptr = strchr( slash+1, '.' );
	if( !p_ptr || p_ptr - slash > 9 || strlen( p_ptr ) > 4 )
	    return( FALSE );
    }
    
    b_ptr = path + strlen( path ) - 1;
    if( b_ptr == path || *(b_ptr-1) == ':' ) /* Handle root directories.    */
    {
	ret = TRUE;
    }
    else
    {
	dt = dos_gdta();
	dos_sdta( (FCB far *)&dtaBlk );
#if DBCS
	if( isequalto(path, strlen(path)-1, '\\') )
#else /* DBCS */
	if( *b_ptr == '\\' )		/* Remove ending slash if there is  */
#endif /* DBCS */
	{				/* one.				    */
	    save = *b_ptr;
	    *b_ptr = '\0';
	}
	else
	{
	    save = 0;
	}
	
	ret = dos_sfirst( (char far *)path, 0x0010 );
	ret = ( ret ) ? ( dtaBlk.fcb_attr & 0x0010 ) : ret;
	if( save )			/* Restore slash if needed,	    */
	    *b_ptr = '\\';
	dos_sdta( dt );
    }
    return( ret );
}
#endif /* JOPTIMIZE */

/*--------------------------------------------------------------------------*/
/* NAME: reverse							    */
/*									    */
/* PURPOSE: reverse the order of bytes in a string.			    */
/*									    */
/* INPUT:   BYTE	*str	-   string to reverse.			    */
/*									    */
/* OUTPUT:  BYTE	*str	-   reversed string.			    */
/*									    */
/*--------------------------------------------------------------------------*/
    GLOBAL VOID
reverse( 
	 BYTE	    *s			/* String to reverse.		    */
	 )
{
    WORD	c, i, j;

    for( i = 0, j = strlen(s) - 1; i < j; i++, j--)
    {
        c = s[i];
        s[i] = s[j];
        s[j] = c;
    }
}

/*--------------------------------------------------------------------------*/
/* NAME: litoa								    */
/*									    */
/* PURPOSE: converts a long value to a decimal string.			    */
/*									    */
/* INPUT:   LONG	val	-   value.				    */
/*									    */
/* OUTPUT:  BYTE	*s	-   decimal string.			    */
/*--------------------------------------------------------------------------*/
    GLOBAL VOID
litoa(     SLONG	i,
	   BYTE	s[]
	   )
{
    WORD	cnt, sign;

    if( (sign = (i < 0L)) == TRUE )
        i = -i;
    cnt = 0;
    do
    {
        s[cnt++] = i % 10L + '0';
    } while( (i /= 10L) > 0);
    if( sign )
        s[cnt++] = '-';
    s[cnt] = '\0';
    reverse(s);
}
    

/*--------------------------------------------------------------------------*/
/* NAME: latoi								    */
/*									    */
/* PURPOSE: Convert a string of digits to an integer.			    */
/*									    */
/* INPUT:   BYTE	*s	-   String to convert.			    */
/*									    */
/* OUTPUT:  LONG	return()-   convert integer.			    */
/*--------------------------------------------------------------------------*/
    GLOBAL SLONG
latoi(     BYTE	s[]
	   )
{
    WORD	i, sign;
    SLONG	n;
    
    for( i=0; s[i]==' ' || s[i]=='\n' || s[i]=='\t'; i++ );
    
    sign = 1;
    if( s[i]=='+' || s[i]=='-' )
	sign = (s[i++]=='+') ? 1 : -1;
    
    for( n = 0; s[i] >= '0' && s[i] <= '9'; i++ )
	n = 10 * n + s[i] - '0';
    
    return( sign * n );
}

/*--------------------------------------------------------------------------*/
/* NAME: decode_format							    */
/*									    */
/* PURPOSE: Takes a numeric string and produces a format from it for use    */
/*	    with fmt_latoi and fmt_litoa.				    */
/*									    */
/* INPUT:   BYTE	*str	-   Numeric string.			    */
/*									    */
/* OUTPUT:  WORD	reutrn()-   Format word.			    */
/*--------------------------------------------------------------------------*/
    GLOBAL WORD
decode_format(     BYTE	*str
		   )
{
    WORD	fmt;			/* Format.			    */
    BYTE	*dec;			/* Position of the decimal.	    */
    WORD	length;			/* Length of numeric string.	    */
    
    if( *str == '+' )			/* If initial character is '+' then */
	fmt = FMT_SIGN;			/* Always display sign.		    */
    else
	fmt = 0;
    
    length = strlen( str );		/* Get length of string.	    */
    if( (dec = strchr( str, decimal )) != 0 ) /* If decimal,		    */
	fmt |= ((((str+length)-dec)-1)<<8); /* Set number of decimal places */
    
    fmt |= ( length & FMT_LENGTH );	/* Use string length as max length  */
					/* of formatted numeric string.	    */
    return( fmt );
}

/*--------------------------------------------------------------------------*/
/* NAME: fmt_latoi							    */
/*									    */
/* PURPOSE: Takes a formatted numeric string and converts it into a	    */
/*	    long. The string can have sign and decimal point. The	    */
/*	    resulting long will be value * 10**decimal places.		    */
/*									    */
/* INPUT:   BYTE	*str	-   String to convert.			    */
/*	    WORD	fmt	-   Format of string.			    */
/*									    */
/* OUTPUT:  LONG	return()-   value of string.			    */
/*--------------------------------------------------------------------------*/
    GLOBAL SLONG
fmt_latoi(     BYTE    *str,
	       WORD    fmt
	       )
{
    SLONG    val;
    WORD    dec;
    BYTE    *ptr, *endptr, buff[80];
    
    strcpy( buff, str );
    ptr = strchr( buff, decimal );
    endptr = buff + strlen( buff );
    dec = ( ptr ) ? endptr - ptr - 1 : 0;
    if( dec )
    {
        for( ; ptr < endptr; ptr++ )
        {
            *ptr = *(ptr+1);
        }
    }
    val = latoi( buff );
    dec -= mask_value( fmt, FMT_DPLACES );
    if( dec > 0 )
    {
	while( dec-- )
	{
	    val = (val + 5) / 10;
	}
    }
    else if( dec < 0 )
    {
	while( dec++ )
	{
	    val *= 10;
	}
    }
    return( val );
}


/*--------------------------------------------------------------------------*/
/* NAME: fmt_itoa							    */
/*									    */
/* PURPOSE: Converts the an integer value to a string using the given	    */
/*	    format.							    */
/*									    */
/* INPUT:   LONG	val	-   value to format.			    */
/*	    WORD	fmt	-   Format specification. bits 0-6: unused; */
/*				    bit 7: 0=no sign, 1=signed; bits 8-15:  */
/*				    number of digits right of decimal point */
/*									    */
/* OUTPUT:  FBYTE	*str	-   value string.			    */
/*									    */
/*--------------------------------------------------------------------------*/
    GLOBAL VOID
fmt_litoa(     SLONG	val,
	       WORD	fmt,
	       FBYTE    *str
	       )
{
    BYTE	buf[81];		/* Buffer for building string.	    */
    WORD	max_l;			/* Maximum length of the string.    */
    WORD	sign;			/* 0 if no sign, 1 if signed.	    */
    WORD	digits;			/* Number of digits.		    */
    WORD	dec;			/* Number of digits right of decimal*/
    WORD	length;			/* Total length of value string.    */
    
    max_l = mask_value( fmt, FMT_LENGTH );
    max_l = min( max_l, 80 );		/* Make sure string does not	    */
					/* overflow buffer.		    */

    if( !max_l )			/* If max length is 0, return.	    */
    {
	*str = '\0';
	return;
    }
    
    sign = 0;
    if( (fmt & FMT_SIGN) && (val > 0L) )/* If signed format and value is    */
    {					/* positive insert '+'.		    */
        buf[sign++] = '+';
    }

    litoa( val, &buf[sign] );		/* Convert value to string.	    */
    
    sign += ( buf[sign] == '-' ) ? 1 : 0; /* Account for minus sign.	    */
    
    digits = strlen( &buf[sign] );	/* Get number of digits in string.  */
    dec = mask_value( fmt, FMT_DPLACES); /* Get number of decimal places.   */
    
    length = ( digits > dec ) ? digits+sign : dec+sign+1; /* Calculate	    */
    if( dec )						  /* length of	    */
	length++;					  /* string.	    */
    
    if( length > max_l )		/* If string is too long,	    */
    {					/* fill with '*'.		    */
	for( length = 0; length < max_l; length++ )
	    buf[length] = '*';
	buf[length] = '\0';
    }
    else if( dec )			/* Otherwise, insert decimal.	    */
    {
        buf[length] = '\0';
	length--;
	while( digits && dec )		/* Shift digits to right of decimal */
	{
	    digits--;
	    dec--;
	    buf[length] = buf[digits+sign];
	    length--;
	}
        
	while( dec-- )			/* Add leading zeros if needed.	    */
	{
	    buf[length] = '0';
	    length--;
	}
	
	buf[length] = decimal;		/* Insert decimal.		    */
	length--;
	
	if( !digits )			/* If no digits left, start with 0  */
	    buf[length] = '0';
    }
    
    fstrcpy( str, (char far *)&buf[0] );	/* Copy buffer to string.   */
}

/*--------------------------------------------------------------------------*/
/* NAME: vst_lattr							    */
/*									    */
/* PURPOSE: Sets line attributes.					    */
/*--------------------------------------------------------------------------*/
    GLOBAL VOID
vst_lattr( 
	   WORD	    wmode,		/* Writing mode.		    */
	   WORD	    ltype,		/* Line type.			    */
	   WORD	    lclr,		/* Line color.			    */
	   WORD	    lbeg,		/* Beginning end style.		    */
	   WORD	    lend,		/* Ending end style.		    */
	   WORD	    lwidth		/* Line width.			    */
	   )
{
    vswr_mode( wmode );
    vsl_type( ltype );
    vsl_color( lclr );
    vsl_ends( lbeg, lend );
    vsl_width( lwidth );
}

/*--------------------------------------------------------------------------*/
/* NAME: init_evmulti							    */
/*									    */
/* PURPOSE: Initializes an event multi data structure.			    */
/*									    */
/* INPUT:   EVMULT	*evm	    -	Pointer to event multi data struct. */
/*									    */
/* OUTPUT:  Initalized event multi data structure.			    */
/*--------------------------------------------------------------------------*/
    GLOBAL VOID
init_evmulti(     EVMULT  *evm
		  )
{
    evm->em_events = MU_BUTTON;
    evm->em_bclk = 2;
    evm->em_bmsk = 1;
    evm->em_bst = BUTTON_DOWN;
    evm->em_1inout = RETURN_ON_ENTRY;
    evm->em_1box.x = 0;
    evm->em_1box.y = 0;
    evm->em_1box.w = 0;
    evm->em_1box.h = 0;
    evm->em_2inout = RETURN_ON_ENTRY;
    evm->em_2box.x = 0;
    evm->em_2box.y = 0;
    evm->em_2box.w = 0;
    evm->em_2box.h = 0;
    evm->em_time = 0L;
}

/*--------------------------------------------------------------------------*/
/* NAME: get_rscstr							    */
/*									    */
/* PURPOSE: Get the address of the string associated with the given object. */
/*									    */
/* INPUT:   FDOBJECT	*tree	-   Pointer to tree.			    */
/*	    WORD	obj	-   object number to find string of.	    */
/*									    */
/* OUTPUT:  FBYTE	*return()-  address of string.			    */
/*									    */
/*--------------------------------------------------------------------------*/
    GLOBAL FBYTE
*get_rscstr(     FDOBJECT	*tree,
		 WORD	obj
		 )
{
    FDOBJECT	*obj_ptr;		/* Pointer to object.		    */
    FTEDINFO	*tinfo;			/* Pointer to TEDINFO .		    */
    FBYTE	*str;			/* Pointer to string.		    */
    
    obj_ptr = tree + obj;
    switch( obj_ptr->ob_type & 0x00FF )
    {
	case G_TEXT:
	case G_BOXTEXT:
	case G_FTEXT:
	case G_FBOXTEXT:
	    tinfo = (FTEDINFO *)(obj_ptr->ob_spec);
	    str = (FBYTE *)tinfo->te_ptext;
	    break;
	case G_BUTTON:
	case G_STRING:
	case G_TITLE:
	    str = (FBYTE *)obj_ptr->ob_spec;
	    break;
	default:
	    str = (FBYTE *)0;
	    break;
    }
    return( str );
}

#if JOPTIMIZE
    GLOBAL VOID
set_rscstr( FDOBJECT	*tree,
	    WORD	obj,
	    FBYTE	*str
	    )
{
    FDOBJECT	*obj_ptr;		/* Pointer to object.		    */
    FTEDINFO	*tinfo;			/* Pointer to TEDINFO .		    */
    
    obj_ptr = tree + obj;
    switch( obj_ptr->ob_type & 0x00FF )
    {
	case G_TEXT:
	case G_BOXTEXT:
	case G_FTEXT:
	case G_FBOXTEXT:
	    tinfo = (FTEDINFO *)(obj_ptr->ob_spec);
	    tinfo->te_ptext = str;
	    break;
	case G_BUTTON:
	case G_STRING:
	case G_TITLE:
	    obj_ptr->ob_spec = str;
	    break;
	default:
	    break;
    }
}
#endif /* JOPTIMIZE */

/*--------------------------------------------------------------------------*/
/* NAME: find_parent							    */
/*									    */
/* PURPOSE: Finds the object number of the parent of the given object.	    */
/*									    */
/* INPUT:   FDOBJECT	*tree	-   Pointer to tree.			    */
/*	    WORD	obj	-   object number whose parent is to be	    */
/*				    found.				    */
/*									    */
/* OUTPUT:  WORD	return()-   Object number of parent. -1 means the   */
/*				    given object is the root of the tree.   */
/*									    */
/*--------------------------------------------------------------------------*/
    GLOBAL WORD
find_parent(     FDOBJECT	*tree,
		 WORD	obj
		 )
{
    WORD	parent;			/* Parent object number.	    */
    
    for( parent = (tree+obj)->ob_next; obj != (tree+parent)->ob_tail;
         parent = (tree+obj)->ob_next )
    {
        if( parent == -1 )
            break;
        obj = parent;
    }
    return( parent );
}


/*--------------------------------------------------------------------------*/
/* NAME: get_obloc							    */
/*									    */
/* PURPOSE: Calculate the screen extent of a resource object.		    */
/*									    */
/* INPUT:   FAR OBJECT	*tree	-   Pointer to tree.			    */
/*	    WORD	ob	-   Object number.			    */
/*									    */
/* OUTPUT:  GRECT	*r	-   Extent of object in screen coordinates. */
/*									    */
/*--------------------------------------------------------------------------*/
    GLOBAL VOID
get_obloc(     TREE	tree,
	       WORD	ob,
	       RECT	*r
	       )
{
    FDOBJECT	*prnt_ptr;		/* Pointer to Parent.		    */
    WORD	parent;			/* Object number of parent.	    */
    
    prnt_ptr = tree + ob;
    r->x = prnt_ptr->ob_box.x;		/* Initialize the extent to object  */
    r->y = prnt_ptr->ob_box.y;		/* extent.			    */
    r->w = prnt_ptr->ob_box.w;
    r->h = prnt_ptr->ob_box.h;
					/* Add parent offsets to get screen */
					/* coordinates.			    */
    for( parent = find_parent( tree, ob ); parent != -1;
         parent = find_parent( tree, parent ) )
    {
        prnt_ptr = tree + parent;
	r->x += prnt_ptr->ob_box.x;
        r->y += prnt_ptr->ob_box.y;
    }
}

/*--------------------------------------------------------------------------*/
/* NAME: evnt_loop							    */
/*									    */
/* PURPOSE: General event loop. Executes the given function each time	    */
/*	    through the loop.						    */
/*									    */
/*  INPUT:  EVMULT	*evm	-   Event multi data structure.		    */
/*	    WORD	exit_ev	-   Event flags that cause an exit.	    */
/*	    TREE	tree	-   Tree for current object.		    */
/*	    WORD	obj	-   object number.			    */
/*	    WORD	(*func)() - function to execute in the loop.	    */
/*	    FBYTE	*func_data-   Pointer to value box data.	    */
/*									    */
/* OUTPUT:  none.							    */
/*--------------------------------------------------------------------------*/
    GLOBAL VOID
evnt_loop(
    EVMULT	*evm,
    WORD	exit_ev,
    TREE	tree,
    WORD	obj,
    WORD	(*func)(EVMULT*, TREE, WORD, WORD, WORD, FBYTE*),
    FBYTE	*func_data )
{

    WORD	err_cnt, dly_cnt;
    WORD	off_x, off_y;
    
    if( tree )
    {

	objc_offset( tree, obj, &off_x, &off_y );
	off_x = evm->em_mstat.mst_x - off_x;
	off_y = evm->em_mstat.mst_y - off_y;
    }
    else
    {
	off_x = off_y = 0;
    }
    
    dly_cnt = 0;
    err_cnt = 0;
    do
    {
	if( !(* func)( evm, tree, obj, off_x, off_y, func_data ) )
	{
	    err_cnt++;
	    if( err_cnt > 3 )
	    {
		v_sound(TRUE, 440, 2);
		err_cnt = 0;
	    }
	}
	else
	    err_cnt = 0;

	if( dly_cnt == 10 )
	    evm->em_time /= 2L;
	dly_cnt++;
	
    } while( !(devnt_multi( evm ) & exit_ev) );
}

/*--------------------------------------------------------------------------*/
/* NAME: upd_ob_state							    */
/*									    */
/* PURPOSE: Updates the given objects state by ORing in the new state with  */
/*	    the existing state. If the toggle flag is set the new state is  */
/*	    XORed with the existing state. An object change call is then    */
/*	    made for that object.					    */
/*--------------------------------------------------------------------------*/
    GLOBAL VOID
upd_ob_state( TREE	tree,		/* Tree address of the object to    */
					/* update.			    */
	      WORD	obj,		/* Object number of object.	    */
	      WORD	new_state,	/* New state to be ORed with old.   */
	      BOOLEAN	toggle,		/* If true new state XORed.	    */
	      BOOLEAN	redraw		/* If true object redrawn.	    */
	      )
{
    FDOBJECT	*obj_ptr;		/* Pointer to object.		    */
    RECT	rc;			/* Redraw clip rectangle.	    */
    
    obj_ptr = tree + obj;
    
    if( toggle )
	new_state ^= obj_ptr->ob_state;
    else
	new_state |= obj_ptr->ob_state;
    
    get_obloc( tree, obj, &rc );
    objc_change( tree, obj, 0, rc.x, rc.y, rc.w, rc.h, new_state, redraw );
}

/*--------------------------------------------------------------------------*/
/* NAME: dsel_rbut							    */
/*									    */
/* PURPOSE: Finds the parent of the given object and turns off the deselects*/
/*	    the selected radio button.					    */
/*--------------------------------------------------------------------------*/
/* 891206 DLB #41: Add redraw flag to dsel_rbut.			    */
    GLOBAL VOID
dsel_rbut( TREE	    tree,		/* Tree address of button.	    */
	   WORD	    obj,		/* Object number of known button.   */
	   WORD	    redraw		/* Redraw flag.			    */
	   )
{
    WORD	parent;			/* Object number of parent.	    */
    WORD	cur_obj;		/* Object number of the current	    */
					/* object.			    */
    FDOBJECT	*obj_ptr;		/* Pointer to current object.	    */
    
    parent = find_parent( tree, obj );
    for( cur_obj = (tree+parent)->ob_head; cur_obj != parent;
	 cur_obj = obj_ptr->ob_next )
    {
	obj_ptr = tree + cur_obj;
	if( (obj_ptr->ob_flags & RBUTTON) && (obj_ptr->ob_state & SELECTED) )
	{
	    upd_ob_state( tree, cur_obj, SELECTED, TRUE, redraw );
	    break;
	}
    }
}

/* danutil.c */
