/****************************************************************************
*   Copyright 1999, Caldera Thin Client Systems, Inc.                       *
*   This software is licensed under the GNU Public License                  *
*   See LICENSE.TXT for futher information.                                 *
*                                                                           *
*   Historical Copyright:                                                   *
*                                                                           *
*   Copyright (c) 1992  Digital Research Inc.				    *
*   All rights reserved.						    *
*   The Software Code contained in this listing is proprietary to Digital   *
*   Research Inc., Monterey, California, and is covered by U.S. and other   *
*   copyright protection.  Unauthorized copying, adaption, distribution,    *
*   use or display is prohibited and may be subject to civil and criminal   *
*   penalties.  Disclosure to others is prohibited.  For the terms and      *
*   conditions of software code use, refer to the appropriate Digital       *
*   Research License Agreement.						    *
*****************************************************************************
*		      U.S. GOVERNMENT RESTRICTED RIGHTS			    *
*                    ---------------------------------                      *
*  This software product is provided with RESTRICTED RIGHTS.  Use, 	    *
*  duplication or disclosure by the Government is subject to restrictions   *
*  as set forth in FAR 52.227-19 (c) (2) (June, 1987) when applicable or    *
*  the applicable provisions of the DOD FAR supplement 252.227-7013 	    *
*  subdivision (b)(3)(ii) (May 1981) or subdivision (c)(1)(ii) (May 1987).  *
*  Contractor/manufacturer is Digital Research Inc. / 70 Garden Court /     *
*  BOX DRI / Monterey, CA 93940.					    *
*****************************************************************************
* $Header: g:/groups/panther/dsk/rcs/deskbkgd.c 4.10 92/04/10 13:40:10 sbc Exp $
* $Log:	deskbkgd.c $
 * Revision 4.10  92/04/10  13:40:10  sbc
 * Rm redundant preferences vars. Create new struct PREFS
 * 
 * Revision 4.9  92/04/09  14:54:17  sbc
 * Merge Becky's memory management improvements re backgrounds
 * 
 * Revision 4.8  92/04/03  17:10:19  sbc
 * WNODEs and PNODEs to fars, lots of other housekeeping
 * 
 * Revision 4.7  92/03/12  13:58:54  rsf
 * Merge in RSF's changes for icons on desktop and (LONG) => (TREE).
 * 
 * Revision 4.6  92/02/27  15:32:00  rsf
 * Communication and display of chosen background image
 * 
 * Revision 4.5  92/02/19  15:55:43  sbc
 * Replace refs to G.a_trees[] with calls to rsrc_gaddr().
 * 
 * Revision 4.4  92/02/06  15:47:28  sbc
 * add test for pFDB == 0L in unload_bmp()
 * 
 * Revision 4.3  92/02/06  12:09:42  sbc
 * add new procedure unload_bmp() to replace two dos_free() calls
 * 
 * Revision 4.2  92/01/31  16:42:06  sbc
 * save and restore FCB around call to dos_sfirst.
 * 
 * Revision 4.1  92/01/28  14:54:25  rsf
 * New module fomr RSF.
 * 
*/

/****************************************************************************
* File:		deskbkgd
*
* Description:	
*
* Build Info:	ndmake -f vm2.mak
*
*****************************************************************************/
#include "shell.h"
#include "funcdef.h"
#include "exproto.h"

extern	WORD	DOS_ERR;
extern	PREFS	prefs;
extern	GLOBES	G;
extern	WS	gl_ws;
extern  UWORD	intin[];
extern  UWORD	contrl[];
extern  WORD	ptsin[];
extern	char	start_path[ 65 ];	/* Path we ran from  */

#define BITSperBYTE	8
#define BITSperWORD	16

/***********************************************************************
*	Free up memory allocated with load_bmp_file()                
***********************************************************************/
void unload_bmp( FDB far * pFDB )
{
    if ( pFDB == 0L )
	return ;
    dos_free( pFDB->fd_addr );
    dos_free( (LONG)pFDB );
	
} /* unload_bmp() */

/***********************************************************************
*	This routine reads the contents of a Windows 3.0 BMP file and
*	converts it to a GEM MFDB, reader for translation and copying
***********************************************************************/

FDB far *load_bmp_file(char *fname, BOOLEAN dump_g_bitmap )
{
	WORD		fh;		/* BMP file handle		*/
	WORD		bytes_read;	/* Return of dos_read()		*/
	LONG		map_size;	/* Total size of bmp data	*/
	LONG		space_avail;	/* Largest free block available.*/
	BMP_HEADER	bhdr;		/* Header of BMP file		*/
	BMP_INFO	binfo;		/* BMP Info Header		*/
	FDB far 	*cicon;		/* MFDB for color image		*/
	
	sprintf(G.g_srcpth, "%s%s",start_path,fname);
	fh = dos_open((LONG)(char far *)G.g_srcpth, READONLY);
	if (!fh || DOS_ERR)
		return(0L);
	
	bytes_read = dos_read(fh, sizeof(BMP_HEADER), 
				    (LONG)(BMP_HEADER far *)&bhdr );

	/* Check read success and file type */
	if (bytes_read != sizeof(BMP_HEADER) || bhdr.type != 0x4D42) /*BM*/
	{
		dos_close(fh);
		return(0L);
	}
	

	bytes_read = dos_read( fh, sizeof(BMP_INFO), 
						(LONG)(BMP_INFO far *)&binfo );
	if (bytes_read != sizeof(BMP_INFO))
	{
		dos_close(fh);
		return(0L);
	}
	
	dos_lseek(fh, SEEK_SET, bhdr.offset);	/* Skip RGB-QUADS   */
	
	/* Read in the bitmap itself and convert to an MFDB */
	cicon = (FDB far*)dos_alloc(sizeof(FDB));
						/* Must even up the width */
	cicon->fd_w=(WORD)binfo.width + ((WORD)binfo.width % BITSperWORD);
	cicon->fd_h=(WORD)binfo.height;

	map_size = (LONG)cicon->fd_w * (LONG)cicon->fd_h 
		* binfo.bit_count / BITSperBYTE;

	if (dump_g_bitmap)
	{
		/* Free existing background bitmap, if necessary, to	*/
		/* provide enough space to bring in new background	*/
		/* bitmap. Don't bother, though, if it won't help.	*/
		space_avail = dos_avail();
		if ( space_avail < map_size && 
		    ((LONG)((LONG)G.g_bitmap->fd_w * (LONG)G.g_bitmap->fd_h 
			* G.g_bitmap->fd_nplanes / BITSperBYTE) >= map_size) )
		{
			unload_bmp(G.g_bitmap);
			G.g_bitmap = 0L;
		}

	}

	if ((cicon->fd_addr = dos_alloc(map_size)) == 0L)
	{
		alert_s( 0x0101, ERNOMEM, "Bitmap" );
		dos_free((LONG)cicon);
		return (0L);
	}
	cicon->fd_wdwidth = cicon->fd_w/BITSperWORD;
	cicon->fd_stand = 1;
	cicon->fd_nplanes = binfo.bit_count;
	convert_bmp_fdb(fh, binfo.bit_count, (WORD)binfo.width, cicon->fd_h,
		(WORD far *)cicon->fd_addr, map_size, FALSE);
	dos_close(fh);
	return(cicon);
}

/***********************************************************************
***********************************************************************/
void	render_bmp(FDB far* fdb, WORD x, WORD y)
{
	FDB	screen;
	
	gsx_fix(&screen, 0L, 0, 0);
	/* Transform if necessary */
	if (fdb->fd_stand)
	{
		*(LONG*)&contrl[7] = (LONG)fdb;
		*(LONG*)&contrl[9] = (LONG)fdb;
		gsx_ncode(TRANSFORM_FORM, 0, 0);
	}

	/* send to screen */

	*(LONG*)&contrl[7] = (LONG)fdb;
	*(LONG*)&contrl[9] = (LONG)(FDB far *)(&screen) ;

	ptsin[0] = 0;
	ptsin[1] = 0;
	ptsin[2] = fdb->fd_w-1;
	ptsin[3] = fdb->fd_h-1;
	ptsin[4] = x;
	ptsin[5] = y;
	ptsin[6] = x + fdb->fd_w - 1;
	ptsin[7] = y + fdb->fd_h - 1;
	if (gl_ws.ws_color && fdb->fd_nplanes == 1)
	{
		/* If color device but mono icon */
		intin[0] = MD_REPLACE;
		intin[1] = BLACK;
		intin[2] = WHITE;
		gsx_ncode(TRAN_RASTER_FORM, 4, 3);
		
	}
	else
	{
		intin[0] = 3;
		gsx_ncode(COPY_RASTER_FORM, 4, 1);
	}

}

/***********************************************************************
***********************************************************************/
GLOBAL FLISTITEM *create_listitem(BYTE *data, WORD len, WORD state)
{
	FLISTITEM *item;
	
	item = (FLISTITEM*)dos_alloc(sizeof (LISTITEM));
	if (item)
	{
		if (len == 0)
			len = strlen(data);
		item->it_ptr = (BYTE far*)dos_alloc(len);
		if (!item->it_ptr)
		{
			dos_free((LONG)item);
			return (0L);
		}
		fstrcpy(item->it_ptr, (char far *)data);
		item->flags = SELECTABLE;
		item->state = state;
	}
	return (item);
}

/***********************************************************************
***********************************************************************/
GLOBAL void init_bmp_list(FLISTBOX *lb, BOOLEAN prepend_none, 
	BOOLEAN none_sel, BYTE *curr_selection)
{
	FLISTITEM	*item = 0L;
	FCB		fcb;
	FCB far *	pOldFCB;	/* be sure to restore orig FCB	*/
	WORD		comp_result;

	pOldFCB = dos_gdta() ;
	dos_sdta( (FCB far *)&fcb );
	
	sprintf(G.g_srcpth, "%s%s",start_path,"*.BMP");
	
	if (prepend_none)
	{
		item = create_listitem("None", LEN_ZFNAME, 
			none_sel ? SELECTED : 0);
		add_to_list(lb->items, lb->items->end, item);
	}
	
	if (!dos_sfirst( (char far *)G.g_srcpth, 0)) {
	    dos_sdta( pOldFCB ) ;
	    return;
	    }
	while (!DOS_ERR)
	{
		comp_result = strcmp(fcb.fcb_name, curr_selection);

		item = create_listitem(fcb.fcb_name, LEN_ZFNAME, 
			(comp_result == 0) ? SELECTED : 0);
		add_to_list(lb->items, lb->items->end, item);
		dos_snext();
	}
	ls_sort(lb->items, 
		prepend_none ? lb->items->start->next : lb->items->start, 
		lb->items->end);
	    
    dos_sdta( pOldFCB ) ;
    
} /* init_bmp_list() */

/***********************************************************************
***********************************************************************/
MLOCAL void setup_chosbkgd(TREE tree, FLISTBOX *lb)
{
	WORD		i;
	
	for (i=0; i< 3; i++)
		(tree+BGCENTER+i)->ob_state = 
			(i+1 == prefs.bkgd_type) ? SELECTED: NORMAL;

	if (prefs.bkgd_type == 0)
		(tree+BGCENTER)->ob_state = SELECTED;
		
					/* Initialize the list structure  */
	if ( !lb->items )
	{
		lb->items= (FLIST*)dos_alloc(sizeof(LIST));
		ls_init(lb->items);
	}

	init_bmp_list(lb, TRUE, !prefs.bkgd_type, prefs.bkgd_name );
	lb_init( tree, BKGDLIST, FALSE );

	return;
}

/***********************************************************************
***********************************************************************/

BOOLEAN choose_bkgd( WORD *new_type, BYTE *new_name )
{
	TREE	tree;
	FLISTBOX	*lb;		/* Pointer to list box data.	*/
	WORD		sel_item;	/* Initially selected item	*/
	WORD		start_fld = BGOK;
	WORD		obj;
	BOOLEAN		done = FALSE;
	BOOLEAN		changed = FALSE;

	rsrc_gaddr( R_TREE, CHOSBKGD, &tree ) ;
	lb = (FLISTBOX *)get_data_ptr( tree, BKGDLIST );	

	*new_type = prefs.bkgd_type ;
	strcpy( new_name, prefs.bkgd_name ) ;
	setup_chosbkgd(tree, lb);
	sel_item = lst_selected(lb->items);
	
	show_hide( FMD_START, tree );

	while (!done)
	{
		obj = xform_do( tree, start_fld);
#if HELP_ALERTS
		if ( obj == -1 ) 
		{
		    do_help_alert( HFINDFIL ) ;
		    continue ;
		}
#endif
		else start_fld = obj;

		obj = inf_what( tree, BGOK, BGCANCEL ) ;
		if ( obj == 1 ) {

		    changed = ( (sel_item != lst_selected(lb->items))
			    || (prefs.bkgd_type != radio_get(tree, BGCENTER, 2)+1) );
		    
		    /* Record the selected background */
		    if (!lb->items->cur || lb->items->cur == lb->items->start)
		    {
		    	/* Nothing or "None" selected */
			new_name[0] = '\0';
			*new_type = 0;
		    }
		    else
		    {
			fstrcpy((char far *)new_name, lb->items->cur->it_ptr);
			*new_type = radio_get( tree, BGCENTER, 2)+1;
		    }
		}
		done = (obj != -1) ;	/* OK or CANCEL chosen */
	}

	show_hide(FMD_FINISH, tree);
	free_listitems(lb->items->start);
	lb->items->start = lb->items->end = 0L;
	
	return(changed);
}

/* end of deskbkgd.c */
