#define SBC_920302
/****************************************************************************
*   Copyright 1999, Caldera Thin Client Systems, Inc.                       *
*   This software is licensed under the GNU Public License.                 *
*   See LICENSE.TXT for further information.                                *
*                                                                           *
*   Historical Copyright                                                    *
*                                                                           *
*   Copyright (c) 1985, 1987, 1990, 1991, 1992  Digital Research Inc.	    *
*   All rights reserved.						    *
*   The Software Code contained in this listing is proprietary to Digital   *
*   Research Inc., Monterey, California, and is covered by U.S. and other   *
*   copyright protection.  Unauthorized copying, adaption, distribution,    *
*   use or display is prohibited and may be subject to civil and criminal   *
*   penalties.  Disclosure to others is prohibited.  For the terms and      *
*   conditions of software code use, refer to the appropriate Digital       *
*   Research License Agreement.						    *
*****************************************************************************
*		      U.S. GOVERNMENT RESTRICTED RIGHTS			    *
*                    ---------------------------------                      *
*  This software product is provided with RESTRICTED RIGHTS.  Use, 	    *
*  duplication or disclosure by the Government is subject to restrictions   *
*  as set forth in FAR 52.227-19 (c) (2) (June, 1987) when applicable or    *
*  the applicable provisions of the DOD FAR supplement 252.227-7013 	    *
*  subdivision (b)(3)(ii) (May 1981) or subdivision (c)(1)(ii) (May 1987).  *
*  Contractor/manufacturer is Digital Research Inc. / 70 Garden Court /     *
*  BOX DRI / Monterey, CA 93940.					    *
*****************************************************************************
* $Header: m:/davinci/users//groups/panther/dsk/rcs/deskfpd.c 4.13 92/04/06 09:46:37 Fontes Stable $
* $Log:	deskfpd.c $
 * Revision 4.13  92/04/06  09:46:37  Fontes
 * Initial cut to extract/display Windows exe embedded icons.
 * 
 * Revision 4.12  92/04/03  17:10:40  sbc
 * WNODEs and PNODEs to fars, lots of other housekeeping
 * 
 * Revision 4.11  92/03/26  14:43:07  sbc
 * WNODEs and PNODEs to far ptrs. Also merge in RSF's changes
 * 
 * Revision 4.10  92/03/13  14:40:49  sbc
 * Merge in Keiko's changes required for Double Byte Character Support
 * 
 * Revision 4.9  92/03/05  09:30:49  sbc
 * Hook up use of New Program Item dialog and INODE structure.
 * 
 * Revision 4.8  92/02/27  09:40:56  sbc
 * Allow assignment of icon to ordinary FNODE.
 * 
 * Revision 4.7  92/02/25  08:13:34  sbc
 * Add New Icon Dialog and allow assignment of icons (only) to FNODEs/ANODEs.
 * 
 * Revision 4.6  92/02/20  15:56:03  sbc
 * Various changes to ANODE structure and defines
 * 
 * Revision 4.5  92/02/19  16:00:50  sbc
 * EXTERN => extern, void => void, FAR => far, (PTR *)0 => (PTR)NULL
 * 
 * Revision 4.4  92/02/06  15:45:40  sbc
 * Turn fake folder at top of dir back on (New Folder).
 * 
 * Revision 4.3  92/02/05  12:51:21  sbc
 * remove New Folder icon from directory windows. Use compile switch
 * FAKEFOLDERICON if we decide to turn this back on.
 * 
 * Revision 4.2  92/01/31  16:40:55  sbc
 * replace refs to G.a_wdta with (FCB far *)G.g_wdta. 
 * 
 * Revision 4.1  91/12/20  15:09:40  anderson
 * ViewMAX3 baseline.  Converted TNODEs to FNODEs.  Using macros to access
 * packed FNODE->istree nibbles.  Deleted useless pointer into PNODE list.
 * Nullify the freed flist pointer in pn_close() for safety.
 * 
 * Revision 3.1  91/08/19  16:38:19  system
 * ViewMAX 2 sources
 * 
Date	Who	SPR#	Comments
-------	-------	----	------------------------------------------------------
911016  K.H		Add supporting double byte character set. (#if DBCS)
910401	RSF		Make pn_alloc and pn_free available.
*****************************************************************************/

#include <dos.h>
#include <dir.h>
#include "shell.h"
#include "viewapps.h"

extern ICONBLK	far	*gl_icons;
extern WORD	DOS_AX;
extern GLOBES	G;
extern WORD	gl_width;
extern WORD	gl_height;
extern UWORD	global[];

GLOBAL FNODE far *ml_pfndx[NUM_FNODES];

/*---------------------------------------------------------------------------
*	Initialize the list of fnodes
*/
MLOCAL	void fn_init(void)
{
	WORD		i;

	for(i=NUM_FNODES - 2; i >= 0; i--)
	  G.g_flist[i].f_next = &G.g_flist[i + 1];
	G.g_favail = G.g_flist;
	G.g_flist[NUM_FNODES - 1].f_next = (FNODE far *)NULL;
}

/*----------------------------------------------------------------------
*	Initialize the list of pnodes
*/
MLOCAL	void pn_init(void)
{
	WORD		i;

	for(i=NUM_PNODES - 2; i >= 0; i--)
	  G.g_plist[i].p_next = &G.g_plist[i + 1];
	G.g_pavail = &G.g_plist[0];
	G.g_plist[NUM_PNODES - 1].p_next = (PNODE far *) NULL;
}

/*----------------------------------------------------------------------
*	Start up by initializing global variables
*/
BOOLEAN fpd_start( void )
{
	fn_init();
	pn_init();
	return( tree_init() ) ;
}

/*----------------------------------------------------------------------
*	Build a filespec out of drive letter, a pointer to a path, a pointer
*	to a filename, and a pointer to an extension.
*
*	EXAMPLES: 
*	drive = 65, ppath = "LEVEL1\LEVEL2", pname = "NAME", pext = "EXT"
*	pspec = "A:\LEVEL1\LEVEL2\NAME.EXT"
*	drive = 68, ppath = "", pname = "NAME", pext = "EXT"
*	pspec = "D:\NAME.EXT"
*/
WORD fpd_bldspec( WORD drive, BYTE * ppath, BYTE * pname, BYTE * pext, 
			BYTE far * pspec )
{
BYTE *	ptr ;
BYTE	tmp[ LEN_ZPATH ] ;

    if ( (strlen(ppath) + LEN_ZFNAME) >= (LEN_ZPATH-MAXDRIVE) )
    	return(FALSE);

    ptr = tmp ;	
    ptr += sprintf( ptr, "%c:\\", drive ) ;
    if ( *ppath )
    	ptr += sprintf( ptr, "%s\\", ppath ) ;
    if ( *pname ) {
    	ptr += sprintf( ptr, "%s", pname ) ;
	if ( *pext )
	    sprintf( ptr, ".%s", pext ) ;
	}

    fstrcpy( pspec, tmp ) ;
    
    return(TRUE);

} /* fpd_bldspec() */

/*----------------------------------------------------------------------
*	Parse a filespec into its drive, path, name, and extension
*	parts. Use runtime library function fnsplit().
*
*	EXAMPLES: 
*	pspec = "A:\LEVEL1\LEVEL2\NAME.EXT"
*	pdrv = 65, ppath = "LEVEL1\LEVEL2", pname = "NAME", pext = "EXT"
*	pspec = "D:\NAME.EXT"
*	pdrv = 68, ppath = "", pname = "NAME", pext = "EXT"
*/
void fpd_parse( BYTE far * pspec, 
			WORD * pdrv, BYTE * ppath, BYTE * pname, BYTE * pext )
{
BYTE    tmp[ LEN_ZPATH ];
BYTE	drive[MAXDRIVE];

    fstrcpy( (char far *)tmp, pspec ) ;		/* use local copy	*/

    fnsplit( tmp,				/* split fname		*/
	(pdrv == (WORD *)NULL) ? (char *)pdrv : drive, ppath, pname, pext ) ; 

    if ( pdrv )
	*pdrv = (WORD)drive[0] ;		/* "C:" => 67		*/
    
    if ( ppath && *ppath ) {			/* "\DIR1\" => "DIR1"	*/
	fstrcpy( &ppath[0], &ppath[1] );	/* rm beginning '\\'	*/
	if ( *ppath )				/* check for single '\\'*/
	    ppath[ fstrlen( ppath ) - 1 ] = NULL ;/* rm ending '\\'	*/
    }
    if ( pext && *pext )			/* ".EXT" => "EXT	*/
	fstrcpy( &pext[0], &pext[1] );		/* rm beginning '.'	*/
    
} /* fpd_parse() */

/*----------------------------------------------------------------------
*	Find the file node that matches a particular object id.
*/
FNODE far *fpd_ofind(FNODE far *pf, WORD obj)
{
	while(pf)
	{
	  if (pf->f_obid == obj)
	    return(pf);
	  pf = pf->f_next;
	}
	return((FNODE far *)NULL);
}

/*----------------------------------------------------------------------
*	Find the list item that is after start and points to stop item.
*/
MLOCAL	FNODE far *fpd_elist(FNODE far *pfpd, FNODE far *pstop)
{
	while( pfpd->f_next != pstop )
	  pfpd = pfpd->f_next;
	return(pfpd);
}

/*----------------------------------------------------------------------
*	Free a single file node
*/
void fn_free(FNODE far *thefile)
{
	if (thefile != (FNODE far *)NULL)
	  thefile->f_next = G.g_favail;
	G.g_favail = thefile;
}

/*----------------------------------------------------------------------
*	Free a list of file nodes (attach it to the head of the free list).
*	If the list describes a directory tree, preserve it for future use
*	and remove its entry from the list of trees in memory.
*/
void fl_free(FNODE far *pflist)
{
	FNODE far *thelast;

	if (pflist && (G.g_favail != pflist))
	{
	    if (GET_ISTREE(pflist))
	    {
		tree_save(pflist);
		G.t_drive[pflist->f_name[0]-'A'] = (FNODE far *)NULL;
	    }
	    
	    thelast = fpd_elist(pflist, (FNODE far *)NULL);
	    thelast->f_next = G.g_favail;
	    G.g_favail = pflist;
	}
}

/*----------------------------------------------------------------------
*	Allocate a file node.
*/
FNODE far *fn_alloc( void )
{
	FNODE far *thefile;

	if ( G.g_favail )
	{
	  thefile = G.g_favail;
	  G.g_favail = G.g_favail->f_next;
	  return(thefile);
	}
	return((FNODE far *)NULL);
}

/*----------------------------------------------------------------------
*	Allocate a path node.
*/
GLOBAL	PNODE far * pn_alloc( void )
{
PNODE far * thepath;

	if ( G.g_pavail )
	{
	  thepath = G.g_pavail;
	  G.g_pavail = G.g_pavail->p_next;
	  thepath->p_flist = (FNODE far *)NULL;		/* init */
	  return(thepath);
	}
	return( (PNODE far *)NULL );
}

/*----------------------------------------------------------------------
*	Free a path node.
*/
GLOBAL	void pn_free(PNODE far *thepath)
{
    if ( thepath != (PNODE far *)NULL )
    {

	fl_free(thepath->p_flist);		/* free our file list	*/
	thepath->p_flist = (FNODE far *)NULL;
	thepath->p_next = G.g_pavail;
	G.g_pavail = thepath;
    }
}

/*----------------------------------------------------------------------
*	Close a particular path.
*/
void pn_close(PNODE far *thepath)
{
	pn_free(thepath);
}

/*----------------------------------------------------------------------
*	Open a particular path.  
*/
PNODE far *pn_open( WORD drive, BYTE *path, BYTE *name, BYTE *ext )
{
PNODE far *	thepath;

	thepath = pn_alloc();
	if ( thepath != (PNODE far *)NULL )
	{
	  if ( fpd_bldspec(drive, path, name, ext, thepath->p_spec ) )
	    return(thepath);
	  else 
	    pn_close(thepath);
	}

	return( (PNODE far *)NULL );

} /* pn_open() */

/*----------------------------------------------------------------------
*	Compare file nodes pf1 & pf2, using a field
*	determined by which
*/
MLOCAL	WORD pn_fcomp(FNODE far *pf1, FNODE far *pf2, WORD which)
{
	WORD		chk;
	BYTE far	*ps1;
	BYTE far	*ps2;

	ps1 = &pf1->f_name[0];
	ps2 = &pf2->f_name[0];

	switch (which)
	{
	  case S_SIZE:
		if (pf2->f_size > pf1->f_size)
		  return(1);
		if (pf2->f_size < pf1->f_size)
		  return(-1);
		return( fstrcmp(ps1, ps2) );
          case S_TYPE:
	  	chk = fstrcmp(fstrchr(ps1, '.'), fstrchr(ps2, '.'));
		if (chk)
		  return(chk);
							/* == falls thru*/
	  case S_NAME:
		return( fstrcmp(ps1, ps2) );
	  case S_DATE:
		chk = pf2->f_date - pf1->f_date;
		if (chk)
		  return(chk);
		else
		{
/* BugFix	*/
/*		  return((pf2->f_time >> 5) - (pf1->f_time >> 5));*/
		  chk = (pf2->f_time >> 11) - (pf1->f_time >> 11);
		  if (chk)
		    return(chk);
		  chk = ((pf2->f_time >> 5) & 0x003F) -
		  	((pf1->f_time >> 5) & 0x003F);
		  if (chk)
		    return(chk);
		  return ( (pf2->f_time & 0x001F) - (pf1->f_time & 0x001F) );
	  case S_DISK:
		  return(pf1->f_junk - pf2->f_junk);
		} /* else */
/* */
	} /* of switch */
	return(-1);	/* invalid which */
}

/*----------------------------------------------------------------------
*	Routine to compare two fnodes to see which one is greater.
*	Folders always sort out first, and then it is based on
*	the G.g_isort parameter.  Return (-1) if pf1 < pf2, (0) if
*	pf1 == pf2, and (1) if pf1 > pf2.
*/
MLOCAL	WORD pn_comp(FNODE far *pf1, FNODE far *pf2)
{
WNODE far * pw ;

	if (pf1->f_attr & F_FAKEFOLD)
	  return( -1 );

	if (pf2->f_attr & F_FAKEFOLD)
	  return( 1 );

	if ( (pf1->f_attr ^ pf2->f_attr) & F_SUBDIR)
	  return ((pf1->f_attr & F_SUBDIR)? -1: 1);
	else {
	  pw = win_find( G.g_cwin ) ;
	  return (pn_fcomp(pf1,pf2, pw->w_sort )); 
      }
}

/*----------------------------------------------------------------------
*
*
*/
FNODE far *pn_sort(WORD lstcnt, FNODE far *pflist)
{
	FNODE far	*pf;
	FNODE far	*pftemp;
	FNODE far	*newlist;
	WORD		gap, i, j;
						/* build index array	*/
						/*   if necessary	*/
	if (lstcnt == -1)
	{
	  lstcnt = 0;
	  for(pf=pflist; pf; pf=pf->f_next)
	    ml_pfndx[lstcnt++] = pf;
	}
						/* sort files using shell*/
						/*   sort on page 108 of */
						/*   K&R C Prog. Lang.	*/
	for(gap = lstcnt/2; gap > 0; gap /= 2)
	{
	  for(i = gap; i < lstcnt; i++)
	  {
	    for (j = i-gap; j >= 0; j -= gap)
	    {
	      if ( pn_comp(ml_pfndx[j], ml_pfndx[j+gap]) <= 0 )
		break;
	      pftemp = ml_pfndx[j];
	      ml_pfndx[j] = ml_pfndx[j+gap];
	      ml_pfndx[j+gap] = pftemp;
	    }
	  }
	}
						/* link up the list in	*/
						/*   order		*/
	newlist = (FNODE far *)NULL;
	pf = (FNODE far *) &newlist;
	for(i=0; i<lstcnt; i++)
	{
	  pf->f_next = ml_pfndx[i];
	  pf = ml_pfndx[i];
	}
	pf->f_next = (FNODE far *)NULL;
	return(newlist);
}

/*--------------------------------------------------------------------------
*	Make a particular path the active path.  This involves
*	reading its directory, initializing a file list, and filling
*	out the information in the path node.
*/
WORD pn_folder( WNODE far * pw )
{
WORD		ret, firstime;
FNODE far *	thefile;
FNODE far *	prevfile;

    if ( pw->w_type & TREEWIN )
	return( tree_open( pw->w_path, TRUE ) );

    pw->w_path->p_count = 0;
    pw->w_path->p_size = 0x0L;
    fl_free(pw->w_path->p_flist);
    thefile = (FNODE far *)NULL;
    prevfile = (FNODE far *) &pw->w_path->p_flist;

    G.g_ndirs0 = 0x0L;	/* count of folders on current level */
    G.g_nfiles0 = 0x0L;	/* count of files on current level */
    G.g_size0 = 0x0L;	/* total of file size on current level */

    if ((thefile = fn_alloc()) == (FNODE far *)NULL) {
	alert(1, EROBJMIS);
	return(FALSE);
    }
#if FAKEFOLDERICON	
    thefile->f_junk = 0x0;
    thefile->f_attr = F_FAKEFOLD | F_SUBDIR;
    thefile->f_time = 0x0;
    thefile->f_date = 0x0;
    thefile->f_size = 0x0L;
    SET_ISTREE(thefile, FALSE);
    fstrcpy( thefile->f_name, (BYTE far *)ini_str(STNEWFOL) );
						/* init for while loop	*/
#endif /* FAKEFOLDERICON */
    if( passw_chdir( pw->w_path->p_spec ) == FALSE ){
	hot_close( G.g_cwin );	/* Recover from error to open a folder */
	return( FALSE );
    }
    ((FCB *)G.g_wdta)->fcb_name[0] = NULL;
    dos_sdta( (FCB far *)G.g_wdta );
#if FAKEFOLDERICON	
    ret = firstime = TRUE;
#else /* FAKEFOLDERICON */
    ret = dos_sfirst( pw->w_path->p_spec, F_SUBDIR | F_HIDDEN );
    firstime = FALSE;
#endif /* FAKEFOLDERICON */
    while ( ret ) {
	if ( !thefile ) {
	    if ((thefile = fn_alloc()) == (FNODE far *)NULL) {	
		ret = FALSE;
		alert(1, EROBJMIS);
	    }
	}
	else {
						/* make so each dir.	*/
						/*   has a available new*/
						/*   folder		*/
	    if ( ((FCB *)G.g_wdta)->fcb_name[0] != '.' ) {
						/* if it is a real file	*/
						/*   or directory then	*/
						/*   save it		*/
		if (!firstime) {
		    fmemcpy( &thefile->f_junk, (BYTE far *)&G.g_wdta[20], 23); 
		    thefile->f_attr &= ~(F_DISK | F_FAKEFOLD | F_PROGITEM );
#ifdef SBC_920302
		    if ( ((FCB *)G.g_wdta)->fcb_name[0] == '#' )
			thefile->f_attr |= F_PROGITEM ;
#endif /* SBC_920302 */
		    SET_ISTREE(thefile, FALSE);
		}

/* Only include directories plus files which conform to the current */
/* window's search mask */

		fstrcpy( (char far *)G.g_1text, pw->w_wild ) ;
		if( ( thefile->f_attr & ( F_DISK | F_FAKEFOLD | F_SUBDIR ) )
		    || wildcmp( G.g_1text, ((FCB *)G.g_wdta)->fcb_name ) ) {
		    pw->w_path->p_size += thefile->f_size;
		    prevfile->f_next = ml_pfndx[pw->w_path->p_count++] = thefile;
		    prevfile = thefile;
		    if( thefile->f_attr & F_SUBDIR )
			G.g_ndirs0++;	/* Do directory totals */	
		    else if( !(thefile->f_attr & ( F_DISK | F_FAKEFOLD )) ){
			G.g_nfiles0++;
			G.g_size0 += thefile->f_size;
		    }
		    thefile = (FNODE far *)NULL;
		}
	    }
#if FAKEFOLDERICON
	    if (firstime) {
		ret = dos_sfirst( pw->w_path->p_spec, F_SUBDIR | F_HIDDEN);
		firstime = FALSE;
	    }
	    else
#endif /* FAKEFOLDERICON */
		ret = dos_snext();
	}
    }
    prevfile->f_next = (FNODE far *)NULL;
    if ( thefile )
	fn_free(thefile);
    pw->w_path->p_flist = pn_sort(pw->w_path->p_count, pw->w_path->p_flist);
#if FAKEFOLDERICON	
    G.g_ndirs0--;	/* Don't count parent directory */
#endif /* FAKEFOLDERICON */
    return(DOS_AX);
} /* pn_folder() */

/*----------------------------------------------------------------------------
*	Get icon to go with this FNODE.
*/
WORD GetIcon( FNODE far * pf, ANODE * pa )
{
#ifdef SBC_920302    
    if ( pa == (ANODE*)NULL )
	return( IA_GENERIC ) ;
#endif /* SBC_920302 */
    if ( pf->f_attr & F_PROGITEM )
	return( ((INODE*)pa)->i_icon ) ;
    
    else if ( pa->a_type == AT_ISPITM )
	return( ((INODE*)pa)->i_docicon ) ;

    return( pa->a_icon ) ;
    
} /* GetIcon() */

/*----------------------------------------------------------------------------
*	Build the desktop list of objects based on this current 
*	application list.
*/
MLOCAL void initDeskObject( FNODE far * pf, ANODE * pa, WORD obj )
{
OBJECT *	pObj;
ICONBLK	far *	pIcon;	/* (hca) */

    pObj = &G.g_screen[obj];
    pIcon = &gl_icons[obj] ;
    
    pObj->ob_state = NORMAL;
    pObj->ob_flags = NONE;
    pObj->ob_type = G_CLRICN;
    pObj->ob_spec = (BYTE far*)pIcon ;

    G.g_index[obj] = GetIcon( pf, pa ) ;
    init_icon( pIcon, G.g_index[obj] );
	    
    pIcon->ib_xicon = ((G.g_wicon - pIcon->ib_wicon) / 2);
    pIcon->ib_ptext = (LONG)(BYTE far *)pf->f_name ;

#if LETTERS_IN_DISK_DRIVE_ICONS
    pIcon->ib_char |= ( pa->a_type & AT_ISDISK ) ? 
				(0x00ff & pa->A_LETTER) : 0x00 ; 
#endif /* LETTERS_IN_DISK_DRIVE_ICONS */
} /* initDeskObject */

/*-----------------------------------------------------------------------------
*/
MLOCAL void initDeskFileNode( FNODE far * pf, ANODE * pa, WORD obj )
{
char tmp[40] ;

    switch( pa->a_icon ) {		/* build icon label for disks */
	case IG_FLOPPY :
	    sprintf( tmp, ini_str(STDSKET), pa->A_LETTER ) ;
	    break ;
	case IG_HARD :
	    sprintf( tmp, ini_str(STHDISK), pa->A_LETTER ) ;
	    break ;
	default : /* IG_NET */
	    sprintf( tmp, ini_str(STNET), pa->A_LETTER ) ;
	    break ;
#ifdef USE_MOBILE_NETWARE													/* USE_MOBILE_NETWARE  tar  02/13/92 */
	case MOBILE_NETWARE_CONNECTED:
	case MOBILE_NETWARE_DISCONNECTED:
	    strcpy( tmp, pa->a_match );									/* USE_MOBILE_NETWARE  tar  02/13/92 */
	    break ;
#endif /* USE_MOBILE_NETWARE */
    } /* switch */

    pf->f_junk = (0x00ff & pa->A_LETTER) ;
    pf->f_attr = F_DISK | F_SUBDIR;
    pf->f_time = 0x0;
    pf->f_date = 0x0;
    pf->f_size = 0x0L;
    SET_ISTREE( pf, FALSE);
    fstrcpy( pf->f_name, (BYTE far *)tmp );
    pf->f_obid = obj;
    pf->f_pa = (void *)pa;
    
} /* end initDeskFileNode() */

/*----------------------------------------------------------------------------
*	For every disk drive, build an object and file node for this window.
*
*/
MLOCAL void app_blddesk( PNODE far * thepath )
{
FNODE far	*prevfile;
FNODE far	*thefile;
ANODE *		pa;
WORD		obj;

    prevfile = (FNODE far *) &thepath->p_flist;
					    /* free all this windows*/
						/*   kids and set size	*/
    obj_wfree( DROOT, 0, 0, gl_width, gl_height);

    G.g_screen[DROOT].ob_spec = (BYTE far *)MK_FP( global[4], global[3] ) ;

    for ( pa = G.g_ahead; pa != (ANODE *)NULL; pa = pa->a_next)
    {
	if (pa->a_type == AT_ISDISK )
	{					/* create an object node */
	    obj = obj_ialloc( DROOT, 0, 0, G.g_wicon, G.g_hicon );
	    if ( !obj )
	    {
		/* error case, no more obs */
		pa = (ANODE *)NULL;
		continue ;
	    }
	    thefile = fn_alloc() ;		/* create a file node */
	    if ( thefile == (FNODE far *)NULL )
	    {	
		pa = (ANODE *)NULL;
		alert(1, EROBJMIS);	
		continue ;
	    }

	    initDeskObject( thefile, pa, obj ) ;
	    initDeskFileNode( thefile, pa, obj ) ;
	    
	    thepath->p_size += thefile->f_size;
	    prevfile->f_next = ml_pfndx[thepath->p_count++] = thefile;
	    prevfile = thefile;
	      
	} /* if on Desktop (same as IS_DISK for ViewMAX Release 1 and 2) */
	
    } /* for all ANODEs */
    
    prevfile->f_next = (FNODE far *)NULL;
	
} /* app_blddesk */

/*-----------------------------------------------------------------------------
*	Make a particular path the active path.  This involves
*	reading its directory, initializing a file list, and filling
*	out the information in the path node.
*/
MLOCAL	WORD pn_desktop(PNODE far *thepath)
{
WORD		sortsave;
WNODE far *	pw ;

/* initialize this path */
    thepath->p_count = 0;
    thepath->p_size = 0x0L;
    fl_free( thepath->p_flist );
	
    app_blddesk( thepath ) ;

    pw = win_find( G.g_cwin ) ;
    sortsave = pw->w_sort ;
    pw->w_sort = S_DISK;		/* sort by drive letter	*/
    thepath->p_flist = pn_sort( thepath->p_count, thepath->p_flist );    
    pw->w_sort = sortsave;
	
    return FALSE ;
	
} /* end pn_desktop() */

/*-----------------------------------------------------------------------------
*/
WORD pn_active( WNODE far * pw )
{
    if ( pw->w_path->p_spec[0] == '@' )
	return( pn_desktop( pw->w_path ) );
    else if ( pw->w_type & GROUPWIN )
	return( pn_folder( pw ) );
    else
	return( pn_folder( pw ) );

} /* end pn_active() */


/*
 *	EOF:	deskfpd.c
 */
